/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.list;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryEntityDto;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.datamodel.IListModel;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.filter.PermissionFilterUtil;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.list.SummaryResult;
import kd.bos.entity.list.events.BeforePackageDataListener;
import kd.bos.entity.list.option.ListUserOption;
import kd.bos.entity.operate.IEntityOperate;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.print.PaperSetting;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.export.IExporter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ControlTypes;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.QingCachedFilterHolder;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterBindDataListener;
import kd.bos.form.events.BeforeBindDataListener;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.field.events.ListExpandEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.IFormOperate;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.list.BillList;
import kd.bos.list.CheckFilterPermissionResult;
import kd.bos.list.ControlContext;
import kd.bos.list.FilterControlContext;
import kd.bos.list.IListChild;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.IMobileListView;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListCache;
import kd.bos.list.ListColumnContext;
import kd.bos.list.ListColumnGroup;
import kd.bos.list.ListEvent;
import kd.bos.list.ListGridView;
import kd.bos.list.ListOperationColumn;
import kd.bos.list.ListPermissionService;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MergeListColumn;
import kd.bos.list.QingView;
import kd.bos.list.SeqColumnType;
import kd.bos.list.TemplateTextListColumn;
import kd.bos.list.ViewCommonUtil;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BillListGetEntityTypeListener;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.list.events.ListBeforeBindDataEvent;
import kd.bos.list.events.ListHyperLinkClickEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.events.ListRowFilterEvent;
import kd.bos.list.events.SetCellFieldValueListener;
import kd.bos.list.events.SetCellsDataListener;
import kd.bos.list.plugin.AbstractListViewPluginProxy;
import kd.bos.list.query.PageRowCacheUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormController;
import kd.bos.mvc.form.FormView;
import kd.bos.mvc.list.ListController;
import kd.bos.mvc.list.ListUserConfig;
import kd.bos.mvc.list.MainOrgFilterResult;
import kd.bos.mvc.list.MainOrgFilterUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.FieldControlRules;
import kd.bos.permission.api.PermissionService;
import kd.bos.qing.util.QingFormUtil;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.script.annotations.KSMethod;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.ServiceFactory;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.service.tips.IHotTipsService;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.parameter.UserParamterServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.utils.DbTypeConverter;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public abstract class AbstractListView
extends FormView
implements IListView,
ICloseCallBack {
    private static final String ENABLE = "enable";
    private static Log log = LogFactory.getLog(AbstractListView.class);
    private static final String SPAN_TYPE_NAME = "list";
    private static final String SPAN_TYPE_OPERATE = "operate";
    public static final int MAX_EXPORT_LIMIT = 1000000;
    public static final String BILLLISTID = "billlistap";
    @Deprecated
    public static final String FILTERCONTAINERID = "filtercontainerap";
    @Deprecated
    public static final String TOOLBARID = "toolbarap";
    @Deprecated
    public static final String F7SELECTEDLISTID = "f7selectedlistap";
    public static final String TREEVIEWID = "treeview";
    @Deprecated
    public static final String MOBILESEARCHID = "mobilesearchap";
    public static final String EXITBUTTONID = "btnexit";
    private static final String BOS_FORM_MVC = "bos-form-mvc";
    private static final String DELETE = "delete";
    public static final String CACHE_KEY_LIST_EXPORT_ID = "CacheKey_LIST_EXPORT_ID";
    public static final String CACHE_KEY_LIST_EXPORT_RUNNING = "CacheKey_LIST_EXPORT_RUNNING";
    public static final String SELECTEDROWS = "selectedRows";
    protected static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"ExportThreadPool", (int)Integer.parseInt(System.getProperty("MAX_EXPORT_THREAD_POOL_SIZE", "8")));
    private ListCache listCache;
    ControlContext context = new ControlContext(new FilterControlContext());
    QingView qingView;
    boolean needRefreshTree = true;
    QingCachedFilterHolder qingCachedFilterHolder;
    String billListEntityId;
    String billFormId;
    SetFilterListener setFilterListener;
    CreateListColumnsListener createListColumnsListener;
    CreateListDataProviderListener createListDataProviderListener;
    BeforeBindDataListener beforeBindDataListener;
    AfterBindDataListener afterBindDataListener;
    SetCellFieldValueListener setCellFieldValueListener;
    Consumer<PackageDataEvent> packageDataListener;
    BeforePackageDataListener beforePackageDataListener;
    SetCellsDataListener setCellsDataListener;
    List<Map<String, Object>> listFieldsControlColumns;
    private BillListGetEntityTypeListener billListGetEntityTypeListener;
    IListModel listModel;
    ListUserOption listUserOption;
    protected BeforeCreateListColumnsArgs beforeCreateListColumnsArgs;
    private Set<String> canNotReadFields;
    private static final List<String> UNSUPPORTED_CHECKMAINORGQFILTER_METHODS = Arrays.asList("queryExceedMaxCount", "getRealCount", "getSumData");
    protected ControlFilters controlFilters;

    protected ListCache getListCache() {
        if (this.listCache == null) {
            IPageCache pageCache = (IPageCache)this.getService(IPageCache.class);
            this.listCache = new ListCache(pageCache);
        }
        return this.listCache;
    }

    public QingCachedFilterHolder getQingCachedFilterHolder() {
        return this.qingCachedFilterHolder;
    }

    public void setQingCachedFilterHolder(QingCachedFilterHolder qingCachedFilterHolder) {
        this.qingCachedFilterHolder = qingCachedFilterHolder;
    }

    public boolean isNeedRefreshTree() {
        return this.needRefreshTree;
    }

    public void setNeedRefreshTree(boolean needRefreshTree) {
        this.needRefreshTree = needRefreshTree;
    }

    protected QingView getQingView() {
        return this.qingView;
    }

    protected final void refreshQingView() {
        if (this.getFormShowParameter().getFormConfig().isQingView() && this.qingView != null && !this.qingView.getItems().isEmpty()) {
            this.qingView.refresh();
        }
    }

    public String getEntityTypeId() {
        if (StringUtils.isBlank((CharSequence)this.billListEntityId)) {
            this.billListEntityId = this.getListModel().getDataEntityType().getName();
        }
        return this.billListEntityId;
    }

    protected String getEntryEntity() {
        BillList list = (BillList)this.getControl(this.context.getBillListId());
        return list.getEntryEntity();
    }

    protected FilterParameter getBillListFilterParameter() {
        BillList list = (BillList)this.getControl(this.context.getBillListId());
        return list.generalFilterParameter();
    }

    protected FilterParameter getListViewFilterParameter() {
        return new ListCache(this.getPageCache(), this.context.getBillListId()).getListViewFilterParameter();
    }

    int queryListRealCount() {
        BillList list = (BillList)this.getControl(this.context.getBillListId());
        list.getRealCount();
        IPageCache pageCache = this.getPageCache();
        if (pageCache != null) {
            String dataCountKey = list.getKey() + "_dc";
            return StringUtils.isNotBlank((CharSequence)pageCache.get(dataCountKey)) ? Integer.parseInt(pageCache.get(dataCountKey)) : 0;
        }
        return 0;
    }

    protected boolean isMultiSelect() {
        boolean isMultiSelect = false;
        if (this.getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)this.getFormShowParameter();
            isMultiSelect = listShowParameter.isMultiSelect();
        }
        return isMultiSelect;
    }

    public void refreshWithSelected() {
        BillList list = (BillList)this.getControl(this.context.getBillListId());
        if (list != null) {
            list.getEntryState().setKeepPageData(false);
        }
        this.refresh();
        if (list != null) {
            list.getEntryState().setKeepPageData(true);
        }
        this.focusIndex();
    }

    protected void refreshAfterEntityOperate() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"AbstractListView.refreshAfterEntityOperate", (EntityTraceHint)EntityTraceHint.getHintLinkAPM());){
            boolean isRefresh;
            Long userId = Long.parseLong(RequestContext.get().getUserId());
            String formId = ((ListShowParameter)this.getFormShowParameter()).getBillFormId();
            String listOption = this.getFormShowParameter().getFormConfig().getListUserOption();
            Object isStopRefreshList = UserParamterServiceHelper.getListOption((Long)userId, (String)formId, (String)listOption, (String)"stoprefreshlist");
            boolean bl = isRefresh = isStopRefreshList == null ? false : Boolean.parseBoolean(isStopRefreshList.toString());
            if (!isRefresh) {
                this.refreshWithSelected();
            }
        }
    }

    private void focusIndex() {
        IClientViewProxy proxy = (IClientViewProxy)this.getService(IClientViewProxy.class);
        BillList billList = (BillList)this.getControl(this.context.getBillListId());
        if (billList != null) {
            AbstractGrid.GridState state = billList.getEntryState();
            Object dataCount = state.get("dataCount");
            int iCount = 0;
            if (dataCount != null) {
                iCount = (Integer)dataCount;
            }
            int iFocusIndex = -1;
            int[] rows = state.getSelectedRows();
            if (rows.length > 0) {
                iFocusIndex = rows[0];
            }
            if (iFocusIndex >= 0 && iFocusIndex == iCount) {
                --iFocusIndex;
            }
            proxy.invokeControlMethod(this.context.getBillListId(), "setFocus", new Object[]{iFocusIndex});
        }
    }

    protected void addBeforeShowBillListener(IFormOperate iFormOperate) {
        iFormOperate.addBeforeShowBillListener(formShowParameter -> {
            AbstractListViewPluginProxy listViewPluginProxy = (AbstractListViewPluginProxy)this.getService(FormViewPluginProxy.class);
            BeforeShowBillFormEvent e = new BeforeShowBillFormEvent((Object)this, (BillShowParameter)formShowParameter);
            listViewPluginProxy.fireBeforeShowBill(e);
            iFormOperate.setCancelShowBill(e.isCancel());
        });
    }

    protected String getViewBillFormId() {
        String listOpenLayoutBill = FormMetadataCache.getListFormConfig((String)this.getBillFormId()).getListOpenLayoutBill();
        if (StringUtils.isNotBlank((CharSequence)listOpenLayoutBill)) {
            return listOpenLayoutBill;
        }
        return this.getEntityTypeId();
    }

    private ListSelectedRowCollection getOperationSelectedRows(OperateOption option) {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        String selectedRowsCache = option.getVariableValue(SELECTEDROWS, "NoSelectedRowsCache");
        if (!"NoSelectedRowsCache".equals(selectedRowsCache)) {
            return (ListSelectedRowCollection)SerializationUtils.fromJsonString((String)selectedRowsCache, ListSelectedRowCollection.class);
        }
        for (IListColumn listColumn : this.getShowListColumns()) {
            if (!(listColumn instanceof ListOperationColumn) || !((ListOperationColumn)listColumn).getKey().equals(this.getGridState().getFocusField())) continue;
            selectedRows = new ListSelectedRowCollection();
            ListSelectedRow currRow = this.getCurrentSelectedRowInfo();
            String str = SerializationUtils.toJsonString((Object)currRow);
            ListSelectedRow selectedRow = (ListSelectedRow)SerializationUtils.fromJsonString((String)str, ListSelectedRow.class);
            selectedRow.setEntryEntityKey(null);
            if (selectedRow.isEntryPkLongType()) {
                selectedRow.setEntryPrimaryKeyValue((Object)0L);
            } else {
                selectedRow.setEntryPrimaryKeyValue((Object)"");
            }
            selectedRow.setSubEntryEntityKey(null);
            if (selectedRow.isSubEntryPkLongType()) {
                selectedRow.setSubEntryPrimaryKeyValue((Object)0L);
            } else {
                selectedRow.setSubEntryPrimaryKeyValue((Object)"");
            }
            selectedRows.add((Object)selectedRow);
            option.setVariableValue(SELECTEDROWS, SerializationUtils.toJsonString((Object)selectedRows));
            this.getGridState().put("fieldKey", null);
            break;
        }
        return selectedRows;
    }

    @Override
    public OperationResult invokeOperation(String operationKey, OperateOption option) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_OPERATE, (String)"AbstractListView.invokeOperation", (EntityTraceHint)EntityTraceHint.getHintLinkAPM());){
            Object object;
            span.addTag("operationKey", operationKey);
            FormOperate operate = this.getOperation(operationKey);
            boolean isBatchExecCallBack = false;
            if (option == null) {
                option = OperateOption.create();
            }
            isBatchExecCallBack = Boolean.parseBoolean(option.getVariableValue("batchop_completed", String.valueOf(false)));
            if (operate.needSelectData() && !isBatchExecCallBack) {
                boolean isEmpty;
                ListSelectedRowCollection selectedRows = null;
                try (EntityTraceSpan span1 = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"invokeOperation_setListSelectedData");){
                    selectedRows = this.getOperationSelectedRows(option);
                }
                if (!"focus".equals(operate.getParameter().get("listDelScope")) && selectedRows.isEmpty()) {
                    this.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AbstractListView_0", (String)BOS_FORM_MVC, (Object[])new Object[0]));
                    span1 = null;
                    return span1;
                }
                boolean bl = isEmpty = StringUtils.isEmpty((CharSequence)operate.getConfirmMessage()) && DELETE.equals(operate.getType());
                if (isEmpty) {
                    EntityTraceSpan span1 = EntityTracer.create((String)SPAN_TYPE_OPERATE, (String)"AbstractListView.invokeOperation.GUIInteraction");
                    object = null;
                    try {
                        String confirmMessage = this.getListCache().getDeleteConfirmMsg();
                        String message = confirmMessage != null ? confirmMessage : String.format(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684%d\u5f20\u5355\u636e\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"AbstractListView_1", (String)BOS_FORM_MVC, (Object[])new Object[0]), selectedRows.getPrimaryKeyValues().length);
                        operate.setConfirmMessage(message);
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (span1 != null) {
                            if (object != null) {
                                try {
                                    span1.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                span1.close();
                            }
                        }
                    }
                }
                operate.setListSelectedData(selectedRows);
                operate.setListFocusRow(this.getCurrentSelectedRowInfo());
            }
            this.getModel().updateCache();
            if (operate instanceof IEntityOperate) {
                IEntityOperate entityOperate = (IEntityOperate)operate;
                entityOperate.setRemoteInvoke(true);
            } else if (operate instanceof IFormOperate) {
                IFormOperate iFormOperate = (IFormOperate)operate;
                MainEntityType queryEntityType = EntityMetadataCache.getDataEntityType((String)this.getEntityTypeId());
                if (queryEntityType instanceof QueryEntityType) {
                    iFormOperate.setViewBillFormId(((QueryEntityType)queryEntityType).getEditEntityName());
                } else {
                    iFormOperate.setViewBillFormId(this.getViewBillFormId());
                }
                CloseCallBack closeCallBack = new CloseCallBack(((Object)((Object)this)).getClass().getName(), "listoperation");
                iFormOperate.setCloseCallBack(closeCallBack);
                this.addBeforeShowBillListener(iFormOperate);
            }
            OperateOption listViewOperateOption = option;
            MainEntityType queryEntityType = EntityMetadataCache.getDataEntityType((String)this.getEntityTypeId());
            if (queryEntityType instanceof QueryEntityType) {
                operate.setPermissionEntityId(this.getEntityTypeId());
                listViewOperateOption = this.getOrSetOptionVariableValue(listViewOperateOption, "permissionentityid", this.getEntityTypeId());
            }
            if (this instanceof IMobileListView) {
                listViewOperateOption = this.getOrSetOptionVariableValue(listViewOperateOption, "isStrict", "false");
            }
            if (StringUtils.isNotEmpty((CharSequence)this.getListCache().getRouteKey())) {
                this.getOrSetOptionVariableValue(listViewOperateOption, "routeKey", this.getListCache().getRouteKey());
                this.getOrSetOptionVariableValue(listViewOperateOption, "ArchiveKey", this.getListCache().getArchiveKey());
            }
            OperationResult operationResult = super.invokeOperation(operationKey, listViewOperateOption);
            if (operate instanceof IEntityOperate && !((IEntityOperate)operate).isCancelRefresh() && operationResult != null && !operationResult.getSuccessPkIds().isEmpty()) {
                this.refreshAfterEntityOperate();
            }
            object = operationResult;
            return object;
        }
    }

    private OperateOption getOrSetOptionVariableValue(OperateOption option, String operateOptionConst, String value) {
        if (option == null) {
            OperateOption listViewOperateOption = OperateOption.create();
            listViewOperateOption.setVariableValue(operateOptionConst, value);
            return listViewOperateOption;
        }
        option.setVariableValue(operateOptionConst, value);
        return option;
    }

    @Override
    protected FormOperate getOperation(String operationKey) {
        if (this.formOperate == null || !this.formOperate.getOperateKey().equalsIgnoreCase(operationKey)) {
            String entityTypeId = this.getEntityTypeId();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityTypeId);
            if (mainEntityType instanceof QueryEntityType) {
                entityTypeId = ((QueryEntityType)mainEntityType).getEditEntityName();
            }
            this.formOperate = (FormOperate)FormMetadataCache.getFormOperation((String)entityTypeId, (String)operationKey);
            this.formOperate.setEntityId(entityTypeId);
            if (this.formOperate instanceof IFormOperate) {
                ((IFormOperate)this.formOperate).setViewBillFormId(this.getViewBillFormId());
            }
            this.formOperate.setView((IFormView)this);
        }
        return this.formOperate;
    }

    @Override
    protected FormController createFormController() {
        return new ListController((IFormView)this);
    }

    public ITreeListView getTreeListView() {
        return null;
    }

    public void focusRootNode() {
    }

    @Override
    public void initialize(FormShowParameter formShowParameter) {
        super.initialize(formShowParameter);
        this.initialContext();
    }

    public void refresh() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"AbstractListView.refresh");){
            BillList billList = (BillList)this.getControl(this.context.getBillListId());
            if (billList != null) {
                billList.setSelectedMainOrgIds(this.getSelectedMainOrgIds());
                this.listModel = billList.getListModel();
                billList.refresh();
            }
        }
    }

    public List<Long> getSelectedMainOrgIds() {
        return this.getListCache().getSelectedMainOrgIds();
    }

    public void setSelectedMainOrgIds(List<Long> selectedMainOrgIds) {
        this.getListCache().setSelectedMainOrgIds(selectedMainOrgIds);
    }

    public ListSelectedRowCollection getCurrentListAllRowCollection() {
        BillList list = (BillList)this.getControl(this.context.getBillListId());
        return list.getCurrentListAllRowCollection();
    }

    public String getBillFormId() {
        if (this.billFormId == null) {
            this.billFormId = this.getListCache().getBillFormId();
            if (StringUtils.isBlank((CharSequence)this.billFormId)) {
                ListShowParameter listShowParameter = (ListShowParameter)this.formShowParameter;
                if (StringUtils.isBlank((CharSequence)listShowParameter.getBillFormId())) {
                    BillList billList = (BillList)this.getControl(this.context.getBillListId());
                    this.cacheBillFormId(billList.getEntityId());
                } else {
                    this.cacheBillFormId(listShowParameter.getBillFormId());
                }
            }
        }
        return this.billFormId;
    }

    private void cacheBillFormId(String billFormId) {
        this.billFormId = billFormId;
        this.getListCache().setBillFormId(billFormId);
    }

    public void setBillFormId(String billFormId) {
        if (billFormId.equalsIgnoreCase(this.getBillFormId())) {
            return;
        }
        BillList billList = (BillList)this.getControl(this.context.getBillListId());
        billList.setBillFormId(billFormId);
        this.cacheBillFormId(billFormId);
    }

    public void changeListView(String billFormId) {
        if (StringUtils.isNotBlank((CharSequence)this.getBillFormId()) && !billFormId.equals(this.getBillFormId())) {
            this.setBillFormId(billFormId);
            BillList billList = (BillList)this.getControl(this.context.getBillListId());
            billList.getItems().clear();
            this.beforeCreateListColumnsArgs = null;
            this.context.setEntryEntity(null);
            this.initBillListByMetadata();
            billList.setEntryEntity(ViewCommonUtil.getFirstEntryEntity((EntityType)billList.getEntityType(), (List)this.context.getEntryEntityDtos()));
        }
    }

    protected void setSelectedRows(BillList billList) {
        ListShowParameter listShowParameter = (ListShowParameter)this.formShowParameter;
        if (listShowParameter.getListSelectedRowCollection() != null) {
            ISimpleProperty pkField = billList.getEntityType().getPrimaryKey();
            for (ListSelectedRow listSelectedRow : listShowParameter.getListSelectedRowCollection()) {
                Object newValue = listSelectedRow.getPrimaryKeyValue();
                if (pkField.getDbType() == -5 && StringUtils.isNotBlank((Object)newValue)) {
                    newValue = Long.parseLong(newValue.toString());
                }
                listSelectedRow.setPrimaryKeyValue(newValue);
            }
            billList.putSelectedRows(listShowParameter.getListSelectedRowCollection());
            billList.setSelectedRowCondition(listShowParameter.getSelectedRowCondition());
        }
    }

    @Deprecated
    protected FilterParameter getQueryFilterParameter() {
        return new FilterParameter();
    }

    private void addSetFilterListener() {
        if (this.setFilterListener == null) {
            BillList billList = (BillList)this.getControl(this.context.getBillListId());
            this.setFilterListener = setFilterEvent -> {
                AbstractListViewPluginProxy abstractListViewPluginProxy = (AbstractListViewPluginProxy)this.getService(FormViewPluginProxy.class);
                abstractListViewPluginProxy.fireSetFilter(setFilterEvent);
            };
            billList.addSetFilterListener(this.setFilterListener);
        }
    }

    private void addCreateListColumnsListener(BillList list) {
        if (this.createListColumnsListener == null) {
            this.createListColumnsListener = beforeCreateListColumnsArg -> {
                AbstractListViewPluginProxy abstractListViewPluginProxy = (AbstractListViewPluginProxy)this.getService(FormViewPluginProxy.class);
                abstractListViewPluginProxy.fireBeforeCreateListColumns(beforeCreateListColumnsArg);
            };
            list.addCreateListColumnsListener(this.createListColumnsListener);
        }
    }

    private void addCreateListDataProviderListener(BillList list) {
        if (this.createListDataProviderListener == null) {
            this.createListDataProviderListener = beforeCreateListDataProviderArgs -> {
                AbstractListViewPluginProxy abstractListViewPluginProxy = (AbstractListViewPluginProxy)this.getService(FormViewPluginProxy.class);
                abstractListViewPluginProxy.fireBeforeCreateListDataProvider(beforeCreateListDataProviderArgs);
            };
            list.addCreateListDataProviderListener(this.createListDataProviderListener);
        }
    }

    List<String> getSelectFields() {
        FilterParameter myFastQueryFilterParameter = this.context.getFastQueryFilterParameter();
        FilterParameter myClientQueryFilterParameter = this.context.getClientQueryFilterParameter();
        ArrayList<String> selectFields = new ArrayList<String>();
        if (myFastQueryFilterParameter != null && myFastQueryFilterParameter.getSelectFields() != null) {
            for (String selectField : myFastQueryFilterParameter.getSelectFields()) {
                if (selectFields.contains(selectField)) continue;
                selectFields.add(selectField);
            }
        }
        if (myClientQueryFilterParameter != null && myClientQueryFilterParameter.getSelectFields() != null) {
            for (String selectField : myClientQueryFilterParameter.getSelectFields()) {
                if (selectFields.contains(selectField)) continue;
                selectFields.add(selectField);
            }
        }
        return selectFields;
    }

    private CheckFilterPermissionResult checkFilterPermission(BillList list) {
        List<Long> selectedMainOrgIds = this.getSelectedMainOrgIds();
        return ListPermissionService.checkFilterPermission((List)list.getClientQueryFilterParameter().getSelectFields(), (String)ShowFormHelper.getBizAppId((FormShowParameter)this.getFormShowParameter()), (EntityType)this.getListModel().getDataEntityType(), selectedMainOrgIds.size() == 1 ? selectedMainOrgIds.get(0) : null);
    }

    private void addBeforeBindDataListener(BillList list) {
        if (this.beforeBindDataListener == null) {
            this.beforeBindDataListener = beforeBindDataEvent -> {
                String isQueryUserFavorite;
                IDataEntityProperty enableProp;
                if (this.context.getEntryEntityDtos().isEmpty()) {
                    this.initBillListByMetadata();
                } else {
                    List entryEntityDtos = this.context.getEntryEntityDtos();
                    String firstEntryEntity = ViewCommonUtil.getFirstEntryEntity((EntityType)list.getEntityType(), (List)entryEntityDtos);
                    if (StringUtils.isBlank((CharSequence)list.getEntryEntity()) && (entryEntityDtos.size() <= 2 || this.context.getEntryEntity() != null && !entryEntityDtos.contains(new EntryEntityDto(this.context.getEntryEntity())))) {
                        list.setEntryEntity(firstEntryEntity);
                    }
                }
                list.setListFieldsControlColumns(this.getListFieldsControlColumns());
                if (beforeBindDataEvent instanceof ListBeforeBindDataEvent && ((ListBeforeBindDataEvent)beforeBindDataEvent).getListEvent() == null || ((ListBeforeBindDataEvent)beforeBindDataEvent).getListEvent() != ListEvent.getGridDataByFilter) {
                    CheckFilterPermissionResult checkFilterPermissionResult = this.checkFilterPermission(list);
                    Set cannotReadSelectFields = this.listCache.getHeaderCannotReadSelectFields();
                    HashMap<String, LocaleString> nameMap = new HashMap<String, LocaleString>(16);
                    if (this.beforeCreateListColumnsArgs == null) {
                        this.initBillListByMetadata();
                    }
                    for (Object listColumn : this.beforeCreateListColumnsArgs.getListColumns()) {
                        if (!StringUtils.isNotBlank((CharSequence)listColumn.getListFieldKey())) continue;
                        nameMap.put(listColumn.getListFieldKey(), listColumn.getCaption());
                    }
                    HashSet<String> finalNames = new HashSet<String>(16);
                    for (String filterName : checkFilterPermissionResult.getHasNotFieldPermissionFields()) {
                        LocaleString name = (LocaleString)nameMap.get(filterName);
                        if (name != null && StringUtils.isNotBlank((CharSequence)name.toString())) {
                            finalNames.add(name.toString());
                            continue;
                        }
                        String caption = (String)this.context.getSelectFieldsCaptionMap().get(filterName);
                        if (!StringUtils.isNotBlank((CharSequence)caption)) continue;
                        finalNames.add(caption);
                    }
                    this.listCache.setFilterControlCannotReadSelectFields(finalNames);
                    if (!checkFilterPermissionResult.isHasFieldPermission()) {
                        finalNames.addAll(cannotReadSelectFields);
                        this.cancelBindingAndShowError(list, (ListBeforeBindDataEvent)beforeBindDataEvent, finalNames);
                        return;
                    }
                    if (!cannotReadSelectFields.isEmpty()) {
                        this.cancelBindingAndShowError(list, (ListBeforeBindDataEvent)beforeBindDataEvent, cannotReadSelectFields);
                    }
                }
                ListShowParameter listShowParameter = (ListShowParameter)this.getFormShowParameter();
                List qFilters = listShowParameter.getListFilterParameter().getQFilters();
                if (!listShowParameter.isLookUp()) {
                    qFilters.addAll(this.getDefaultDataFilters(list));
                }
                if (listShowParameter.isF7ClickByFilter() && (enableProp = list.getEntityType().findProperty(ENABLE)) instanceof BillStatusProp && StringUtils.isNotBlank((CharSequence)enableProp.getAlias())) {
                    qFilters = qFilters.stream().filter(f -> !ENABLE.equals(f.getProperty())).collect(Collectors.toList());
                    if (this.getModel().getDataEntityType().getProperty("isshowdisabled") != null && !((Boolean)this.getModel().getValue("isshowdisabled")).booleanValue()) {
                        qFilters.add(new QFilter(ENABLE, "=", (Object)"1"));
                    }
                }
                if (listShowParameter.isShowFrequent() && listShowParameter.isLookUp() && (isQueryUserFavorite = this.getPageCache().get("isQueryUserFavorite")) != null && "true".equals(isQueryUserFavorite)) {
                    List dataIds = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("dataIds"), String.class);
                    int dbType = list.getEntityType().getPrimaryKey().getDbType();
                    List ids = dataIds.stream().map(obj -> DbTypeConverter.safeConvert((int)dbType, (Object)obj)).collect(Collectors.toList());
                    qFilters.add(new QFilter("id", "in", ids));
                }
                list.setFilterParameter(new FilterParameter(qFilters, listShowParameter.getListFilterParameter().getOrderBy()));
                FormViewPluginProxy formViewPluginProxy = (FormViewPluginProxy)this.getService(FormViewPluginProxy.class);
                formViewPluginProxy.fireBeforeBindData((EventObject)beforeBindDataEvent);
            };
            list.addBeforeBindDataListener(this.beforeBindDataListener);
        }
    }

    private void cancelBindingAndShowError(BillList list, ListBeforeBindDataEvent beforeBindDataEvent, Set<String> finalNames) {
        beforeBindDataEvent.setCancel(true);
        this.showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u5b57\u6bb5\u7684\u67e5\u770b\u6743\u9650\uff0c\u8bf7\u66f4\u6362\u67e5\u8be2\u6761\u4ef6\u8fdb\u884c\u8fc7\u6ee4\u3002", (String)"AbstractListView_20", (String)BOS_FORM_MVC, (Object[])new Object[0]), String.join((CharSequence)"\u3001", finalNames)));
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("1", "!=", (Object)"1"));
        list.setFilterParameter(new FilterParameter(qFilters, ""));
    }

    private void addAfterBindDataListener(BillList list) {
        if (this.afterBindDataListener == null) {
            this.afterBindDataListener = afterBindDataEvent -> {
                this.listModel = list.getListModel();
                this.sendHotTips();
                AbstractListViewPluginProxy formViewPluginProxy = (AbstractListViewPluginProxy)this.getService(FormViewPluginProxy.class);
                formViewPluginProxy.fireAfterBindData((EventObject)afterBindDataEvent);
            };
            list.addAfterBindDataListener(this.afterBindDataListener);
        }
    }

    private void addSetCellFieldValueListener(BillList list) {
        if (this.setCellFieldValueListener == null) {
            this.setCellFieldValueListener = setCellFieldValueArgs -> {
                AbstractListViewPluginProxy formViewPluginProxy = (AbstractListViewPluginProxy)this.getService(FormViewPluginProxy.class);
                formViewPluginProxy.fireCellFieldValue(setCellFieldValueArgs);
            };
            list.addSetCellFieldValueListener(this.setCellFieldValueListener);
        }
    }

    private void addPackageDataListener(BillList list) {
        if (this.packageDataListener == null) {
            this.packageDataListener = packageDataEvent -> {
                AbstractListViewPluginProxy abstractListViewPluginProxy = (AbstractListViewPluginProxy)this.getService(FormViewPluginProxy.class);
                abstractListViewPluginProxy.firePackageData(packageDataEvent);
            };
            list.addPackageDataListener(this.packageDataListener);
        }
    }

    private void addBeforePackageDataListener(BillList list) {
        if (this.beforePackageDataListener == null) {
            this.beforePackageDataListener = repackagePageDataEvent -> {
                AbstractListViewPluginProxy abstractListViewPluginProxy = (AbstractListViewPluginProxy)this.getService(FormViewPluginProxy.class);
                abstractListViewPluginProxy.fireBeforePackageData(repackagePageDataEvent);
            };
            list.addBeforePackageDataListener(this.beforePackageDataListener);
        }
    }

    private void addSetCellsDataListener(BillList list) {
        if (this.setCellsDataListener == null) {
            this.setCellsDataListener = SetCellsDataEvent2 -> {
                AbstractListViewPluginProxy formViewPluginProxy = (AbstractListViewPluginProxy)this.getService(FormViewPluginProxy.class);
                formViewPluginProxy.fireSetCellsData(SetCellsDataEvent2);
            };
            list.addSetCellsDataListener(this.setCellsDataListener);
        }
    }

    protected void addBillListListener(BillList billList) {
        this.addBillListGetEntityTypeListener(billList);
        this.addSetFilterListener();
        this.addCreateListColumnsListener(billList);
        this.addCreateListDataProviderListener(billList);
        this.addBeforeBindDataListener(billList);
        this.addAfterBindDataListener(billList);
        this.addSetCellFieldValueListener(billList);
        this.addBeforePackageDataListener(billList);
        this.addPackageDataListener(billList);
        this.addSetCellsDataListener(billList);
    }

    protected List<Map<String, Object>> getListFieldsControlColumns() {
        if (this.listFieldsControlColumns != null) {
            return this.listFieldsControlColumns;
        }
        BillList list = (BillList)this.getControl(this.context.getBillListId());
        String billFormId = list != null ? list.getBillFormId() : this.getBillFormId();
        String setting = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)(StringUtils.isBlank((CharSequence)this.getListCache().getSchemeId()) ? billFormId : billFormId + "." + this.getListCache().getSchemeId()));
        this.listFieldsControlColumns = StringUtils.isNotBlank((CharSequence)setting) ? SerializationUtils.fromJsonStringToList((String)setting, Map.class) : new ArrayList<Map<String, Object>>();
        return this.listFieldsControlColumns;
    }

    protected void initLinkQueryPkIdCollection() {
    }

    protected void restoreQingFilterValues() {
    }

    @Override
    @KSMethod
    public void updateView() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"AbstractListView.updateView");){
            this.initLinkQueryPkIdCollection();
            this.restoreQingFilterValues();
            BillList billList = (BillList)this.getControl(this.context.getBillListId());
            if (billList != null) {
                this.setSelectedRows(billList);
                ListShowParameter listShowParameter = (ListShowParameter)this.getFormShowParameter();
                billList.setSpecialDataPermQFilter(this.getSpecialDataPermQFilter());
                billList.setDataPermQFilters(this.getDataPermQFilters());
                billList.setFieldControlRules(this.getFieldControlRules());
                this.context.setEntryEntity(listShowParameter.getListFilterParameter().getSelectEntity());
            }
            super.updateView();
            if (billList != null) {
                billList.setListFieldsControlColumns(this.getListFieldsControlColumns());
            }
        }
    }

    private void addBillListGetEntityTypeListener(BillList billList) {
        if (this.billListGetEntityTypeListener == null) {
            this.billListGetEntityTypeListener = getEntityTypeEventArgs -> {
                AbstractListViewPluginProxy abstractListViewPluginProxy = (AbstractListViewPluginProxy)this.getService(FormViewPluginProxy.class);
                abstractListViewPluginProxy.fireBillListGetEntityTypeListener(getEntityTypeEventArgs);
            };
            billList.addBillListGetEntityTypeListener(this.billListGetEntityTypeListener);
        }
    }

    public int getFocusRow() {
        BillList billList = (BillList)this.getControl(this.context.getBillListId());
        return billList.getEntryState().getFocusRow();
    }

    public ListSelectedRow getCurrentSelectedRowInfo() {
        BillList billList = (BillList)this.getControl(this.context.getBillListId());
        return billList.getCurrentSelectedRowInfo();
    }

    public Object getFocusRowPkId() {
        BillList billList = (BillList)this.getControl(this.context.getBillListId());
        return billList.getFocusRowPkId();
    }

    public void clearSelection() {
        BillList list = (BillList)this.getControl(this.context.getBillListId());
        list.clearSelection();
    }

    protected QueryResult queryData(int start, int limit) {
        BillList list = (BillList)this.getControl(this.context.getBillListId());
        return list.queryBatchData(false, start, limit);
    }

    protected QueryResult queryDataBySelectedRows(ListSelectedRowCollection listSelectedRowCollection) {
        BillList list = (BillList)this.getControl(this.context.getBillListId());
        return list.queryDataBySelectedRows(listSelectedRowCollection);
    }

    protected int queryBillDataCount() {
        BillList list = (BillList)this.getControl(this.context.getBillListId());
        return list.queryBillDataCount();
    }

    protected List<SummaryResult> querySummaryResults(String ... summaryFields) {
        BillList list = (BillList)this.getControl(this.context.getBillListId());
        return list.querySummaryResults(summaryFields);
    }

    @KSMethod
    public IListModel getListModel() {
        BillList billList;
        if (this.listModel == null && (billList = (BillList)this.getControl(this.context.getBillListId())) != null) {
            billList.setBillFormId(this.getBillFormId());
            this.setMetadata();
            this.listModel = billList.getListModel();
        }
        return this.listModel;
    }

    public ListSelectedRowCollection getSelectedRows() {
        BillList billList = (BillList)this.getControl(this.context.getBillListId());
        return billList.getSelectedRows();
    }

    protected boolean isMergeRow() {
        return this.getListUserOption().isMergeRow(this.formShowParameter.getCustomParams());
    }

    public void returnLookupData() {
        ListSelectedRowCollection listSelectedRowCollection = this.getSelectedRows();
        if (!this.checkSelectedRows(listSelectedRowCollection)) {
            return;
        }
        if (this.isMergeRow()) {
            ListSelectedRowCollection mergeCollection = listSelectedRowCollection.getBillListSelectedRowCollection();
            mergeCollection.setClearFlag(listSelectedRowCollection.isClearFlag());
            this.returnDataToParent(mergeCollection);
        } else {
            this.returnDataToParent(listSelectedRowCollection);
        }
        this.close();
    }

    protected boolean checkSelectedRows(ListSelectedRowCollection listSelectedRowCollection) {
        return true;
    }

    private Set<String> preparelistFieldKeys(List<ListField> listFields) {
        HashSet<String> keys = new HashSet<String>();
        for (ListField f : listFields) {
            if (f == null) continue;
            keys.add(f.getListFieldKey());
        }
        return keys;
    }

    /*
     * Exception decompiling
     */
    public String formatException(Throwable throwable) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Object showExportProgress(String listname) {
        Long logId = DB.genLongId((String)"t_log_exportlog");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("bos_exporting");
        showParameter.setCustomParam("ListName", (Object)listname);
        showParameter.setCustomParam("LogId", (Object)logId);
        showParameter.setCustomParam("ListPageId", (Object)this.getPageId());
        this.showForm(showParameter);
        return logId;
    }

    private boolean isExporting(BillList billList) {
        String appId = EntityMetadataCache.getDataEntityType((String)billList.getEntityType().getName()).getAppId();
        String exportId = this.getPageCache().get(CACHE_KEY_LIST_EXPORT_ID);
        String isRunning = this.getPageCache().get(CACHE_KEY_LIST_EXPORT_RUNNING);
        if (StringUtils.isNotBlank((CharSequence)exportId)) {
            Map cachedata = (Map)AppCache.get((String)appId).get(exportId, Map.class);
            return cachedata != null && !cachedata.isEmpty();
        }
        return StringUtils.isNotBlank((CharSequence)isRunning);
    }

    private List<IListColumn> prepareListColumns(BillList billList) {
        List<IListColumn> columns = this.getShowListColumns();
        String listGridViewKey = billList.getListGridViewKey();
        columns.removeIf(col -> {
            if (col instanceof TemplateTextListColumn) {
                return false;
            }
            if (col instanceof ListOperationColumn) {
                return true;
            }
            Container parent = col.getParent();
            if (parent instanceof IListChild) {
                return !listGridViewKey.equalsIgnoreCase(col.getParentViewKey());
            }
            if (parent instanceof MergeListColumn) {
                return !listGridViewKey.equalsIgnoreCase(((MergeListColumn)parent).getParentViewKey());
            }
            if (parent instanceof ListColumnGroup) {
                return !listGridViewKey.equalsIgnoreCase(((ListColumnGroup)parent).getParentViewKey());
            }
            return true;
        });
        return columns;
    }

    private boolean isValidListColumn(BillList billList, IListColumn col) {
        boolean isEntrySeq = billList.getListUserOption().isShowEntrySeq();
        if (col.getSeqColType() == SeqColumnType.EntitySeq) {
            return false;
        }
        return isEntrySeq || col.getSeqColType() != SeqColumnType.EntryEntitySeq;
    }

    private List<IListColumn> filterColumns(List<Control> items) {
        ArrayList<IListColumn> columns = new ArrayList<IListColumn>();
        for (Control ctl : items) {
            if (!(ctl instanceof IListColumn)) continue;
            columns.add((IListColumn)ctl);
        }
        return columns;
    }

    public void export(long templateId) {
        this.export(templateId, false);
    }

    public void importData(List<String> urls, String type) {
        this.importData(urls, type, null);
    }

    public void importData(List<String> urls, String type, List<String> plugins) {
        AbstractListView.importData((IFormView)this, urls, type, plugins, FormMetadataCache.getFormConfig((String)this.getBillFormId()).getEntityTypeId(), null);
    }

    @Deprecated
    public static void importData(IFormView view, List<String> urls, String type, List<String> plugins, String billFormId, String extendData) {
        String appId = FormMetadataCache.getFormConfig((String)billFormId).getAppId();
        String serviceAppId = ServiceLookup.getServiceAppId((String)appId);
        AbstractListView.importData(view, urls, type, plugins, billFormId, serviceAppId, extendData);
    }

    public static void importData(IFormView view, List<String> urls, String type, List<String> plugins, String serviceAppId, String billFormId, String extendData) {
        LocalDateTime now = LocalDateTime.now();
        JobInfo job = new JobInfo();
        job.setName("frame_import_" + billFormId + "_" + now);
        job.setNumber("frame_import_" + billFormId + "_" + now);
        job.setJobType(JobType.REALTIME);
        job.setAppId(serviceAppId);
        job.setTaskClassname("kd.bos.mvc.export.ImportDataTask");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("Type", type);
        params.put("ServiceAppId", serviceAppId);
        params.put("BillFormId", billFormId);
        params.put("Urls", urls);
        params.put("ExtendData", extendData);
        if (plugins != null && !plugins.isEmpty()) {
            params.put("Plugins", plugins);
        }
        job.setParams(params);
        log.info("before-JobClient.dispatch------billformid=" + billFormId + ", import_serviceappid=" + serviceAppId);
        String taskid = JobClient.dispatch((JobInfo)job);
        if (StringUtils.isNotBlank((CharSequence)taskid)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(urls.size() > 1 ? "bos_importprogress_batch" : "bos_importprogress");
            showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
            showParameter.setCustomParam("taskid", (Object)taskid);
            showParameter.setCustomParam("Urls", urls);
            showParameter.setParentPageId(view.getFormShowParameter().getParentPageId());
            showParameter.setCloseCallBack(view.getFormShowParameter().getCloseCallBack());
            view.showForm(showParameter);
        } else {
            view.showMessage(ResManager.loadKDString((String)"\u5f02\u6b65\u4efb\u52a1\u8fd4\u56detaskid\u4e3a\u7a7a", (String)"AbstractListView_9", (String)BOS_FORM_MVC, (Object[])new Object[0]));
        }
    }

    protected boolean isLinkQuery() {
        return false;
    }

    protected void setBillListFilterParameter(BillList billList) {
        GroupProp prop;
        if (this.context.getEntryEntity() != null) {
            billList.setEntryEntity(this.context.getEntryEntity());
        }
        billList.setClientQueryFilterParameter(this.context.getClientQueryFilterParameter());
        if (this.getTreeListView() != null && this.getTreeListView().getTreeModel() != null && this.getTreeListView().getTreeModel().getGroupProp() != null && this.getTreeListView().getTreeModel().getGroupProp().isNeedRefreshTree() && (prop = this.getTreeListView().getTreeModel().getGroupProp()) instanceof ParentBasedataProp) {
            this.getTreeListView().getTreeModel().getTreeFilter().addAll(this.context.getClientQueryFilterParameter().getQFilters());
        }
        MainEntityType entityType = (MainEntityType)billList.getEntityType();
        String dimAssistFidKey = entityType.getPermissionControlType().getDataAssistDimensionField();
        boolean isNotExistsOrNoLimit = !this.context.isContainMainOrg() || this.context.isMainOrgNoLimit();
        this.setMainOrgQFilter(billList, isNotExistsOrNoLimit, (ControlFilter)this.context.getControlFiltersMap().get(dimAssistFidKey + ".id"));
    }

    private List<QFilter> getDefaultDataFilters(BillList billList) {
        QFilter qFilter;
        ListShowParameter listShowParameter = (ListShowParameter)this.getFormShowParameter();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (listShowParameter.isShowApproved() && !this.context.isContainBillStatus() && (qFilter = PermissionFilterUtil.getApprovedFilter((EntityType)billList.getEntityType())) != null) {
            qFilters.add(qFilter);
        }
        if (listShowParameter.isShowUsed() && !this.context.isContainUsedStatus() && (qFilter = PermissionFilterUtil.getUsedFilter((EntityType)billList.getEntityType())) != null) {
            qFilters.add(qFilter);
        }
        return qFilters;
    }

    protected boolean isLookup() {
        boolean isLookup = false;
        if (this.getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)this.getFormShowParameter();
            isLookup = listShowParameter.isLookUp();
        }
        return isLookup;
    }

    private ListUserOption getListUserOption() {
        if (this.listUserOption != null) {
            return this.listUserOption;
        }
        ListShowParameter listShowParameter = (ListShowParameter)this.formShowParameter;
        this.listUserOption = listShowParameter.getListUserOption();
        if (this.listUserOption == null) {
            this.listUserOption = new ListUserOption();
        }
        return this.listUserOption;
    }

    protected void initialContext() {
        BillList billList = (BillList)this.getControl(this.context.getBillListId());
        if (billList != null) {
            ListShowParameter listShowParameter = (ListShowParameter)this.formShowParameter;
            if (StringUtils.isBlank((CharSequence)this.getBillFormId())) {
                this.cacheBillFormId(listShowParameter.getBillFormId());
            }
            this.context.setBillFormId(this.billFormId);
            this.context.setLookup(this.isLookup());
            this.context.setIsolationOrg(listShowParameter.isIsolationOrg());
            this.context.setBillListId(billList.getKey());
            billList.setBillFormId(this.billFormId);
            billList.setContext(this.context);
            billList.setListUserOption(this.getListUserOption());
            this.addBillListListener(billList);
        }
    }

    protected Map<String, Object> getListMetadata() {
        return null;
    }

    protected void addQingView() {
        if (!this.getListCache().getIsQingViewAdded() && this.qingView != null && !this.qingView.getItems().isEmpty()) {
            String pageId = this.getPageId();
            String sUrl = QingFormUtil.getQingURL((String)"/qing/qingViewEntrance.do");
            sUrl = QingFormUtil.appendParamToUrl((String)sUrl, (String)"pageId", (String)pageId);
            sUrl = QingFormUtil.appendParamToUrl((String)sUrl, (String)"appId", (String)this.getFormShowParameter().getServiceAppId());
            sUrl = QingFormUtil.appendParamToUrl((String)sUrl, (String)"billFormId", (String)this.getBillFormId());
            HashMap<String, Object> para = new HashMap<String, Object>();
            para.put("id", "qingview");
            para.put("src", sUrl);
            HashMap<String, Integer> metadata = new HashMap<String, Integer>();
            metadata.put("vi", this.qingView.getVisible());
            para.put("meta", metadata);
            IClientViewProxy proxy = (IClientViewProxy)this.getService(IClientViewProxy.class);
            proxy.invokeControlMethod(BILLLISTID, "addQingView", new Object[]{para});
            this.getListCache().setIsQingViewAdded(true);
        }
    }

    void afterSetMetadata(BillList billList) {
        if (this.getFormShowParameter().getFormConfig().isQingView()) {
            this.qingView = (QingView)FormMetadataCache.getListQingView((String)this.getBillFormId());
            if (this.qingView != null) {
                this.qingView.setParent(billList);
                this.qingView.setView((IFormView)this);
                if (!this.qingView.getItems().isEmpty()) {
                    BeforeCreateListColumnsArgs qingViewBeforeCreateListColumnsArgs = ViewCommonUtil.createContainerListColumns((Container)this.qingView, (ControlContext)this.context);
                    this.beforeCreateListColumnsArgs.getListColumns().addAll(qingViewBeforeCreateListColumnsArgs.getListColumns());
                    this.beforeCreateListColumnsArgs.getListGroupColumns().addAll(qingViewBeforeCreateListColumnsArgs.getListGroupColumns());
                }
                ArrayList<Control> items = new ArrayList<Control>();
                items.add((Control)this.qingView);
                this.createControlIndex(items);
            }
            this.addQingView();
        }
    }

    protected void setMetadata() {
        Map<String, Object> meta;
        BillList billList = (BillList)this.getControl(this.context.getBillListId());
        if (this.beforeCreateListColumnsArgs != null) {
            return;
        }
        this.beforeCreateListColumnsArgs = ViewCommonUtil.createBeforeCreateListColumnArgs((BillList)billList);
        if (this.beforeCreateListColumnsArgs.getListColumns().isEmpty() && this.beforeCreateListColumnsArgs.getListGroupColumns().isEmpty() && (meta = this.getListMetadata()) != null && meta.containsKey(BillList.class.getSimpleName())) {
            String strBillList = (String)meta.get(BillList.class.getSimpleName());
            BillList list = (BillList)ControlTypes.fromJsonString((String)strBillList);
            list.setView((IFormView)this);
            this.templeteRuntimeControlCompareAndInvisible(billList, list);
            this.beforeCreateListColumnsArgs = ViewCommonUtil.createBeforeCreateListColumnArgs((BillList)list);
            billList.setPageRow(list.getPageRow());
            billList.setDefaultView(list.getDefaultView());
            billList.setEntityId(list.getEntityId());
            billList.getItems().clear();
            billList.getItems().addAll(list.getItems());
            billList.setCtlTips(list.getCtlTips());
            billList.setHasFilter(list.isHasFilter());
            billList.setSummaryFieldId(list.getSummaryFieldId());
            billList.setSummaryFieldIds(list.getSummaryFieldIds());
            billList.setFilter(list.getFilter());
            billList.setMulti(list.isMulti());
            billList.setQueryType(list.getQueryType());
            billList.setSelectedAll(list.isSelectedAll());
            billList.setDefaultOrder(list.isDefaultOrder());
            billList.setSortSetting(list.getSortSetting());
            billList.setMulCurrencyFields(list.getMulCurrencyFields());
        }
        this.afterSetMetadata(billList);
    }

    private void templeteRuntimeControlCompareAndInvisible(BillList templeteView, BillList runtimeView) {
        List templeteControls = templeteView.getItems();
        List runtimeViewControls = runtimeView.getItems();
        HashSet<String> runtimeControlKeys = new HashSet<String>(16);
        for (Control control : runtimeViewControls) {
            runtimeControlKeys.add(control.getKey());
        }
        ArrayList<Object> needUpdateCommands = new ArrayList<Object>();
        for (Control control : templeteControls) {
            if (runtimeControlKeys.contains(control.getKey())) continue;
            needUpdateCommands.add(control.getKey());
            HashMap<String, Boolean> command = new HashMap<String, Boolean>(16);
            command.put("vi", Boolean.FALSE);
            needUpdateCommands.add(command);
        }
        if (!needUpdateCommands.isEmpty()) {
            this.getClientProxy().addAction("updateControlMetadata", needUpdateCommands);
        }
    }

    private String getBizAppId() {
        return ShowFormHelper.getBizAppId((FormShowParameter)this.getFormShowParameter());
    }

    Set<String> getListCanNotReadFields(String entityId) {
        if (this.canNotReadFields == null) {
            List<Long> selectedMainOrgIds = this.getSelectedMainOrgIds();
            this.canNotReadFields = ListPermissionService.getCanNotReadFields((String)this.getBizAppId(), (String)entityId, selectedMainOrgIds.size() == 1 ? selectedMainOrgIds.get(0) : null);
        }
        return this.canNotReadFields;
    }

    protected void initBillListByMetadata() {
        BillList list = (BillList)this.getControl(this.context.getBillListId());
        this.setMetadata();
        if (list.getCreateListColumnsListenerListeners() != null) {
            for (Object myCreateListColumnsListener : list.getCreateListColumnsListenerListeners()) {
                myCreateListColumnsListener.createListColumns(this.beforeCreateListColumnsArgs);
            }
        }
        ListColumnContext listColumnContext = new ListColumnContext(this.getListCanNotReadFields(list.getEntityType().getName()), this.context.getBlackFields(), this.context.isSingleOrgMode());
        for (IListColumn listColumn : this.beforeCreateListColumnsArgs.getListColumns()) {
            listColumn.setContext(listColumnContext);
        }
        for (IListColumn listColumn : this.beforeCreateListColumnsArgs.getMergeListColumns()) {
            listColumn.setContext(listColumnContext);
        }
        for (IListColumn listColumn : this.beforeCreateListColumnsArgs.getDynamicTextListColumns()) {
            listColumn.setContext(listColumnContext);
        }
        list.setBeforeCreateListColumnsArgs(this.beforeCreateListColumnsArgs);
        List entryEntityDtos = ViewCommonUtil.getValidEntryListByListColumn((EntityType)list.getEntityType(), (List)this.beforeCreateListColumnsArgs.getListColumns());
        this.context.setEntryEntityDtos(entryEntityDtos);
        this.context.setBillListEntityId(list.getEntityType().getName());
        this.getListCache().setBillEntityId(list.getEntityType().getName());
    }

    protected void initFilterGridView() {
    }

    void initListModel() {
        BillList billList = (BillList)this.getControl(this.context.getBillListId());
        if (billList != null) {
            this.listModel = billList.getListModel();
        }
    }

    public AbstractGrid.GridState getGridState() {
        BillList billList = (BillList)this.getControl(this.context.getBillListId());
        return billList.getEntryState();
    }

    public List<IListColumn> getShowListColumns() {
        BillList billList = (BillList)this.getControl(this.context.getBillListId());
        return billList.getShowListColumns();
    }

    protected List<ListField> getListFields() {
        BillList billList = (BillList)this.getControl(this.context.getBillListId());
        return billList.getListFields();
    }

    protected void openBillOrReturnData() {
    }

    protected void fireListRowFilter(AbstractListViewPluginProxy abstractListViewPluginProxy, ListRowFilterEvent listRowFilterEvent) {
        abstractListViewPluginProxy.fireListRowFilter(listRowFilterEvent);
    }

    protected void fireListRowClick(AbstractListViewPluginProxy abstractListViewPluginProxy, ListRowClickEvent listrowclickevent) {
        abstractListViewPluginProxy.fireListRowClick(listrowclickevent);
    }

    private void fireListExpandClick(AbstractListViewPluginProxy abstractListViewPluginProxy, ListExpandEvent evt) {
        abstractListViewPluginProxy.fireListExpandClick(evt);
    }

    private void fireListHyperLinkClick(AbstractListViewPluginProxy abstractListViewPluginProxy, ListHyperLinkClickEvent evt) {
        abstractListViewPluginProxy.fireListHyperLinkClick(evt);
    }

    private void fireToolbarItemClick(AbstractListViewPluginProxy abstractListViewPluginProxy) {
        Toolbar toolbar = (Toolbar)this.getControl(TOOLBARID);
        if (toolbar != null) {
            toolbar.addItemClickListener(new ItemClickListener(){

                public void beforeItemClick(BeforeItemClickEvent evt) {
                    if ("exportlistbyselectfields".equals(evt.getOperationKey()) || "listprintpreview".equals(evt.getOperationKey())) {
                        AbstractListView.this.initFilterGridView();
                        AbstractListView.this.initBillListByMetadata();
                        super.beforeItemClick(evt);
                    }
                }
            });
        }
        abstractListViewPluginProxy.fireToolbarItemClick();
    }

    public void registerListener() {
        final AbstractListViewPluginProxy abstractListViewPluginProxy = (AbstractListViewPluginProxy)this.getService(FormViewPluginProxy.class);
        BillList list = (BillList)this.getControl(this.context.getBillListId());
        if (list != null) {
            this.checkPermissionCacheAndReset(list);
            list.addListRowClickListener(new ListRowClickListener(){

                public void listRowClick(ListRowClickEvent listrowclickevent) {
                    AbstractListView.this.initFilterGridView();
                    AbstractListView.this.initBillListByMetadata();
                    AbstractListView.this.fireListRowClick(abstractListViewPluginProxy, listrowclickevent);
                }
            });
            list.addListFieldsControlListeners(listFieldsControlEvent -> {
                list.setListFieldsControlColumns(this.getListFieldsControlColumns());
                this.initBillListByMetadata();
            });
            list.addChatListener(t -> abstractListViewPluginProxy.fireChat(t));
            list.addListRowDetailShowListeners(listRowDetailShowEvent -> {
                this.initBillListByMetadata();
                this.addPackageDataListener(list);
                this.addBeforePackageDataListener(list);
            });
            list.addListRowSelectAllListeners(listRowSelectAllEvent -> {
                this.initBillListByMetadata();
                this.initFilterGridView();
            });
            list.addListExpandListener(evt -> {
                this.initBillListByMetadata();
                this.fireListExpandClick(abstractListViewPluginProxy, evt);
            });
            list.addListHyperLinkClickListener(evt -> {
                this.initBillListByMetadata();
                this.fireListHyperLinkClick(abstractListViewPluginProxy, evt);
            });
            this.fireToolbarItemClick(abstractListViewPluginProxy);
            list.addListRowSortListeners(listRowSortEvent -> this.initFilterGridView());
            list.addListRowFilterListeners(listRowFilterEvent -> {
                this.initFilterGridView();
                this.fireListRowFilter(abstractListViewPluginProxy, (ListRowFilterEvent)listRowFilterEvent);
            });
            list.addQueryBillDataCountListener(queryBillDataCountEvent -> this.initFilterGridView());
            list.addQueryRealCountListener(queryRealCountEvent -> this.initFilterGridView());
            list.addQueryExceedMaxCountListener(queryExceedMaxCountEvent -> this.initFilterGridView());
            list.addQuerySumDataListener(querySumDataEvent -> this.initFilterGridView());
            list.addPagerClickListener(pagerClickEvent -> this.initFilterGridView());
            list.addSelectPageAllRowsListener(selectPageAllRowsEvent -> this.initFilterGridView());
            list.addSetCellsDataListener(setCellsDataEvent -> this.initBillListByMetadata());
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"AbstractListView.closedCallBack");){
            boolean isNeedrefreshTree;
            BillList billList = (BillList)this.getControl(this.context.getBillListId());
            boolean bl = isNeedrefreshTree = this.getTreeListView() != null && this.getTreeListView().getTreeModel().getGroupProp() != null && this.getTreeListView().getTreeModel().getGroupProp().isNeedRefreshTree();
            if (!isNeedrefreshTree) {
                String dataChanged;
                if ("listoperation".equals(closedCallBackEvent.getActionId()) && "1".equals(dataChanged = this.getPageCache().get("listdatachanged"))) {
                    if (billList != null) {
                        billList.getEntryState().setKeepPageData(false);
                    }
                    this.refreshOnClosedCallBack();
                    this.getPageCache().remove("listdatachanged");
                    if (billList != null) {
                        billList.getEntryState().setKeepPageData(true);
                    }
                }
                return;
            }
            ITreeListView treeListView = this.getTreeListView();
            if (treeListView.getTreeModel().getRoot() == null) {
                treeListView.refresh();
                return;
            }
            Object value = closedCallBackEvent.getReturnData();
            if (value == null) {
                String dataChanged = this.getPageCache().get("listdatachanged");
                if ("1".equals(dataChanged)) {
                    if (billList != null) {
                        billList.getEntryState().setKeepPageData(false);
                    }
                    if ("parent".equals(this.getTreeListView().getTreeModel().getGroupProp().getName())) {
                        String rootId = treeListView.getTreeModel().getRoot().getId();
                        treeListView.getTreeModel().refreshNode((Object)rootId);
                        treeListView.refreshTreeNode(rootId);
                    }
                    if (billList != null) {
                        this.refresh();
                    }
                    this.getPageCache().remove("listdatachanged");
                    if (billList != null) {
                        billList.getEntryState().setKeepPageData(true);
                    }
                }
                return;
            }
            if (!(value instanceof Map)) {
                String currenNodeId = value.toString();
                treeListView.getTreeModel().refreshNode((Object)currenNodeId);
                treeListView.refreshTreeNode(currenNodeId);
                if (billList != null) {
                    this.refresh();
                }
                return;
            }
            Map map = (Map)value;
            String isneedRefresh = (String)map.get("isNeedRefresh");
            if ("false".equals(isneedRefresh)) {
                if (billList != null) {
                    this.refresh();
                }
                return;
            }
            String currenNodeId = (String)map.get("currentNode");
            String parentId = (String)map.get("parentId");
            String rootId = treeListView.getTreeModel().getRoot().getId();
            TreeNode currenNode = treeListView.getTreeModel().getRoot().getTreeNode(currenNodeId);
            String oldParent = null;
            String oldText = null;
            if (currenNode != null) {
                oldParent = currenNode.getParentid();
                oldText = currenNode.getText();
            }
            if (StringUtils.isBlank((CharSequence)parentId)) {
                treeListView.getTreeModel().refreshNode((Object)rootId);
            } else {
                treeListView.getTreeModel().refreshNode((Object)parentId);
            }
            currenNode = treeListView.getTreeModel().getRoot().getTreeNode(currenNodeId);
            if (currenNode != null) {
                if (StringUtils.isBlank((CharSequence)oldParent) || oldParent != null && !oldParent.equals(parentId)) {
                    treeListView.getTreeModel().refreshNode((Object)rootId);
                    treeListView.refreshTreeNode(rootId);
                } else if (oldText != null && !oldText.equals(currenNode.getText())) {
                    treeListView.getTreeModel().refreshNode((Object)currenNodeId);
                    treeListView.refreshTreeNode(currenNodeId);
                }
            } else {
                treeListView.getTreeModel().refreshNode((Object)rootId);
                treeListView.getTreeView().updateNode(treeListView.getTreeModel().getRoot());
                treeListView.getTreeView().focusNode(treeListView.getTreeModel().getRoot());
            }
            if (billList != null) {
                this.refresh();
                this.refreshQingView();
            }
        }
    }

    protected void refreshOnClosedCallBack() {
        this.refresh();
    }

    @Override
    public <T extends Control> T getControl(String key) {
        Object ctl = super.getControl(key);
        if (ctl == null) {
            if (this.context.getBillListId().equalsIgnoreCase(key)) {
                throw new KDException(BosErrorCode.metaNotFound, new Object[]{ResManager.loadKDString((String)"\u5355\u636e\u5217\u8868\u63a7\u4ef6\u4e0d\u5b58\u5728\u3002", (String)"AbstractListView_10", (String)BOS_FORM_MVC, (Object[])new Object[0])});
            }
            if (TREEVIEWID.equalsIgnoreCase(key) || this.context.getF7SeletedControlId().equalsIgnoreCase(key)) {
                return null;
            }
            this.setMetadata();
            BillList billList = (BillList)this.getControl(this.context.getBillListId());
            this.createControlIndex(billList.getItems());
            return super.getControl(key);
        }
        return ctl;
    }

    protected String getProfileKey() {
        return this.getBillFormId();
    }

    @Override
    @KSMethod
    public void close() {
        this.storeUserConfig();
        PageRowCacheUtils.clearPageRowcache((String)this.getPageId());
        super.close();
    }

    void storeUserConfig() {
        ThreadPools.executeOnceIncludeRequestContext((String)((Object)((Object)this)).getClass().getSimpleName(), () -> {
            ListUserConfig listUserConfig = new ListUserConfig();
            listUserConfig.setPageRows(this.getGridState().getPageRows());
            Optional filterMode = this.getListCache().getFilterMode();
            if (filterMode.isPresent()) {
                listUserConfig.setFilterMode((Integer)filterMode.get());
            }
            listUserConfig.store(this.getProfileKey());
        });
    }

    public ControlFilters getControlFilters() {
        return this.controlFilters;
    }

    public void requestGridInfo() {
        IClientViewProxy proxy = (IClientViewProxy)this.getService(IClientViewProxy.class);
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        map.put("types", new String[]{"cw", "cv", "ca", "cs"});
        proxy.invokeControlMethod(BILLLISTID, "getGridInfo", new Object[]{map});
    }

    public String preview(PaperSetting info) {
        AbstractGrid.GridState state = this.getGridState();
        int startIndex = (state.getCurrentPageIndex() - 1) * state.getPageRows();
        ArrayList<IListColumn> columns = new ArrayList<IListColumn>();
        for (IListColumn col : this.getShowListColumns()) {
            boolean isExist;
            if (col.getListFieldKey() == null || (isExist = columns.stream().anyMatch(p -> p.getListFieldKey().contentEquals(col.getListFieldKey())))) continue;
            columns.add(col);
        }
        BillList billList = (BillList)this.getControl(this.context.getBillListId());
        QueryResult queryReslt = billList.queryBatchData(true, startIndex, state.getPageRows().intValue());
        String gridViewKey = "";
        Optional<Control> opt = billList.getItems().stream().filter(p -> p instanceof ListGridView).findFirst();
        if (opt.isPresent()) {
            ListGridView gridView = (ListGridView)opt.get();
            gridViewKey = gridView.getKey();
        }
        String setting = UserConfigServiceHelper.getSetting((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getFormShowParameter().getSettingKey());
        Map columnSetting = new HashMap();
        if (StringUtils.isNotBlank((CharSequence)setting)) {
            Map settingMap = (Map)SerializationUtils.fromJsonString((String)setting, Map.class);
            columnSetting = (Map)settingMap.get(gridViewKey);
            StringBuilder s = new StringBuilder();
            s.append(ResManager.loadKDString((String)"\u83b7\u53d6\u5230\u7684\u5217\u8868\u4e2a\u4eba\u8bbe\u7f6e\uff1a", (String)"AbstractListView_19", (String)BOS_FORM_MVC, (Object[])new Object[0])).append(setting).append(" gridViewKey:").append(gridViewKey);
            log.info(s.toString());
        }
        FieldControlRules fieldControlRules = billList.getFieldControlRules();
        String tempUrl = "";
        String exporterClassName = "kd.bos.mvc.export.ListPdfExporter";
        try {
            IExporter exporter = (IExporter)Class.forName(exporterClassName).newInstance();
            IFormView view = this.getView(this.getPageId());
            if (view != null) {
                info.setAppId(view.getFormShowParameter().getAppId());
            }
            tempUrl = exporter.export(fieldControlRules, this.context.getBillFormId(), columns, queryReslt, columnSetting, info);
        }
        catch (KDException e) {
            if (e.getErrorCode().equals((Object)BosErrorCode.reportHeadEmpty)) {
                this.showErrorNotification(BosErrorCode.reportHeadEmpty.getMessage());
            }
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
        return tempUrl;
    }

    public String print(PaperSetting info) {
        return "";
    }

    protected void openBill() {
        if (Boolean.TRUE.equals(SystemParamServiceHelper.isViewBill((String)this.getEntityTypeId()))) {
            String operationKey = "view";
            ListSelectedRow currentSelectedRowInfo = this.getCurrentSelectedRowInfo();
            if (currentSelectedRowInfo != null && "A".equals(currentSelectedRowInfo.getBillStatus())) {
                operationKey = "modify";
            }
            if (Boolean.getBoolean("list.viewbill")) {
                operationKey = "view";
            }
            this.invokeOperation(operationKey);
        } else {
            this.invokeOperation("modify");
        }
    }

    public void setConfirmDeleteMsg(String deleteConfirmMsg) {
        this.getListCache().setDeleteConfirmMsg(deleteConfirmMsg);
    }

    protected void sendHotTips() {
        List tipsList;
        IHotTipsService hotTipsService = (IHotTipsService)ServiceFactory.getService(IHotTipsService.class);
        if (hotTipsService.enableHotTips() && (tipsList = hotTipsService.getHotTips(this.getPageId())) != null && !tipsList.isEmpty()) {
            ((IClientViewProxy)this.getService(IClientViewProxy.class)).addAction("setTips", (Object)tipsList);
        }
    }

    @SdkInternal
    public void showListColumnSetting(String schemeId) {
        BillList billList = (BillList)this.getControl(this.context.getBillListId());
        this.initBillListByMetadata();
        billList.showListColumnSetting(schemeId);
    }

    @SdkInternal
    public void showListSort(String schemeId) {
        BillList billList = (BillList)this.getControl(this.context.getBillListId());
        this.initBillListByMetadata();
        billList.showListSort(schemeId);
    }

    @SdkInternal
    boolean isNeedCheckMainOrgQFilter() {
        return false;
    }

    private void checkPermissionCacheAndReset(BillList list) {
        String opMethod;
        OperationContext operationContext = OperationContext.get();
        if (operationContext != null && !UNSUPPORTED_CHECKMAINORGQFILTER_METHODS.contains(opMethod = operationContext.getOpMethod())) {
            ListCache listCache = new ListCache((IPageCache)this.getService(IPageCache.class), list.getKey());
            if (this.isNeedCheckMainOrgQFilter() && !listCache.isExsitMainOrgQFilter()) {
                this.setMainOrgQFilter(list, true, null);
                log.info("check MainOrgQFilter is null and reset");
            }
            if (!listCache.isExsitSpecialDataPermQFilter()) {
                list.setSpecialDataPermQFilter(this.getSpecialDataPermQFilter());
                log.info("check SpecialDataPermQFilter is null and reset");
            }
            if (!listCache.isExsitDataPermQFilters()) {
                list.setDataPermQFilters(this.getDataPermQFilters());
                log.info("check DataPermQFilters is null and reset");
            }
            if (!listCache.isExsitFieldControlRules()) {
                list.setFieldControlRules(this.getFieldControlRules());
                log.info("check FieldControlRules is null and reset");
            }
        }
    }

    private void setMainOrgQFilter(BillList billList, boolean isNotExistsOrNoLimit, ControlFilter dimAssistControlFilter) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getFormShowParameter();
        MainOrgProp mainOrgProp = PermissionFilterUtil.getMainOrgProp((MainEntityType)((MainEntityType)billList.getEntityType()));
        MainEntityType entityType = (MainEntityType)billList.getEntityType();
        String dimFldKey = entityType.getPermissionControlType().getDataDimensionField();
        String dimAssistFidKey = entityType.getPermissionControlType().getDataAssistDimensionField();
        boolean isControlFuction = entityType.getPermissionControlType().isControlFunction();
        boolean isDim = isControlFuction && StringUtils.isNotBlank((CharSequence)dimFldKey) && !"null".equals(dimFldKey);
        boolean isMainOrg = mainOrgProp != null && !isDim;
        String entityTypeId = this.getEntityTypeId();
        String appId = listShowParameter.getAppId();
        billList.setMainOrgQFilter(null);
        if (!listShowParameter.isLookUp() && (isDim || isMainOrg)) {
            if (!listShowParameter.isIsolationOrg()) {
                if (this.getSelectedMainOrgIds().isEmpty() && isNotExistsOrNoLimit) {
                    billList.setMainOrgQFilter(null);
                }
            } else {
                if (this.isLinkQuery()) {
                    billList.setMainOrgQFilter(null);
                    return;
                }
                DynamicObject defCtrlStrthy = BaseDataServiceHelper.getDefaultCtrlStrtgy((String)billList.getEntityType().getName());
                if (defCtrlStrthy != null) {
                    billList.setMainOrgQFilter(null);
                    return;
                }
                MainOrgFilterResult mainOrgQFilter = MainOrgFilterUtil.getMainOrgQFilter(entityType, mainOrgProp, dimFldKey, dimAssistFidKey, isDim, entityTypeId, appId, isNotExistsOrNoLimit, this.getSelectedMainOrgIds(), dimAssistControlFilter);
                if (mainOrgQFilter.isNewMainOrgIds()) {
                    this.setSelectedMainOrgIds(mainOrgQFilter.getMainOrgIds());
                }
                if (mainOrgQFilter.getMainOrgIds() != null) {
                    billList.setSelectedMainOrgIds(mainOrgQFilter.getMainOrgIds());
                }
                billList.setMainOrgQFilter(mainOrgQFilter.getMainOrgFilter());
            }
        }
    }

    private QFilter getSpecialDataPermQFilter() {
        String entityNumber = this.getListModel().getDataEntityType().getName();
        String bizAppId = ShowFormHelper.getBizAppId((FormShowParameter)this.getFormShowParameter());
        ITimeService timeService = (ITimeService)this.getService(ITimeService.class);
        IUserService userService = (IUserService)this.getService(IUserService.class);
        return PermissionFilterUtil.getSpecialDataPermissionFilter((String)bizAppId, (String)entityNumber, (String)"view", (ITimeService)timeService, (IUserService)userService);
    }

    private List getDataPermQFilters() {
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        long userId = Long.parseLong(RequestContext.get().getUserId());
        String entityNumber = this.getListModel().getDataEntityType().getName();
        String bizAppId = ShowFormHelper.getBizAppId((FormShowParameter)this.getFormShowParameter());
        ListShowParameter listShowParameter = (ListShowParameter)this.getFormShowParameter();
        HashMap<String, Comparable<Boolean>> customParams = new HashMap<String, Comparable<Boolean>>();
        customParams.put("isLookUp", Boolean.valueOf(this.isLookup()));
        customParams.put("UseOrgId", Long.valueOf(listShowParameter.getUseOrgId()));
        customParams.putAll(this.getFormShowParameter().getCustomParams());
        return Collections.singletonList(permissionService.getDataPermWithOrg(userId, bizAppId, entityNumber, customParams));
    }

    private FieldControlRules getFieldControlRules() {
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        long userId = Long.parseLong(RequestContext.get().getUserId());
        String entityNumber = this.getListModel().getDataEntityType().getName();
        String bizAppId = ShowFormHelper.getBizAppId((FormShowParameter)this.getFormShowParameter());
        String checkRightAppId = this.getFormShowParameter().getCheckRightAppId();
        if (StringUtils.isNotBlank((CharSequence)checkRightAppId)) {
            bizAppId = checkRightAppId;
        }
        return permissionService.getFieldControlRules(userId, bizAppId, entityNumber);
    }
}

