/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.list;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.IQuery;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.list.SummaryResult;
import kd.bos.entity.list.option.ListUserOption;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IPageCache;
import kd.bos.list.query.PageRowCacheUtils;
import kd.bos.list.query.QueryFactory;
import kd.bos.list.query.impl.CountQuery;
import kd.bos.list.query.impl.IdQuery;
import kd.bos.list.query.impl.SumQuery;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.list.BillListContext;
import kd.bos.mvc.list.GroupByDispatcherContext;
import kd.bos.mvc.list.ListDataProviderContext;
import kd.bos.mvc.list.ListDataProviderMask;
import kd.bos.mvc.list.QueryBuilderContext;
import kd.bos.mvc.list.QueryBuilderFactory;
import kd.bos.mvc.list.SumDispatcherContext;
import kd.bos.mvc.list.SummaryResultsCache;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;
import org.jetbrains.annotations.NotNull;

@KSObject
@SdkPublic
public class ListDataProvider
implements IListDataProvider {
    private static final String SPAN_TYPE_NAME = "list";
    IQuery query = QueryFactory.createQuery();
    List<IDataEntityType> dataEntityTypes;
    List<SqlParameter> param = new ArrayList<SqlParameter>();
    private boolean isRegisterProperty;
    private ListDataProviderContext context;
    private BillListContext billListContext;
    private List<ListField> visibleSelectFieldList = new ArrayList<ListField>();

    void setBillListContext(BillListContext billListContext) {
        this.context.setBillListContext(billListContext);
        this.billListContext = billListContext;
    }

    BillListContext getOrCreateBillListContext() {
        if (this.billListContext == null) {
            this.billListContext = new BillListContext();
        }
        return this.billListContext;
    }

    protected boolean isRegisterProperty() {
        return this.isRegisterProperty;
    }

    void setForExport(boolean forExport) {
        this.context.setForExport(forExport);
    }

    IQuery getQuery() {
        return this.query;
    }

    protected boolean isOnlyPK4SelectedAllRows() {
        return false;
    }

    @Deprecated
    public void setDefaultOrder(boolean defaultOrder) {
        this.getOrCreateBillListContext().setDefaultOrder(defaultOrder);
    }

    public QueryBuilder getQueryBuilder() {
        return this.context.getQueryBuilder();
    }

    public void setQueryBuilder(QueryBuilder queryBuilder) {
        this.context.setQueryBuilder(queryBuilder);
    }

    @Deprecated
    protected void setNeedResum(boolean isNeedResum) {
        this.getOrCreateBillListContext().setNeedResum(isNeedResum);
    }

    @Deprecated
    protected void setSelectedAllRows(boolean isSelectedAllRows) {
        this.getOrCreateBillListContext().setSelectedAllRows(isSelectedAllRows);
    }

    @Deprecated
    public void setListUserOption(ListUserOption listUserOption) {
        this.getOrCreateBillListContext().setListUserOption(listUserOption);
    }

    public List<IDataEntityType> getDataEntityTypes() {
        return this.dataEntityTypes;
    }

    @Deprecated
    public void setDataEntityTypes(List<IDataEntityType> dataEntityTypes) {
        this.dataEntityTypes = dataEntityTypes;
    }

    public void setParam(List<SqlParameter> param) {
        this.param = param;
    }

    public String getOrderByExpr() {
        return this.context.getOrderByExpr();
    }

    public void setOrderByExpr(String orderByExpr) {
        this.context.setOrderByExpr(orderByExpr);
    }

    public void addQFilters(QFilter qFilter) {
        this.context.getQFilters().add(qFilter);
    }

    public List<QFilter> getQFilters() {
        return this.context.getQFilters();
    }

    public void setQFilters(List<QFilter> qFilters) {
        this.context.setQFilters(qFilters);
    }

    public List<ListField> getListFields() {
        return this.context.getListFields();
    }

    public void setListFields(List<ListField> listFields) {
        this.context.setListFields(listFields);
    }

    public List<ListField> getPKFields() {
        return this.context.getPkFields();
    }

    public void setPKFields(List<ListField> pkFields) {
        this.context.setPkFields(pkFields);
    }

    public List<ListField> getKeyFields() {
        return this.context.getKeyFields();
    }

    public void setKeyFields(List<ListField> keyFields) {
        this.context.setKeyFields(keyFields);
    }

    public EntityType getEntityType() {
        return this.context.getEntityType();
    }

    public void setEntityType(EntityType entityType) {
        this.context.setEntityType(entityType);
    }

    public QueryResult getQueryResult() {
        return this.query.getQueryResult();
    }

    public List<ListField> getVisibleSelectFieldList() {
        return this.visibleSelectFieldList;
    }

    public void setVisibleSelectFieldList(List<ListField> visibleSelectFieldList) {
        this.visibleSelectFieldList = visibleSelectFieldList;
    }

    public ListUserOption getListUserOption() {
        return this.getOrCreateBillListContext().getListUserOption();
    }

    public boolean isNeedResum() {
        return this.getOrCreateBillListContext().isNeedResum();
    }

    public boolean isCustomListDataProvider() {
        return this.context.isCustomListDataProvider();
    }

    public void setCustomListDataProvider(boolean isCustomListDataProvider) {
        this.context.setCustomListDataProvider(isCustomListDataProvider);
    }

    public ListDataProvider() {
        this.context = new ListDataProviderContext();
    }

    public ListDataProvider(EntityType entityType, List<ListField> listFields, List<ListField> pkFields, List<ListField> keyFields) {
        this();
        this.setEntityType(entityType);
        this.setListFields(listFields);
        this.setPKFields(pkFields);
        this.setKeyFields(keyFields);
    }

    @ListDataProviderMask.Native
    public DynamicObjectCollection getData(int start, int limit) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"ListDataProvider.getData");){
            this.initContext(start, limit);
            QueryBuilder qBuilder = this.context.getQueryBuilder();
            if (span.isRealtime()) {
                span.addLocaleTag("queryBuilder", (Object)qBuilder);
                span.addLocaleTag("listFields", this.getListFields());
                span.addLocaleTag("pkFields", this.getPKFields());
                span.addLocaleTag("isCustomListDataProvider", (Object)this.context.isCustomListDataProvider());
                span.addLocaleTag("isDefaultOrder", (Object)this.getOrCreateBillListContext().isDefaultOrder());
                span.addLocaleTag("maxReturnData", (Object)this.getMaxReturnData());
                span.addLocaleTag("queryType", (Object)(this.query instanceof IdQuery ? "idquery" : "sqlquery"));
            }
            DynamicObjectCollection dynamicObjectCollection = this.query.getData(qBuilder);
            return dynamicObjectCollection;
        }
    }

    protected void initContext(int start, int limit) {
        if (this.context.isCustomListDataProvider() && !this.isRegisterProperty()) {
            QueryBuilder thisQueryBuilder;
            String orderBy = null;
            boolean isSelectedAllRows = this.getOrCreateBillListContext().isSelectedAllRows();
            if (isSelectedAllRows && this.isOnlyPK4SelectedAllRows()) {
                thisQueryBuilder = QueryBuilderFactory.createQueryBuilder((IListDataProvider)this, start, limit, new QueryBuilderContext(true, this.getOrCreateBillListContext()));
                orderBy = thisQueryBuilder.getOrderBys();
                ArrayList<ListField> listFields = new ArrayList<ListField>(this.getPKFields());
                this.setListFields(listFields);
                this.setKeyFields(listFields);
            }
            thisQueryBuilder = QueryBuilderFactory.createQueryBuilder((IListDataProvider)this, start, limit, new QueryBuilderContext(false, this.getOrCreateBillListContext()));
            if (orderBy != null) {
                thisQueryBuilder.setOrderBys(orderBy);
            }
            this.setQueryBuilder(thisQueryBuilder);
        }
        if (this.context.isForExport()) {
            this.context.getQueryBuilder().setMaxReturnData(-1);
        }
        if (this.context.isForceSqlQuery() || StringUtils.isEmpty((CharSequence)this.getQueryBuilder().getOrderBys())) {
            this.query = QueryFactory.createSqlQuery();
        }
        this.query.setDataEntityTypes(this.dataEntityTypes);
    }

    @Deprecated
    public int getDataCount() {
        return 0;
    }

    @ListDataProviderMask.Native
    public int getRealCount() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"ListDataProvider.getRealCount");){
            int n = CountQuery.getCount((QueryBuilder)this.context.getQueryBuilder());
            return n;
        }
    }

    @ListDataProviderMask.Native
    public int getMaxCount() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"ListDataProvider.getMaxCount");){
            this.context.getQueryBuilder().setExceedMaxCount(true);
            int n = CountQuery.getCount((QueryBuilder)this.context.getQueryBuilder());
            return n;
        }
    }

    public boolean isExceedMaxCount() {
        return CountQuery.isExceedMaxCount((QueryBuilder)this.context.getQueryBuilder());
    }

    public int getBillDataCount() {
        return CountQuery.getBillDataCount((QueryBuilder)this.context.getQueryBuilder());
    }

    @ListDataProviderMask.Native
    public List<SummaryResult> getSummaryResults() {
        IPageCache pageCache = SessionManager.getCurrent().getPageCache(this.getOrCreateBillListContext().getPageId());
        SummaryResultsCache summaryResultsCache = new SummaryResultsCache(pageCache, PageRowCacheUtils.getControlKey(), this.getQueryBuilder().getGroupBySumFields());
        List<SummaryResult> summaryResults = summaryResultsCache.getGroupBySummaryResults(this.createGroupByDispatcherContext());
        int mask = ListDataProviderMask.mask(this.getClass());
        if (!this.getOrCreateBillListContext().isAsyncSum() || (mask & 8) > 0) {
            List syncSummaryResults = summaryResultsCache.getCachedSummaryResults();
            if (syncSummaryResults.isEmpty()) {
                try {
                    syncSummaryResults = SumQuery.getSummaryResults((QueryBuilder)this.context.getQueryBuilder());
                    summaryResultsCache.cacheSummaryResults(syncSummaryResults);
                    summaryResults.addAll(syncSummaryResults);
                }
                catch (KDException e) {
                    if (e.getErrorCode() == BosErrorCode.sQLRWTimeOut) {
                        summaryResultsCache.cacheSyncTimeoutResult(this.getNotGroupBySumFields().stream().map(f -> f.getListFieldKey() != null ? f.getListFieldKey() : f.getKey()).collect(Collectors.toList()));
                    }
                    throw e;
                }
            } else {
                summaryResults.addAll(syncSummaryResults);
            }
        } else {
            summaryResults.addAll(summaryResultsCache.getSummaryResults(this.createSumDispatcherContext()));
        }
        return summaryResults;
    }

    private SumDispatcherContext createSumDispatcherContext() {
        SumDispatcherContext sumDispatcherContext = new SumDispatcherContext(this.getNotGroupBySumFields(), this.billListContext.getAppId(), this.billListContext.getRootPageId(), this.billListContext.getPageId(), (MainEntityType)this.getQueryBuilder().getEntityType(), this.billListContext.getMainOrgId());
        sumDispatcherContext.setEntityName(this.getQueryBuilder().getEntityName());
        sumDispatcherContext.setFilters(this.getQueryBuilder().getFilters());
        return sumDispatcherContext;
    }

    @NotNull
    private List<ListField> getNotGroupBySumFields() {
        List sumFields = this.getQueryBuilder().getSumFields();
        ArrayList<ListField> notGroupBySumFields = new ArrayList<ListField>(sumFields.size());
        for (ListField sumField : sumFields) {
            if ((sumField.getListFieldKey() == null || this.getQueryBuilder().getGroupBySumFields().contains(sumField.getListFieldKey())) && (sumField.getListFieldKey() != null || sumField.getKey() == null || this.getQueryBuilder().getGroupBySumFields().contains(sumField.getKey()))) continue;
            notGroupBySumFields.add(sumField);
        }
        return notGroupBySumFields;
    }

    private GroupByDispatcherContext createGroupByDispatcherContext() {
        GroupByDispatcherContext groupByDispatcherContext = new GroupByDispatcherContext(this.getQueryBuilder().getGroupBySumFields(), this.billListContext.getAppId(), this.billListContext.getRootPageId(), this.billListContext.getPageId(), (MainEntityType)this.getQueryBuilder().getEntityType(), this.billListContext.getMainOrgId());
        groupByDispatcherContext.setEntityName(this.getQueryBuilder().getEntityName());
        groupByDispatcherContext.setFilters(this.getQueryBuilder().getFilters());
        return groupByDispatcherContext;
    }

    public int getMaxReturnData() {
        return this.getOrCreateBillListContext().getMaxReturnData();
    }

    @Deprecated
    public void setMaxReturnData(int maxReturnData) {
        this.getOrCreateBillListContext().setMaxReturnData(maxReturnData);
    }

    public void setForceSqlQuery(boolean forceSqlQuery) {
        this.context.setForceSqlQuery(forceSqlQuery);
    }

    public boolean isForceSqlQuery() {
        return this.context.isForceSqlQuery();
    }
}

