/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.events.LocateEvent;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.privacy.PrivacyCenterUtils;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.MobLocation;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.filter.MobileSearchFilterValues;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidataErrorCode;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.mcontrol.MobFilterSort;
import kd.bos.form.ClientMethod;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.QingCachedFilterHolder;
import kd.bos.form.QingCachedFilterValues;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterMobileListPushDownRefreshListener;
import kd.bos.form.events.MobFilterSortInitArgs;
import kd.bos.form.events.MobFilterSortSearchClickArgs;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.list.BillList;
import kd.bos.list.IMobileListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MobControlContext;
import kd.bos.list.MobileSearch;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListViewPluginProxy;
import kd.bos.list.plugin.MobListViewPluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormController;
import kd.bos.mvc.form.MobLocationProvider;
import kd.bos.mvc.list.AbstractListView;
import kd.bos.mvc.list.MobileListController;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.ParameterReader;
import kd.bos.script.annotations.KSMethod;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class MobileListView
extends AbstractListView
implements IMobileListView {
    private static final String BOS_FORM_MVC = "bos-form-mvc";
    private static final Log log = LogFactory.getLog(MobileListView.class);
    private static final String SPAN_TYPE_NAME = "list";
    private static final String CLEAR_DATA = "clearData";
    private static final String MOBILESEARCHID = "mobilesearchap";
    AfterMobileListPushDownRefreshListener mobileListPushDownRefreshListener;

    public MobileListView() {
        this.context = new MobControlContext();
    }

    @Override
    public QingCachedFilterHolder getQingCachedFilterHolder() {
        MobileSearch mobileSearch = (MobileSearch)this.getControl(this.context.getMobileSearchId());
        if (mobileSearch != null) {
            return new QingCachedFilterHolder(new QingCachedFilterValues(this.context.getMobileSearchId(), (Object)mobileSearch.getMobileSearchFilterValues()));
        }
        return super.getQingCachedFilterHolder();
    }

    @Override
    protected void refreshAfterEntityOperate() {
        this.refresh();
        this.clearSelection();
    }

    @Override
    protected FormController createFormController() {
        return new MobileListController((IFormView)this);
    }

    @Override
    protected FormViewPluginProxy createPluginProxy() {
        return new MobListViewPluginProxy();
    }

    @Override
    protected String getViewBillFormId() {
        FormConfig lcf;
        String listOpenLayoutBill;
        String entityTypeId = this.getEntityTypeId();
        String billFormId = this.getBillFormId();
        Boolean isDefaultLayout = (Boolean)this.getFormShowParameter().getCustomParam("DefaultLayout");
        if (isDefaultLayout != null && Boolean.TRUE.equals(isDefaultLayout)) {
            billFormId = entityTypeId;
        }
        if (StringUtils.isNotBlank((CharSequence)(listOpenLayoutBill = (lcf = FormMetadataCache.getMobListFormConfig((String)billFormId)).getListOpenLayoutBill()))) {
            billFormId = listOpenLayoutBill;
        }
        if (StringUtils.isBlank((CharSequence)billFormId) || entityTypeId.equals(billFormId)) {
            return entityTypeId + "_mob";
        }
        FormConfig cf = FormMetadataCache.getFormConfig((String)billFormId);
        String modelType = cf.getModelType();
        if (!"mobilebill".equals(modelType)) {
            return billFormId + "_mob";
        }
        return billFormId;
    }

    @Override
    public void setBillFormId(String billFormId) {
        MobileSearch mobileSearch = (MobileSearch)this.getControl(this.context.getMobileSearchId());
        mobileSearch.setBillFormId(billFormId);
        MobFilterSort mobFilterSort = (MobFilterSort)this.getControl(((MobControlContext)this.context).getMobFilterSortId());
        mobFilterSort.setBillFormId(billFormId);
        super.setBillFormId(billFormId);
    }

    public void upload(List<Object> urls) {
    }

    @Override
    protected List<Map<String, Object>> getListFieldsControlColumns() {
        return new ArrayList<Map<String, Object>>();
    }

    @Override
    protected void restoreQingFilterValues() {
        MobileSearch mobileSearch;
        if (this.qingCachedFilterHolder != null && (mobileSearch = (MobileSearch)this.getControl(this.qingCachedFilterHolder.getQingCachedFilterValues().getControlKey())) != null) {
            mobileSearch.setMobileSearchFilterValues((MobileSearchFilterValues)this.qingCachedFilterHolder.getQingCachedFilterValues().getValue());
        }
        super.restoreQingFilterValues();
    }

    @Override
    public void updateView() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"MobileListView.updateView");){
            MobFilterSort mobFilterSort;
            MobileSearch mobileSearch = (MobileSearch)this.getControl(this.context.getMobileSearchId());
            if (mobileSearch != null) {
                mobileSearch.addMobileSearchInitListener(mobileSearchInitEvent -> {
                    MobListViewPluginProxy mobListViewPluginProxy = (MobListViewPluginProxy)this.getService(FormViewPluginProxy.class);
                    mobListViewPluginProxy.fireMobileSearchInit(mobileSearchInitEvent);
                    for (FilterColumn filterColumn : mobileSearchInitEvent.getFilterColumns()) {
                        FilterField field = FilterField.create((MainEntityType)((MainEntityType)this.getListModel().getDataEntityType()), (String)filterColumn.getFieldName());
                        filterColumn.setEntryEntity(field.getEntityKey());
                    }
                    this.setEmptyText(mobileSearch, (MainEntityType)this.getListModel().getDataEntityType(), mobileSearchInitEvent.getFilterColumns());
                });
            }
            if ((mobFilterSort = (MobFilterSort)this.getControl(((MobControlContext)this.context).getMobFilterSortId())) != null) {
                this.addMobFilterSortInitListener(mobFilterSort, true);
                mobFilterSort.addAfterBindDataListener(afterBindDataEvent -> {
                    this.setSelectedMainOrgIds(this.context.getSelectedMainOrgIds());
                    BillList billList = (BillList)this.getControl(this.context.getBillListId());
                    if (billList != null) {
                        this.getListCache().setMobFilterSortFilterParameter(this.context.getClientQueryFilterParameter());
                        this.getListCache().setMobSchemeQueryFilterParameter(this.context.getSchemeQueryFilterParameter());
                        if (this.context.getSchemeQueryFilterParameter() != null) {
                            this.context.getClientQueryFilterParameter().getQFilters().addAll(this.context.getSchemeQueryFilterParameter().getQFilters());
                        }
                        this.setBillListFilterParameter(billList);
                    }
                });
            }
            if (!this.isLookup()) {
                this.setVisible(false, new String[]{"rowsel"});
            }
            super.updateView();
            this.updateToolBarControlMetadata();
        }
    }

    public long getCurrentCityId() {
        return MobLocationProvider.getCurrentCityId();
    }

    @KSMethod
    public void setMenuItemVisible(boolean value, String ... itemKeys) {
        HashMap<String, Object> visableMap = new HashMap<String, Object>();
        visableMap.put("visible", value);
        visableMap.put("keys", itemKeys);
        ((IClientViewProxy)this.getService(IClientViewProxy.class)).addAction("setMenuItemVisible", visableMap);
    }

    public void showOperationResult(OperationResult operationResult, String operateName) {
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        int size = errorInfos.size();
        if (size > 0) {
            if (size == 1) {
                IOperateInfo errorInfo = (IOperateInfo)errorInfos.get(0);
                if (errorInfo instanceof OperateErrorInfo && (((OperateErrorInfo)errorInfo).getLevel() == ErrorLevel.Warning || ((OperateErrorInfo)errorInfo).getLevel() == ErrorLevel.Error)) {
                    this.showTipNotification(errorInfo.getMessage(), this.getDuration());
                    return;
                }
                this.showErrorNotification(errorInfo.getMessage());
                return;
            }
            StringBuilder val = new StringBuilder();
            for (int i = 0; i < size; ++i) {
                IOperateInfo errorInfo = (IOperateInfo)errorInfos.get(i);
                val.append(i + 1).append(ResManager.loadKDString((String)"\u3001", (String)"MobileBillView_1", (String)BOS_FORM_MVC, (Object[])new Object[0])).append(errorInfo.getMessage()).append(System.lineSeparator());
                if (!(errorInfo instanceof ValidationErrorInfo) || !ValidataErrorCode.AttTimeout.getCode().equals(((ValidationErrorInfo)errorInfo).getErrorCode())) continue;
                this.showConfirm(errorInfo.getMessage(), MessageBoxOptions.OK);
                return;
            }
            String title = ResManager.loadKDString((String)"\u5904\u7406\u7ed3\u679c", (String)"MobileBillView_0", (String)BOS_FORM_MVC, (Object[])new Object[0]);
            this.showConfirm(title, val.toString(), MessageBoxOptions.None);
        } else if (operationResult.getSuccessPkIds().size() == 1) {
            this.showSuccessNotification(operationResult.getMessage());
        } else {
            this.showErrorNotification(operationResult.getMessage());
        }
    }

    @Override
    protected void initialContext() {
        MobFilterSort mobFilterSort;
        this.context.setExitButtonId("btnexit");
        MobileSearch mobileSearch = (MobileSearch)this.getControl(MOBILESEARCHID);
        if (mobileSearch != null) {
            mobileSearch.setBillFormId(this.getBillFormId());
            mobileSearch.setContext(this.context);
        }
        if ((mobFilterSort = (MobFilterSort)this.getControl(((MobControlContext)this.context).getMobFilterSortId())) != null) {
            mobFilterSort.setBillFormId(this.getBillFormId());
            mobFilterSort.setContext(this.context);
        }
        super.initialContext();
    }

    @Override
    protected void refreshOnClosedCallBack() {
        BillList billList = (BillList)this.getControl(this.context.getBillListId());
        if (billList != null) {
            billList.setPageIndex(1);
        }
        super.refresh();
    }

    @Override
    protected Map<String, Object> getListMetadata() {
        return FormMetadataCache.getMobListMeta((String)this.getBillFormId());
    }

    public void addMobileSearchFocusListener(final MobileSearch mobileSearch) {
        final BillList billList = (BillList)this.getControl(this.context.getBillListId());
        final Button button = (Button)this.getControl(this.context.getExitButtonId());
        mobileSearch.addMobileSearchFocusListener(() -> {
            if (button != null) {
                button.getView().setVisible(Boolean.valueOf(true), new String[]{button.getKey()});
            }
            MobListViewPluginProxy mobListViewPluginProxy = (MobListViewPluginProxy)this.getService(FormViewPluginProxy.class);
            mobListViewPluginProxy.fireMobileSearchFocus();
        });
        if (button != null) {
            button.addClickListener(new ClickListener(){

                public void click(EventObject eventObject) {
                    MobileListView.this.clearSelRows();
                    billList.getEntryState().put(MobileListView.CLEAR_DATA, (Object)true);
                    MobileListView.this.bindData();
                    billList.getEntryState().put(MobileListView.CLEAR_DATA, (Object)false);
                    mobileSearch.setText("");
                    button.getView().setVisible(Boolean.valueOf(false), new String[]{button.getKey()});
                }
            });
        }
    }

    private void clearSelRows() {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(this.context.getBillListId(), "clearSelRows", new Object[0]);
    }

    public void addMobileSearchTextChangeListener(MobileSearch mobileSearch) {
        BillList billList = (BillList)this.getControl(this.context.getBillListId());
        mobileSearch.addMobileSearchTextChangeListener(mobileSearchTextChangeEvent -> {
            String findStr = mobileSearchTextChangeEvent.getText();
            FilterParameter filterParameter = this.getMobileSearchFilterParameter(mobileSearch, billList, findStr);
            this.getListCache().setMobileSearchFilterParameter(filterParameter);
            this.context.setClientQueryFilterParameter(filterParameter);
            this.addMobFilterSortFilter();
            MobListViewPluginProxy mobListViewPluginProxy = (MobListViewPluginProxy)this.getService(FormViewPluginProxy.class);
            mobListViewPluginProxy.fireMobileSearchTextChange(mobileSearchTextChangeEvent);
            if (!mobileSearchTextChangeEvent.isCancel()) {
                this.clearSelRows();
                billList.getEntryState().put(CLEAR_DATA, (Object)true);
                this.bindData();
                billList.getEntryState().put(CLEAR_DATA, (Object)false);
            }
        });
    }

    private void addMobileSearchCancelListener(MobileSearch mobileSearch) {
        BillList billList = (BillList)this.getControl(this.context.getBillListId());
        mobileSearch.addMobileSearchCancelListener(() -> {
            this.clearSelRows();
            this.getListCache().setMobileSearchFilterParameter(new FilterParameter());
            this.context.setClientQueryFilterParameter(new FilterParameter());
            this.addMobFilterSortFilter();
            billList.getEntryState().put(CLEAR_DATA, (Object)true);
            this.bindData();
            billList.getEntryState().put(CLEAR_DATA, (Object)false);
        });
    }

    private void addMobFilterSortFilter() {
        if (!this.getListCache().getMobFilterSortFilterParameter().getQFilters().isEmpty()) {
            this.context.getClientQueryFilterParameter().getQFilters().addAll(this.getListCache().getMobFilterSortFilterParameter().getQFilters());
        }
        if (!this.getListCache().getMobSchemeQueryFilterParameter().getQFilters().isEmpty()) {
            this.context.getClientQueryFilterParameter().getQFilters().addAll(this.getListCache().getMobSchemeQueryFilterParameter().getQFilters());
        }
    }

    private FilterParameter getMobileSearchFilterParameter(MobileSearch mobileSearch, BillList billList, String findStr) {
        FilterParameter filterParameter = new FilterParameter();
        if (StringUtils.isNotBlank((CharSequence)findStr)) {
            List<QFilter> qFilters = this.buildQuickFilterString(findStr, billList.getEntityType(), mobileSearch, billList.getEntryEntity());
            filterParameter.setQFilters(qFilters);
        }
        return filterParameter;
    }

    protected void bindData() {
        BillList billList = (BillList)this.getControl(this.context.getBillListId());
        this.setBillListFilterParameter(billList);
        billList.setClearSelection(true);
        billList.refresh();
    }

    private Set<String> getFieldNames(EntityType entityType) {
        BillEntityType billEntityType;
        HashSet<String> fieldNames = new HashSet<String>();
        if (entityType instanceof BasedataEntityType) {
            BasedataEntityType baseEntityType = (BasedataEntityType)entityType;
            String numberKey = baseEntityType.getNumberProperty();
            String nameKey = baseEntityType.getNameProperty();
            if (StringUtils.isNotBlank((CharSequence)nameKey)) {
                fieldNames.add(nameKey);
            }
            if (StringUtils.isNotBlank((CharSequence)numberKey)) {
                fieldNames.add(numberKey);
            }
        } else if (entityType instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)(billEntityType = (BillEntityType)entityType).getBillNo())) {
            fieldNames.add(billEntityType.getBillNo());
        }
        return fieldNames;
    }

    private List<QFilter> buildQuickFilterString(String quickFilter, EntityType entityType, MobileSearch mobileSearch, String entryEntity) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (StringUtils.isNotBlank((CharSequence)quickFilter)) {
            ArrayList filterList = new ArrayList();
            Set<String> fieldNames = this.getFieldNames(entityType);
            for (Control control : mobileSearch.getItems()) {
                String fieldName;
                FilterField filterField;
                if (!(control instanceof FilterColumn) || (filterField = FilterField.create((MainEntityType)((MainEntityType)entityType), (String)(fieldName = ((FilterColumn)control).getFieldName()))).isFieldPropAliasEmpty()) continue;
                String fullFieldName = filterField.getFullFieldName();
                fieldNames.add(fullFieldName);
            }
            Iterator<String> fieldNamesIt = fieldNames.iterator();
            while (fieldNamesIt.hasNext()) {
                String fieldName = fieldNamesIt.next();
                FilterField filterField = FilterField.create((MainEntityType)((MainEntityType)entityType), (String)fieldName);
                if (!filterField.isDesenAndNoSearch() && !filterField.isEncryptField()) continue;
                fieldNamesIt.remove();
                log.info("fieldName{} is privacycenter isDesensitizeField or isEncryptField, skip QuickFilter", (Object)fieldName);
            }
            MobileSearchFilterValues mobileSearchFilterValues = new MobileSearchFilterValues(quickFilter, filterList, entryEntity);
            mobileSearch.setMobileSearchFilterValues(mobileSearchFilterValues);
            Map pubSysParam = ParameterReader.loadBillParameterObjectFromCache((String)entityType.getName());
            String searchtype = "1";
            if (pubSysParam != null) {
                searchtype = (String)pubSysParam.get("searchtype");
            }
            List<String> finalValueList = this.getFinalValueList(quickFilter, mobileSearch, searchtype);
            ArrayList<String> encryptFields = new ArrayList<String>(6);
            Iterator<String> iterator = fieldNames.iterator();
            while (iterator.hasNext()) {
                IDataEntityProperty prop;
                boolean isEncrypt;
                String searchField = iterator.next();
                FilterField filterField = FilterField.create((MainEntityType)((MainEntityType)entityType), (String)searchField);
                if (filterField == null || !(isEncrypt = PrivacyCenterUtils.isEncryptField((IDataEntityProperty)(prop = filterField.getSrcFieldProp())))) continue;
                iterator.remove();
                encryptFields.add(searchField);
            }
            QFilter searchQFilter = null;
            for (String finvalValue : finalValueList) {
                if (!fieldNames.isEmpty()) {
                    searchQFilter = QFilter.ftlike((boolean)"2".equals(searchtype), (String)finvalValue, (String[])fieldNames.toArray(new String[0]));
                    qFilters.add(searchQFilter);
                }
                for (String encryptField : encryptFields) {
                    if (searchQFilter == null) {
                        searchQFilter = new QFilter(encryptField, "=", (Object)finvalValue);
                        qFilters.add(searchQFilter);
                        continue;
                    }
                    searchQFilter.or(new QFilter(encryptField, "=", (Object)finvalValue));
                }
            }
        }
        return qFilters;
    }

    private List<String> getFinalValueList(String quickFilter, MobileSearch mobileSearch, String searchtype) {
        ArrayList<String> newValueList = new ArrayList<String>();
        Object myIsMultiKeySearch = ((ListShowParameter)this.getFormShowParameter()).getCustomParam("isMultiKeySearch");
        if (mobileSearch.isMultiKeySearch() || myIsMultiKeySearch != null && myIsMultiKeySearch.toString().equalsIgnoreCase("true")) {
            newValueList.addAll(Arrays.asList(StringUtils.split((String)quickFilter, (String)" ")));
        } else {
            newValueList.add(quickFilter);
        }
        return newValueList;
    }

    @Override
    protected void openBillOrReturnData() {
        if (this.isLookup()) {
            if (!this.isMultiSelect()) {
                this.returnLookupData();
            }
        } else {
            if (this.getListCache().getCardSelectStatus()) {
                return;
            }
            this.openBill();
        }
    }

    @Override
    protected void fireListRowClick(AbstractListViewPluginProxy abstractListViewPluginProxy, ListRowClickEvent listrowclickevent) {
        super.fireListRowClick(abstractListViewPluginProxy, listrowclickevent);
        if (!listrowclickevent.isCancel()) {
            this.openBillOrReturnData();
        }
    }

    @Override
    public void registerListener() {
        Toolbar mobToolbar;
        MobFilterSort mobFilterSort;
        super.registerListener();
        MobileSearch mobileSearch = (MobileSearch)this.getControl(this.context.getMobileSearchId());
        if (mobileSearch != null) {
            this.addMobileSearchFocusListener(mobileSearch);
            this.addMobileSearchTextChangeListener(mobileSearch);
            this.addMobileSearchCancelListener(mobileSearch);
        }
        if ((mobFilterSort = (MobFilterSort)this.getControl(((MobControlContext)this.context).getMobFilterSortId())) != null) {
            this.addMobFilterSortBeforeFilterF7SelectListener(mobFilterSort);
            this.addMobFilterSortAfterSearchClickListener(mobFilterSort);
            this.addMobFilterSortInitListener(mobFilterSort, false);
            this.addMobFilterSortSearchClickListener(mobFilterSort);
        }
        if ((mobToolbar = (Toolbar)this.getControl("mtoolbarap")) != null) {
            mobToolbar.addItemClickListener(new ItemClickListener(){});
        }
    }

    private void addMobFilterSortBeforeFilterF7SelectListener(MobFilterSort mobFilterSort) {
        MobListViewPluginProxy listViewPluginProxy = (MobListViewPluginProxy)this.getService(FormViewPluginProxy.class);
        mobFilterSort.addBeforeF7SelectListener(arg_0 -> ((MobListViewPluginProxy)listViewPluginProxy).fireMobFilterSortBeforeF7Select(arg_0));
    }

    private void addMobFilterSortInitListener(MobFilterSort mobFilterSort, boolean isLoad) {
        MobListViewPluginProxy listViewPluginProxy = (MobListViewPluginProxy)this.getService(FormViewPluginProxy.class);
        mobFilterSort.addMobFilterSortInitListener(mobFilterSortInitEvent -> {
            MobFilterSortInitArgs mobFilterSortInitArgs = new MobFilterSortInitArgs(mobFilterSortInitEvent);
            listViewPluginProxy.fireMobFilterSortInit(mobFilterSortInitArgs);
            if (isLoad) {
                this.initBillListByMetadata();
            }
        });
    }

    private void addMobFilterSortSearchClickListener(MobFilterSort mobFilterSort) {
        MobListViewPluginProxy listViewPluginProxy = (MobListViewPluginProxy)this.getService(FormViewPluginProxy.class);
        mobFilterSort.addSearchClickListener(afterSearchClickEvent -> {
            MobFilterSortSearchClickArgs mobFilterSortSearchClickArgs = new MobFilterSortSearchClickArgs(afterSearchClickEvent);
            listViewPluginProxy.fireMobFilterSortSearchClick(mobFilterSortSearchClickArgs);
        });
    }

    private void addMobFilterSortAfterSearchClickListener(MobFilterSort mobFilterSort) {
        MobListViewPluginProxy listViewPluginProxy = (MobListViewPluginProxy)this.getService(FormViewPluginProxy.class);
        mobFilterSort.addAfterSearchClickListener(afterSearchClickEvent -> {
            MobFilterSortSearchClickArgs mobFilterSortSearchClickArgs = new MobFilterSortSearchClickArgs(afterSearchClickEvent);
            listViewPluginProxy.fireMobFilterSortAfterSearchClick(mobFilterSortSearchClickArgs);
            BillList billList = (BillList)this.getControl(this.context.getBillListId());
            if (billList != null) {
                if (this.context.getSchemeQueryFilterParameter() == null) {
                    this.getListCache().setMobFilterSortFilterParameter(this.context.getClientQueryFilterParameter());
                }
                this.getListCache().setMobSchemeQueryFilterParameter(this.context.getSchemeQueryFilterParameter());
                if (!this.getListCache().getMobileSearchFilterParameter().getQFilters().isEmpty()) {
                    this.context.getClientQueryFilterParameter().getQFilters().addAll(this.getListCache().getMobileSearchFilterParameter().getQFilters());
                }
                if (!this.getListCache().getMobSchemeQueryFilterParameter().getQFilters().isEmpty()) {
                    this.context.getClientQueryFilterParameter().getQFilters().addAll(this.getListCache().getMobSchemeQueryFilterParameter().getQFilters());
                }
                if (this.context.getSchemeQueryFilterParameter() != null && !this.getListCache().getMobFilterSortFilterParameter().getQFilters().isEmpty()) {
                    this.context.getClientQueryFilterParameter().getQFilters().addAll(this.getListCache().getMobFilterSortFilterParameter().getQFilters());
                }
                this.setSelectedMainOrgIds(this.context.getSelectedMainOrgIds());
                this.setBillListFilterParameter(billList);
                billList.bindData(null);
            }
        });
    }

    @Override
    protected void addBillListListener(BillList billList) {
        super.addBillListListener(billList);
        this.addMobileListPushDownRefreshListener(billList);
    }

    protected void addMobileListPushDownRefreshListener(BillList list) {
        if (this.mobileListPushDownRefreshListener == null) {
            this.mobileListPushDownRefreshListener = mobileListPushDownRefreshEvent -> {
                MobListViewPluginProxy abstractListViewPluginProxy = (MobListViewPluginProxy)this.getService(FormViewPluginProxy.class);
                abstractListViewPluginProxy.afterPushDownRefresh(mobileListPushDownRefreshEvent);
            };
            list.addMobileListPushDownRefreshistener(this.mobileListPushDownRefreshListener);
        }
    }

    @Override
    protected String getProfileKey() {
        return super.getProfileKey() + "_mob";
    }

    @Override
    public OperationResult invokeOperation(String operationKey, OperateOption option) {
        if (option == null) {
            option = OperateOption.create();
        }
        option.setVariableValue("isStrict", "false");
        return super.invokeOperation(operationKey, option);
    }

    public void locate() {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getService(IClientViewProxy.class);
        clientViewProxy.addAction("getLocation", (Object)new Object[0]);
    }

    public MobLocation getLocation() {
        return MobLocationProvider.getMobLocation();
    }

    public void setLocation(Map<String, String> location) {
        MobLocationProvider.setLocation(location);
        if (this.getPluginProxy() instanceof MobListViewPluginProxy) {
            LocateEvent locateEvent = new LocateEvent((Object)this, MobLocationProvider.getMobLocation());
            ((MobListViewPluginProxy)this.getPluginProxy()).fireLocate(locateEvent);
        }
    }

    @Override
    public void changeListView(String billFormId) {
        super.changeListView(billFormId);
        MobileSearch mobileSearch = (MobileSearch)this.getControl(this.context.getMobileSearchId());
        if (mobileSearch != null) {
            mobileSearch.setEntityId("");
            mobileSearch.bindData(null);
        }
    }

    @KSMethod
    public void callClientAppMethod(ClientMethod clientMethod, Object parameter) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getService(IClientViewProxy.class);
        String method = clientMethod.getValue();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("method", method);
        if (parameter != null) {
            map.put("parameter", parameter);
        }
        clientViewProxy.addAction("callAppMethod", map);
    }

    @Override
    public ControlFilters getControlFilters() {
        MobileSearchFilterValues cachedFilterValues;
        MobileSearch mobileSearch = (MobileSearch)this.getControl(MOBILESEARCHID);
        if (mobileSearch != null && this.controlFilters == null && !(cachedFilterValues = mobileSearch.getMobileSearchFilterValues()).isEmpty()) {
            this.controlFilters = new ControlFilters(cachedFilterValues.getFastFilterValues());
            this.controlFilters.setSearchText(cachedFilterValues.getSearchText());
        }
        return this.controlFilters;
    }

    @Override
    public void returnLookupData() {
        ListSelectedRowCollection listSelectedRowCollection = this.getSelectedRows();
        if (listSelectedRowCollection.isEmpty()) {
            listSelectedRowCollection.setClearFlag(true);
            this.returnDataToParent(listSelectedRowCollection);
            this.close();
            return;
        }
        super.returnLookupData();
    }

    private void updateToolBarControlMetadata() {
        Toolbar mobToolbar = (Toolbar)this.getControl("mtoolbarap");
        if (mobToolbar == null) {
            return;
        }
        MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        String str = metadataService.loadFormRuntimeMeta(this.billFormId, RuntimeMetaType.MobList.getValue(), "mtoolbarap");
        if (StringUtils.isBlank((CharSequence)str)) {
            return;
        }
        Map meta = (Map)SerializationUtils.fromJsonString((String)str, Map.class);
        if (CollectionUtils.isEmpty((Map)meta)) {
            return;
        }
        this.updateControlMetadata(mobToolbar.getKey(), meta);
        Object items = meta.get("items");
        if (items instanceof List) {
            List itemList = (List)items;
            ArrayList<String> hideKeys = new ArrayList<String>(itemList.size());
            for (Map item : itemList) {
                Object interactionType = item.get("it");
                if ((interactionType == null || (Integer)interactionType != 1) && !"cancel".equals(item.get("opk"))) continue;
                hideKeys.add(item.get("id").toString());
            }
            this.setVisible(false, hideKeys.toArray(new String[hideKeys.size()]));
        }
    }

    @Override
    void storeUserConfig() {
    }

    @Override
    void afterSetMetadata(BillList billList) {
    }

    @SdkInternal
    public void afterMobilePageClose() {
        if (this.getPluginProxy() instanceof MobListViewPluginProxy) {
            ((MobListViewPluginProxy)this.getPluginProxy()).fireAfterMobilePageClose(new EventObject((Object)this));
        }
    }

    @Override
    @SdkInternal
    boolean isNeedCheckMainOrgQFilter() {
        MobFilterSort mobFilterSort = (MobFilterSort)this.getControl(((MobControlContext)this.context).getMobFilterSortId());
        return mobFilterSort != null;
    }

    private void setEmptyText(MobileSearch mobileSearch, MainEntityType entityType, List<FilterColumn> filterColumns) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"MobileListView.setEmptyText");){
            LocaleString emptyText = mobileSearch.getEmptyText();
            if (emptyText != null && StringUtils.isNotEmpty((CharSequence)emptyText.toString())) {
                return;
            }
            Set<String> defaultFields = this.getFieldNames((EntityType)entityType);
            ArrayList<String> fieldNames = new ArrayList<String>(10);
            for (String fieldName : defaultFields) {
                DynamicProperty property = entityType.getProperty(fieldName);
                if (property == null || this.isEncryptOrDesenField(entityType, fieldName)) continue;
                fieldNames.add(property.getDisplayName().toString());
            }
            for (FilterColumn filterColumn : filterColumns) {
                String fieldName = filterColumn.getFieldName();
                if (this.isEncryptOrDesenField(entityType, fieldName) || defaultFields.contains(fieldName)) continue;
                fieldNames.add(filterColumn.getCaption().toString());
            }
            if (!CollectionUtils.isEmpty(fieldNames)) {
                String mobileBillViewStr = String.format(ResManager.loadKDString((String)"\u641c\u7d22%s", (String)"MobileBillView_2", (String)BOS_FORM_MVC, (Object[])new Object[0]), String.join((CharSequence)"/", fieldNames));
                mobileSearch.setEmptyText(new LocaleString(mobileBillViewStr));
            }
            span.addLocaleTag("fieldNames", fieldNames);
            span.addLocaleTag("entitytype", (Object)entityType);
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6\u5217\u8868\u8fc7\u6ee4\u63a7\u4ef6\u7684\u4e3a\u7a7a\u63d0\u793a\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
    }

    private boolean isEncryptOrDesenField(MainEntityType entityType, String fieldName) {
        FilterField filterField = FilterField.create((MainEntityType)entityType, (String)fieldName);
        return filterField.isDesenAndNoSearch() || filterField.isEncryptField();
    }
}

