/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.list;

import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.list.BillList;
import kd.bos.list.query.impl.SumQuery;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.mvc.list.BillListAsyncSumCommander;
import kd.bos.mvc.list.ListAsyncQueryContext;
import kd.bos.mvc.list.SummaryResultsCache;
import kd.bos.schedule.executor.AbstractTask;

public class SumGroupTask
extends AbstractTask {
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        String rootPageId = (String)map.get("rootPageId");
        String pageId = (String)map.get("pageId");
        String controlKey = (String)map.get("controlKey");
        String mainOrgIdStr = (String)map.get("mainOrgId");
        Long mainOrgId = StringUtils.isNotBlank((CharSequence)mainOrgIdStr) ? Long.valueOf(Long.parseLong(mainOrgIdStr)) : null;
        ListAsyncQueryContext listAsyncQueryContext = new ListAsyncQueryContext(pageId);
        QueryBuilder queryBuilder = listAsyncQueryContext.getQueryBuilder(this.taskId);
        SummaryResultsCache summaryResultsCache = new SummaryResultsCache(new PageCache(pageId), (String)map.get("controlKey"), queryBuilder.getGroupBySumFields());
        Log logger = LogFactory.getLog(BillList.class);
        if (this.checkExpired(pageId, controlKey, listAsyncQueryContext, queryBuilder, logger)) {
            return;
        }
        MainEntityType entityType = listAsyncQueryContext.getEntityType(this.taskId);
        if (entityType == null) {
            logger.info(String.format("SumGroupTaskError:entityType is null,may be page is released,rootPageId:%s,pageId:%s,controlKey:%s", rootPageId, pageId, controlKey));
            return;
        }
        queryBuilder.setEntityType((IDataEntityType)entityType);
        queryBuilder.setFilters(listAsyncQueryContext.getQFilters(this.taskId));
        BillListAsyncSumCommander billListAsyncSumCommander = new BillListAsyncSumCommander(rootPageId, pageId, queryBuilder.getGroupBySumFields(), (String)map.get("appId"), entityType);
        try {
            List summaryResults = SumQuery.getSummaryResults((QueryBuilder)queryBuilder);
            if (this.checkExpired(pageId, controlKey, listAsyncQueryContext, queryBuilder, logger)) {
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)queryBuilder.getGroupBy()) && queryBuilder.getGroupBySumFields() != null && !queryBuilder.getGroupBySumFields().isEmpty()) {
                summaryResultsCache.cacheGroupByAsyncResult(summaryResults);
            } else {
                summaryResultsCache.cacheSummaryResults(summaryResults);
            }
            billListAsyncSumCommander.sendNormal(summaryResults, summaryResultsCache.getPageSyncSummaryResults(), controlKey, mainOrgId);
        }
        catch (KDException e) {
            if (e.getErrorCode() == BosErrorCode.sQLRWTimeOut) {
                billListAsyncSumCommander.sendTimeOut(summaryResultsCache.cacheAsyncTimeoutResult(queryBuilder.getQuerySumFields()), controlKey, mainOrgId);
            }
            throw e;
        }
        listAsyncQueryContext.remove(this.taskId);
        if (StringUtils.isNotBlank((CharSequence)queryBuilder.getGroupBy())) {
            listAsyncQueryContext.cacheGroupByTask(controlKey, queryBuilder.getGroupBy(), "");
        } else {
            listAsyncQueryContext.cacheSumTask(controlKey, "");
        }
    }

    private boolean checkExpired(String pageId, String controlKey, ListAsyncQueryContext listAsyncQueryContext, QueryBuilder queryBuilder, Log logger) {
        if (StringUtils.isNotBlank((CharSequence)queryBuilder.getGroupBy()) && !this.taskId.equals(listAsyncQueryContext.getGroupbyTask(controlKey, queryBuilder.getGroupBy())) || StringUtils.isBlank((CharSequence)queryBuilder.getGroupBy()) && !this.taskId.equals(listAsyncQueryContext.getSumTask(controlKey))) {
            logger.info(String.format("SumGroupTaskError:task has expired,taskId:%s,queryBuilder:%s,pageId:%s,controlKey:%s", this.taskId, queryBuilder, pageId, controlKey));
            return true;
        }
        return false;
    }
}

