/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.list;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AmountPrecision;
import kd.bos.entity.datamodel.DecimalPrecision;
import kd.bos.entity.datamodel.IntegerPrecision;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.list.AsyncSummaryEnum;
import kd.bos.entity.list.GroupByField;
import kd.bos.entity.list.GroupBySummaryResult;
import kd.bos.entity.list.SummaryResult;
import kd.bos.entity.list.SummaryType;
import kd.bos.entity.list.TimeoutSummaryResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.mvc.list.DispatchResult;
import kd.bos.mvc.list.GroupByDispatchResult;
import kd.bos.mvc.list.GroupByDispatcher;
import kd.bos.mvc.list.GroupByDispatcherContext;
import kd.bos.mvc.list.SumDispatcher;
import kd.bos.mvc.list.SumDispatcherContext;
import org.jetbrains.annotations.NotNull;

class SummaryResultsCache {
    private static final String TWO_PLACEHOLDER = "%s_%s";
    private static final String BOS_FORM_MVC = "bos-form-mvc";
    private IPageCache pageCache;
    private String preKey;
    private List<String> groupBySumFields = new ArrayList<String>(10);

    SummaryResultsCache(IPageCache pageCache, String preKey, List<String> groupBySumFields) {
        this.pageCache = pageCache;
        this.preKey = preKey;
        this.groupBySumFields = groupBySumFields;
    }

    List<SummaryResult> getSummaryResults(SumDispatcherContext sumDispatcherContext) {
        if (!sumDispatcherContext.getSumFields().isEmpty()) {
            List<SummaryResult> cachedSummaryResults = this.getCachedSummaryResults();
            if (!cachedSummaryResults.isEmpty()) {
                return cachedSummaryResults;
            }
            this.checkSumEvic();
            new SumDispatcher(sumDispatcherContext).dispatch();
        }
        return new ArrayList<SummaryResult>(0);
    }

    void cacheSummaryResults(List<SummaryResult> summaryResults) {
        if (!summaryResults.isEmpty()) {
            HashMap<String, NumberPrecision> numberPrecisionMap = new HashMap<String, NumberPrecision>(16);
            List<SummaryResult> pageSummaryResults = this.getPageSyncSummaryResults();
            for (SummaryResult summaryResult : pageSummaryResults) {
                numberPrecisionMap.put(summaryResult.getFieldName(), summaryResult.getNumberPrecision());
            }
            for (SummaryResult summaryResult : summaryResults) {
                NumberPrecision numberPrecision = (NumberPrecision)numberPrecisionMap.get(summaryResult.getFieldName());
                if (numberPrecision == null) continue;
                BigDecimal result = summaryResult.getNumberPrecision().getResult();
                if (numberPrecision instanceof AmountPrecision) {
                    summaryResult.setNumberPrecision((NumberPrecision)new AmountPrecision(numberPrecision.getPrecision(), numberPrecision.getSign(), numberPrecision.isShowSign(), result, numberPrecision.getFormatObject()));
                    continue;
                }
                if (numberPrecision instanceof DecimalPrecision) {
                    summaryResult.setNumberPrecision((NumberPrecision)new DecimalPrecision(numberPrecision.getPrecision(), numberPrecision.getSign(), numberPrecision.isShowSign(), result, numberPrecision.getFormatObject()));
                    continue;
                }
                if (numberPrecision instanceof IntegerPrecision) {
                    summaryResult.setNumberPrecision((NumberPrecision)new IntegerPrecision(numberPrecision.getPrecision(), numberPrecision.getSign(), numberPrecision.isShowSign(), result, numberPrecision.getFormatObject()));
                    continue;
                }
                summaryResult.setNumberPrecision(new NumberPrecision(numberPrecision.getPrecision(), numberPrecision.getSign(), numberPrecision.isShowSign(), result));
            }
        }
        this.putSummaryResults(summaryResults);
    }

    List<SummaryResult> getGroupBySummaryResults(GroupByDispatcherContext groupByDispatcherContext) {
        List<String> groupBySumFields = groupByDispatcherContext.getSumFields();
        int size = groupBySumFields.size();
        ArrayList<SummaryResult> summaryResults = new ArrayList<SummaryResult>(size);
        if (!groupBySumFields.isEmpty()) {
            ArrayList<String> finalGroupBySumFields = new ArrayList<String>(size);
            ArrayList<String> hasSumFields = new ArrayList<String>(size);
            for (String groupBySumField : groupBySumFields) {
                List<SummaryResult> asyncResults = this.getGroupByAsyncResults(groupBySumField);
                if (asyncResults != null) {
                    hasSumFields.add(groupBySumField);
                    summaryResults.addAll(asyncResults);
                    continue;
                }
                finalGroupBySumFields.add(groupBySumField);
            }
            ArrayList<SummaryResult> asyncSummaryResults = new ArrayList<SummaryResult>(finalGroupBySumFields.size());
            if (!finalGroupBySumFields.isEmpty()) {
                this.checkGroupByEvic();
                List<DispatchResult> dispatchResults = new GroupByDispatcher(groupByDispatcherContext).dispatch();
                for (DispatchResult dispatchResult : dispatchResults) {
                    if (!(dispatchResult instanceof GroupByDispatchResult)) continue;
                    GroupByField groupByField = ((GroupByDispatchResult)dispatchResult).getGroupByField();
                    for (String sum : groupByField.getSums()) {
                        hasSumFields.add(sum);
                    }
                }
            }
            for (String groupBySumField : groupBySumFields) {
                if (hasSumFields.contains(groupBySumField)) continue;
                GroupBySummaryResult emptySummaryResult = new GroupBySummaryResult(groupBySumField, null, 1);
                asyncSummaryResults.add((SummaryResult)emptySummaryResult);
                summaryResults.add((SummaryResult)emptySummaryResult);
            }
            if (!asyncSummaryResults.isEmpty()) {
                this.cacheGroupByAsyncResult(asyncSummaryResults);
            }
        }
        return summaryResults;
    }

    private void checkSumEvic() {
        this.checkEvic("sum");
    }

    private void checkGroupByEvic() {
        this.checkEvic("groupby");
    }

    private void checkEvic(String key) {
        long l;
        String lasttime = this.getLasttime(key);
        if (lasttime != null && (l = System.currentTimeMillis() - Long.parseLong(lasttime)) <= 2000L) {
            throw new KDBizException(new ErrorCode("GroupBySummaryLimited", ResManager.loadKDString((String)"\u7cfb\u7edf\u56e0\u64cd\u4f5c\u9891\u7e41\u5173\u95ed\u5408\u8ba1\uff0c\u53ef\u624b\u52a8\u70b9\u51fb\u3010\u8ba1\u7b97\u5408\u8ba1\u3011\u6309\u94ae\u89e6\u53d1\u5217\u8868\u5408\u8ba1\u3002", (String)"SummaryResultsCache_0", (String)BOS_FORM_MVC, (Object[])new Object[0])), new Object[0]);
        }
        this.putLastTime(key);
    }

    @NotNull
    private String getLasttime_4_setFieldSumDataKey(String key) {
        return this.preKey + "_lasttime_4_setFieldSumData_" + key;
    }

    private void putLastTime(String key) {
        this.pageCache.put(this.getLasttime_4_setFieldSumDataKey(key), String.valueOf(System.currentTimeMillis()));
    }

    private String getLasttime(String key) {
        return this.pageCache.get(this.getLasttime_4_setFieldSumDataKey(key));
    }

    String getCachedSummaryResultsKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "tfbd");
    }

    void putSummaryResults(List<SummaryResult> summaryResults) {
        String cacheKey = this.getCachedSummaryResultsKey();
        if (summaryResults != null) {
            this.pageCache.put(cacheKey, SerializationUtils.toJsonString(summaryResults));
        }
    }

    List<SummaryResult> getCachedSummaryResults() {
        String cacheKey = this.getCachedSummaryResultsKey();
        if (this.pageCache.get(cacheKey) == null) {
            return new ArrayList<SummaryResult>(0);
        }
        List results = SerializationUtils.fromJsonStringToList((String)this.pageCache.get(cacheKey), SummaryResult.class);
        if (results != null) {
            FormatObject formatObject = FormatFactory.getFormat((Long)RequestContext.get().getCurrUserId());
            for (SummaryResult summaryResult : results) {
                summaryResult.getNumberPrecision().setFormatObject(formatObject);
            }
        }
        return results;
    }

    String getPageSyncSummaryResultsKey() {
        return String.format(TWO_PLACEHOLDER, this.preKey, "fbd");
    }

    List<SummaryResult> getPageSyncSummaryResults() {
        String cacheKey = this.getPageSyncSummaryResultsKey();
        if (this.pageCache.get(cacheKey) == null) {
            return new ArrayList<SummaryResult>();
        }
        List results = SerializationUtils.fromJsonStringToList((String)this.pageCache.get(cacheKey), SummaryResult.class);
        if (results != null) {
            FormatObject formatObject = FormatFactory.getFormat((Long)RequestContext.get().getCurrUserId());
            for (SummaryResult summaryResult : results) {
                summaryResult.getNumberPrecision().setFormatObject(formatObject);
            }
        }
        return results;
    }

    private String getFieldSumDataKey() {
        return this.preKey + "_FieldSumData_";
    }

    List<SummaryResult> getGroupByAsyncResults(String groupBySumField) {
        List summaryResults = null;
        String sumDataStr = this.pageCache.get(this.getFieldSumDataKey() + groupBySumField);
        if (StringUtils.isNotBlank((CharSequence)sumDataStr)) {
            summaryResults = SerializationUtils.fromJsonStringToList((String)sumDataStr, GroupBySummaryResult.class);
        }
        return summaryResults;
    }

    void cacheGroupByAsyncResult(List<SummaryResult> summaryResults) {
        HashMap<String, ArrayList<SummaryResult>> cachedSummaryResultMap = new HashMap<String, ArrayList<SummaryResult>>(16);
        for (SummaryResult summaryResult : summaryResults) {
            if (summaryResult.getSummary() != SummaryType.SUM.getValue()) continue;
            ArrayList<SummaryResult> summaryResultList = (ArrayList<SummaryResult>)cachedSummaryResultMap.get(summaryResult.getFieldName());
            if (summaryResultList == null) {
                summaryResultList = new ArrayList<SummaryResult>(10);
                cachedSummaryResultMap.put(summaryResult.getFieldName(), summaryResultList);
            }
            summaryResultList.add(summaryResult);
        }
        for (Map.Entry entry : cachedSummaryResultMap.entrySet()) {
            this.pageCache.put(this.getFieldSumDataKey() + (String)entry.getKey(), SerializationUtils.toJsonString(entry.getValue()));
        }
        for (String string : this.groupBySumFields) {
            List summaryResultsList = (List)cachedSummaryResultMap.get(string);
            if (summaryResultsList != null) continue;
            ArrayList<GroupBySummaryResult> wrapSumResultList = new ArrayList<GroupBySummaryResult>(1);
            wrapSumResultList.add(new GroupBySummaryResult(string, null, 1));
            this.pageCache.put(this.getFieldSumDataKey() + string, SerializationUtils.toJsonString(wrapSumResultList));
        }
    }

    void cacheSyncTimeoutResult(List<String> sumFields) {
        this.cacheSummaryResults(this.createTimeoutResults(sumFields));
    }

    List<SummaryResult> cacheAsyncTimeoutResult(List<String> sumFields) {
        List<SummaryResult> timeoutResults = this.createTimeoutResults(sumFields);
        for (SummaryResult summaryResult : timeoutResults) {
            this.pageCache.put(this.getFieldSumDataKey() + summaryResult.getFieldName(), SerializationUtils.toJsonString((Object)summaryResult));
        }
        return timeoutResults;
    }

    private List<SummaryResult> createTimeoutResults(List<String> sumFields) {
        ArrayList<SummaryResult> summaryResults = new ArrayList<SummaryResult>(10);
        int size = sumFields.size();
        for (int i = 0; i < size; ++i) {
            TimeoutSummaryResult timeoutSummaryResult = new TimeoutSummaryResult(sumFields.get(i).replace('.', '_'), null, 1, AsyncSummaryEnum.TIMEOUT);
            summaryResults.add((SummaryResult)timeoutSummaryResult);
        }
        return summaryResults;
    }
}

