/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.list;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Button;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TreeNodeDragEvent;
import kd.bos.form.control.events.TreeNodeDragListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.list.AbstractTreeListView;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ITreeListView;
import kd.bos.list.plugin.ListViewPluginProxy;
import kd.bos.mvc.list.TreeListModel;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class TreeListView
extends AbstractTreeListView
implements TreeNodeQueryListener,
TreeNodeDragListener,
ClickListener {
    private static final String SPAN_TYPE_NAME = "list";
    private static final String ISCONTAINLOWER = "iscontainlower";
    private static final String IS_CONTAINNOW = "iscontainnow";
    private ListViewPluginProxy pluginProxy;

    public synchronized void initialize(IListView view, TreeView tv) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"TreeListView.initialize");){
            super.initialize(view, tv);
            this.pluginProxy = (ListViewPluginProxy)view.getService(FormViewPluginProxy.class);
            this.pluginProxy.setTreeListView((ITreeListView)this);
            tv.addTreeNodeQueryListener((TreeNodeQueryListener)this);
            if (tv.isDragEnable()) {
                tv.addTreeNodeDragListener((TreeNodeDragListener)this);
            }
            this.addButtonClickListener("btnnew", "btnedit", "btndel");
            this.treeModel = this.getTreeModel();
            this.root = this.treeModel.getRoot();
            if (this.root == null) {
                this.pluginProxy.fireInitializeTree();
                this.root = this.treeModel.getRoot();
                if (this.root == null) {
                    return;
                }
                tv.addNode(this.root);
                this.treeModel.setRoot(this.root);
            }
            if (!this.treeModel.isRootVisable()) {
                tv.setRootVisible(false);
            }
            this.hideControl(this.treeModel, view);
            this.pluginProxy.fireSetCustomerParam();
            this.pluginProxy.fireInitTreeToolbar();
        }
    }

    public void refresh() {
        this.refreshTreeView();
    }

    public void refreshTreeView() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"TreeListView.refreshTreeView");){
            String nodeId = (String)this.treeModel.getCurrentNodeId();
            if (StringUtils.isBlank((CharSequence)nodeId)) {
                return;
            }
            TreeNode node = this.treeModel.refreshNode((Object)nodeId);
            if (node != null) {
                this.treeview.updateNode(node);
                this.treeview.focusNode(node);
                this.treeview.treeNodeClick(node.getParentid(), nodeId);
            }
        }
    }

    public void focusRootNode() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"TreeListView.focusRootNode");){
            TreeNode root = this.getRoot();
            this.treeModel.setCurrentNodeId((Object)root.getId());
            this.treeview.focusNode(root);
            BillList billList = (BillList)this.view.getControl("billlistap");
            FilterParameter filterParameter = new FilterParameter();
            filterParameter.setFilter(this.treeModel.getListFilter());
            billList.setQueryFilterParameter(filterParameter);
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent e) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"TreeListView.queryTreeNodeChildren");){
            TreeNode node = e.getExpandedNode();
            if (node == null) {
                String nodeId = (String)e.getNodeId();
                node = this.treeModel.refreshNode((Object)nodeId);
            }
            if (node != null) {
                node.setIsOpened(true);
            }
            this.treeview.updateNode(node);
            this.treeview.focusNode(node);
            this.pluginProxy.fireExpendTreeNode(e);
        }
    }

    public void click(EventObject e) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"TreeListView.click");){
            this.pluginProxy.fireTreeToolbarClick(e);
        }
    }

    public void refreshTreeNode(String nodeId, boolean isRefreshBillList) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"TreeListView.refreshTreeNode");){
            TreeNode node = this.root.getTreeNode(nodeId);
            this.treeview.updateNode(node);
            String currNodeId = (String)this.treeModel.getCurrentNodeId();
            TreeNode currNode = this.treeModel.getRoot().getTreeNode(currNodeId);
            TreeNodeEvent event = null;
            if (currNode != null) {
                this.treeview.focusNode(currNode);
                event = new TreeNodeEvent((Object)this, (Object)currNode.getParentid(), (Object)currNodeId);
                if (isRefreshBillList) {
                    this.treeNodeClick(event);
                }
            } else if (node != null) {
                this.treeview.focusNode(node);
                event = new TreeNodeEvent((Object)this, (Object)node.getParentid(), (Object)node.getId());
                this.treeModel.setCurrentNodeId((Object)node.getId());
                if (isRefreshBillList) {
                    this.treeNodeClick(event);
                }
            }
        }
    }

    public ITreeModel getTreeModel() {
        if (this.treeModel == null) {
            this.treeModel = new TreeListModel(this.view.getPageId(), this.view.getListModel().getDataEntityType());
            IPageCache pageCache = (IPageCache)this.view.getService(IPageCache.class);
            ((TreeListModel)this.treeModel).setCache(pageCache);
            ((TreeListModel)this.treeModel).setPluginProxy(this.pluginProxy);
        }
        return this.treeModel;
    }

    public List<Map<String, Object>> getSelectedNodes() {
        List selNodes = this.treeview.getTreeState().getSelectedNodes();
        return selNodes;
    }

    private void addButtonClickListener(String ... ctlKeys) {
        for (String ctlKey : ctlKeys) {
            Button btn = (Button)this.view.getControl(ctlKey);
            if (btn == null) continue;
            btn.addClickListener((ClickListener)this);
        }
    }

    public void treeNodeDragged(TreeNodeDragEvent event) {
        GroupProp groupProp = this.treeModel.getGroupProp();
        if (groupProp == null) {
            return;
        }
        if (groupProp.getEntityType().getProperty("parent") == null) {
            this.view.showMessage(ResManager.loadKDString((String)"\u8be5\u5206\u7ec4\u7c7b\u522b\u6ca1\u6709\u4e0a\u7ea7\u7c7b\u522b\uff0c\u4e0d\u652f\u6301\u62d6\u62fd\uff01", (String)"TreeListView_1", (String)"bos-form-mvc", (Object[])new Object[0]));
            return;
        }
        Object sourceNodeId = event.getNodeId();
        Object targetNodeId = event.getToParentId();
        if (sourceNodeId == null || targetNodeId == null || sourceNodeId.equals(targetNodeId)) {
            return;
        }
        TreeNode sourceNode = this.root.getTreeNode((String)sourceNodeId);
        if (sourceNode == null) {
            return;
        }
        TreeNode targetNode = sourceNode.getTreeNode(targetNodeId.toString());
        if (targetNode != null) {
            String msg = String.format(ResManager.loadKDString((String)"%1$s\u5df2\u662f%2$s\u7684\u4e0a\u7ea7\u8282\u70b9\uff0c\u4e0d\u80fd\u4f5c\u4e3a%3$s\u7684\u4e0b\u7ea7\u7c7b\u522b\uff01", (String)"TreeListView_2", (String)"bos-form-mvc", (Object[])new Object[0]), sourceNode.getText(), targetNode.getText(), targetNode.getText());
            this.view.showMessage(msg);
            return;
        }
    }

    private void hideControl(ITreeModel treeModel, IListView view) {
        GroupProp groupProp = treeModel.getGroupProp();
        if (groupProp != null) {
            if (groupProp instanceof ParentBasedataProp) {
                view.setVisible(Boolean.valueOf(false), new String[]{ISCONTAINLOWER});
                view.setVisible(Boolean.valueOf(((ParentBasedataProp)groupProp).isShowTreeNow()), new String[]{IS_CONTAINNOW});
            } else {
                view.setVisible(Boolean.valueOf(false), new String[]{IS_CONTAINNOW});
                view.setVisible(Boolean.valueOf(groupProp.isShowTreeLower()), new String[]{ISCONTAINLOWER});
            }
        } else {
            view.setVisible(Boolean.valueOf(false), new String[]{IS_CONTAINNOW});
            view.setVisible(Boolean.valueOf(false), new String[]{ISCONTAINLOWER});
        }
    }
}

