/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.list.column.VoucherNoColumnDesc;
import kd.bos.entity.param.AppParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.xdb.ExceedShardingQueryLimit;
import org.jetbrains.annotations.Nullable;

public class VoucherNoUtil {
    private static final String GL_VOUCHER = "gl_voucher";
    public static final Log logger = LogFactory.getLog(VoucherNoUtil.class);

    public static void fillVoucherNo(DynamicObjectCollection pageData, List<AbstractColumnDesc> cols, String entityID) {
        VoucherNoColumnDesc vchnoCol = null;
        for (AbstractColumnDesc desc : cols) {
            if (!(desc instanceof VoucherNoColumnDesc)) continue;
            vchnoCol = (VoucherNoColumnDesc)desc;
            ArrayList<String> ids = new ArrayList<String>();
            for (DynamicObject data : pageData) {
                String pk = data.getPkValue().toString();
                ids.add(pk);
            }
            Map<String, String> vchNums = VoucherNoUtil.getVoucherNumbers(entityID, vchnoCol, ids);
            vchnoCol.setVchNums(vchNums);
        }
    }

    @Nullable
    public static Map<String, String> getVoucherNumbers(String entityID, VoucherNoColumnDesc vchnoCol, List<String> ids) {
        HashMap<String, String> vchNums;
        int batch = 2000;
        int size = ids.size();
        if (size > batch) {
            vchNums = new HashMap(16);
            for (int j = 0; j < size; j += batch) {
                int endIdx = j + batch;
                if (endIdx > size) {
                    endIdx = size;
                }
                vchNums.putAll(VoucherNoUtil.getVoucherNumber(ids.subList(j, endIdx), entityID, vchnoCol));
            }
        } else {
            vchNums = VoucherNoUtil.getVoucherNumber(ids, entityID, vchnoCol);
        }
        return vchNums;
    }

    public static Map<String, String> getVoucherNumber(List<String> fids, String entityID) {
        return VoucherNoUtil.getVoucherNumber(fids, entityID, null);
    }

    public static Map<String, String> getVoucherNumber(List<String> fids, String entityID, VoucherNoColumnDesc vchnoCol) {
        Object billid;
        Object OpKey2;
        Object et;
        if (CollectionUtils.isEmpty(fids)) {
            return null;
        }
        List newFids = fids.stream().map(s -> Long.valueOf(s)).collect(Collectors.toList());
        HashSet<Long> voucherids = new HashSet<Long>(16);
        HashMap<Object, Long> singleBillVchMap = new HashMap<Object, Long>(16);
        HashMap multiBillVchMap = new HashMap(16);
        if (vchnoCol != null) {
            HashSet<Object> vids;
            long vid;
            String billid2;
            Object object;
            DataSet daptracks;
            String voucherFieldId = vchnoCol.getListFieldId();
            et = EntityMetadataCache.getDataEntityType((String)entityID);
            if (StringUtils.isNotBlank((CharSequence)voucherFieldId)) {
                DynamicProperty vp = et.getProperty(voucherFieldId);
                if (vp == null || StringUtils.isBlank((CharSequence)vp.getAlias())) {
                    return null;
                }
                daptracks = QueryServiceHelper.queryDataSet((String)"VoucherNoUtil.queryVoucherIDField", (String)entityID, (String)("id," + voucherFieldId), (QFilter[])new QFilter[]{new QFilter("id", "in", newFids)}, null);
                object = null;
                try {
                    for (Row row : daptracks) {
                        billid2 = row.getString("id");
                        vid = row.getLong(voucherFieldId);
                        if (vid == 0L) continue;
                        if (multiBillVchMap.containsKey(billid2)) {
                            ((Set)multiBillVchMap.get(billid2)).add(vid);
                        } else if (singleBillVchMap.containsKey(billid2)) {
                            vids = new HashSet<Object>(2);
                            multiBillVchMap.put(billid2, vids);
                            vids.add(singleBillVchMap.remove(billid2));
                            vids.add(vid);
                        } else {
                            singleBillVchMap.put(billid2, vid);
                        }
                        voucherids.add(vid);
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (daptracks != null) {
                        if (object != null) {
                            try {
                                daptracks.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            daptracks.close();
                        }
                    }
                }
            }
            if (!StringUtils.isEmpty((CharSequence)(OpKey2 = vchnoCol.getOperationKey()))) {
                daptracks = QueryServiceHelper.queryDataSet((String)"VoucherNoUtil.queryDaptracker", (String)"ai_daptracker", (String)"sourcebillid,voucherid", (QFilter[])new QFilter[]{new QFilter("billtype", "=", (Object)entityID), new QFilter("opr", "=", OpKey2), new QFilter("sourcebillid", "in", newFids)}, null);
                object = null;
                try {
                    for (Row row : daptracks) {
                        billid2 = row.getString("sourcebillid");
                        vid = row.getLong("voucherid");
                        if (multiBillVchMap.containsKey(billid2)) {
                            ((Set)multiBillVchMap.get(billid2)).add(vid);
                        } else if (singleBillVchMap.containsKey(billid2)) {
                            vids = new HashSet(2);
                            multiBillVchMap.put(billid2, vids);
                            vids.add(singleBillVchMap.remove(billid2));
                            vids.add(vid);
                        } else {
                            singleBillVchMap.put(billid2, vid);
                        }
                        voucherids.add(vid);
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (daptracks != null) {
                        if (object != null) {
                            try {
                                daptracks.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            daptracks.close();
                        }
                    }
                }
            }
        }
        if (vchnoCol == null || StringUtils.isEmpty((CharSequence)vchnoCol.getListFieldId()) && StringUtils.isEmpty((CharSequence)vchnoCol.getOperationKey())) {
            DataSet daptracks = QueryServiceHelper.queryDataSet((String)"VoucherNoUtil.queryDaptracker", (String)"ai_daptracker", (String)"sourcebillid,voucherid", (QFilter[])new QFilter[]{new QFilter("billtype", "=", (Object)entityID), new QFilter("sourcebillid", "in", newFids)}, null);
            et = null;
            try {
                for (Row row : daptracks) {
                    billid = row.getString("sourcebillid");
                    long vid = row.getLong("voucherid");
                    if (multiBillVchMap.containsKey(billid)) {
                        ((Set)multiBillVchMap.get(billid)).add(vid);
                    } else if (singleBillVchMap.containsKey(billid)) {
                        HashSet<Object> vids = new HashSet<Object>(2);
                        multiBillVchMap.put(billid, vids);
                        vids.add(singleBillVchMap.remove(billid));
                        vids.add(vid);
                    } else {
                        singleBillVchMap.put(billid, vid);
                    }
                    voucherids.add(vid);
                }
            }
            catch (Throwable OpKey2) {
                et = OpKey2;
                throw OpKey2;
            }
            finally {
                if (daptracks != null) {
                    if (et != null) {
                        try {
                            daptracks.close();
                        }
                        catch (Throwable OpKey2) {
                            ((Throwable)et).addSuppressed(OpKey2);
                        }
                    } else {
                        daptracks.close();
                    }
                }
            }
        }
        HashMap<Long, String> vnos = new HashMap<Long, String>(voucherids.size());
        if (voucherids.size() > 0) {
            ExceedShardingQueryLimit es = ExceedShardingQueryLimit.create();
            OpKey2 = null;
            try {
                es.setSkipExceedLimit(true);
                DataSet vouchers = QueryServiceHelper.queryDataSet((String)"VoucherNoUtil.queryGLVoucher", (String)GL_VOUCHER, (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", voucherids)}, null);
                billid = null;
                try {
                    for (Row row : vouchers) {
                        long id = row.getLong("id");
                        String vchno = row.getString("billno");
                        vnos.put(id, vchno);
                    }
                }
                catch (Throwable vid) {
                    billid = vid;
                    throw vid;
                }
                finally {
                    if (vouchers != null) {
                        if (billid != null) {
                            try {
                                vouchers.close();
                            }
                            catch (Throwable vid) {
                                ((Throwable)billid).addSuppressed(vid);
                            }
                        } else {
                            vouchers.close();
                        }
                    }
                }
            }
            catch (Throwable vouchers) {
                OpKey2 = vouchers;
                throw vouchers;
            }
            finally {
                if (es != null) {
                    if (OpKey2 != null) {
                        try {
                            es.close();
                        }
                        catch (Throwable vouchers) {
                            ((Throwable)OpKey2).addSuppressed(vouchers);
                        }
                    } else {
                        es.close();
                    }
                }
            }
        }
        HashMap<String, String> result = new HashMap<String, String>(fids.size());
        Set sSet = singleBillVchMap.entrySet();
        for (Map.Entry se : sSet) {
            result.put((String)se.getKey(), (String)vnos.get(se.getValue()));
        }
        Set mSet = multiBillVchMap.entrySet();
        for (Map.Entry me : mSet) {
            Set vids = (Set)me.getValue();
            ArrayList<String> vnoList = new ArrayList<String>(vids.size());
            for (Long vid : vids) {
                String vno = (String)vnos.get(vid);
                if (vno == null) continue;
                vnoList.add(vno);
            }
            result.put((String)me.getKey(), String.join((CharSequence)",", vnoList));
        }
        return result;
    }

    public static void traceVoucher(String billid, IFormView view, String entityID) {
        VoucherNoUtil.traceVoucher(billid, view, entityID, null, null);
    }

    public static void traceVoucher(String billid, IFormView view, String entityID, String operationKey, String voucherFieldId) {
        FormShowParameter showParameter = VoucherNoUtil.getFormShowParameter(billid, entityID, operationKey, voucherFieldId);
        if (showParameter == null) {
            return;
        }
        view.showForm(showParameter);
    }

    @Nullable
    public static FormShowParameter getFormShowParameter(String billid, String entityID, String operationKey, String voucherFieldId) {
        ListShowParameter showParameter;
        long billidLong = 0L;
        HashSet<Long> voucherids = null;
        try {
            billidLong = Long.parseLong(billid);
        }
        catch (NumberFormatException e2) {
            logger.error((Throwable)e2);
        }
        if (!StringUtils.isEmpty((CharSequence)voucherFieldId)) {
            DataSet daptracks = QueryServiceHelper.queryDataSet((String)"VoucherNoUtil.queryVoucherIDField", (String)entityID, (String)("id," + voucherFieldId), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billidLong)}, null);
            Object object = null;
            try {
                for (Row row : daptracks) {
                    long vid = row.getLong(voucherFieldId);
                    if (vid == 0L) continue;
                    voucherids = new HashSet<Long>(16);
                    voucherids.add(vid);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (daptracks != null) {
                    if (object != null) {
                        try {
                            daptracks.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        daptracks.close();
                    }
                }
            }
        }
        if (!(voucherids != null && voucherids.size() != 0 || StringUtils.isEmpty((CharSequence)operationKey))) {
            voucherids = (Set)DB.query((DBRoute)DBRoute.of((String)"gl"), (String)"select ai.fvoucherid as voucherid from t_ai_daptracker ai where ai.fbilltype= ? and ai.FSOURCEBILLID= ? and ai.foper= ?", (Object[])new Object[]{entityID, billidLong, operationKey}, e -> {
                HashSet<Long> vchSet = new HashSet<Long>(16);
                while (e.next()) {
                    vchSet.add(e.getLong("voucherid"));
                }
                return vchSet;
            });
        }
        if (StringUtils.isEmpty((CharSequence)voucherFieldId) && StringUtils.isEmpty((CharSequence)operationKey)) {
            voucherids = (Set)DB.query((DBRoute)DBRoute.of((String)"gl"), (String)"select ai.fvoucherid as voucherid from t_ai_daptracker ai where ai.fbilltype= ? and ai.FSOURCEBILLID= ?", (Object[])new Object[]{entityID, billidLong}, e -> {
                HashSet<Long> vchSet = new HashSet<Long>(16);
                while (e.next()) {
                    vchSet.add(e.getLong("voucherid"));
                }
                return vchSet;
            });
        }
        if (voucherids == null || voucherids.size() == 0) {
            return null;
        }
        if (voucherids.size() == 1) {
            long billId = (Long)voucherids.iterator().next();
            showParameter = new BillShowParameter();
            ((BillShowParameter)showParameter).setPkId((Object)billId);
            showParameter.setFormId(GL_VOUCHER);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            long orgId = 0L;
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"TraceVoucher_queryvoucher", (String)GL_VOUCHER, (String)"org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId)}, null);){
                for (Row row : ds) {
                    orgId = row.getLong("org");
                }
            }
            long userId = Long.parseLong(RequestContext.get().getUserId());
            int i = PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)orgId, (String)"83bfebc8000017ac", (String)GL_VOUCHER, (String)"4715a0df000000ac");
            if (i == 1 && !VoucherNoUtil.getEnableBizVoucherBySysParam(orgId)) {
                showParameter.setStatus(OperationStatus.EDIT);
            } else {
                showParameter.setStatus(OperationStatus.VIEW);
            }
            showParameter.setHasRight(true);
            showParameter.setHasRight(true);
        } else {
            showParameter = new ListShowParameter();
            showParameter.setBillFormId(GL_VOUCHER);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            for (Long pkid : voucherids) {
                showParameter.addLinkQueryPkId((Object)pkid);
            }
            showParameter.getCustomParams().put("org", "");
            showParameter.getCustomParams().put("booktype", "");
        }
        return showParameter;
    }

    private static boolean getEnableBizVoucherBySysParam(Long org) {
        String appId = AppMetadataCache.getAppInfo((String)"gl").getId();
        AppParam param = new AppParam(appId, "10", org, Long.valueOf(0L));
        Object bizvoucher = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)"isbizvoucher");
        Boolean isbizvoucher = bizvoucher == null ? Boolean.FALSE : (Boolean)bizvoucher;
        return isbizvoucher;
    }
}

