/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.report;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Base64;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.report.DynamicObjectJsonValue;
import kd.bos.entity.report.IReportCache;
import kd.bos.entity.report.ReportException;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.ReportResultLimit;
import kd.bos.entity.report.ReportRowSet;
import kd.bos.entity.report.ReportTaskParam;
import kd.bos.entity.report.ReportTaskResult;
import kd.bos.entity.report.TreeModel;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.report.ReportPropUtil;
import kd.bos.report.ReportSelectedRow;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.ExecutorService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;

public class ReportCacheImpl
implements IReportCache {
    private static final Log log = LogFactory.getLog(ReportCacheImpl.class);
    private static final String REPORT_QUERY_PARAM = "report-query-param";
    private static final String REPORT_TASK_PARAM = "report-task-param";
    private static final String REPORT_TASK_RESULT = "report-task-result";
    private static final String REPORT_TREE_RESULT = "report-tree-result";
    private static final String REPORT_TASK_PROGRESS = "report-task-progress";
    private static final String REPORT_TEMP_FILES = "report-temp-files";
    private static final String REPORT_TASK_PROGRESS_TYPE = "report-task-progress-type";
    private static final String REPORT_TASK_DOWNLOADURL = "report-task-downloadUrl";
    private static final String REPORT_TASK_EXCEPTIONMSG = "report-task-exceptionmsg";
    private static final String REPORT_TASK_LARGEDATA = "report-task-largedata";
    private static final String REPORT_RESULT_LIMIT = "report-result-limit";

    public void setReportTaskParam(String pageId, String ctrlId, ReportTaskParam param) {
        if (param.getOtherParam() instanceof DynamicObject) {
            DynamicObjectJsonValue val = this.toDynamicObjectJsonValue((DynamicObject)param.getOtherParam());
            param.setOtherParam((Object)val);
        }
        CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REPORT_TASK_PARAM, new DistributeCacheHAPolicy(true, true)).put(REPORT_TASK_PARAM + pageId + ctrlId, (Object)this.toSerializedString(param));
        log.info("kd.bos.mvc.report.ReportCacheImpl.setReportTaskParam \u6dfb\u52a0\u5bf9\u8c61\u8fdb\u7f13\u5b58\uff0ckey={}\uff0c value{}", (Object)(REPORT_TASK_PARAM + pageId + ctrlId), (Object)param);
        CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REPORT_TASK_PROGRESS, new DistributeCacheHAPolicy(true, true)).remove(REPORT_TASK_PROGRESS + pageId);
        log.info("kd.bos.mvc.report.ReportCacheImpl.setReportTaskParam \u79fb\u9664\u7f13\u5b58\u5bf9\u8c61\uff0ckey={}", (Object)(REPORT_TASK_PROGRESS + pageId));
    }

    public ReportTaskParam getReportTaskParam(String pageId, String ctrlId) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REPORT_TASK_PARAM, new DistributeCacheHAPolicy(true, true));
        String pageCacheJson = (String)cache.get(REPORT_TASK_PARAM + pageId + ctrlId);
        if (pageCacheJson == null) {
            return null;
        }
        ReportTaskParam param = (ReportTaskParam)this.fromSerializedString(pageCacheJson);
        if (param.getOtherParam() instanceof DynamicObjectJsonValue) {
            DynamicObject obj = this.toDynamicObject((DynamicObjectJsonValue)param.getOtherParam());
            param.setOtherParam((Object)obj);
        }
        return param;
    }

    public void setReportQueryParam(String pageId, ReportQueryParam queryParam) {
        String queryParamStr = this.toSerializedString(queryParam);
        CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REPORT_QUERY_PARAM, new DistributeCacheHAPolicy(true, true)).put(REPORT_QUERY_PARAM + pageId, (Object)queryParamStr);
        log.info("kd.bos.mvc.report.ReportCacheImpl.setReportQueryParam \u6dfb\u52a0\u7f13\u5b58\u5bf9\u8c61\uff0ckey={}\uff0c value={}", (Object)(REPORT_QUERY_PARAM + pageId), (Object)queryParamStr);
    }

    public ReportQueryParam getReportQueryParam(String pageId) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REPORT_QUERY_PARAM, new DistributeCacheHAPolicy(true, true));
        String pageCacheJson = (String)cache.get(REPORT_QUERY_PARAM + pageId);
        if (pageCacheJson == null) {
            return new ReportQueryParam();
        }
        return (ReportQueryParam)this.fromSerializedString(pageCacheJson);
    }

    public Object getOtherQueryParam(ReportTaskParam param, String pageId) {
        Object otherParam = param.getOtherParam();
        if (otherParam instanceof ReportSelectedRow) {
            ReportSelectedRow selectedRow = (ReportSelectedRow)otherParam;
            ReportTaskResult result = this.getReportTaskResult(pageId, selectedRow.getCtrlId());
            DynamicObject selectedObj = null;
            if (result != null) {
                MainEntityType itemType = EntityMetadataCache.getDataEntityType((String)selectedRow.getEntityId());
                itemType = ReportPropUtil.createReportType((DynamicObjectType)itemType, result.getReportColumnList());
                ReportRowSet rowSet = result.getData(selectedRow.getRowIndex(), 1);
                DataEntityPropertyCollection props = itemType.getProperties();
                if (rowSet.next()) {
                    selectedObj = new DynamicObject((DynamicObjectType)itemType);
                    for (IDataEntityProperty property : props) {
                        if (property == null || !rowSet.containsColumn(property.getName())) continue;
                        if (property instanceof BasedataProp) {
                            ((BasedataProp)property).getRefIdProp().setValue((Object)selectedObj, rowSet.getObject(property.getName()));
                            continue;
                        }
                        property.setValue((Object)selectedObj, rowSet.getObject(property.getName()));
                    }
                    BusinessDataServiceHelper.loadRefence((Object[])new DynamicObject[]{selectedObj}, (IDataEntityType)itemType);
                }
            }
            return selectedObj;
        }
        return otherParam;
    }

    public void setReportTaskResult(String pageId, String ctrlId, ReportTaskResult result) {
        if (this.isStopQuery(pageId)) {
            if (result != null) {
                result.close();
            }
            log.info("Query terminated, cache results do not updated");
            return;
        }
        this.releaseLastResult(pageId, ctrlId, result);
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REPORT_TASK_RESULT, new DistributeCacheHAPolicy(true, true));
        cache.put(REPORT_TASK_RESULT + pageId + ctrlId, (Object)this.toSerializedString(result));
        log.info("kd.bos.mvc.report.ReportCacheImpl.setReportTaskResult \u6dfb\u52a0\u7f13\u5b58\u5bf9\u8c61, pageId:{}, ctrlId:{}, resultId:{}", new Object[]{pageId, ctrlId, result == null ? null : result.getResultId()});
    }

    public ReportTaskResult getReportTaskResult(String pageId, String ctrlId) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REPORT_TASK_RESULT, new DistributeCacheHAPolicy(true, true));
        String pageCacheJson = (String)cache.get(REPORT_TASK_RESULT + pageId + ctrlId);
        if (pageCacheJson == null) {
            return null;
        }
        return (ReportTaskResult)this.fromSerializedString(pageCacheJson);
    }

    public void setReportTreeModel(String pageId, TreeModel treeModel) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REPORT_TREE_RESULT, new DistributeCacheHAPolicy(true, true));
        cache.put(REPORT_TREE_RESULT + pageId, (Object)SerializationUtils.toJsonString((Object)treeModel));
        log.info("kd.bos.mvc.report.ReportCacheImpl.setReportTreeModel \u6dfb\u52a0\u7f13\u5b58\u5bf9\u8c61\uff0ckey={}\uff0c value={}", (Object)(REPORT_TREE_RESULT + pageId), (Object)SerializationUtils.toJsonString((Object)treeModel));
    }

    public TreeModel getReportTreeModel(String pageId) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REPORT_TREE_RESULT, new DistributeCacheHAPolicy(true, true));
        String pageCacheJson = (String)cache.get(REPORT_TREE_RESULT + pageId);
        if (pageCacheJson == null) {
            return null;
        }
        return (TreeModel)SerializationUtils.fromJsonString((String)pageCacheJson, TreeModel.class);
    }

    public void setProgress(String pageId, int progress) {
        String taskId = this.getTaskId(pageId);
        if (StringUtils.isNotEmpty((CharSequence)taskId)) {
            ExecutorService.getInstance().getObjectFactory().getTaskDao().updateProgress(taskId, progress, null, null);
            return;
        }
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REPORT_TASK_PROGRESS, new DistributeCacheHAPolicy(true, true));
        cache.put(REPORT_TASK_PROGRESS + pageId, (Object)String.valueOf(progress));
        log.info("kd.bos.mvc.report.ReportCacheImpl.setProgress \u6dfb\u52a0\u7f13\u5b58\u5bf9\u8c61\uff0ckey={}\uff0c value={}", (Object)(REPORT_TASK_PROGRESS + pageId), (Object)String.valueOf(progress));
    }

    public int getProgress(String pageId) {
        TaskInfo taskInfo;
        String taskId = this.getTaskId(pageId);
        if (StringUtils.isNotEmpty((CharSequence)taskId) && (taskInfo = ScheduleServiceHelper.queryTask((String)taskId)) != null) {
            return taskInfo.getProgress();
        }
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REPORT_TASK_PROGRESS, new DistributeCacheHAPolicy(true, true));
        String progress = (String)cache.get(REPORT_TASK_PROGRESS + pageId);
        if (progress == null) {
            return 0;
        }
        return Integer.parseInt(progress);
    }

    private String toSerializedString(Object obj) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(out);
            os.writeObject(obj);
            return Base64.getEncoder().encodeToString(out.toByteArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object fromSerializedString(String s) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(Base64.getDecoder().decode(s));
            ObjectInputStream is = new ObjectInputStream(in);
            return is.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private DynamicObject toDynamicObject(DynamicObjectJsonValue value) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)value.getEntityId());
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)type);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        return (DynamicObject)jser.deserializeFromString(value.getData()[0], null);
    }

    private DynamicObjectJsonValue toDynamicObjectJsonValue(DynamicObject obj) {
        DynamicObjectType type = obj.getDynamicObjectType();
        DynamicObjectJsonValue val = new DynamicObjectJsonValue();
        val.setEntityId(type.getName());
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(type);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        jser.setIsLocaleValueFull(true);
        binder.setOnlyDbProperty(false);
        val.setData(new String[]{jser.serializeToString((Object)obj, null)});
        return val;
    }

    public void setProgressType(String pageId, String type) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REPORT_TASK_PROGRESS_TYPE, new DistributeCacheHAPolicy(true, true));
        cache.put(REPORT_TASK_PROGRESS_TYPE + pageId, (Object)type);
        log.info("kd.bos.mvc.report.ReportCacheImpl.setProgressType \u6dfb\u52a0\u7f13\u5b58\u5bf9\u8c61\uff0ckey={}\uff0c value={}", (Object)(REPORT_TASK_PROGRESS_TYPE + pageId), (Object)type);
    }

    public String getProgressType(String pageId) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REPORT_TASK_PROGRESS_TYPE, new DistributeCacheHAPolicy(true, true));
        return (String)cache.get(REPORT_TASK_PROGRESS_TYPE + pageId);
    }

    public void setDownloadUrl(String pageId, String url) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REPORT_TASK_DOWNLOADURL, new DistributeCacheHAPolicy(true, true));
        cache.put(REPORT_TASK_DOWNLOADURL + pageId, (Object)url);
        log.info("kd.bos.mvc.report.ReportCacheImpl.setDownloadUrl \u6dfb\u52a0\u7f13\u5b58\u5bf9\u8c61\uff0ckey={}\uff0c value={}", (Object)(REPORT_TASK_DOWNLOADURL + pageId), (Object)url);
    }

    public String getDownloadUrl(String pageId) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REPORT_TASK_DOWNLOADURL, new DistributeCacheHAPolicy(true, true));
        return (String)cache.get(REPORT_TASK_DOWNLOADURL + pageId);
    }

    public void clear(String pageId, String ctrlId) {
        log.info("kd.bos.mvc.report.ReportCacheImpl.clear, pageId:{}, ctrlId:{}", (Object)pageId, (Object)ctrlId);
        CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REPORT_TASK_PARAM, new DistributeCacheHAPolicy(true, true)).remove(REPORT_TASK_PARAM + pageId + ctrlId);
        CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REPORT_QUERY_PARAM, new DistributeCacheHAPolicy(true, true)).remove(REPORT_QUERY_PARAM + pageId);
        CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REPORT_TASK_RESULT, new DistributeCacheHAPolicy(true, true)).remove(REPORT_TASK_RESULT + pageId + ctrlId);
        CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REPORT_TREE_RESULT, new DistributeCacheHAPolicy(true, true)).remove(REPORT_TREE_RESULT + pageId + ctrlId);
        CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REPORT_TASK_PROGRESS, new DistributeCacheHAPolicy(true, true)).remove(REPORT_TASK_PROGRESS + pageId);
        CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REPORT_TASK_PROGRESS, new DistributeCacheHAPolicy(true, true)).remove(REPORT_TEMP_FILES + pageId);
        CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REPORT_TASK_PROGRESS_TYPE, new DistributeCacheHAPolicy(true, true)).remove(REPORT_TASK_PROGRESS_TYPE + pageId);
        CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REPORT_TASK_DOWNLOADURL, new DistributeCacheHAPolicy(true, true)).remove(REPORT_TASK_DOWNLOADURL + pageId);
        CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REPORT_TASK_EXCEPTIONMSG, new DistributeCacheHAPolicy(true, true)).remove(REPORT_TASK_EXCEPTIONMSG + pageId);
        CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REPORT_TASK_LARGEDATA, new DistributeCacheHAPolicy(true, true)).remove(REPORT_TASK_LARGEDATA + pageId);
        CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REPORT_RESULT_LIMIT, new DistributeCacheHAPolicy(true, true)).remove(REPORT_RESULT_LIMIT + pageId);
    }

    public void clearReportQueryParam(String pageId) {
        CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REPORT_QUERY_PARAM, new DistributeCacheHAPolicy(true, true)).remove(REPORT_QUERY_PARAM + pageId);
    }

    public void setException(String pageId, ReportException exception) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REPORT_TASK_EXCEPTIONMSG, new DistributeCacheHAPolicy(true, true));
        String msg = SerializationUtils.toJsonString((Object)exception);
        cache.put(REPORT_TASK_EXCEPTIONMSG + pageId, (Object)msg);
        log.info("kd.bos.mvc.report.ReportCacheImpl.setException \u7f13\u5b58\u9519\u8bef\u4fe1\u606f\uff0ckey={}\uff0c value={}", (Object)(REPORT_TASK_EXCEPTIONMSG + pageId), (Object)msg);
    }

    public ReportException getException(String pageId) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REPORT_TASK_EXCEPTIONMSG, new DistributeCacheHAPolicy(true, true));
        String exception = (String)cache.get(REPORT_TASK_EXCEPTIONMSG + pageId);
        if (exception == null) {
            return null;
        }
        return (ReportException)SerializationUtils.fromJsonString((String)exception, ReportException.class);
    }

    public String getExcptionMsg(String pageId) {
        ReportException exception = this.getException(pageId);
        if (exception != null) {
            return exception.getContent();
        }
        return null;
    }

    public void setExceptionMsg(String pageId, String msg) {
        this.setException(pageId, new ReportException(ReportException.ShowType.SHOW_NOTIFICATION_MSG, msg));
        log.info("kd.bos.mvc.report.ReportCacheImpl.setExceptionMsg \u6dfb\u52a0\u7f13\u5b58\u5bf9\u8c61\uff0ckey={}\uff0c value={}", (Object)(REPORT_TASK_EXCEPTIONMSG + pageId), (Object)msg);
    }

    public void clearExceptionMsg(String pageId) {
        CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REPORT_TASK_EXCEPTIONMSG, new DistributeCacheHAPolicy(true, true)).remove(REPORT_TASK_EXCEPTIONMSG + pageId);
        log.info("kd.bos.mvc.report.ReportCacheImpl.clearExceptionMsg \u6e05\u9664\u7f13\u5b58\u5bf9\u8c61\uff0ckey={}", (Object)(REPORT_TASK_EXCEPTIONMSG + pageId));
    }

    public boolean isLargeData(String pageId) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REPORT_TASK_LARGEDATA, new DistributeCacheHAPolicy(true, true));
        return Boolean.parseBoolean((String)cache.get(REPORT_TASK_LARGEDATA + pageId));
    }

    public void setLargeData(String pageId, boolean largeData) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REPORT_TASK_LARGEDATA, new DistributeCacheHAPolicy(true, true));
        cache.put(REPORT_TASK_LARGEDATA + pageId, (Object)String.valueOf(largeData));
        log.info("kd.bos.mvc.report.ReportCacheImpl.setLargeData \u6dfb\u52a0\u7f13\u5b58\u5bf9\u8c61\uff0ckey={}\uff0c value={}", (Object)(REPORT_TASK_LARGEDATA + pageId), (Object)String.valueOf(largeData));
    }

    public void setReportResultLimit(String pageId, String ctrlId, ReportResultLimit limit) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REPORT_RESULT_LIMIT, new DistributeCacheHAPolicy(true, true));
        String cacheJson = null;
        if (limit == null) {
            cache.remove(REPORT_RESULT_LIMIT + pageId + ctrlId);
        } else {
            cacheJson = SerializationUtils.toJsonString((Object)limit);
            cache.put(REPORT_RESULT_LIMIT + pageId + ctrlId, (Object)cacheJson);
        }
        log.info("kd.bos.mvc.report.ReportCacheImpl.setReportResultLimit \u6dfb\u52a0\u7f13\u5b58\u5bf9\u8c61\uff0ckey={}\uff0c limit={}", (Object)(REPORT_TASK_LARGEDATA + pageId + ctrlId), (Object)cacheJson);
    }

    public ReportResultLimit getReportResultLimit(String pageId, String ctrlId) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REPORT_RESULT_LIMIT, new DistributeCacheHAPolicy(true, true));
        String pageCacheJson = (String)cache.get(REPORT_RESULT_LIMIT + pageId + ctrlId);
        if (pageCacheJson == null) {
            return null;
        }
        return (ReportResultLimit)SerializationUtils.fromJsonString((String)pageCacheJson, ReportResultLimit.class);
    }

    private String getTaskId(String pageId) {
        IPageCache pageCache = SessionManager.getCurrent().getPageCache(pageId);
        return pageCache.get("taskId");
    }

    private boolean isStopQuery(String pageId) {
        if (Boolean.getBoolean("report.query.ignorecheck")) {
            return false;
        }
        DistributeSessionlessCache pageCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("form-pagecache", new DistributeCacheHAPolicy(true, true));
        String reportQueryId = (String)pageCache.get(CacheKeyUtil.getAcctId() + ".pagecache." + pageId, "reportQueryId");
        if (StringUtils.isEmpty((CharSequence)reportQueryId) || ThreadCache.get((Object)"reportQueryId") == null) {
            return false;
        }
        return !reportQueryId.equals(ThreadCache.get((Object)"reportQueryId"));
    }

    private void releaseLastResult(String pageId, String ctrlId, ReportTaskResult result) {
        try {
            ReportTaskResult oldResult = this.getReportTaskResult(pageId, ctrlId);
            if (result != null && oldResult != null) {
                result.coverCacheResult(oldResult);
            }
        }
        catch (Exception e) {
            log.error("\u6e05\u9664\u62a5\u8868\u7f13\u5b58\u62a5\u9519", (Throwable)e);
        }
    }
}

