/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.AlgoException;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.MulBasedataReportColumn;
import kd.bos.entity.report.ReportBatchQueryParameter;
import kd.bos.entity.report.ReportBatchQueryResult;
import kd.bos.entity.report.ReportByBatchTaskResult;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.ReportResultLimit;
import kd.bos.entity.report.ReportRowSet;
import kd.bos.entity.report.ReportSysPublicParameter;
import kd.bos.entity.report.ReportTaskParam;
import kd.bos.entity.report.ReportTaskResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.report.ReportService;
import kd.bos.mvc.report.ReportPropUtil;
import kd.bos.report.AbstractReportListModel;
import kd.bos.report.plugin.ReportViewPluginProxy;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.collections4.map.CaseInsensitiveMap;

@SdkPublic
public class ReportListModel
extends AbstractReportListModel {
    private static final Log log = LogFactory.getLog(ReportListModel.class);
    private static final String BOS_FORM_MVC = "bos-form-mvc";

    protected void query() {
        int limit;
        IPageCache pageCache = this.getView().getPageCache();
        String pageId = this.getPageId();
        String ctrlId = this.getCtrlId();
        String directExportExcel = pageCache.get("DirectExportExcel");
        if (StringUtils.isNotEmpty((CharSequence)directExportExcel) && !StringUtils.equals((CharSequence)"exportreport", (CharSequence)directExportExcel)) {
            pageId = pageId + "_noQueryExport";
            limit = ReportSysPublicParameter.getMaxExportLimit() * 10000;
        } else {
            limit = ReportSysPublicParameter.getMaxQueryLimit() * 10000;
        }
        this.getReportCache().setReportResultLimit(pageId, ctrlId, new ReportResultLimit(limit));
        String reportQueryId = UUID.randomUUID().toString();
        pageCache.put("reportQueryId", reportQueryId);
        pageCache.saveChanges();
        if (this.isAsynQuery()) {
            this.asynQuery(reportQueryId);
        } else {
            ThreadCache.put((Object)"reportQueryId", (Object)reportQueryId);
            DispatchServiceHelper.invokeBOSService((String)this.getItemType().getAppId(), (String)ReportService.class.getSimpleName(), (String)"doQuery", (Object[])new Object[]{pageId, ctrlId});
        }
        this.setReportTaskResult(null);
    }

    public DynamicObjectCollection getRowData(int startIndex, int length) {
        return this.getRowData(startIndex, length, null);
    }

    public DynamicObjectCollection getRowData(int startIndex, int length, String parentId) {
        return this.getRowData(startIndex, length, parentId, null, false);
    }

    protected DynamicObjectCollection getRowData(int startIndex, int length, String parentId, Integer currentSeq) {
        return this.getRowData(startIndex, length, parentId, currentSeq, false, true);
    }

    public DynamicObjectCollection getRowData(int startIndex, int length, boolean onlyWithSelectedRows) {
        return this.getRowData(startIndex, length, null, null, onlyWithSelectedRows);
    }

    private DynamicObjectCollection getRowData(int startIndex, int length, String parentId, Integer currentSeq, boolean onlyWithSelectedRows) {
        return this.getRowData(startIndex, length, parentId, currentSeq, onlyWithSelectedRows, true);
    }

    private DynamicObjectCollection getRowData(int startIndex, int length, String parentId, Integer currentSeq, boolean onlyWithSelectedRows, boolean isRetry) {
        ReportByBatchTaskResult batchTskR;
        int prepare;
        ReportTaskResult result = this.getReportTaskResult();
        if (result == null) {
            log.info("ReportListModel.getRowData, reportTaskResult is null, pageId={}, ctrlId={}, parentId ={}", new Object[]{this.getPageId(), this.getCtrlId(), parentId});
            throw new KDBizException(ResManager.loadKDString((String)"\u7f13\u5b58\u5931\u6548\u5bfc\u81f4\u65e0\u6cd5\u5c55\u793a\u6570\u636e\uff0c\u8bf7\u5237\u65b0\u6216\u91cd\u65b0\u67e5\u8be2\u3002", (String)"ReportListModel_0", (String)BOS_FORM_MVC, (Object[])new Object[0]));
        }
        List cols = result.getReportColumnList();
        ReportQueryParam queryParam = this.getReportQueryParam();
        if (result instanceof ReportByBatchTaskResult && (startIndex != 0 || length != 0) && (prepare = this.preFetchBatchData(startIndex, length, parentId, currentSeq, batchTskR = (ReportByBatchTaskResult)result, queryParam)) < 0 && startIndex > batchTskR.getBatchLoadInfo().getLoadedRowCount()) {
            DynamicObjectType itemType = ReportPropUtil.createReportType((DynamicObjectType)this.getItemType(), cols);
            return new DynamicObjectCollection(itemType, null);
        }
        if (startIndex < 0 || length < 0) {
            startIndex = 0;
            length = 0;
        }
        ReportRowSet rowSet = null;
        try {
            rowSet = this.getReportRowSet(startIndex, length, parentId, currentSeq);
        }
        catch (AlgoException e) {
            if (isRetry) {
                this.setReportTaskResult(null);
                DispatchServiceHelper.invokeBOSService((String)this.getItemType().getAppId(), (String)ReportService.class.getSimpleName(), (String)"doQuery", (Object[])new Object[]{this.getPageId(), this.getCtrlId()});
                return this.getRowData(startIndex, length, parentId, currentSeq, onlyWithSelectedRows, false);
            }
            throw e;
        }
        DynamicObjectCollection rowColl = this.toDynamicObjectCollection(rowSet, cols, startIndex, parentId, onlyWithSelectedRows);
        this.processRowData(rowColl);
        return rowColl;
    }

    private int preFetchBatchData(int startIndex, int length, String parentId, Integer currentSeq, ReportByBatchTaskResult batchTskR, ReportQueryParam queryParam) {
        int batchIndex = batchTskR.needFetchMore(startIndex, length, parentId, currentSeq);
        if (batchIndex > 0) {
            ReportResultLimit limit = this.getReportResultLimit();
            if (limit != null && limit.isExceedLimitCount(startIndex + length)) {
                log.info("\u83b7\u53d6\u6570\u636e\u8d85\u8fc7\u9650\u5236, limitCount={}, start={}, limit={}", new Object[]{limit.getLimitCount(), startIndex, length});
                length = limit.getLimitCount() - startIndex;
                if (length <= 0) {
                    return -1;
                }
            }
            String pageId = this.getPageId();
            String ctrlId = this.getCtrlId();
            String directExportExcel = this.getView().getPageCache().get("DirectExportExcel");
            if (StringUtils.isNotEmpty((CharSequence)directExportExcel) && !StringUtils.equals((CharSequence)"exportreport", (CharSequence)directExportExcel)) {
                pageId = pageId + "_noQueryExport";
            }
            ReportBatchQueryResult result = (ReportBatchQueryResult)DispatchServiceHelper.invokeBOSService((String)this.getItemType().getAppId(), (String)ReportService.class.getSimpleName(), (String)"doQueryByBatch", (Object[])new Object[]{new ReportBatchQueryParameter(pageId, ctrlId, batchIndex)});
            Tuple r = batchTskR.addBatchData(startIndex, length, batchIndex, parentId, currentSeq, result);
            this.getReportCache().setReportTaskResult(pageId, ctrlId, (ReportTaskResult)batchTskR);
            if (((Boolean)r.item2).booleanValue()) {
                return this.preFetchBatchData(startIndex, length, parentId, currentSeq, batchTskR, queryParam) + (Integer)r.item1;
            }
            return (Integer)r.item1;
        }
        return batchIndex;
    }

    protected Map<String, Object> formatSummaryValue() {
        HashMap<String, Object> formatSummaryValue = new HashMap<String, Object>(16);
        ReportTaskResult result = this.getReportTaskResult();
        if (result != null) {
            List cols = result.getReportColumnList();
            DynamicObjectType itemType = ReportPropUtil.createReportType((DynamicObjectType)this.getItemType(), cols);
            DynamicObject obj = new DynamicObject(itemType);
            for (AbstractReportColumn column : cols) {
                String fieldKey = ((ReportColumn)column).getFieldKey();
                if (!this.getSummaryValueMap().containsKey(fieldKey)) continue;
                Object srcValue = this.getSummaryValueMap().get(fieldKey);
                obj.set(fieldKey, srcValue);
                Object formatValue = ((ReportColumn)column).formatCell(obj, srcValue, null);
                formatSummaryValue.put(fieldKey, formatValue);
            }
        }
        return formatSummaryValue;
    }

    private ReportRowSet getReportRowSet(int startIndex, int length, String parentId, Integer currentSeq) {
        ReportTaskResult result = this.getReportTaskResult();
        ReportResultLimit limit = this.getReportResultLimit();
        if (limit != null && limit.isExceedLimitCount(startIndex + length)) {
            log.info("\u83b7\u53d6\u6570\u636e\u8d85\u8fc7\u9650\u5236, limitCount={}, start={}, limit={}", new Object[]{limit.getLimitCount(), startIndex, length});
            length = limit.getLimitCount() - startIndex;
            this.getReportCache().setReportResultLimit(this.getPageId(), this.getCtrlId(), limit);
        }
        return result.getData(startIndex, length, parentId, currentSeq);
    }

    private DynamicObjectCollection toDynamicObjectCollection(ReportRowSet rowSet, List<ReportColumn> columns, int startIndex, String parentId, boolean onlyWithSelectedRows) {
        DynamicObjectType itemType = ReportPropUtil.createReportType((DynamicObjectType)this.getItemType(), columns);
        this.registOtherProperty(itemType);
        DynamicObjectCollection rowData = new DynamicObjectCollection(itemType, null);
        Boolean isQueryDS = StringUtils.isBlank((CharSequence)this.getPluginClassName()) && !StringUtils.isBlank((CharSequence)this.getDataSourceId());
        ArrayList<Tuple<String, DynamicProperty>> colMap = new ArrayList<Tuple<String, DynamicProperty>>(itemType.getProperties().size());
        for (ReportColumn column : columns) {
            DynamicProperty property;
            String key;
            String string = key = column.getDateIndex() == null ? column.getFieldKey() : column.getDateIndex();
            if (isQueryDS.booleanValue() && column instanceof MulBasedataReportColumn) {
                key = key + ".fbasedataid";
            }
            if (!rowSet.containsColumn(key) || (property = itemType.getProperty(column.getFieldKey())) == null) continue;
            colMap.add((Tuple<String, DynamicProperty>)new Tuple((Object)key, (Object)property));
        }
        AbstractGrid.GridState entryState = this.getEntryState();
        int seq = startIndex + 1;
        while (rowSet.next()) {
            if (!onlyWithSelectedRows || this.isSelectedData(entryState, seq)) {
                DynamicObject obj = this.toDynamicObject(rowSet, itemType, colMap, isQueryDS);
                if (parentId == null && itemType.getProperty("fseq") != null) {
                    obj.set("fseq", (Object)seq++);
                }
                rowData.add((Object)obj);
                continue;
            }
            ++seq;
        }
        BusinessDataReader.loadRefence((Object[])rowData.toArray((Object[])new DynamicObject[0]), (IDataEntityType)itemType);
        return rowData;
    }

    private boolean isSelectedData(AbstractGrid.GridState entryState, int seq) {
        if (entryState.isSelectAllRows() && entryState.get("notSelRows") != null && !((List)entryState.get("notSelRows")).contains(seq)) {
            return true;
        }
        return !entryState.isSelectAllRows() && entryState.get("selRows") != null && ((List)entryState.get("selRows")).contains(seq);
    }

    private AbstractGrid.GridState getEntryState() {
        IPageCache pageCache = this.getView().getPageCache();
        String states = pageCache.get("controlstates");
        Object controlViewStates = StringUtils.isBlank((CharSequence)states) ? new CaseInsensitiveMap() : (Map)SerializationUtils.fromJsonString((String)states, CaseInsensitiveMap.class);
        HashMap state = (HashMap)controlViewStates.get(this.getCtrlId());
        if (state == null) {
            state = new HashMap();
        }
        return new AbstractGrid.GridState(this.getCtrlId(), state);
    }

    protected void registOtherProperty(DynamicObjectType type) {
    }

    private DynamicObject toDynamicObject(ReportRowSet rowSet, DynamicObjectType itemType, List<Tuple<String, DynamicProperty>> colMap, boolean isQueryDS) {
        DynamicObject obj = new DynamicObject(itemType);
        obj.beginInit();
        for (Tuple<String, DynamicProperty> colItem : colMap) {
            String key = (String)colItem.item1;
            DynamicProperty property = (DynamicProperty)colItem.item2;
            if (isQueryDS && property instanceof ICollectionProperty) {
                if (!(property instanceof MulBasedataProp)) continue;
                DynamicObjectCollection objs = (DynamicObjectCollection)obj.get((IDataEntityProperty)property);
                String str = rowSet.getObject(key) == null ? null : rowSet.getObject(key).toString();
                if (!StringUtils.isNotBlank((CharSequence)str)) continue;
                String[] strs = str.split(",");
                String[] uniqueStrs = this.unique(strs);
                for (int i = 0; i < uniqueStrs.length; ++i) {
                    if (StringUtils.isEmpty((CharSequence)uniqueStrs[i]) || StringUtils.equals((CharSequence)uniqueStrs[i], (CharSequence)"null")) continue;
                    DynamicObject col = objs.addNew();
                    col.set("fbasedataid_id", (Object)Long.parseLong(uniqueStrs[i]));
                }
                continue;
            }
            if (property instanceof BasedataProp) {
                ((BasedataProp)property).getRefIdProp().setValueFast((Object)obj, rowSet.getObject(key));
                continue;
            }
            property.setValueFast((Object)obj, rowSet.getObject(key));
        }
        obj.endInit();
        return obj;
    }

    private String[] unique(String[] arr) {
        List<String> list = new ArrayList<String>(Arrays.asList(arr));
        list = list.stream().distinct().collect(Collectors.toList());
        return new ArrayList<String>(list).toArray(new String[list.size()]);
    }

    private void processRowData(DynamicObjectCollection pageData) {
        ReportQueryParam queryParam = this.getReportCache().getReportQueryParam(this.getPageId());
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        if (pluginProxy instanceof ReportViewPluginProxy) {
            ((ReportViewPluginProxy)pluginProxy).fireProcessRowData(this.getCtrlId(), pageData, queryParam);
        }
    }

    private void asynQuery(String reportQueryId) {
        JobInfo job = new JobInfo();
        job.setJobType(JobType.REALTIME);
        job.setName((String)this.getItemType().getDisplayName().getDefaultItem());
        job.setTaskClassname("kd.bos.mvc.report.ReportTask");
        job.setRunByUserId(RequestContext.get().getCurrUserId());
        job.setRunByOrgId(RequestContext.get().getOrgId());
        job.setAppId(this.getItemType().getAppId());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pageId", this.getPageId());
        params.put("ctrlId", this.getCtrlId());
        params.put("appId", this.getItemType().getAppId());
        params.put("type", "reportQuery");
        params.put("reportQueryId", reportQueryId);
        job.setParams(params);
        String taskId = JobClient.dispatch((JobInfo)job);
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put("taskId", taskId);
        ReportCacheManager.getInstance().getCache().setProgress(this.getPageId(), 5);
    }

    public Object getOtherQueryParam() {
        ReportTaskParam param = this.getReportCache().getReportTaskParam(this.getPageId(), this.getCtrlId());
        if (param == null) {
            return null;
        }
        return this.getReportCache().getOtherQueryParam(param, this.getPageId());
    }

    public ReportQueryParam getReportQueryParam() {
        return this.getReportCache().getReportQueryParam(this.getPageId());
    }

    private ReportResultLimit getReportResultLimit() {
        String directExportExcel = this.getView().getPageCache().get("DirectExportExcel");
        if (StringUtils.isNotEmpty((CharSequence)directExportExcel) && !StringUtils.equals((CharSequence)directExportExcel, (CharSequence)"exportreport")) {
            return null;
        }
        Object type = ThreadCache.get((Object)"bos_report_limit_type");
        if (type instanceof String && StringUtils.equals((CharSequence)"largeDataExport", (CharSequence)((String)type))) {
            return null;
        }
        return this.getReportCache().getReportResultLimit(this.getPageId(), this.getCtrlId());
    }
}

