/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.report;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.print.PaperSetting;
import kd.bos.entity.report.IReportCache;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.export.IExportExcelOperate;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.FilterContainerFilterValues;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.limiter.impl.ConcurrencyLimiter;
import kd.bos.limiter.scene.ConcurrentScene;
import kd.bos.limiter.scene.ConcurrentSceneManager;
import kd.bos.list.ControlContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.export.ExportProgress;
import kd.bos.mvc.form.FormController;
import kd.bos.mvc.form.FormView;
import kd.bos.mvc.form.IFormController;
import kd.bos.mvc.report.ReportController;
import kd.bos.mvc.report.click.ReportTreeNodeClick;
import kd.bos.mvc.report.export.ReportExportManager;
import kd.bos.mvc.report.listener.ReportListenerManager;
import kd.bos.mvc.report.operation.IReportOperation;
import kd.bos.mvc.report.operation.ReportOperationFactory;
import kd.bos.mvc.report.permission.ReportFieldPermission;
import kd.bos.mvc.report.query.ReportQueryManager;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.IReportView;
import kd.bos.report.ReportForm;
import kd.bos.report.ReportList;
import kd.bos.report.ReportSelectedRow;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.ReportTree;
import kd.bos.report.events.QueryEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.flex.FlexColumnSplitService;
import kd.bos.report.plugin.ReportViewPluginProxy;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
@KSObject
public class ReportView
extends FormView
implements IReportView,
IExportExcelOperate,
TreeNodeClickListener,
RowClickEventListener,
IConfirmCallBack {
    private static final Log log = LogFactory.getLog((String)"ReportView");
    private boolean isjoinQuery = false;
    private ReportTree reportTree;
    private ReportList reportLeftList;
    private ReportList reportList;
    private ReportForm reportForm;
    private ReportFilter custFilterCont;
    private FilterContainer commFilterCont;
    private ReportQueryParam queryParam;
    private IReportCache reportCache;
    private boolean hasQueryParam;
    protected ControlFilters controlFilters;
    private ExportProgress exportProgress;

    public void setHasQueryParam(boolean hasQueryParam) {
        this.hasQueryParam = hasQueryParam;
    }

    public boolean hasQueryParam() {
        return this.hasQueryParam;
    }

    @Override
    protected void fireInitialize() {
        super.fireInitialize();
        this.addListener();
    }

    @Override
    protected void initiService() {
        super.initiService();
        this.addService(FlexColumnSplitService.class, new FlexColumnSplitService());
    }

    @Override
    @KSMethod
    public void updateView() {
        super.updateView();
        this.initFieldsWithPermission();
        this.loadUserConfig(this.getRootControl().getItems());
    }

    private void initFieldsWithPermission() {
        new ReportFieldPermission(this).setFieldsControlWithPerm();
    }

    public List<Control> getControls() {
        FormRoot root;
        List rootControls;
        ArrayList<Control> allControls = new ArrayList<Control>();
        if (this.cacheControls != null && !this.cacheControls.isEmpty()) {
            allControls.addAll(this.cacheControls.values());
        }
        if ((rootControls = (root = this.getRootControl()).getItems()) != null) {
            allControls.addAll(rootControls);
        }
        return allControls;
    }

    public void setVisible(String policy, Boolean value, String ... ctlKeys) {
        ArrayList<String> list = new ArrayList<String>();
        for (String ctlKey : ctlKeys) {
            Object ctl = this.getControl(ctlKey);
            if (ctl instanceof FieldEdit) {
                if (((FieldEdit)ctl).getProperty().getParent() instanceof EntryType) {
                    ((FieldEdit)ctl).setVisible("", value.booleanValue());
                } else {
                    list.add(ctlKey);
                }
                ctl.getView().getRootControl();
                continue;
            }
            list.add(ctlKey);
        }
        HashMap<String, Object> visableMap = new HashMap<String, Object>();
        visableMap.put("policy", policy);
        visableMap.put("visible", value);
        visableMap.put("keys", list.toArray());
        this.getClientProxy().addAction("setVisible", visableMap);
    }

    public void setEnable(String policy, Boolean value, String ... ctlKeys) {
        HashMap<String, Object> enableMap = new HashMap<String, Object>();
        enableMap.put("policy", policy);
        enableMap.put("enable", value);
        enableMap.put("keys", ctlKeys);
        this.getClientProxy().addAction("setEnable", enableMap);
    }

    @KSMethod
    public void refresh() {
        this.fireQuery();
    }

    public int getProgress() {
        return this.getReportCache().getProgress(this.getPageId());
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        ReportTreeNodeClick.treeNodeClick(evt, this);
    }

    public void entryRowClick(RowClickEvent evt) {
        if (evt.getRow() == -1) {
            return;
        }
        this.queryRightList(((ReportList)evt.getSource()).getKey(), evt.getRow() - 1);
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
    }

    public boolean isAsynQuery() {
        return this.getReportForm().isAsynQuery() && !this.isjoinQuery;
    }

    protected void setjoinQuery(boolean isjoinQuery) {
        this.isjoinQuery = isjoinQuery;
    }

    public ReportQueryParam getQueryParam() {
        if (this.queryParam == null) {
            this.queryParam = this.getReportCache().getReportQueryParam(this.getPageId());
        }
        return this.queryParam;
    }

    public void exportExcel() {
        if (this.isHasOtherTaskWithExport()) {
            return;
        }
        ReportList list = this.getReportList();
        if (list == null) {
            return;
        }
        ReportExportManager.export(this);
        this.getPageCache().remove("DirectExportExcel");
    }

    public FormOperate getFormOperate() {
        return this.formOperate;
    }

    public String exportPdf(PaperSetting info) {
        String result = "";
        ReportList list = this.getReportList();
        if (list != null) {
            String setting = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)this.getFormShowParameter().getSettingKey());
            Map columnSetting = new HashMap();
            if (StringUtils.isNotBlank((CharSequence)setting)) {
                Map settingMap = (Map)SerializationUtils.fromJsonString((String)setting, Map.class);
                columnSetting = (Map)settingMap.get(list.getKey());
            }
            result = list.exportPdf(info, columnSetting);
        }
        return result;
    }

    public void requestGridInfo() {
        IClientViewProxy proxy = (IClientViewProxy)this.getService(IClientViewProxy.class);
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        map.put("types", new String[]{"cw", "cv", "ca", "cs", "cwg"});
        proxy.invokeControlMethod(this.reportList.getKey(), "getGridInfo", new Object[]{map});
    }

    public void showData() {
        this.getReportCache().setProgress(this.getPageId(), 0);
        if (this.getReportTree() != null) {
            this.reportTree.showData();
            String nodeId = this.reportTree.getTreeState().getFocusNodeId();
            this.queryReportList(nodeId);
        } else if (this.getLeftList() != null) {
            ReportList leftList = this.getLeftList();
            leftList.setDefaultSelectRow(true);
            leftList.initGrid();
            this.queryRightList(leftList.getKey(), 0);
        } else if (this.getReportList() != null) {
            this.reportList.initGrid();
        }
    }

    public void setQueryParam(ReportQueryParam queryParam) {
        this.queryParam = queryParam;
    }

    public void fireQuery() {
        ReportList reportList = this.getReportList();
        if (reportList != null) {
            reportList.clearEntryState();
        }
        this.getPageCache().remove("lastGetVirtualDataStartIndex");
        this.getPageCache().remove("lastGetVirtualDataLength");
        this.getReportCache().clearExceptionMsg(this.getPageId());
        ReportQueryParam param = this.getQueryParam();
        if (this.verifyScheme(param)) {
            if (this.isHasOtherTaskWithQuery()) {
                return;
            }
            this.getPageCache().put("isReportSearching", "true");
            this.initialVisible();
            try {
                this.query(param);
            }
            finally {
                if (!this.isAsynQuery()) {
                    this.getPageCache().put("isReportSearching", "false");
                }
            }
        }
        this.showQueryMessage();
        if (reportList != null) {
            HashMap<String, Object> ctl = new HashMap<String, Object>(3);
            if (reportList.isSelectedAll()) {
                ctl.put("selallrow", reportList.isSelectedAll());
            }
            if (!reportList.isShowCount()) {
                ctl.put("showRowCount", reportList.isShowCount());
            }
            if (reportList.isAsyncTotal()) {
                ctl.put("asyncTotal", reportList.isAsyncTotal());
            }
            if (StringUtils.isNotBlank((CharSequence)reportList.getTotalType())) {
                ctl.put("totalType", reportList.getTotalType());
            }
            if (!CollectionUtils.isEmpty(ctl)) {
                this.updateControlMetadata(reportList.getKey(), ctl);
            }
        }
    }

    private void initialVisible() {
        String directExportExcel = this.getPageCache().get("DirectExportExcel");
        if (StringUtils.equals((CharSequence)directExportExcel, (CharSequence)"exportExcelNoQuery")) {
            return;
        }
        ReportFilter custCont = this.getCustomFilterContainer();
        if (custCont != null) {
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getService(IClientViewProxy.class);
            clientViewProxy.preInvokeControlMethod(custCont.getKey(), "setCollapse", new Object[]{true});
        }
        HashSet<String> ctrKey = new HashSet<String>();
        for (Control control : this.getReportForm().getItems()) {
            if (!"toolbarap".equals(control.getKey()) && !"splitcontainerap".equals(control.getKey()) && !"reportlistap".equals(control.getKey())) continue;
            ctrKey.add(control.getKey());
        }
        if (!ctrKey.isEmpty()) {
            this.setVisible(true, ctrKey.toArray(new String[0]));
        }
    }

    private void query(ReportQueryParam queryParam) {
        ReportViewPluginProxy viewPluginProxy = this.getReportViewPluginProxy();
        viewPluginProxy.fireBeforeQuery(queryParam);
        queryParam.setMulLang(RequestContext.get().getLang());
        String pageId = this.getPageId();
        String directExportExcel = this.getPageCache().get("DirectExportExcel");
        if (StringUtils.isNotEmpty((CharSequence)directExportExcel) && !StringUtils.equals((CharSequence)directExportExcel, (CharSequence)"exportreport")) {
            pageId = pageId + "_noQueryExport";
        }
        this.getReportCache().setReportQueryParam(pageId, queryParam);
        new ReportQueryManager(this, queryParam).query();
        viewPluginProxy.fireAfterQuery(queryParam);
    }

    private void addListener() {
        new ReportListenerManager(this).addReportListener();
    }

    private FilterContainer initFilterContainer() {
        if (this.commFilterCont == null) {
            this.commFilterCont = (FilterContainer)this.getControl("filtercontainerap");
        }
        if (this.commFilterCont != null) {
            ControlContext context = new ControlContext();
            ReportShowParameter reportShowParameter = (ReportShowParameter)this.getFormShowParameter();
            context.addFilterColumnInitListener(filterColumn -> {
                if (filterColumn.getFilterField() == null || filterColumn.getFilterField().getFieldProp() == null) {
                    filterColumn.addProp();
                    FilterField filterField = filterColumn.getFilterField();
                    if (filterField == null) {
                        if (filterColumn instanceof CommonFilterColumn) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5e38\u7528\u6761\u4ef6\u5b57\u6bb5\u3010%s\u3011\uff0c\u8fc7\u6ee4\u5b57\u6bb5\u540d\u8bbe\u7f6e\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ReportView_8", (String)"bos-form-mvc", (Object[])new Object[0]), filterColumn.getCaption().toString()));
                        }
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65b9\u6848\u67e5\u8be2\u5b57\u6bb5\u3010%s\u3011\uff0c\u8fc7\u6ee4\u5b57\u6bb5\u540d\u8bbe\u7f6e\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ReportView_9", (String)"bos-form-mvc", (Object[])new Object[0]), filterColumn.getCaption().toString()));
                    }
                }
            });
            context.setIsolationOrg(reportShowParameter.isIsolationOrg());
            this.commFilterCont.setContext(context);
        }
        return this.commFilterCont;
    }

    public FilterContainer getFilterContainer() {
        if (this.commFilterCont == null) {
            this.commFilterCont = this.initFilterContainer();
        }
        return this.commFilterCont;
    }

    public ReportFilter getCustomFilterContainer() {
        if (this.custFilterCont == null) {
            this.custFilterCont = (ReportFilter)this.getControl("reportfilterap");
        }
        return this.custFilterCont;
    }

    protected ReportController getReportController() {
        return (ReportController)this.getService(IFormController.class);
    }

    @Override
    protected FormController createFormController() {
        return new ReportController((IFormView)this);
    }

    private boolean verifyScheme(ReportQueryParam repotParam) {
        ReportViewPluginProxy pluginProxy = this.getReportViewPluginProxy();
        QueryEvent queryEvt = new QueryEvent();
        queryEvt.setQueryParam(repotParam);
        pluginProxy.fireVerifyQuery(queryEvt);
        return !queryEvt.isCancel();
    }

    @Override
    protected FormViewPluginProxy createPluginProxy() {
        return new ReportViewPluginProxy();
    }

    public ReportTree getReportTree() {
        if (this.reportTree == null) {
            this.reportTree = (ReportTree)this.getControl("reporttreeap");
        }
        return this.reportTree;
    }

    public IReportCache getReportCache() {
        if (this.reportCache == null) {
            this.reportCache = ReportCacheManager.getInstance().getCache();
        }
        return this.reportCache;
    }

    public ReportList getLeftList() {
        if (this.reportLeftList == null) {
            this.reportLeftList = (ReportList)this.getControl("reportllistap");
        }
        return this.reportLeftList;
    }

    public ReportList getReportList() {
        if (this.reportList == null) {
            this.reportList = (ReportList)this.getControl("reportlistap");
        }
        return this.reportList;
    }

    protected synchronized ReportForm getReportForm() {
        if (this.reportForm == null) {
            this.reportForm = (ReportForm)this.getRootControl();
        }
        return this.reportForm;
    }

    public void queryRightList(String ctrlId, int rowIndex) {
        if (this.getReportList() != null) {
            ReportSelectedRow selectedRow = new ReportSelectedRow();
            selectedRow.setCtrlId(ctrlId);
            selectedRow.setRowIndex(rowIndex);
            this.queryReportList(selectedRow);
        }
    }

    @Override
    protected void release() {
        super.release();
        try {
            ReportList leftList;
            if (this.getReportList() != null) {
                this.reportList.close();
            }
            if ((leftList = this.getLeftList()) != null) {
                leftList.close();
            }
            if (this.getReportTree() != null) {
                this.reportTree.close();
            }
        }
        catch (Exception ex) {
            log.info(ex.getMessage(), (Object)ex);
        }
    }

    private void queryReportList(Object selectedObj) {
        if (this.getReportList() != null) {
            this.reportList.submitTask(this.getReportCache().getReportQueryParam(this.getPageId()), selectedObj);
        }
    }

    public ReportViewPluginProxy getReportViewPluginProxy() {
        return (ReportViewPluginProxy)this.getService(FormViewPluginProxy.class);
    }

    @Override
    public OperationResult invokeOperation(String operationKey) {
        if (StringUtils.equals((CharSequence)"exportreport", (CharSequence)operationKey)) {
            this.getPageCache().put("DirectExportExcel", "exportreport");
        }
        IReportOperation reportOperation = ReportOperationFactory.getReportOperation(operationKey);
        reportOperation.setReportView(this);
        OperateOption operationOption = reportOperation.invokeOperation(operationKey);
        if (operationOption == null) {
            return super.invokeOperation(operationKey);
        }
        return super.invokeOperation(operationKey, operationOption);
    }

    public ControlFilters getControlFilters() {
        FilterContainerFilterValues cachedFilterValues;
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        if (filterContainer != null && this.controlFilters == null && !(cachedFilterValues = filterContainer.getCachedFilterValues()).isEmpty()) {
            this.controlFilters = new ControlFilters(cachedFilterValues.getFastFilterValues(), cachedFilterValues.getOtherFilterValues());
        }
        return this.controlFilters;
    }

    public boolean isLargeData() {
        return this.getReportCache().isLargeData(this.getPageId());
    }

    public void setProgress(int percent) {
        if (this.exportProgress != null) {
            this.exportProgress.feedbackProgress(this.getReportList().getTotalRecords(), percent);
        }
    }

    public void setExportProgress(ExportProgress exportProgress) {
        this.exportProgress = exportProgress;
    }

    private void showQueryMessage() {
        ReportQueryParam param = this.getReportCache().getReportQueryParam(this.getPageId());
        String message = param.getMessage();
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            param.setMessage(null);
            this.getReportCache().setReportQueryParam(this.getPageId(), param);
            this.showMessage(message);
        }
    }

    private boolean isHasOtherTaskWithQuery() {
        try {
            String queryParamKey;
            String directExportExcel = this.getPageCache().get("DirectExportExcel");
            if (StringUtils.isNotEmpty((CharSequence)directExportExcel) && !StringUtils.equals((CharSequence)directExportExcel, (CharSequence)"exportreport")) {
                return false;
            }
            if (StringUtils.equals((CharSequence)"true", (CharSequence)this.getPageCache().get("SecondaryConfirmation"))) {
                this.getPageCache().remove("SecondaryConfirmation");
                return false;
            }
            String msg = this.getReportCache().getExcptionMsg(this.getPageId());
            boolean hasOtherQuery = StringUtils.isBlank((CharSequence)msg) && "true".equals(this.getPageCache().get("isReportSearching"));
            ReportList reportList = this.getReportList();
            if (!hasOtherQuery && reportList != null) {
                String sceneCode = reportList.getLimitSceneCode(ReportList.LimitType.QUERY_LIMIT, this.getEntityId());
                hasOtherQuery = this.isLockingUser(sceneCode);
            }
            if (hasOtherQuery) {
                queryParamKey = "";
                if (this.queryParam != null) {
                    queryParamKey = UUID.randomUUID().toString();
                    this.getPageCache().putBigObject(queryParamKey, this.toSerializedString(this.queryParam));
                }
                this.showConfirm(ResManager.loadKDString((String)"\u8be5\u62a5\u8868\u4e2d\u60a8\u5df2\u6709\u4e00\u6761\u67e5\u8be2\u4efb\u52a1\u5728\u8fdb\u884c\uff0c\u786e\u5b9a\u9700\u8981\u7ed3\u675f\u8be5\u4efb\u52a1\u5e76\u91cd\u65b0\u5f00\u59cb\u5417\uff1f", (String)"ReportView_11", (String)"bos-form-mvc", (Object[])new Object[0]), null, MessageBoxOptions.YesNo, null, new ConfirmCallBackListener("ReportSearchCallBack", (IConfirmCallBack)this), null, queryParamKey);
                return true;
            }
            if (StringUtils.isBlank((CharSequence)msg) && "true".equals(this.getPageCache().get("isReportExporting"))) {
                queryParamKey = "";
                if (this.queryParam != null) {
                    queryParamKey = UUID.randomUUID().toString();
                    this.getPageCache().putBigObject(queryParamKey, this.toSerializedString(this.queryParam));
                }
                this.showConfirm(ResManager.loadKDString((String)"\u5df2\u6709\u6b63\u5728\u8fdb\u884c\u7684\u5bfc\u51fa\u4efb\u52a1\uff0c\u5f00\u59cb\u67e5\u8be2\u4f1a\u7ec8\u6b62\u6b63\u5728\u8fdb\u884c\u7684\u5bfc\u51fa\u4efb\u52a1\uff0c\u786e\u8ba4\u5f00\u59cb\uff1f", (String)"ReportView_5", (String)"bos-form-mvc", (Object[])new Object[0]), null, MessageBoxOptions.YesNo, null, new ConfirmCallBackListener("ReportExportCallBack", (IConfirmCallBack)this), null, queryParamKey);
                return true;
            }
        }
        catch (Exception e) {
            log.warn("hasOtherTaskWithQuery error", (Throwable)e);
        }
        return false;
    }

    private boolean isHasOtherTaskWithExport() {
        try {
            String sceneCode;
            ReportList reportList;
            if (StringUtils.equals((CharSequence)"true", (CharSequence)this.getPageCache().get("SecondaryConfirmation"))) {
                this.getPageCache().remove("SecondaryConfirmation");
                return false;
            }
            String msg = this.getReportCache().getExcptionMsg(this.getPageId());
            if (StringUtils.isBlank((CharSequence)msg)) {
                if ("true".equals(this.getPageCache().get("isReportSearching"))) {
                    this.showErrorNotification(ResManager.loadKDString((String)"\u5df2\u6709\u6b63\u5728\u8fdb\u884c\u7684\u67e5\u8be2\u4efb\u52a1\uff0c\u8bf7\u7b49\u5f85\u67e5\u8be2\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u5bfc\u51fa\u3002", (String)"ReportView_6", (String)"bos-form-mvc", (Object[])new Object[0]));
                    return true;
                }
                if ("true".equals(this.getPageCache().get("isReportExporting"))) {
                    this.showErrorNotification(ResManager.loadKDString((String)"\u5df2\u6709\u6b63\u5728\u8fdb\u884c\u7684\u5bfc\u51fa\u4efb\u52a1\uff0c\u8bf7\u7b49\u5f85\u5bfc\u51fa\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u65b0\u7684\u5bfc\u51fa\u3002", (String)"ReportView_7", (String)"bos-form-mvc", (Object[])new Object[0]));
                    return true;
                }
            }
            if ((reportList = this.getReportList()) != null && this.isLockingUser(sceneCode = reportList.getLimitSceneCode(ReportList.LimitType.EXPORT_LIMIT, this.getEntityId()))) {
                this.showConfirm(ResManager.loadKDString((String)"\u8be5\u62a5\u8868\u4e2d\u60a8\u5df2\u6709\u4e00\u6761\u5bfc\u51fa\u4efb\u52a1\u5728\u8fdb\u884c\uff0c\u786e\u5b9a\u9700\u8981\u7ed3\u675f\u8be5\u4efb\u52a1\u5e76\u91cd\u65b0\u5f00\u59cb\u5417\uff1f", (String)"ReportView_12", (String)"bos-form-mvc", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("ReportReExportCallBack", (IConfirmCallBack)this));
                return true;
            }
        }
        catch (Exception e) {
            log.warn("hasOtherTaskWithExport error", (Throwable)e);
        }
        return false;
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        String queryParamKey = evt.getCustomVaule();
        if ("ReportSearchCallBack".equals(callBackId) && evt.getResult() == MessageBoxResult.Yes) {
            Object reportQueryParam;
            String queryParamStr;
            ReportView currentView = (ReportView)((Object)evt.getSource());
            currentView.getPageCache().put("isReportSearching", "false");
            currentView.getPageCache().put("SecondaryConfirmation", "true");
            this.getReportCache().clearExceptionMsg(currentView.getPageId());
            if (StringUtils.isNotBlank((CharSequence)queryParamKey) && StringUtils.isNotBlank((CharSequence)(queryParamStr = currentView.getPageCache().getBigObject(queryParamKey))) && (reportQueryParam = this.fromSerializedString(queryParamStr)) instanceof ReportQueryParam) {
                currentView.setQueryParam((ReportQueryParam)reportQueryParam);
                currentView.getPageCache().removeBigObject(queryParamKey);
            }
            currentView.fireQuery();
        } else if ("ReportExportCallBack".equals(callBackId) && evt.getResult() == MessageBoxResult.Yes) {
            Object reportQueryParam;
            String queryParamStr;
            ReportView currentView = (ReportView)((Object)evt.getSource());
            currentView.getPageCache().put("isStopExport", "true");
            currentView.getPageCache().put("isReportExporting", "false");
            currentView.getPageCache().put("SecondaryConfirmation", "true");
            currentView.getPageCache().saveChanges();
            if (StringUtils.isNotBlank((CharSequence)queryParamKey) && StringUtils.isNotBlank((CharSequence)(queryParamStr = currentView.getPageCache().getBigObject(queryParamKey))) && (reportQueryParam = this.fromSerializedString(queryParamStr)) instanceof ReportQueryParam) {
                currentView.setQueryParam((ReportQueryParam)reportQueryParam);
                currentView.getPageCache().removeBigObject(queryParamKey);
            }
            this.getReportCache().clearExceptionMsg(currentView.getPageId());
            currentView.fireQuery();
        } else if ("ReportReExportCallBack".equals(callBackId) && evt.getResult() == MessageBoxResult.Yes) {
            ReportView currentView = (ReportView)((Object)evt.getSource());
            currentView.getPageCache().put("isReportExporting", "false");
            currentView.getPageCache().put("SecondaryConfirmation", "true");
            currentView.getPageCache().saveChanges();
            this.getReportCache().clearExceptionMsg(currentView.getPageId());
            currentView.exportExcel();
        }
    }

    private void loadUserConfig(List<Control> controls) {
        try {
            Object hasLoadUserConfig = this.getModel().getContextVariable("report_hasLoadUserConfig");
            if (hasLoadUserConfig instanceof Boolean && ((Boolean)hasLoadUserConfig).booleanValue()) {
                return;
            }
            for (Control control : controls) {
                if (control instanceof ReportList) {
                    ReportList reportList = (ReportList)control;
                    EntityTraceSpan span = EntityTracer.create((String)"ReportView", (String)"loadUserConfig");
                    Throwable throwable = null;
                    try {
                        Object pageRowsObj;
                        Map setting;
                        if (span.isRealtime()) {
                            span.addLocaleTag("splitPage", (Object)reportList.isSplitPage());
                        }
                        if (!reportList.isSplitPage()) continue;
                        String key = String.format("%s_%s_%s", this.getEntityId(), reportList.getKey(), "_report_userconfig");
                        String currUserSetting = this.getModel().getCurrUserSetting(key);
                        int pageRow = reportList.getPageRow();
                        if (currUserSetting != null && !CollectionUtils.isEmpty((Map)(setting = (Map)SerializationUtils.fromJsonString((String)currUserSetting, Map.class))) && (pageRowsObj = setting.get("pageRows")) instanceof Integer && (Integer)pageRowsObj > 0) {
                            pageRow = (Integer)pageRowsObj;
                        }
                        if (span.isRealtime()) {
                            span.addLocaleTag("pageRowsObj", (Object)pageRow);
                        }
                        reportList.getEntryState().setPageRows(pageRow);
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (span == null) continue;
                        if (throwable != null) {
                            try {
                                span.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        span.close();
                        continue;
                    }
                }
                if (!(control instanceof Container)) continue;
                this.loadUserConfig(((Container)control).getItems());
            }
        }
        catch (Exception e) {
            log.warn("\u52a0\u8f7d\u62a5\u8868\u7528\u6237\u8bbe\u7f6e\u5206\u9875\u6570\u5f02\u5e38", (Throwable)e);
        }
    }

    private boolean isLockingUser(String sceneCode) {
        ConcurrentScene scenes = ConcurrentSceneManager.getScene((String)sceneCode);
        if (scenes != null && scenes.isSingleUserLimit1()) {
            return ConcurrencyLimiter.isLockingUser((String)sceneCode, (String)this.getEntityId());
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private String toSerializedString(Object obj) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private Object fromSerializedString(String s) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

