/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.report.listener;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.report.DateEnum;
import kd.bos.entity.report.FastFilter;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.ReportTaskParam;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.FilterContainerInitListener;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.SearchClickListener;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.ReportViewPluginProxy;

public class ReportFilterContainerListener {
    private static final Log log = LogFactory.getLog(ReportFilterContainerListener.class);
    private static final String FILTER_MODEL_NAME = "kd.bos.filter.FilterModel";
    private ReportView view;

    public ReportFilterContainerListener(ReportView view) {
        this.view = view;
    }

    public void addFilterContainerListener() {
        FilterContainer commCont = this.view.getFilterContainer();
        if (commCont != null) {
            commCont.setNeedShareScheme(true);
            commCont.setEntityId(this.view.getEntityId());
            try {
                ReportList reportList = (ReportList)this.view.getControl("reportlistap");
                if (reportList != null && StringUtils.isEmpty((CharSequence)reportList.getReportPluginClassName()) && StringUtils.isNotEmpty((CharSequence)reportList.getDataSourceId())) {
                    String dataSourceId = reportList.getDataSourceId();
                    commCont.setEntityType((MainEntityType)EntityMetadataCache.getDataEntityTypeById((String)dataSourceId).clone());
                } else {
                    commCont.setEntityType((MainEntityType)commCont.getEntityType().clone());
                }
            }
            catch (CloneNotSupportedException e) {
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[]{e});
            }
            commCont.setFilterModelClassName(FILTER_MODEL_NAME);
            this.setFilterContainerTitle(commCont);
            this.addFilterContainerInitListener(commCont);
            this.addSearchClickListener(commCont);
            commCont.addAfterBindDataListener(afterBindDataEvent -> {
                this.loadUserConfig(this.view, this.view.getRootControl().getItems());
                if (!this.view.hasQueryParam()) {
                    FilterParameter filterParam = commCont.getContext().getClientQueryFilterParameter();
                    ReportQueryParam queryParam = this.buildReportQueryParam(filterParam);
                    this.view.setQueryParam(queryParam);
                }
                this.view.fireQuery();
            });
            commCont.addBeforeF7SelectListener(arg_0 -> ((ReportViewPluginProxy)this.view.getReportViewPluginProxy()).fireFilterContainerBeforeF7Select(arg_0));
        }
    }

    private void addSearchClickListener(FilterContainer filterContainer) {
        filterContainer.addSearchClickListener(new SearchClickListener(){

            public void click(SearchClickEvent searchClickEvent) {
                FilterParameter filterParam = searchClickEvent.getFilterParameter();
                FilterInfo lastFilterInfo = ReportFilterContainerListener.this.view.getQueryParam().getFilter();
                List tableHeadFilterItems = lastFilterInfo.getTableHeadFilterItems();
                ReportQueryParam queryParam = ReportFilterContainerListener.this.buildReportQueryParam(filterParam);
                queryParam.getFilter().setTableHeadFilterItems(tableHeadFilterItems);
                queryParam.getFilter().copyCol2ndFilterOption(lastFilterInfo);
                FastFilter fastFilter = new FastFilter((List)searchClickEvent.getFilterValues().get("fastfilter"), searchClickEvent.getFastQFilters());
                queryParam.getFilter().setFastFilter(fastFilter);
                ReportTaskParam param = ReportFilterContainerListener.this.view.getReportCache().getReportTaskParam(ReportFilterContainerListener.this.view.getPageId(), "reportlistap");
                if (param != null && StringUtils.isNotBlank((CharSequence)param.getQueryDataSource()) && filterParam != null && filterParam.getQFilters() != null && filterParam.getQFilters().size() > 0) {
                    HashMap<String, QFilter> map = new HashMap<String, QFilter>();
                    QFilter qfilter = (QFilter)filterParam.getQFilters().get(0);
                    for (int i = 1; i < filterParam.getQFilters().size(); ++i) {
                        qfilter.and((QFilter)filterParam.getQFilters().get(i));
                    }
                    map.put(param.getQueryDataSource(), qfilter);
                    queryParam.getFilter().setCommFilter(map);
                }
                ReportFilterContainerListener.this.view.setQueryParam(queryParam);
                ReportViewPluginProxy viewPluginProxy = ReportFilterContainerListener.this.view.getReportViewPluginProxy();
                FilterContainerSearchClickArgs filterContainerSearchClickArgs = new FilterContainerSearchClickArgs(searchClickEvent);
                viewPluginProxy.fireFilterContainerSearchClick(filterContainerSearchClickArgs);
                ReportFilterContainerListener.this.view.fireQuery();
            }
        });
    }

    private void addFilterContainerInitListener(FilterContainer filterContainer) {
        filterContainer.addFilterContainerInitListener(new FilterContainerInitListener(){

            public void filterContainerInit(FilterContainerInitEvent evt) {
                ReportViewPluginProxy viewPluginProxy = ReportFilterContainerListener.this.view.getReportViewPluginProxy();
                if (ReportFilterContainerListener.this.view.getQueryParam() == null) {
                    ReportQueryParam queryParam = new ReportQueryParam();
                    viewPluginProxy.fireInitDefaultQueryParam(queryParam);
                    ReportFilterContainerListener.this.setDefaultQueryParam(evt.getCommonFilterColumns(), queryParam);
                    ReportFilterContainerListener.this.view.setQueryParam(queryParam);
                }
                viewPluginProxy.fireFilterContainerInit(evt, ReportFilterContainerListener.this.view.getQueryParam());
            }
        });
    }

    private void setDefaultQueryParam(List<FilterColumn> filterColumnList, ReportQueryParam queryParam) {
        if (queryParam == null || queryParam.getFilter() == null) {
            return;
        }
        for (FilterColumn filterColumn : filterColumnList) {
            Object val;
            String propName = filterColumn.getFieldName();
            FilterItemInfo filterItem = queryParam.getFilter().getFilterItem(propName);
            if (filterItem == null || (val = filterItem.getValue()) == null) continue;
            if (val instanceof DynamicObject) {
                filterColumn.setDefaultValue(((DynamicObject)val).getPkValue().toString());
                continue;
            }
            if (val instanceof DateEnum) {
                filterColumn.setDefaultValue(((DateEnum)val).getValue());
                continue;
            }
            if (val instanceof String[]) {
                filterColumn.setDefaultValues(Collections.singletonList(val));
                continue;
            }
            filterColumn.setDefaultValue(val.toString());
        }
    }

    private void setFilterContainerTitle(FilterContainer filterContainer) {
        LocaleString title = new LocaleString(this.view.getFormShowParameter().getCaption());
        if (StringUtils.isBlank((Object)title) && StringUtils.isBlank((Object)filterContainer.getTitle())) {
            title = FormMetadataCache.getFormConfig((String)this.view.getEntityId()).getCaption();
        }
        if (StringUtils.isNotBlank((Object)title)) {
            filterContainer.setTitle(title);
        }
    }

    private ReportQueryParam buildReportQueryParam(FilterParameter filterParam) {
        ReportQueryParam reportQueryParam = new ReportQueryParam();
        ReportList reportList = this.view.getReportList();
        FilterInfo commonFilter = new FilterInfo();
        reportQueryParam.setFilter(commonFilter);
        if (reportList != null && StringUtils.isNotBlank((CharSequence)reportList.getDataSourceId())) {
            QFilter qfilter = null;
            if (filterParam != null && filterParam.getQFilters() != null && filterParam.getQFilters().size() > 0) {
                qfilter = (QFilter)filterParam.getQFilters().get(0);
                for (int i = 1; i < filterParam.getQFilters().size(); ++i) {
                    qfilter.and((QFilter)filterParam.getQFilters().get(i));
                }
            }
            if (qfilter != null) {
                HashMap<String, QFilter> map = new HashMap<String, QFilter>();
                map.put(reportList.getDataSourceId(), qfilter);
                commonFilter.setCommFilter(map);
            }
        }
        if (filterParam != null && filterParam.getQFilters() != null) {
            commonFilter.setQFilters(filterParam.getQFilters());
            this.forQFilter(filterParam.getQFilters(), commonFilter);
        }
        return reportQueryParam;
    }

    private void forQFilter(List<QFilter> qFilters, FilterInfo filterInfo) {
        for (QFilter qFilter : qFilters) {
            this.forQFilter(qFilter, filterInfo);
        }
    }

    private void forQFilter(QFilter qFilter, FilterInfo filterInfo) {
        if (qFilter == null) {
            return;
        }
        filterInfo.addFilterItem(qFilter.getProperty(), qFilter.getValue(), qFilter.getCP());
        List nests = qFilter.getNests(false);
        for (QFilter.QFilterNest nest : nests) {
            this.forQFilter(nest.getFilter(), filterInfo);
        }
    }

    private void loadUserConfig(ReportView view, List<Control> controls) {
        try {
            for (Control control : controls) {
                if (control instanceof ReportList) {
                    ReportList reportList = (ReportList)control;
                    EntityTraceSpan span = EntityTracer.create((String)"ReportView", (String)"loadUserConfig");
                    Throwable throwable = null;
                    try {
                        Object pageRowsObj;
                        Map setting;
                        if (span.isRealtime()) {
                            span.addLocaleTag("splitPage", (Object)reportList.isSplitPage());
                        }
                        if (!reportList.isSplitPage()) continue;
                        String key = String.format("%s_%s_%s", view.getEntityId(), reportList.getKey(), "_report_userconfig");
                        String currUserSetting = view.getModel().getCurrUserSetting(key);
                        int pageRow = reportList.getPageRow();
                        if (currUserSetting != null && !CollectionUtils.isEmpty((Map)(setting = (Map)SerializationUtils.fromJsonString((String)currUserSetting, Map.class))) && (pageRowsObj = setting.get("pageRows")) instanceof Integer && (Integer)pageRowsObj > 0) {
                            pageRow = (Integer)pageRowsObj;
                        }
                        if (span.isRealtime()) {
                            span.addLocaleTag("pageRowsObj", (Object)pageRow);
                        }
                        reportList.getEntryState().setPageRows(pageRow);
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (span == null) continue;
                        if (throwable != null) {
                            try {
                                span.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        span.close();
                        continue;
                    }
                }
                if (!(control instanceof Container)) continue;
                this.loadUserConfig(view, ((Container)control).getItems());
            }
            view.getModel().putContextVariable("report_hasLoadUserConfig", (Object)true);
        }
        catch (Exception e) {
            log.warn("\u52a0\u8f7d\u62a5\u8868\u7528\u6237\u8bbe\u7f6e\u5206\u9875\u6570\u5f02\u5e38", (Throwable)e);
        }
    }
}

