/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.report.permission;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.PermissionControlType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataPropEdit;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.FieldControlRule;
import kd.bos.permission.api.FieldControlRules;
import kd.bos.permission.api.PermissionService;
import kd.bos.permission.model.PermRes;
import kd.bos.permission.model.perm.req.field.FieldControlRules2RuleReq;
import kd.bos.service.ServiceFactory;

public class ReportFieldPermission {
    private ReportView view;

    public ReportFieldPermission(ReportView view) {
        this.view = view;
    }

    public void setFieldsControlWithPerm() {
        IPageCache cache = (IPageCache)this.view.getService(IPageCache.class);
        String pageId = this.view.getPageId();
        if (cache.get("canNotReadFields" + pageId) != null) {
            Set oldCanNotReadFields = (Set)SerializationUtils.fromJsonString((String)cache.get("canNotReadFields" + pageId), Set.class);
            for (String oldCanNotReadField : oldCanNotReadFields) {
                this.view.setVisible("FieldPermission", true, oldCanNotReadField);
            }
            cache.remove("canNotReadFields" + pageId);
        }
        if (cache.get("canNotWriteField" + pageId) != null) {
            Set oldCanNotWriteFields = (Set)SerializationUtils.fromJsonString((String)cache.get("canNotWriteField" + pageId), Set.class);
            for (String oldCanNotWriteField : oldCanNotWriteFields) {
                this.view.setEnable("FieldPermission", true, oldCanNotWriteField);
            }
            cache.remove("canNotWriteField" + pageId);
        }
        long userId = RequestContext.get().getCurrUserId();
        String mainOrg = this.view.getModel().getDataEntityType().getMainOrg();
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.view.getEntityId());
        FieldControlRules fieldControlRules = permissionService.getFieldControlRules(userId, ShowFormHelper.getBizAppId((FormShowParameter)this.view.getFormShowParameter()), entityType.getName());
        if (fieldControlRules == null) {
            return;
        }
        FieldControlRule frule = this.getFieldControlRule(fieldControlRules, mainOrg);
        Set lstCanNotReadFields = frule.getCanNotReadFields();
        Set lstCanNotWriteFields = frule.getCanNotWriteFields();
        this.getBasedataPropKeyByFieldKey(lstCanNotReadFields);
        this.getBasedataPropKeyByFieldKey(lstCanNotWriteFields);
        for (String canNotReadField : lstCanNotReadFields) {
            this.view.setVisible("FieldPermission", false, canNotReadField);
        }
        for (String canNotWriteField : lstCanNotWriteFields) {
            this.view.setEnable("FieldPermission", false, canNotWriteField);
        }
        cache.put("canNotReadFields" + pageId, SerializationUtils.toJsonString((Object)lstCanNotReadFields));
        cache.put("canNotWriteField" + pageId, SerializationUtils.toJsonString((Object)lstCanNotWriteFields));
    }

    private FieldControlRule getFieldControlRule(FieldControlRules fieldControlRules, String mainOrg) {
        MainEntityType dataEntityType = this.view.getModel().getDataEntityType();
        PermissionControlType permissionControlType = null == dataEntityType ? null : dataEntityType.getPermissionControlType();
        String dimension = null == permissionControlType ? "" : permissionControlType.getDimension();
        String dataDimensionField = null == permissionControlType ? "" : permissionControlType.getDataDimensionField();
        DynamicObject dyn = this.view.getModel().getDataEntity();
        DynamicObjectCollection doc = new DynamicObjectCollection();
        doc.add((Object)dyn);
        FieldControlRules2RuleReq req = new FieldControlRules2RuleReq(doc, fieldControlRules, mainOrg, dimension, dataDimensionField);
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        PermRes fieldControlRuleMapPermRes = permissionService.fieldControlRules2RuleMap(req);
        Map fieldControlRuleMap = (Map)fieldControlRuleMapPermRes.getData();
        if (null == fieldControlRuleMap || fieldControlRuleMap.isEmpty()) {
            FieldControlRule fieldControlRule = new FieldControlRule();
            fieldControlRule.setCanNotReadRuleFields(new ArrayList());
            fieldControlRule.setCanNotWriteRuleFields(new ArrayList());
            fieldControlRule.setCanNotReadFields(new HashSet());
            fieldControlRule.setCanNotWriteFields(new HashSet());
            return fieldControlRule;
        }
        FieldControlRule fieldControlRuleRes = (FieldControlRule)fieldControlRuleMap.get(String.valueOf(dyn.getPkValue()));
        if (null == fieldControlRuleRes) {
            FieldControlRule fieldControlRule = new FieldControlRule();
            fieldControlRule.setCanNotReadRuleFields(new ArrayList());
            fieldControlRule.setCanNotWriteRuleFields(new ArrayList());
            fieldControlRule.setCanNotReadFields(new HashSet());
            fieldControlRule.setCanNotWriteFields(new HashSet());
            return fieldControlRule;
        }
        return fieldControlRuleRes;
    }

    private long getMainOrgId(String mainOrg) {
        DynamicObject obj = this.view.getModel().getDataEntity();
        long orgId = -1L;
        Object orgObj = obj.get(mainOrg);
        if (orgObj == null) {
            return orgId;
        }
        if (orgObj instanceof DynamicObject) {
            orgId = Long.parseLong(String.valueOf(((DynamicObject)orgObj).getPkValue()));
        } else if (orgObj instanceof Long) {
            orgId = (Long)orgObj;
        }
        return orgId;
    }

    private void getBasedataPropKeyByFieldKey(Set<String> fields) {
        if (fields == null || fields.isEmpty()) {
            return;
        }
        List<Control> allControls = this.view.getControls();
        HashSet<String> basedataPropSet = new HashSet<String>(16);
        for (Control ctrl : allControls) {
            if (!(ctrl instanceof BasedataPropEdit)) continue;
            BasedataPropEdit basedataPropEdit = (BasedataPropEdit)ctrl;
            String key = basedataPropEdit.getRefBasedataProp() + "." + basedataPropEdit.getRefDisplayProp();
            if (fields.contains(key)) {
                fields.add(basedataPropEdit.getKey());
                basedataPropSet.add(key);
            }
            if (!fields.contains(basedataPropEdit.getRefBasedataProp())) continue;
            fields.add(basedataPropEdit.getKey());
        }
        if (!CollectionUtils.isEmpty(basedataPropSet)) {
            fields.removeAll(basedataPropSet);
        }
    }
}

