/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.report.query;

import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.ProgressBar;
import kd.bos.mvc.report.ReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportTree;

public class ReportQueryManager {
    private static final String CONTROL_PROGRESSBARAP = "progressbarap";
    private static final String PROGRESSTYPE_QUERY = "query";
    private ReportView view;
    private ReportQueryParam queryParam;

    public ReportQueryManager(ReportView view, ReportQueryParam queryParam) {
        this.view = view;
        this.queryParam = queryParam;
    }

    public void query() {
        if (this.view.getReportTree() != null) {
            this.queryReportTree();
        } else if (this.view.getLeftList() != null) {
            this.queryLeftList();
        } else if (this.view.getReportList() != null) {
            this.queryReportList();
        }
        this.view.setQueryParam(this.queryParam);
    }

    private void queryReportTree() {
        ReportTree reportTree = this.view.getReportTree();
        reportTree.submitTask(this.queryParam);
        if (!this.view.isAsynQuery()) {
            reportTree.showData();
        } else {
            this.view.setVisible(true, new String[]{CONTROL_PROGRESSBARAP});
            ProgressBar bar = (ProgressBar)this.view.getControl(CONTROL_PROGRESSBARAP);
            this.view.getReportCache().setProgressType(this.view.getPageId(), PROGRESSTYPE_QUERY);
            IClientViewProxy proxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
            proxy.setFieldProperty(bar.getKey(), "percent", (Object)0);
            bar.start();
        }
    }

    private void queryLeftList() {
        ReportList leftList = this.view.getLeftList();
        leftList.setAsynQuery(this.view.isAsynQuery());
        leftList.setDefaultSelectRow(true);
        leftList.submitTask(this.queryParam, null);
        if (!this.view.isAsynQuery()) {
            this.view.queryRightList(leftList.getKey(), 0);
        }
    }

    private void queryReportList() {
        ReportList reportList = this.view.getReportList();
        if (this.view.isAsynQuery()) {
            this.view.setVisible(true, new String[]{CONTROL_PROGRESSBARAP});
            ProgressBar bar = (ProgressBar)this.view.getControl(CONTROL_PROGRESSBARAP);
            this.view.getReportCache().setProgressType(this.view.getPageId(), PROGRESSTYPE_QUERY);
            IClientViewProxy proxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
            proxy.setFieldProperty(bar.getKey(), "percent", (Object)0);
            bar.start();
        }
        reportList.setAsynQuery(this.view.isAsynQuery());
        reportList.submitTask(this.queryParam, null);
    }
}

