/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.baserecordset.exportandimport;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;

public class BaseDataSetReader {
    public List<Object> getAllItems(String table, List<String> lstTableFields, DBRoute dbRoute) {
        String sql = this.getAllItemsSql(table, lstTableFields);
        Object[] params = new SqlParameter[]{};
        MyResultSetCallBack action = new MyResultSetCallBack();
        action.lstFields = lstTableFields;
        List list = (List)DB.query((DBRoute)dbRoute, (String)sql, (Object[])params, action);
        return list;
    }

    private String getAllItemsSql(String table, List<String> lstTableFields) {
        if (lstTableFields.size() <= 0) {
            return null;
        }
        StringBuilder sqlFields = new StringBuilder();
        for (String item : lstTableFields) {
            sqlFields.append(String.format(" %s,", item.toString()));
        }
        sqlFields.deleteCharAt(sqlFields.length() - 1);
        StringBuilder sql = new StringBuilder();
        sql.append("select").append((CharSequence)sqlFields).append(" from ").append(table);
        return sql.toString();
    }

    public List<Object> getItemsByIds(String table, List<String> lstTableFields, DBRoute dbRoute, List<String> ids, String primaryKey) {
        String sql = this.getItemsSqlByIds(table, lstTableFields, ids, primaryKey);
        Object[] params = new SqlParameter[]{};
        MyResultSetCallBack action = new MyResultSetCallBack();
        action.lstFields = lstTableFields;
        List list = (List)DB.query((DBRoute)dbRoute, (String)sql, (Object[])params, action);
        return list;
    }

    private String getItemsSqlByIds(String table, List<String> lstTableFields, List<String> ids, String primaryKey) {
        if (lstTableFields.size() <= 0) {
            return null;
        }
        StringBuilder sqlFields = new StringBuilder();
        for (String item : lstTableFields) {
            sqlFields.append(String.format(" %s,", item.toString()));
        }
        sqlFields.deleteCharAt(sqlFields.length() - 1);
        StringBuilder sqlWhere = new StringBuilder();
        for (int k = 0; k < ids.size(); ++k) {
            sqlWhere.append('\'').append(ids.get(k)).append('\'').append(',');
        }
        sqlWhere.deleteCharAt(sqlWhere.length() - 1);
        StringBuilder sql = new StringBuilder();
        sql.append("select").append((CharSequence)sqlFields).append(" from ").append(table).append(" where ").append(primaryKey).append(" in (").append((CharSequence)sqlWhere).append(')');
        return sql.toString();
    }

    public String getBizAppId(String number) {
        String appid = "";
        Object[] params = new SqlParameter[]{new SqlParameter(":fnumber", 12, (Object)number)};
        String sql = "select fbizappid from t_meta_formdesign where fnumber=?";
        try {
            appid = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<String>(){

                public String handle(ResultSet rs) throws KDException {
                    String sFdata = null;
                    try {
                        if (rs.next()) {
                            sFdata = rs.getString(1);
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                    }
                    return sFdata;
                }
            });
            if (StringUtils.isBlank((CharSequence)appid)) {
                appid = "";
            }
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[0]);
        }
        return appid;
    }

    class MyResultSetCallBack<T>
    implements ResultSetHandler<T> {
        public List<String> lstFields;

        MyResultSetCallBack() {
        }

        public T handle(ResultSet rs) throws KDException {
            ArrayList list = new ArrayList(16);
            try {
                while (rs.next()) {
                    HashMap<String, String> mapItem = new HashMap<String, String>(16);
                    for (String field : this.lstFields) {
                        String string = field.toString();
                        String sValue = rs.getString(string);
                        mapItem.put(string, sValue);
                    }
                    list.add(mapItem);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
            }
            return (T)list;
        }
    }
}

