/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.MainEntityInfo;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;

public class MainEntityInfoQuery {
    private static final String SELECTFIELDS = "select FID, FDENTITYID, FMODELTYPE, FBIZAPPID,FTABLENAME, FPKFIELDNAME, FPKFIELDTYPE, FNUMBERFIELDKEY,";
    private static final String FIELDS = " FNAMEFIELDKEY, FNAMEISLOCALE, FMAINORGFIELDKEY, FCODENUMBER,FBILLTYPE, FWORKFLOW, FBOTP, FVOUCHER, FISTEMPLATE,FNoSearchEnabled";
    private static final String ERROR = "Error:%s";
    private static final String ERROR_SQL = "error:%s; sql:%s";

    private MainEntityInfo resultSetMapper(ResultSet rs) throws SQLException {
        MainEntityInfo mainEntityInfo = new MainEntityInfo();
        mainEntityInfo.setId(rs.getString("FID"));
        mainEntityInfo.setEntityId(rs.getString("FDENTITYID"));
        mainEntityInfo.setModelType(rs.getString("FMODELTYPE"));
        mainEntityInfo.setBizAppId(rs.getString("FBIZAPPID"));
        mainEntityInfo.setTableName(rs.getString("FTABLENAME"));
        mainEntityInfo.setPKFieldName(rs.getString("FPKFIELDNAME"));
        mainEntityInfo.setPKFieldType(Integer.valueOf(rs.getInt("FPKFIELDTYPE")));
        mainEntityInfo.setNumberFieldKey(rs.getString("FNUMBERFIELDKEY"));
        mainEntityInfo.setNameFieldKey(rs.getString("FNAMEFIELDKEY"));
        mainEntityInfo.setNameIsLocale(Boolean.valueOf(rs.getBoolean("FNAMEISLOCALE")));
        mainEntityInfo.setMainOrgFieldKey(rs.getString("FMAINORGFIELDKEY"));
        mainEntityInfo.setCodeNumber(rs.getBoolean("FCODENUMBER"));
        mainEntityInfo.setBillType(rs.getBoolean("FBILLTYPE"));
        mainEntityInfo.setWorkFlow(rs.getBoolean("FWORKFLOW"));
        mainEntityInfo.setBotp(rs.getBoolean("FBOTP"));
        mainEntityInfo.setVoucher(rs.getBoolean("FVOUCHER"));
        mainEntityInfo.setTemplate(rs.getBoolean("FISTEMPLATE"));
        mainEntityInfo.setNoSearchEnabled(rs.getBoolean("FNoSearchEnabled"));
        return mainEntityInfo;
    }

    public List<MainEntityInfo> getMainEntityInfoList() {
        String sql = "select FID, FDENTITYID, FMODELTYPE, FBIZAPPID,FTABLENAME, FPKFIELDNAME, FPKFIELDTYPE, FNUMBERFIELDKEY, FNAMEFIELDKEY, FNAMEISLOCALE, FMAINORGFIELDKEY, FCODENUMBER,FBILLTYPE, FWORKFLOW, FBOTP, FVOUCHER, FISTEMPLATE,FNoSearchEnabled from t_meta_mainentityinfo";
        try {
            return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])new Object[0], (ResultSetHandler)new ResultSetHandler<List<MainEntityInfo>>(){

                public List<MainEntityInfo> handle(ResultSet rs) throws KDException {
                    ArrayList<MainEntityInfo> list = new ArrayList<MainEntityInfo>();
                    try {
                        while (rs.next()) {
                            list.add(MainEntityInfoQuery.this.resultSetMapper(rs));
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(MainEntityInfoQuery.ERROR, e.getMessage())});
                    }
                    return list;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format(ERROR_SQL, e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
    }

    public List<MainEntityInfo> getMainEntityInfoList(String[] entityNames, Lang lang) {
        if (entityNames.length == 0) {
            return new ArrayList<MainEntityInfo>();
        }
        StringBuilder joins = new StringBuilder();
        int length = entityNames.length;
        Object[] values = new Object[length + 1];
        for (int i = 0; i < length; ++i) {
            if (StringUtils.isEmpty((CharSequence)joins)) {
                joins.append('?');
            } else {
                joins.append(",?");
            }
            values[i] = entityNames[i];
        }
        values[length] = lang.name();
        String sql = String.format("select t.FID, FDENTITYID, FMODELTYPE, FBIZAPPID,FTABLENAME, FPKFIELDNAME, FPKFIELDTYPE, FNUMBERFIELDKEY, FNAMEFIELDKEY, FNAMEISLOCALE, FMAINORGFIELDKEY, FCODENUMBER,FBILLTYPE, FWORKFLOW, FBOTP, FVOUCHER, FISTEMPLATE,FNoSearchEnabled, tl.FNAME from t_meta_mainentityinfo as t left join T_META_MAINENTITYINFO_L as tl on t.FID=tl.FID where t.FID in(%s) AND tl.FLOCALEID=? ", joins);
        try {
            return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])values, (ResultSetHandler)new ResultSetHandler<List<MainEntityInfo>>(){

                public List<MainEntityInfo> handle(ResultSet rs) throws KDException {
                    ArrayList<MainEntityInfo> list = new ArrayList<MainEntityInfo>();
                    try {
                        while (rs.next()) {
                            list.add(MainEntityInfoQuery.this.resultSetMapper(rs));
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(MainEntityInfoQuery.ERROR, e.getMessage())});
                    }
                    return list;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format(ERROR_SQL, e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
    }

    public MainEntityInfo getMainEntityInfoByNumber(String entityNumber) {
        String sql = "select FID, FDENTITYID, FMODELTYPE, FBIZAPPID,FTABLENAME, FPKFIELDNAME, FPKFIELDTYPE, FNUMBERFIELDKEY, FNAMEFIELDKEY, FNAMEISLOCALE, FMAINORGFIELDKEY, FCODENUMBER,FBILLTYPE, FWORKFLOW, FBOTP, FVOUCHER, FISTEMPLATE,FNoSearchEnabled from t_meta_mainentityinfo where FID=?";
        try {
            return (MainEntityInfo)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])new Object[]{entityNumber}, (ResultSetHandler)new ResultSetHandler<MainEntityInfo>(){

                public MainEntityInfo handle(ResultSet rs) throws KDException {
                    try {
                        MainEntityInfo mainEntityInfo = null;
                        while (rs.next()) {
                            mainEntityInfo = MainEntityInfoQuery.this.resultSetMapper(rs);
                        }
                        return mainEntityInfo;
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(MainEntityInfoQuery.ERROR, e.getMessage())});
                    }
                }
            });
        }
        catch (Exception e) {
            String msg = String.format(ERROR_SQL, e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
    }

    public MainEntityInfo getMainEntityInfoByEntityId(String entityId) {
        String sql = "select FID, FDENTITYID, FMODELTYPE, FBIZAPPID,FTABLENAME, FPKFIELDNAME, FPKFIELDTYPE, FNUMBERFIELDKEY, FNAMEFIELDKEY, FNAMEISLOCALE, FMAINORGFIELDKEY, FCODENUMBER,FBILLTYPE, FWORKFLOW, FBOTP, FVOUCHER, FISTEMPLATE,FNoSearchEnabled from t_meta_mainentityinfo where FDENTITYID=?";
        try {
            return (MainEntityInfo)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])new Object[]{entityId}, (ResultSetHandler)new ResultSetHandler<MainEntityInfo>(){

                public MainEntityInfo handle(ResultSet rs) throws KDException {
                    try {
                        MainEntityInfo mainEntityInfo = null;
                        while (rs.next()) {
                            mainEntityInfo = MainEntityInfoQuery.this.resultSetMapper(rs);
                        }
                        return mainEntityInfo;
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(MainEntityInfoQuery.ERROR, e.getMessage())});
                    }
                }
            });
        }
        catch (Exception e) {
            String msg = String.format(ERROR_SQL, e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
    }
}

