/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityItemTypes;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.OpBizRuleSetWriter;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

public class OpBizRuleSetReader {
    private static final Log log = LogFactory.getLog(OpBizRuleSetReader.class);
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("opBizRuleService", new DistributeCacheHAPolicy(true, false));
    public static final String FORMID_OPBIZRULESET = "bos_opbizruleset";
    public static final String KEY_ENTRYENTITY = "entryentity";
    public static final String KEY_OPBIZRULE = "opbizrule";
    public static final String KEY_OBJECTTYPE = "objecttype";
    public static final String KEY_OBJECTTYPE_ID = "objecttype_id";
    public static final String KEY_OPERATIONKEY = "operationkey";

    public static List<String> getOpBizRuleSet(String entityNumber, String opKey) {
        try (EntityTraceSpan span = EntityTracer.create((String)"OpBizRuler", (String)"getOpBizRuleSet", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            span.addLocaleTag("entityNumber", (Object)entityNumber);
            span.addLocaleTag("opKey", (Object)opKey);
            List<String> cacheOpBizRuleSet = OpBizRuleSetReader.loadOpBizRuleSetByOpKey(entityNumber, opKey, true);
            String[] lastBizOpServiceArray = cache.getSetValues(OpBizRuleSetReader.buildCacheKey(entityNumber, opKey));
            List<String> lastBizOpBizRules = new ArrayList<String>();
            if (lastBizOpServiceArray != null && lastBizOpServiceArray.length > 0) {
                lastBizOpBizRules = Arrays.asList(lastBizOpServiceArray);
            }
            boolean isEqual = OpBizRuleSetReader.isEquals(cacheOpBizRuleSet, lastBizOpBizRules);
            span.addLocaleTag("isEqual", (Object)isEqual);
            if (!isEqual) {
                List<String> result1 = cacheOpBizRuleSet;
                cacheOpBizRuleSet = OpBizRuleSetReader.loadOpBizRuleSetByOpKey(entityNumber, opKey, isEqual);
                String msg = String.format("OpBizRule.getOpBizRuleSet(%s, %s), last:=%s, read1:=%s, read2:=%s", entityNumber, opKey, lastBizOpBizRules, result1, cacheOpBizRuleSet);
                span.addLocaleTag("OpBizRule.getOpBizRuleSet", (Object)msg);
                if (!OpBizRuleSetReader.isEquals(result1, cacheOpBizRuleSet)) {
                    OpBizRuleSetWriter.clearCache();
                }
            }
            if (log.isInfoEnabled()) {
                String msg = String.format("OpBizRule.getOpBizRuleSet(%s, %s), return\uff1a%s", entityNumber, opKey, cacheOpBizRuleSet);
                span.addLocaleTag("OpBizRule.getOpBizRuleSet.return", (Object)msg);
            }
            List<String> list = cacheOpBizRuleSet;
            return list;
        }
    }

    public static List<DynamicObject> loadFromCache(QFilter[] qFilters) {
        MainEntityType dt = OpBizRuleDataType.getDataType();
        Map objs = BusinessDataReader.loadFromCache((DynamicObjectType)dt, (QFilter[])qFilters);
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(objs.size());
        if (objs != null && !objs.isEmpty()) {
            list.addAll(objs.values());
        }
        return list;
    }

    public static List<DynamicObject> load(QFilter[] qFilters) {
        ArrayList listIds = new ArrayList();
        try (DataSet ds = ORM.create().queryDataSet("OpBizRuleSetReader.getOpBizRuleSet", FORMID_OPBIZRULESET, "id", qFilters);){
            ds.forEach(row -> listIds.add(row.get(0)));
        }
        if (listIds.isEmpty()) {
            return new ArrayList<DynamicObject>(0);
        }
        Object[] pks = listIds.toArray(new Object[listIds.size()]);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)FORMID_OPBIZRULESET);
        DynamicObject[] objs = BusinessDataReader.load((Object[])pks, (DynamicObjectType)mainType, (Boolean)Boolean.TRUE);
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(listIds.size());
        if (objs != null && objs.length > 0) {
            list.addAll(Arrays.asList(objs));
        }
        return list;
    }

    private static List<String> loadOpBizRuleSetByOpKey(String entityNumber, String opKey, boolean equals) {
        try (EntityTraceSpan span = EntityTracer.create((String)"OpBizRuler", (String)"loadOpBizRuleSetByOpKey", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            span.addLocaleTag("entityNumber", (Object)entityNumber);
            span.addLocaleTag("opKey", (Object)opKey);
            span.addLocaleTag("equals", (Object)equals);
            if (StringUtils.isBlank((CharSequence)entityNumber) || StringUtils.isBlank((CharSequence)opKey)) {
                String msg = String.format("OpBizRule.getOpBizRuleSet(%s, %s), param is null, return empty", entityNumber, opKey);
                span.addLocaleTag("OpBizRule.getOpBizRuleSet.param is null", (Object)msg);
                ArrayList<String> arrayList = new ArrayList<String>(0);
                return arrayList;
            }
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)FORMID_OPBIZRULESET);
            QFilter[] objectTypeFilters = new QFilter[]{new QFilter(KEY_OBJECTTYPE, "=", (Object)entityNumber)};
            List<DynamicObject> objs = equals ? OpBizRuleSetReader.loadFromCache(objectTypeFilters) : OpBizRuleSetReader.load(objectTypeFilters);
            HashSet<String> opBizRuleSet = new HashSet<String>(objs.size());
            if (objs.isEmpty()) {
                String msg = String.format("OpBizRule.getOpBizRuleSet(%s, %s, %s), objs is empty", entityNumber, opKey, equals);
                span.addLocaleTag("OpBizRule.getOpBizRuleSet.obj is empty", (Object)msg);
            } else {
                IDataEntityProperty opBizRuleProp = mainType.findProperty(KEY_OPBIZRULE);
                IDataEntityProperty opKeyProp = mainType.findProperty(KEY_OPERATIONKEY);
                EntryProp entryProp = (EntryProp)mainType.findProperty(KEY_ENTRYENTITY);
                block12: for (DynamicObject obj : objs) {
                    String opBizRule = (String)opBizRuleProp.getValueFast((Object)obj);
                    if (StringUtils.isBlank((CharSequence)opBizRule)) continue;
                    DynamicObjectCollection rows = (DynamicObjectCollection)entryProp.getValueFast((Object)obj);
                    for (DynamicObject row : rows) {
                        String op = (String)opKeyProp.getValue((Object)row);
                        if (!StringUtils.equalsIgnoreCase((CharSequence)op, (CharSequence)opKey)) continue;
                        opBizRuleSet.add(opBizRule);
                        continue block12;
                    }
                }
            }
            ArrayList<String> opBizRuleList = new ArrayList<String>(opBizRuleSet);
            if (!equals) {
                if (opBizRuleList.isEmpty()) {
                    cache.remove(OpBizRuleSetReader.buildCacheKey(entityNumber, opKey));
                } else {
                    cache.addToSet(OpBizRuleSetReader.buildCacheKey(entityNumber, opKey), opBizRuleList.toArray(new String[0]));
                }
            }
            ArrayList<String> arrayList = opBizRuleList;
            return arrayList;
        }
    }

    private static boolean isEquals(List<String> cacheOpBizRules, List<String> lastOpBizRules) {
        if (cacheOpBizRules == null && lastOpBizRules == null) {
            return true;
        }
        if (cacheOpBizRules == null || lastOpBizRules == null) {
            return false;
        }
        if (cacheOpBizRules.size() != lastOpBizRules.size()) {
            return false;
        }
        for (String opBizRule : cacheOpBizRules) {
            if (lastOpBizRules.contains(opBizRule)) continue;
            return false;
        }
        return true;
    }

    private static String buildCacheKey(String entityName, String opKey) {
        String accountId = RequestContext.get().getAccountId();
        return accountId + "_opservice_" + entityName + "_" + opKey;
    }

    static class OpBizRuleDataType {
        private static final String strType = "{\"BizAppNumber\":\"mdl\",\"InheritPath\":\"\",\"ForbidStatus\":\"enabled\",\"DBRouteKey\":\"sys.meta\",\"Properties\":[{\"_Type_\":\"LongProp\"},{\"_Type_\":\"BasedataProp\",\"Alias\":\"fobjecttypeid\",\"LayoutId\":\"\",\"DisplayName\":{\"zh_CN\":\"\u542f\u7528\u670d\u52a1\u7684\u5355\u636e\",\"en_US\":\"Enable Service Doc\",\"zh_TW\":\"\u555f\u7528\u670d\u52d9\u7684\u55ae\u64da\"},\"Features\":219,\"Name\":\"objecttype\",\"BaseEntityId\":\"bos_entityobject\"},{\"DefValue\":\"1\",\"_Type_\":\"BillStatusProp\",\"Alias\":\"fenabled\",\"DisplayName\":{\"zh_CN\":\"\u542f\u7528\u72b6\u6001\",\"en_US\":\"Enabled Status\",\"zh_TW\":\"\u555f\u7528\u72c0\u614b\"},\"StatusItems\":[{\"StatusKey\":\"0\",\"_Type_\":\"StatusItemPro\",\"OperationDateKey\":{\"action\":\"setnull\"},\"StatusName\":{\"zh_CN\":\"\u7981\u7528\",\"en_US\":\"Disable\",\"zh_TW\":\"\u7981\u7528\"},\"OperationerKey\":{\"action\":\"setnull\"}},{\"StatusKey\":\"1\",\"_Type_\":\"StatusItemPro\",\"OperationDateKey\":{\"action\":\"setnull\"},\"StatusName\":{\"zh_CN\":\"\u542f\u7528\",\"en_US\":\"Enable\",\"zh_TW\":\"\u555f\u7528\"},\"OperationerKey\":{\"action\":\"setnull\"}}],\"Features\":217,\"ComboItems\":[{\"_Type_\":\"ValueMapItem\",\"Value\":\"0\",\"Name\":{\"zh_CN\":\"\u7981\u7528\",\"en_US\":\"Disable\",\"zh_TW\":\"\u7981\u7528\"}},{\"_Type_\":\"ValueMapItem\",\"Value\":\"1\",\"Name\":{\"zh_CN\":\"\u542f\u7528\",\"en_US\":\"Enable\",\"zh_TW\":\"\u555f\u7528\"}}],\"Name\":\"enabled\"},{\"_Type_\":\"ComboProp\",\"Alias\":\"fopbizrule\",\"DisplayName\":{\"zh_CN\":\"\u670d\u52a1\",\"en_US\":\"Service\",\"zh_TW\":\"\u670d\u52d9\"},\"Features\":219,\"Name\":\"opbizrule\"},{\"_Type_\":\"EntryProp\",\"KeyFieldId\":\"operationkey\",\"ItemType\":{\"_Type_\":\"EntryType\",\"Alias\":\"t_meta_opbizrulesetentry\",\"DBRouteKey\":\"sys.meta\",\"DisplayName\":{\"zh_CN\":\"\u5355\u636e\u4f53\",\"en_US\":\"Grid\",\"zh_TW\":\"\u55ae\u64da\u9ad4\"},\"KeyField\":\"operationkey\",\"Properties\":[{\"_Type_\":\"LongProp\",\"Alias\":\"FEntryId\"},{\"_Type_\":\"IntegerProp\",\"Alias\":\"FSeq\",\"DisplayName\":{\"VI\":\"\u5206\u5f55\u884c\u53f7\",\"en_US\":\"Entry Line Number\",\"ES\":\"\u5206\u5f55\u884c\u53f7\",\"zh_CN\":\"\u5206\u5f55\u884c\u53f7\",\"JA\":\"\u5206\u5f55\u884c\u53f7\",\"zh_TW\":\"\u5206\u9304\u884c\u865f\"},\"Sys\":true,\"Name\":\"seq\"},{\"_Type_\":\"TextProp\",\"Alias\":\"foperationkey\",\"DisplayName\":{\"zh_CN\":\"\u64cd\u4f5c\",\"en_US\":\"Action\",\"zh_TW\":\"\u64cd\u4f5c\"},\"Features\":219,\"MaxLenth\":30,\"Name\":\"operationkey\"}],\"ExtendName\":\"entryentity\",\"Name\":\"entryentity\"},\"DisplayName\":{\"zh_CN\":\"\u5355\u636e\u4f53\",\"en_US\":\"Grid\",\"zh_TW\":\"\u55ae\u64da\u9ad4\"},\"Name\":\"entryentity\"}],\"Name\":\"bos_opbizruleset\",\"_Type_\":\"BasedataEntityType\",\"AppId\":\"bos\",\"Version\":\"1.1.634.1677034325639.2024-01-14 21:27:43:569\",\"Alias\":\"t_meta_opbizruleset\",\"DisplayName\":{\"zh_CN\":\"\u8bfb\u53d6\u64cd\u4f5c\u670d\u52a1\"},\"RefPropTypes\":[{\"_Type_\":\"RefPropType\",\"Id\":\"bos_entityobject\"}],\"ExtendName\":\"bos_opbizruleset\",\"BOSVer\":\"1.1.634\"}";
        private static MainEntityType dt = null;

        private OpBizRuleDataType() {
        }

        public static MainEntityType getDataType() {
            if (dt == null) {
                dt = (MainEntityType)EntityItemTypes.fromJsonString((String)strType);
            }
            return dt;
        }
    }
}

