/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.upgrade;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.upgrade.ClassManager;
import kd.bos.upgrade.ZipFileCache;

class JarFileManager {
    private String account;
    private volatile Map<String, File> classes;
    private static final ConcurrentLinkedDeque<File> files_to_be_destroyed = new ConcurrentLinkedDeque();
    private static Log logger = LogFactory.getLog(JarFileManager.class);

    JarFileManager(String account) {
        this.account = account;
        if (this.classes == null) {
            try {
                this.classes = this.init();
            }
            catch (Exception e) {
                this.classes = new HashMap<String, File>();
                logger.error("\u52a0\u8f7d\u4e8c\u6b21\u5f00\u53d1\u6269\u5c55\u5305\u5931\u8d25\uff01", (Throwable)e);
            }
        }
    }

    File find(String name) {
        Map<String, File> classes = this.classes;
        if (classes == null) {
            return null;
        }
        return classes.get(name);
    }

    void dispose() {
        Map<String, File> classes = this.classes;
        if (classes != null) {
            this.classes = null;
            HashSet<File> files = new HashSet<File>();
            files.addAll(classes.values());
            files_to_be_destroyed.addAll(files);
        }
    }

    static String getResouceKey(String name) {
        if (name.endsWith(".class")) {
            return name.substring(0, name.length() - ".class".length()).replace('/', '.');
        }
        return name;
    }

    private static void deleteDisposedFiles() {
        try {
            JarFileManager.innerDeleteDisposedFiles();
        }
        catch (Throwable e) {
            logger.warn("deleteDisposedFiles failed.", e);
        }
    }

    final synchronized Map<String, File> init() throws Exception {
        Map<String, File> classes = this.classes;
        if (classes == null) {
            this.checkRequestContext();
            ArrayList<File> files = new ArrayList<File>();
            try {
                JarFileManager.createTempFiles(files);
                this.classes = classes = JarFileManager.scanFiles(files);
            }
            catch (Throwable e) {
                files_to_be_destroyed.addAll(files);
                throw e;
            }
        }
        return classes;
    }

    private static Map<String, File> scanFiles(List<File> files) throws IOException {
        HashMap<String, File> classes = new HashMap<String, File>(1024);
        for (File file : files) {
            JarFileManager.scanFile(file, classes);
        }
        return classes;
    }

    private static void scanFile(File file, Map<String, File> classes) throws IOException {
        try (ZipFile zip = new ZipFile(file);){
            Enumeration<? extends ZipEntry> en = zip.entries();
            while (en.hasMoreElements()) {
                ZipEntry e = en.nextElement();
                if (e.isDirectory()) continue;
                String key = JarFileManager.getResouceKey(e.getName());
                JarFileManager.checkResourceKey(key);
                classes.put(key, file);
            }
        }
    }

    private static void checkResourceKey(String key) throws Error {
    }

    private static void createTempFiles(List<File> files) throws Exception {
        JarFileManager.innerCreateTempFiles(files);
    }

    private static void innerCreateTempFiles(final List<File> files) {
        String sql = "SELECT fjar FROM T_META_EXT_JAR WHERE fenabled='1'";
        DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    byte[] bytes = JarFileManager.readBytes(rs);
                    if (bytes == null || bytes.length <= 0) continue;
                    File file = File.createTempFile("jar_", ".bin");
                    files.add(file);
                    JarFileManager.saveAsTempFile(file, bytes);
                }
                return Boolean.TRUE;
            }
        });
    }

    private static void saveAsTempFile(File file, byte[] bytes) throws IOException {
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file), 524288);){
            for (byte c : bytes) {
                ((OutputStream)os).write(c & 0xFF);
            }
        }
    }

    private static byte[] readBytes(ResultSet rs) throws SQLException {
        Object data = rs.getObject(1);
        if (data instanceof Blob) {
            return JarFileManager.readBlob((Blob)data);
        }
        return (byte[])data;
    }

    private static byte[] readBlob(Blob lob) throws SQLException {
        try {
            byte[] byArray = lob.getBytes(1L, (int)lob.length());
            return byArray;
        }
        finally {
            lob.free();
        }
    }

    private void checkRequestContext() {
        RequestContext rc = RequestContext.get();
        String accountId = null;
        accountId = rc == null ? "requestcontextnull" : RequestContext.get().getAccountId();
        if (StringUtils.isBlank((CharSequence)this.account)) {
            accountId = "accountidnull";
        }
        if (!this.account.equals(accountId)) {
            String message = String.format(ResManager.loadKDString((String)"Jar\u5305\u7ba1\u7406\u5668\u7684\u8d26\u5957\uff08%1$s\uff09\u4e0e\u5f53\u524d\u8d26\u5957\uff08%2$s\uff09\u4e0d\u7b26\uff01", (String)"JarFileManager_0", (String)"bos-business-dao", (Object[])new Object[0]), this.account, accountId);
            throw new UnsupportedOperationException(message);
        }
    }

    private static void innerDeleteDisposedFiles() {
        File file;
        while ((file = files_to_be_destroyed.pollFirst()) != null) {
            try {
                ZipFileCache.close(file);
            }
            catch (Throwable e) {
                try {
                    logger.warn("\u5173\u95ed\u4e34\u65f6\u6587\u4ef6\u5931\u8d25\uff0c\u6587\u4ef6\u8def\u5f84\u662f\uff1a" + file.getCanonicalPath(), e);
                }
                catch (IOException exception) {
                    logger.error((Throwable)exception);
                }
            }
            if (file.delete()) {
                try {
                    logger.warn("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u6210\u529f\uff0c\u6587\u4ef6\u8def\u5f84\u662f\uff1a" + file.getCanonicalPath());
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
                continue;
            }
            try {
                logger.warn("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\u672a\u77e5\uff0c\u6587\u4ef6\u8def\u5f84\u662f\uff1a" + file.getCanonicalPath());
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
    }

    static {
        ClassManager.addJob(new ClassManager.Job(){

            @Override
            public void run() {
                JarFileManager.deleteDisposedFiles();
            }
        });
    }
}

