/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.upgrade;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class SingletonContainer<K, V> {
    private ConcurrentHashMap<K, V> singletons = new ConcurrentHashMap();
    private Factory<K, V> factory;

    public SingletonContainer(Factory<K, V> factory) {
        this.factory = factory;
    }

    public V get(K key) {
        V v = this.singletons.get(key);
        if (v == null) {
            v = this.getOrCreate(key);
        }
        return v;
    }

    public V getOnly(K key) {
        return this.singletons.get(key);
    }

    public void put(K key, V value) {
        this.singletons.put(key, value);
    }

    private V getOrCreate(K key) {
        V v = this.factory.create(key);
        V oldValue = this.singletons.putIfAbsent(key, v);
        if (oldValue == null) {
            oldValue = v;
        }
        return oldValue;
    }

    public V remove(K key) {
        return this.singletons.remove(key);
    }

    public void clear() {
        this.singletons.clear();
    }

    public void visit(Visitor<K, V> visitor) throws Exception {
        Iterator<Map.Entry<K, V>> it = this.singletons.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<K, V> e = it.next();
            Action a = visitor.visit(e);
            a.afterVisit(it);
        }
    }

    public static enum Action {
        Remove{

            @Override
            void afterVisit(Iterator<?> it) {
                it.remove();
            }
        }
        ,
        NOP{

            @Override
            void afterVisit(Iterator<?> it) {
            }
        };


        abstract void afterVisit(Iterator<?> var1);
    }

    public static interface Visitor<K, V> {
        public Action visit(Map.Entry<K, V> var1) throws Exception;
    }

    public static interface Factory<K, V> {
        public V create(K var1);
    }
}

