/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.IEntityOperateService;
import kd.bos.entity.operate.OperateLog;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.facade.FacadeResult;
import kd.bos.facade.base.BaseFacade;
import kd.bos.facade.entity.IEntityLifecycleFacade;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.operation.Audit;
import kd.bos.service.operation.Delete;
import kd.bos.service.operation.Draft;
import kd.bos.service.operation.Invalid;
import kd.bos.service.operation.Save;
import kd.bos.service.operation.Submit;
import kd.bos.service.operation.UnAudit;
import kd.bos.service.operation.UnSubmit;
import kd.bos.service.operation.Valid;

public class MsOperationFacade
extends BaseFacade {
    private static final Log log = LogFactory.getLog(MsOperationFacade.class);
    private static final String SPAN_TYPE_MSOPFACADE = "msopfacade";
    private ConcurrentHashMap<String, List<IEntityLifecycleFacade>> instanceMap = new ConcurrentHashMap();

    public FacadeResult beforeDoExecute(IEntityOperateService owner, Map<String, Object> operateMetaMap, OperateOption option, OperateLog operateLog, DynamicObject[] dataEntities, MainEntityType mainEntityType, MainEntityType subEntityType, boolean invokeByIds, OperationResult operationResult, String operationKey) {
        HashMap<String, Object> params = new HashMap<String, Object>(7);
        params.put("operateLog", operateLog);
        params.put("owner", owner);
        params.put("option", option);
        params.put("operateMetaMap", operateMetaMap);
        params.put("operationKey", operationKey);
        params.put("operationResult", operationResult);
        params.put("dataEntities", dataEntities);
        params.put("mainEntityType", mainEntityType);
        params.put("subEntityType", subEntityType);
        params.put("invokeByIds", invokeByIds);
        List<IEntityLifecycleFacade> facades = this.buildFacadeImpl("EntityOperateService");
        FacadeResult result = null;
        if (facades.size() > 0) {
            for (IEntityLifecycleFacade obj : facades) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_MSOPFACADE, (String)(obj.getClass().getName() + ".beforeDoExecute"));
                Throwable throwable = null;
                try {
                    result = obj.beforeDoExecute(params);
                    if (null == result || result.getCode() == 3) continue;
                    FacadeResult facadeResult = result;
                    return facadeResult;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
        return result;
    }

    public FacadeResult doExecute(IEntityOperateService owner, OperateOption option, OperateLog operateLog, DynamicObject[] dataEntities, MainEntityType mainEntityType, boolean invokeByIds, OperationResult operationResult, String operationKey) {
        HashMap<String, Object> params = new HashMap<String, Object>(7);
        params.put("operateLog", operateLog);
        params.put("owner", owner);
        params.put("option", option);
        params.put("operationKey", operationKey);
        params.put("operationResult", operationResult);
        params.put("dataEntities", dataEntities);
        params.put("mainEntityType", mainEntityType);
        params.put("invokeByIds", invokeByIds);
        List<IEntityLifecycleFacade> facades = this.buildFacadeImpl("EntityOperateService");
        FacadeResult result = null;
        if (facades.size() > 0) {
            for (IEntityLifecycleFacade obj : facades) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_MSOPFACADE, (String)(obj.getClass().getName() + ".doExecute"));
                Throwable throwable = null;
                try {
                    result = obj.doExecute(params);
                    if (null == result || result.getCode() == 3) continue;
                    FacadeResult facadeResult = result;
                    return facadeResult;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
        return result;
    }

    public List<IEntityLifecycleFacade> buildFacadeImpl(String extClass) {
        if (this.instanceMap.size() <= 0) {
            List classAry = this.getRegisterClassByExpenPoint(extClass);
            ArrayList<IEntityLifecycleFacade> pointClass = new ArrayList<IEntityLifecycleFacade>();
            if (classAry == null) {
                log.info("MsOperationFacade extClass is null:" + extClass);
                return this.instanceMap.getOrDefault(extClass, new ArrayList());
            }
            for (String str : classAry) {
                try {
                    Class<?> classz = Class.forName(str);
                    Object obj = classz.newInstance();
                    pointClass.add((IEntityLifecycleFacade)obj);
                }
                catch (Exception e) {
                    log.info("class error\uff1a" + str + e.getMessage());
                }
            }
            this.instanceMap.put(extClass, pointClass);
            return pointClass;
        }
        return this.instanceMap.getOrDefault(extClass, new ArrayList());
    }

    public void HandleResult(FacadeResult result) {
        if (result == null) {
            return;
        }
        if (result.isSuccess()) {
            switch (result.getCode()) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
            }
        }
    }

    public void afterInitialize(IEntityOperateService owner, IDataEntityType dataEntityType, Map<String, Object> operateMetaMap, OperateOption option) {
        Integer operationType = -1;
        if (owner instanceof Save) {
            operationType = 1;
        } else if (owner instanceof Draft) {
            operationType = 0;
        } else if (owner instanceof Audit) {
            operationType = 2;
        } else if (owner instanceof UnAudit) {
            operationType = 3;
        } else if (owner instanceof Valid) {
            operationType = 6;
        } else if (owner instanceof Submit) {
            operationType = 1;
        } else if (owner instanceof UnSubmit) {
            operationType = 1;
        } else if (owner instanceof Delete) {
            operationType = 4;
        } else if (owner instanceof Invalid) {
            Object link;
            boolean keepLink = false;
            operationType = 4;
            Map parametar = (Map)operateMetaMap.get("parameter");
            if (parametar != null && (link = parametar.get("KeepLink")) != null) {
                keepLink = Boolean.parseBoolean(link.toString());
                operationType = keepLink ? Integer.valueOf(5) : Integer.valueOf(4);
            }
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dataEntityType", dataEntityType);
        params.put("operateMetaMap", operateMetaMap);
        params.put("OperationType", operationType);
        params.put("owner", owner);
        params.put("option", option);
        List<IEntityLifecycleFacade> facades = this.buildFacadeImpl("EntityOperateService");
        for (IEntityLifecycleFacade obj : facades) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_MSOPFACADE, (String)(obj.getClass().getName() + ".afterInitialize"));
            Throwable throwable = null;
            try {
                this.HandleResult(obj.afterInitialize(params));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    public void afterPreparePropertysFirst(IEntityOperateService owner, Map<String, Object> operateMetaMap, MainEntityType subEntityType, String formId, Long orgId, OperateOption option, MainEntityType billEntityType, List<String> fieldKeys) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("fieldKeys", fieldKeys);
        params.put("subEntityType", subEntityType);
        params.put("operateMetaMap", operateMetaMap);
        params.put("formId", formId);
        params.put("orgId", orgId);
        params.put("owner", owner);
        params.put("option", option);
        params.put("billEntityType", billEntityType);
        List<IEntityLifecycleFacade> facades = this.buildFacadeImpl("EntityOperateService");
        for (IEntityLifecycleFacade obj : facades) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_MSOPFACADE, (String)(obj.getClass().getName() + ".afterPreparePropertysFirst"));
            Throwable throwable = null;
            try {
                this.HandleResult(obj.afterPreparePropertysFirst(params));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    public void afterPreparePropertys(IEntityOperateService owner, Object[] ids, List<String> fieldKeys) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ids", ids);
        params.put("owner", owner);
        params.put("fieldKeys", fieldKeys);
        List<IEntityLifecycleFacade> facades = this.buildFacadeImpl("EntityOperateService");
        for (IEntityLifecycleFacade obj : facades) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_MSOPFACADE, (String)(obj.getClass().getName() + ".afterPreparePropertys"));
            Throwable throwable = null;
            try {
                this.HandleResult(obj.afterPreparePropertys(params));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    public void afterUpdateBillStatus(IEntityOperateService owner, DynamicObject[] objs) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("objs", objs);
        params.put("owner", owner);
        List<IEntityLifecycleFacade> facades = this.buildFacadeImpl("EntityOperateService");
        for (IEntityLifecycleFacade obj : facades) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_MSOPFACADE, (String)(obj.getClass().getName() + ".afterUpdateBillStatus"));
            Throwable throwable = null;
            try {
                this.HandleResult(obj.afterUpdateBillStatus(params));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    public void afterRollback(IEntityOperateService owner, DynamicObject[] objs, Exception ex) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("objs", objs);
        params.put("owner", owner);
        params.put("ex", ex);
        List<IEntityLifecycleFacade> facades = this.buildFacadeImpl("EntityOperateService");
        for (IEntityLifecycleFacade obj : facades) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_MSOPFACADE, (String)(obj.getClass().getName() + ".afterRollback"));
            Throwable throwable = null;
            try {
                this.HandleResult(obj.afterRollback(params));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    public void beforeCallOperationTransaction(IEntityOperateService owner, DynamicObject[] objs) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("objs", objs);
        params.put("owner", owner);
        List<IEntityLifecycleFacade> facades = this.buildFacadeImpl("EntityOperateService");
        for (IEntityLifecycleFacade obj : facades) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_MSOPFACADE, (String)(obj.getClass().getName() + ".beforeCallOperationTransaction"));
            Throwable throwable = null;
            try {
                this.HandleResult(obj.beforeCallOperationTransaction(params));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    public void afterCallOperationTransaction(IEntityOperateService owner, DynamicObject[] objs) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("objs", objs);
        params.put("owner", owner);
        List<IEntityLifecycleFacade> facades = this.buildFacadeImpl("EntityOperateService");
        for (IEntityLifecycleFacade obj : facades) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_MSOPFACADE, (String)(obj.getClass().getName() + ".afterCallOperationTransaction"));
            Throwable throwable = null;
            try {
                this.HandleResult(obj.afterCallOperationTransaction(params));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    public void afterRelease() {
        List<IEntityLifecycleFacade> facades = this.buildFacadeImpl("EntityOperateService");
        for (IEntityLifecycleFacade obj : facades) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_MSOPFACADE, (String)(obj.getClass().getName() + ".afterRelease"));
            Throwable throwable = null;
            try {
                this.HandleResult(obj.afterRelease());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    public void callOperation(IEntityOperateService owner, DynamicObject[] objs) {
        this.callOperation(owner, null, objs, null, null, null);
    }

    public void callOperation(IEntityOperateService owner, MainEntityType billEntityType, DynamicObject[] successObjs, OperateLog operateLog, OperateOption option, String operationKey) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("objs", successObjs);
        params.put("owner", owner);
        params.put("operateLog", operateLog);
        params.put("option", option);
        params.put("billEntityType", billEntityType);
        params.put("operationKey", operationKey);
        List<IEntityLifecycleFacade> facades = this.buildFacadeImpl("EntityOperateService");
        for (IEntityLifecycleFacade obj : facades) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_MSOPFACADE, (String)(obj.getClass().getName() + ".callOperation"));
            Throwable throwable = null;
            try {
                this.HandleResult(obj.callOperation(params));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    public void callOperationTransaction(IEntityOperateService owner, DynamicObject[] objs) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("objs", objs);
        params.put("owner", owner);
        List<IEntityLifecycleFacade> facades = this.buildFacadeImpl("EntityOperateService");
        for (IEntityLifecycleFacade obj : facades) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_MSOPFACADE, (String)(obj.getClass().getName() + ".callOperationTransaction"));
            Throwable throwable = null;
            try {
                this.HandleResult(obj.callOperationTransaction(params));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    public void afterCommit(IEntityOperateService owner, DynamicObject[] objs) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("objs", objs);
        params.put("owner", owner);
        List<IEntityLifecycleFacade> facades = this.buildFacadeImpl("EntityOperateService");
        for (IEntityLifecycleFacade obj : facades) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_MSOPFACADE, (String)(obj.getClass().getName() + ".afterCommit"));
            Throwable throwable = null;
            try {
                this.HandleResult(obj.afterCommit(params));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    public void beforeExecuteOperate(IEntityOperateService owner, DynamicObject[] objs) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("objs", objs);
        params.put("owner", owner);
        List<IEntityLifecycleFacade> facades = this.buildFacadeImpl("EntityOperateService");
        for (IEntityLifecycleFacade obj : facades) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_MSOPFACADE, (String)(obj.getClass().getName() + ".beforeExecuteOperate"));
            Throwable throwable = null;
            try {
                this.HandleResult(obj.beforeExecuteOperate(params));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    public void afterExecuteOperate(IEntityOperateService owner, DynamicObject[] objs) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("objs", objs);
        params.put("owner", owner);
        List<IEntityLifecycleFacade> facades = this.buildFacadeImpl("EntityOperateService");
        for (IEntityLifecycleFacade obj : facades) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_MSOPFACADE, (String)(obj.getClass().getName() + ".afterExecuteOperate"));
            Throwable throwable = null;
            try {
                this.HandleResult(obj.afterExecuteOperate(params));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    public void addDefaultValidator(List<AbstractValidator> validators, MainEntityType mainEntityType, Map<String, Object> operateMetaMap, String operationKey, IEntityOperateService owner, OperateLog operateLog) {
        HashMap<String, Object> params = new HashMap<String, Object>(6);
        params.put("validators", validators);
        params.put("mainEntityType", mainEntityType);
        params.put("operateMetaMap", operateMetaMap);
        params.put("operationKey", operationKey);
        params.put("owner", owner);
        params.put("operateLog", operateLog);
        List<IEntityLifecycleFacade> facades = this.buildFacadeImpl("EntityOperateService");
        for (IEntityLifecycleFacade obj : facades) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_MSOPFACADE, (String)(obj.getClass().getName() + ".addDefaultValidator"));
            Throwable throwable = null;
            try {
                this.HandleResult(obj.addDefaultValidator(params));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }
}

