/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.CalcExprParser;
import kd.bos.entity.formula.ExpressionParameter;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.function.FunctionManage;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.operate.bizrule.OpBizRule;
import kd.bos.entity.operate.bizrule.OpBizRuleType;
import kd.bos.entity.operate.bizrule.OpBizRuleTypeLoader;
import kd.bos.entity.operate.bizrule.OpBizRuleTypes;
import kd.bos.entity.plugin.IOperationServicePlugIn;
import kd.bos.entity.plugin.OperationServicePlugInProxy;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.OpBizRuleSetServiceHelper;

class OpBizRuleServicePluginProxy
extends OperationServicePlugInProxy {
    private static final Log log = LogFactory.getLog(OpBizRuleServicePluginProxy.class);
    private static final String OPBIZ_RULE = "opbizrule";
    private FunctionManage funcLib;
    private MainEntityType subMainType;
    private Map<IOperationServicePlugIn, List<ExtendedDataEntity>> validExtendedDataRows = new HashMap<IOperationServicePlugIn, List<ExtendedDataEntity>>();

    public OpBizRuleServicePluginProxy(List<Map<String, Object>> plugins) {
        super(plugins);
    }

    public void createOpBizRuleAction(MainEntityType billEntityType, Map<String, Object> operateMetaMap, OperateOption option) {
        List opBizRules = (List)operateMetaMap.get("opbiz");
        String opKey = (String)operateMetaMap.get("key");
        List opBizRuleSet = OpBizRuleSetServiceHelper.getOpBizRuleSet((String)billEntityType.getName(), (String)opKey);
        if ((opBizRules == null || opBizRules.isEmpty()) && (opBizRuleSet == null || opBizRuleSet.isEmpty())) {
            this.getOperateLog().info("OpBizRuleServicePluginProxy.createOpBizRuleAction(), opBizRules and opBizRuleSet is empty, return");
            return;
        }
        OpBizRuleTypes ruleTypes = OpBizRuleTypeLoader.load();
        HashMap<String, OpBizRuleType> mapRuleTypes = new HashMap<String, OpBizRuleType>(ruleTypes.getRuleTypes().size());
        for (OpBizRuleType ruleType : ruleTypes.getRuleTypes()) {
            mapRuleTypes.put(ruleType.getId(), ruleType);
        }
        if (opBizRules != null) {
            for (String bizRuleStr : opBizRules) {
                OpBizRule rule = (OpBizRule)SerializationUtils.fromJsonString((String)bizRuleStr, OpBizRule.class);
                String ruleTypeId = rule.getRuleType();
                OpBizRuleType ruleType = (OpBizRuleType)mapRuleTypes.get(ruleTypeId);
                if (ruleType != null && !ruleType.isDesignForbid() && StringUtils.isNotBlank((CharSequence)ruleType.getRunClass())) {
                    this.getOperateLog().info(String.format("OpBizRuleServicePluginProxy.createOpBizRuleAction: create op meta rule, ruleType = %s, class = %s", ruleTypeId, ruleType.getRunClass()));
                    AbstractOpBizRuleAction plugin = (AbstractOpBizRuleAction)TypesContainer.createInstance((String)ruleType.getRunClass());
                    plugin.setContext(billEntityType, operateMetaMap, option);
                    plugin.setBizRule(rule);
                    this.registerPlugIn((IOperationServicePlugIn)plugin);
                    continue;
                }
                if (ruleType == null) {
                    this.getOperateLog().important(String.format("OpBizRuleServicePluginProxy.createOpBizRuleAction(%s) failed: ruleType is null", ruleTypeId));
                    continue;
                }
                if (ruleType.isDesignForbid()) {
                    this.getOperateLog().important(String.format("OpBizRuleServicePluginProxy.createOpBizRuleAction(%s) failed: ruleType is Design Forbid", ruleTypeId));
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)ruleType.getRunClass())) {
                    this.getOperateLog().important(String.format("OpBizRuleServicePluginProxy.createOpBizRuleAction(%s) failed: run class is null", ruleTypeId));
                    continue;
                }
                this.getOperateLog().important(String.format("OpBizRuleServicePluginProxy.createOpBizRuleAction(%s) failed: unknow", ruleTypeId));
            }
        }
        if (opBizRuleSet != null && !opBizRuleSet.isEmpty()) {
            for (String opBizRuleId : opBizRuleSet) {
                OpBizRuleType ruleType = (OpBizRuleType)mapRuleTypes.get(opBizRuleId);
                if (ruleType != null && ruleType.isDesignForbid() && StringUtils.isNotBlank((CharSequence)ruleType.getRunClass())) {
                    OpBizRule rule = new OpBizRule();
                    rule.setKey(opBizRuleId);
                    rule.setName(ruleType.getName());
                    this.getOperateLog().info(String.format("OpBizRuleServicePluginProxy.createOpBizRuleAction: create op dynamic rule, ruleType = %s, class = %s", opBizRuleId, ruleType.getRunClass()));
                    AbstractOpBizRuleAction plugin = (AbstractOpBizRuleAction)TypesContainer.createInstance((String)ruleType.getRunClass());
                    plugin.setContext(billEntityType, operateMetaMap, option);
                    plugin.setBizRule(rule);
                    this.registerPlugIn((IOperationServicePlugIn)plugin);
                    continue;
                }
                if (ruleType == null) {
                    this.getOperateLog().important(String.format("OpBizRuleServicePluginProxy.createOpBizRuleAction(%s) failed: ruleType is null", opBizRuleId));
                    continue;
                }
                if (!ruleType.isDesignForbid()) {
                    this.getOperateLog().important(String.format("OpBizRuleServicePluginProxy.createOpBizRuleAction(%s) failed: ruleType is not Design Forbid", opBizRuleId));
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)ruleType.getRunClass())) {
                    this.getOperateLog().important(String.format("OpBizRuleServicePluginProxy.createOpBizRuleAction(%s) failed: run class is null", opBizRuleId));
                    continue;
                }
                this.getOperateLog().important(String.format("OpBizRuleServicePluginProxy.createOpBizRuleAction(%s) failed: unknow", opBizRuleId));
            }
        }
    }

    public List<IOperationServicePlugIn> getPlugIns() {
        return this.plugIns;
    }

    public void setSubEntityType(EntityType entityType) {
        super.setSubEntityType(entityType);
        this.subMainType = (MainEntityType)entityType;
    }

    public void setFuncLib(FunctionManage funcLib) {
        this.funcLib = funcLib;
    }

    public void fireBeforeExecuteOperationTransaction(BeforeOperationArgs mainArgs) {
        if (this.plugIns.isEmpty()) {
            return;
        }
        RowDataModel rowModel = null;
        if (mainArgs.getValidExtDataEntities() == null || mainArgs.getValidExtDataEntities().isEmpty()) {
            rowModel = new RowDataModel(this.subMainType.getName(), this.subMainType);
        } else {
            String entityKey = ((ExtendedDataEntity)mainArgs.getValidExtDataEntities().get(0)).getDataEntity().getDataEntityType().getName();
            rowModel = new RowDataModel(entityKey, this.subMainType);
        }
        ArrayList<ExtendedDataEntity> dataEntities = new ArrayList<ExtendedDataEntity>(mainArgs.getValidExtDataEntities());
        HashSet<ExtendedDataEntity> removes = new HashSet<ExtendedDataEntity>();
        for (IOperationServicePlugIn plugin : this.plugIns) {
            AbstractOpBizRuleAction pl;
            OpBizRule rule;
            long beginTime = System.currentTimeMillis();
            if (this.isSplitPage() && !plugin.isSupportSplitPageMode() || (rule = (pl = (AbstractOpBizRuleAction)plugin).getBizRule()) == null) continue;
            String mothedName = plugin.getClass().getName() + ".beforeExecuteOperationTransaction()";
            this.getOperateLog().beginMothed(mothedName, null);
            List<ExtendedDataEntity> currPlugBills = this.filterRuleDataEntity(rowModel, rule, dataEntities, removes);
            this.validExtendedDataRows.put((IOperationServicePlugIn)pl, currPlugBills);
            BeforeOperationArgs currPlugArgs = new BeforeOperationArgs(mainArgs.getOperationKey(), new ArrayList<ExtendedDataEntity>(currPlugBills));
            try (EntityTraceSpan span = EntityTracer.create((String)OPBIZ_RULE, (String)(plugin.getClass().getName() + ".beforeExecuteOperationTransaction"));){
                plugin.beforeExecuteOperationTransaction(currPlugArgs);
            }
            long costTime = System.currentTimeMillis() - beginTime;
            if (costTime > 10L) {
                this.getOperateLog().endMothed(mothedName, null);
            } else {
                this.getOperateLog().removeMothed(mothedName);
            }
            boolean bl = mainArgs.cancel = mainArgs.cancel || currPlugArgs.cancel;
            if (currPlugArgs.cancel && StringUtils.isNotBlank((CharSequence)currPlugArgs.getCancelMessage())) {
                mainArgs.setCancelMessage(currPlugArgs.getCancelMessage());
            }
            if (mainArgs.cancel) break;
            HashSet afterPlugBills = new HashSet(currPlugArgs.getValidExtDataEntities());
            HashSet<DynamicObject> afterPlugObjs = new HashSet<DynamicObject>(Arrays.asList(currPlugArgs.getDataEntities()));
            for (ExtendedDataEntity dataEntity : currPlugBills) {
                if (afterPlugBills.contains(dataEntity) && afterPlugObjs.contains(dataEntity.getDataEntity())) continue;
                removes.add(dataEntity);
            }
        }
        if (!removes.isEmpty()) {
            ArrayList<DynamicObject> afterObjs = new ArrayList<DynamicObject>();
            ArrayList<ExtendedDataEntity> afterDataEntitis = new ArrayList<ExtendedDataEntity>();
            for (ExtendedDataEntity dataEntity : dataEntities) {
                if (removes.contains(dataEntity)) continue;
                afterDataEntitis.add(dataEntity);
                afterObjs.add(dataEntity.getDataEntity());
            }
            mainArgs.getValidExtDataEntities().clear();
            mainArgs.getValidExtDataEntities().addAll(afterDataEntitis);
            mainArgs.setDataEntities(afterObjs.toArray(new DynamicObject[afterObjs.size()]));
        }
    }

    public void fireBeginOperationTransaction(BeginOperationTransactionArgs mainArgs) {
        if (this.plugIns.isEmpty()) {
            return;
        }
        HashSet<DynamicObject> dataEntities = new HashSet<DynamicObject>(Arrays.asList(mainArgs.getDataEntities()));
        HashSet<DynamicObject> removes = new HashSet<DynamicObject>();
        for (IOperationServicePlugIn plugin : this.plugIns) {
            long beginTime = System.currentTimeMillis();
            if (this.isSplitPage() && !plugin.isSupportSplitPageMode() || this.validExtendedDataRows.get(plugin) == null) continue;
            String mothedName = plugin.getClass().getName() + ".beginOperationTransaction()";
            this.getOperateLog().beginMothed(mothedName, null);
            DynamicObject[] beforePlugObjs = this.getRuleDataEntity(plugin, dataEntities, removes);
            BeginOperationTransactionArgs currPlugArgs = new BeginOperationTransactionArgs(mainArgs.getOperationKey(), beforePlugObjs);
            try (EntityTraceSpan span = EntityTracer.create((String)OPBIZ_RULE, (String)(plugin.getClass().getName() + ".beginOperationTransaction"));){
                plugin.beginOperationTransaction(currPlugArgs);
            }
            long costTime = System.currentTimeMillis() - beginTime;
            if (costTime > 10L) {
                this.getOperateLog().endMothed(mothedName, null);
            } else {
                this.getOperateLog().removeMothed(mothedName);
            }
            mainArgs.setCancelFormService(mainArgs.CancelFormService || currPlugArgs.CancelFormService);
            mainArgs.setCancelOperation(mainArgs.cancelOperation || currPlugArgs.cancelOperation);
            if (mainArgs.isCancelFormService() || mainArgs.isCancelOperation()) break;
            HashSet<DynamicObject> afterPlugObjs = new HashSet<DynamicObject>(Arrays.asList(currPlugArgs.getDataEntities()));
            for (DynamicObject obj : beforePlugObjs) {
                if (afterPlugObjs.contains(obj)) continue;
                removes.add(obj);
            }
        }
        if (!removes.isEmpty()) {
            ArrayList<DynamicObject> afterObjs = new ArrayList<DynamicObject>();
            for (DynamicObject obj : mainArgs.getDataEntities()) {
                if (removes.contains(obj)) continue;
                afterObjs.add(obj);
            }
            mainArgs.setDataEntities(afterObjs.toArray(new DynamicObject[afterObjs.size()]));
        }
    }

    public void fireEndOperationTransaction(EndOperationTransactionArgs mainArgs) {
        if (this.plugIns.isEmpty()) {
            return;
        }
        HashSet<DynamicObject> dataEntities = new HashSet<DynamicObject>(Arrays.asList(mainArgs.getDataEntities()));
        HashSet<DynamicObject> removes = new HashSet<DynamicObject>();
        for (IOperationServicePlugIn plugin : this.plugIns) {
            long costTime;
            if (this.isSplitPage() && !plugin.isSupportSplitPageMode()) continue;
            long beginTime = System.currentTimeMillis();
            String mothedName = plugin.getClass().getName() + ".endOperationTransaction()";
            this.getOperateLog().beginMothed(mothedName, null);
            if (this.validExtendedDataRows.get(plugin) != null) {
                DynamicObject[] bills = this.getRuleDataEntity(plugin, dataEntities, removes);
                EndOperationTransactionArgs args = new EndOperationTransactionArgs(mainArgs.getOperationKey(), bills);
                try (EntityTraceSpan span = EntityTracer.create((String)OPBIZ_RULE, (String)(plugin.getClass().getName() + ".endOperationTransaction"));){
                    plugin.endOperationTransaction(args);
                }
            }
            if ((costTime = System.currentTimeMillis() - beginTime) > 10L) {
                this.getOperateLog().endMothed(mothedName, null);
                continue;
            }
            this.getOperateLog().removeMothed(mothedName);
        }
    }

    public void fireRollbackOperation(RollbackOperationArgs mainArgs) {
        if (this.plugIns.isEmpty()) {
            return;
        }
        HashSet<DynamicObject> dataEntities = new HashSet<DynamicObject>(Arrays.asList(mainArgs.dataEntitys));
        HashSet<DynamicObject> removes = new HashSet<DynamicObject>();
        for (IOperationServicePlugIn plugin : this.plugIns) {
            if (this.isSplitPage() && !plugin.isSupportSplitPageMode() || this.validExtendedDataRows.get(plugin) == null) continue;
            DynamicObject[] bills = this.getRuleDataEntity(plugin, dataEntities, removes);
            RollbackOperationArgs args = new RollbackOperationArgs(bills);
            EntityTraceSpan span = EntityTracer.create((String)OPBIZ_RULE, (String)(plugin.getClass().getName() + ".rollbackOperation"));
            Throwable throwable = null;
            try {
                plugin.rollbackOperation(args);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    public void fireAfterExecuteOperationTransaction(AfterOperationArgs mainArgs) {
        if (this.plugIns.isEmpty()) {
            return;
        }
        HashSet<DynamicObject> dataEntities = new HashSet<DynamicObject>(Arrays.asList(mainArgs.getDataEntities()));
        HashSet<DynamicObject> removes = new HashSet<DynamicObject>();
        for (IOperationServicePlugIn plugin : this.plugIns) {
            long costTime;
            if (this.isSplitPage() && !plugin.isSupportSplitPageMode()) continue;
            long beginTime = System.currentTimeMillis();
            String mothedName = plugin.getClass().getName() + ".afterExecuteOperationTransaction()";
            this.getOperateLog().beginMothed(mothedName, null);
            if (this.validExtendedDataRows.get(plugin) != null) {
                DynamicObject[] bills = this.getRuleDataEntity(plugin, dataEntities, removes);
                AfterOperationArgs args = new AfterOperationArgs(mainArgs.getOperationKey(), mainArgs.getSelectedRows());
                args.setDataEntities(bills);
                try (EntityTraceSpan span = EntityTracer.create((String)OPBIZ_RULE, (String)(plugin.getClass().getName() + ".afterExecuteOperationTransaction"));){
                    plugin.afterExecuteOperationTransaction(args);
                }
            }
            if ((costTime = System.currentTimeMillis() - beginTime) > 10L) {
                this.getOperateLog().endMothed(mothedName, null);
                continue;
            }
            this.getOperateLog().removeMothed(mothedName);
        }
    }

    private List<ExtendedDataEntity> filterRuleDataEntity(RowDataModel rowModel, OpBizRule rule, List<ExtendedDataEntity> dataEntities, Set<ExtendedDataEntity> removes) {
        ArrayList<ExtendedDataEntity> currRuleBills = new ArrayList<ExtendedDataEntity>();
        if (StringUtils.isBlank((CharSequence)rule.getPrecondition())) {
            for (ExtendedDataEntity dataEntity : dataEntities) {
                if (removes.contains(dataEntity)) continue;
                currRuleBills.add(dataEntity);
            }
        } else {
            ExpressionParameter calcParameter = new ExpressionParameter(rule.getPrecondition(), rowModel, this.funcLib);
            for (ExtendedDataEntity dataEntity : dataEntities) {
                if (removes.contains(dataEntity)) continue;
                calcParameter.setActiveRow((Object)dataEntity.getDataEntity());
                boolean pass = (Boolean)CalcExprParser.getExpressionValue((ExpressionParameter)calcParameter);
                if (!pass) continue;
                currRuleBills.add(dataEntity);
            }
        }
        return currRuleBills;
    }

    private DynamicObject[] getRuleDataEntity(IOperationServicePlugIn plugin, Set<DynamicObject> dataEntities, Set<DynamicObject> removes) {
        List<ExtendedDataEntity> beforeList = this.validExtendedDataRows.get(plugin);
        ArrayList<DynamicObject> afterList = new ArrayList<DynamicObject>(dataEntities.size());
        HashSet<Integer> dataIndexs = new HashSet<Integer>(dataEntities.size());
        for (ExtendedDataEntity dataEntity : beforeList) {
            DynamicObject root;
            DynamicObject activeRow = dataEntity.getDataEntity();
            if (activeRow.getParent() == null) {
                if (!dataEntities.contains(activeRow) || removes.contains(activeRow)) continue;
                afterList.add(dataEntity.getDataEntity());
                continue;
            }
            if (!dataIndexs.add(dataEntity.getDataEntityIndex()) || !dataEntities.contains(root = this.getRoot(activeRow)) || removes.contains(root)) continue;
            afterList.add(root);
        }
        return afterList.toArray(new DynamicObject[afterList.size()]);
    }

    private DynamicObject getRoot(DynamicObject activeRow) {
        DynamicObject root = activeRow;
        while (root.getParent() instanceof DynamicObject) {
            root = (DynamicObject)root.getParent();
        }
        return root;
    }
}

