/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation;

import java.util.Map;
import kd.bos.context.OperationContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.archive.ArchiveRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.operation.EntityOperateService;
import kd.bos.service.operation.EntityOperateTypes;
import kd.bos.service.operation.OperationService;
import kd.bos.utils.LogPrintUtil;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class OperationServiceImpl
implements OperationService {
    private static final Log log = LogFactory.getLog(OperationServiceImpl.class);
    private static final String SPAN_TYPE_NAME = "opservice";
    private static final String SPAN_TAG_ENTITYNUMBER = "entityNumber";
    private static final String SPAN_TAG_OPKEY = "opKey";
    private static final String SPAN_TAG_IDS = "ids";
    private static final String SPAN_TAG_IDSLEN = "ids.len";
    private static final String SPAN_TAG_OPTION = "option";
    private static final String SPAN_TAG_RESULT = "result";

    public String invokeOperation(String operationKey, String entityNumber, Object[] ids, OperateOption option) {
        OperationResult operationResult = this.localInvokeOperation(operationKey, entityNumber, ids, option);
        return this.serializeOperationResult(operationResult);
    }

    public String invokeOperation(String operationKey, DynamicObject[] dataEntities, OperateOption option) {
        OperationResult operationResult = this.localInvokeOperation(operationKey, dataEntities, option);
        return this.serializeOperationResult(operationResult);
    }

    public OperationResult localInvokeOperation(String operationKey, String entityNumber, Object[] ids, OperateOption option) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"OperationService.invokeOperation", (EntityTraceHint)EntityTraceHint.getHintLinkAPM());){
            OperationResult operationResult;
            block32: {
                OperateOption operateOption = option;
                if (operateOption == null) {
                    operateOption = OperateOption.create();
                }
                if (span.isRealtime()) {
                    span.addTag(SPAN_TAG_ENTITYNUMBER, entityNumber);
                    span.addTag(SPAN_TAG_OPKEY, operationKey);
                    span.addLocaleTag(SPAN_TAG_IDSLEN, (Object)ids.length);
                    span.addLocaleTag(SPAN_TAG_IDS, (Object)ids);
                    span.addLocaleTag(SPAN_TAG_OPTION, (Object)operateOption);
                }
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                EntityOperateService operate = this.initializeOperate(operationKey, mainEntityType, null, operateOption);
                operationResult = new OperationResult();
                this.setOperationContext(mainEntityType.getAppId(), mainEntityType.getName(), operationKey);
                try {
                    if (operateOption.containsVariable("routeKey")) {
                        try (ArchiveRoute mr = ArchiveRoute.mapRoute((String)operateOption.getVariableValue("routeKey", ""), (String)operateOption.getVariableValue("ArchiveKey", ""));){
                            operationResult = operate.excute(ids);
                            break block32;
                        }
                    }
                    operationResult = operate.excute(ids);
                }
                catch (KDBizException e) {
                    span.addTag("errorMessage", e.getMessage());
                    if (StringUtils.equalsIgnoreCase((CharSequence)operateOption.getVariableValue("WF", ""), (CharSequence)"TRUE")) {
                        throw e;
                    }
                    operationResult.setSuccess(false);
                    operationResult.setMessage(e.getMessage());
                }
                catch (Exception e) {
                    LogPrintUtil.printExceptionMessage((Exception)e, (String)e.getMessage());
                    span.addTag(SPAN_TAG_ENTITYNUMBER, entityNumber);
                    span.addTag(SPAN_TAG_OPKEY, operationKey);
                    span.addLocaleTag(SPAN_TAG_IDSLEN, (Object)ids.length);
                    span.addLocaleTag(SPAN_TAG_IDS, (Object)ids);
                    span.addLocaleTag(SPAN_TAG_OPTION, (Object)operateOption);
                    span.error((Throwable)e);
                    throw new KDException((Throwable)e, BosErrorCode.operationFailed, new Object[]{e.getMessage()});
                }
            }
            if (span.isRealtime()) {
                span.addLocaleTag(SPAN_TAG_RESULT, (Object)operationResult);
            }
            OperationResult operationResult2 = operationResult;
            return operationResult2;
        }
    }

    public OperationResult localInvokeOperation(String operationKey, DynamicObject[] dataEntities, OperateOption option) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"OperationService.invokeOperation", (EntityTraceHint)EntityTraceHint.getHintLinkAPM());){
            OperateOption operateOption = option;
            if (option == null) {
                operateOption = OperateOption.create();
            }
            OperationResult operationResult = new OperationResult();
            if (dataEntities.length == 0) {
                operationResult.setSuccess(true);
            } else {
                MainEntityType mainEntityType = (MainEntityType)dataEntities[0].getDataEntityType();
                if (span.isRealtime()) {
                    span.addTag(SPAN_TAG_ENTITYNUMBER, mainEntityType.getName());
                    span.addTag(SPAN_TAG_OPKEY, operationKey);
                    span.addLocaleTag("dataEntities", (Object)dataEntities);
                    span.addLocaleTag(SPAN_TAG_OPTION, (Object)operateOption);
                }
                EntityOperateService operate = this.initializeOperate(operationKey, mainEntityType, dataEntities, operateOption);
                this.setOperationContext(mainEntityType.getAppId(), mainEntityType.getName(), operationKey);
                try {
                    operationResult = operate.excute(dataEntities);
                }
                catch (KDBizException e) {
                    log.warn((Throwable)e);
                    if (StringUtils.equalsIgnoreCase((CharSequence)operateOption.getVariableValue("WF", ""), (CharSequence)"TRUE")) {
                        throw e;
                    }
                    operationResult.setSuccess(false);
                    operationResult.setMessage(e.getMessage());
                }
                catch (Exception e) {
                    LogPrintUtil.printExceptionMessage((Exception)e, (String)e.getMessage());
                    span.addTag(SPAN_TAG_ENTITYNUMBER, mainEntityType.getName());
                    span.addTag(SPAN_TAG_OPKEY, operationKey);
                    span.addLocaleTag("dataEntities", (Object)dataEntities);
                    span.addLocaleTag(SPAN_TAG_OPTION, (Object)operateOption);
                    span.addLocaleTag("billType", (Object)dataEntities[0].getDataEntityType());
                    span.error((Throwable)e);
                    throw new KDException((Throwable)e, BosErrorCode.operationFailed, new Object[]{e.getMessage()});
                }
            }
            if (span.isRealtime()) {
                span.addLocaleTag(SPAN_TAG_RESULT, (Object)operationResult);
            }
            OperationResult operationResult2 = operationResult;
            return operationResult2;
        }
    }

    private String serializeOperationResult(OperationResult operationResult) {
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(true);
        String serialResult = DataEntitySerializer.serializerToString((Object)operationResult, (DataEntitySerializerOption)option);
        return serialResult;
    }

    private EntityOperateService initializeOperate(String operationKey, MainEntityType mainEntityType, DynamicObject[] dataEntities, OperateOption option) {
        EntityOperateService operate = this.createOperation(operationKey, mainEntityType.getName());
        operate.setOption(option != null ? option : OperateOption.create());
        operate.initialize(mainEntityType, operationKey, dataEntities);
        return operate;
    }

    private EntityOperateService createOperation(String operationKey, String entityNumber) {
        Map op;
        try {
            op = EntityMetadataCache.getDataEntityOperate((String)entityNumber, (String)operationKey);
        }
        catch (RuntimeException e) {
            throw new KDBizException(e.getMessage());
        }
        String type = (String)op.get("type");
        EntityOperateService entityOperateService = (EntityOperateService)EntityOperateTypes.createEntityOperate(type);
        return entityOperateService;
    }

    private void setOperationContext(String appId, String formId, String opKey) {
        OperationContext oc = OperationContext.get();
        if (oc == null) {
            oc = new OperationContext();
        } else if (StringUtils.equals((CharSequence)"bos", (CharSequence)oc.getAppId()) || StringUtils.equals((CharSequence)"mq", (CharSequence)oc.getAppId())) {
            oc = new OperationContext();
        } else {
            return;
        }
        oc.setAppId(appId);
        oc.setFormId(formId);
        oc.setOpMethod(opKey);
        OperationContext.set((OperationContext)oc);
    }
}

