/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation.validate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.formula.CalcExprParser;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.formula.VarValueParser;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.entity.function.ExprFuncCreator;
import kd.bos.entity.function.FunctionManage;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.FieldPos;
import kd.bos.entity.validate.ValidPromtType;
import kd.bos.entity.validate.ValidateExpressionContext;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.BinaryExpr;
import kd.bos.formula.excel.ExecuteContext;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.FormulaException;
import kd.bos.formula.excel.MapExecuteContext;
import kd.bos.formula.excel.Operator;
import kd.bos.formula.excel.UDFunction;
import kd.bos.formula.excel.VerifyVisitor;
import kd.bos.formula.excel.Visitor;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.operation.validate.FieldChecker;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ConditionValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(ConditionValidator.class);
    private static final String KEY_EXPRESS = "express";
    private LocaleString desc;
    private String express;
    private BOSExpression expr;
    private LocaleString message;
    private boolean exeById = false;

    public void setEntityKey(String entityKey) {
        this.entityKey = entityKey;
    }

    public String getEntityKey() {
        return this.entityKey;
    }

    public Set<String> preparePropertys() {
        Set set = super.preparePropertys();
        this.exeById = true;
        this.desc = LocaleString.fromMap((Map)((Map)this.getValidationValueByKey("description")));
        this.express = (String)this.getValidationValueByKey(KEY_EXPRESS);
        this.expr = new BOSExpression(this.express);
        if (this.expr.isError()) {
            throw new KDBizException(this.buildSyntaxErrMessage(this.expr.getErrMessage()));
        }
        set.addAll(this.expr.getVars());
        return set;
    }

    public void initializeConfiguration() {
        EntityType entityType;
        super.initializeConfiguration();
        this.desc = LocaleString.fromMap((Map)((Map)this.getValidationValueByKey("description")));
        Object msg = this.getValidationValueByKey("message");
        if (msg != null) {
            this.message = LocaleString.fromMap((Map)((Map)msg));
        }
        if (this.message == null || StringUtils.isBlank((CharSequence)this.message.toString())) {
            this.message = new LocaleString(String.format(ResManager.loadKDString((String)"%s\u5931\u8d25\u3002", (String)"ConditionValidator_0", (String)"bos-mservice-operation", (Object[])new Object[0]), this.desc.toString()));
        }
        if (this.expr == null) {
            this.express = (String)this.getValidationValueByKey(KEY_EXPRESS);
            this.expr = new BOSExpression(this.express);
            if (this.expr.isError()) {
                throw new KDBizException(this.buildSyntaxErrMessage(this.expr.getErrMessage()));
            }
        }
        if (this.expr.getExpr() == null) {
            return;
        }
        FieldChecker fieldChecker = new FieldChecker(this.getValidateContext().getSubEntityType());
        fieldChecker.check((Collection)this.expr.getVars());
        if (fieldChecker.isNotExistsFields()) {
            throw new KDBizException(this.buildSyntaxErrMessage(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5%s\u4e0d\u5b58\u5728", (String)"ConditionValidator_1", (String)"bos-mservice-operation", (Object[])new Object[0]), StringUtils.join((Object[])fieldChecker.getNotExistsFields().toArray(), (String)","))));
        }
        if (fieldChecker.isOverEntry()) {
            throw new KDBizException(this.buildSyntaxErrMessage(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u4e0d\u5141\u8bb8\u6765\u81ea\u4e8e\u591a\u4e2a\u5355\u636e\u4f53(%s)", (String)"ConditionValidator_2", (String)"bos-mservice-operation", (Object[])new Object[0]), fieldChecker.getOverEntryNames("+"))));
        }
        String entityKey = (String)this.getValidationValueByKey("entitykey");
        this.entityKey = StringUtils.isBlank((CharSequence)entityKey) ? fieldChecker.getEntityKey() : (StringUtils.equals((CharSequence)"billhead", (CharSequence)entityKey) || StringUtils.equals((CharSequence)entityKey, (CharSequence)this.getValidateContext().getSubEntityType().getName()) ? this.getValidateContext().getSubEntityType().getName() : ((entityType = (EntityType)this.getValidateContext().getSubEntityType().getAllEntities().get(entityKey)) != null && (fieldChecker.getEntrys().contains(entityType) || fieldChecker.getSubEntrys().contains(entityType)) ? entityKey : fieldChecker.getEntityKey()));
    }

    public void validate() {
        EntityType entityType;
        if (this.dataEntities == null || this.dataEntities.length == 0 || StringUtils.isBlank((CharSequence)this.express)) {
            return;
        }
        EntityType mainType = entityType = (EntityType)this.dataEntities[0].getDataEntity().getDataEntityType();
        while (mainType.getParent() != null) {
            mainType = (EntityType)mainType.getParent();
        }
        RowDataModel rowModel = new RowDataModel(entityType.getName(), (MainEntityType)mainType);
        ValidateExpressionContext expContext = new ValidateExpressionContext(rowModel, this.getValidateContext());
        boolean abnormalPos = Boolean.parseBoolean(this.getOption().getVariableValue("bos_fromFormViewOp", "false"));
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Object exprValue;
            expContext.getRowDataModel().setRowContext((Object)dataEntity.getDataEntity(), dataEntity.getRowIndex());
            try {
                exprValue = CalcExprParser.getExpressionValue((BOSExpression)this.expr, (ExpressionContext)expContext, (FunctionManage)this.getValidateContext().getFuncLib());
            }
            catch (FormulaException exp) {
                log.error((Throwable)exp);
                StringBuilder builder = new StringBuilder();
                builder.append(String.format(ResManager.loadKDString((String)"\u5408\u6cd5\u6027\u6821\u9a8c\u5668\u6267\u884c\u5f02\u5e38\uff1a%1$s\uff08%2$s\uff09", (String)"ConditionValidator_6", (String)"bos-mservice-operation", (Object[])new Object[0]), exp.getMessage(), this.express));
                throw new KDBizException(builder.toString());
            }
            if (exprValue == null) continue;
            boolean exprResult = (Boolean)exprValue;
            if ((!this.getErrorWhenExpressIsTrue() || !exprResult) && (this.getErrorWhenExpressIsTrue() || exprResult)) continue;
            ArrayList<String> errVars = new ArrayList<String>(10);
            if (abnormalPos) {
                errVars.addAll(this.parserRuntimeErrVars(expContext));
            }
            if (errVars.isEmpty() && this.expr != null) {
                errVars.addAll(this.expr.getVars());
            }
            String errMsg = this.buildMessage(dataEntity, entityType, errVars);
            this.addMessage(dataEntity, errMsg, this.getErrorLevl());
        }
    }

    private List<String> parserRuntimeErrVars(ValidateExpressionContext expContext) {
        try {
            Map ctx = VarValueParser.getVarValues((BOSExpression)this.expr, (ExpressionContext)expContext);
            BOSUDFunction[] functions = ExprFuncCreator.createUDFunctions((Set)this.expr.getFuncs(), (FunctionManage)this.getValidateContext().getFuncLib(), (ExpressionContext)expContext);
            ExprTreeBuilder builder = new ExprTreeBuilder(FormulaEngine.parseFormula((String)this.express));
            builder.build();
            ArrayList<Expr> errNodes = new ArrayList<Expr>(10);
            if (!builder.parserSuccess) {
                return new ArrayList<String>(3);
            }
            ExprTreeWapper root = builder.getRootTree();
            root.run(ctx, functions);
            this.collectErrNode(root, this.getErrorWhenExpressIsTrue(), errNodes);
            List<String> errVars = this.getErrVars(errNodes);
            return errVars;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return new ArrayList<String>(3);
        }
    }

    private String buildMessage(ExtendedDataEntity dataEntity, EntityType entityType, List<String> errVars) {
        String errorMsg;
        ArrayList<String> tipsVars = new ArrayList<String>(3);
        if (errVars != null) {
            tipsVars.addAll(errVars);
        }
        if (entityType instanceof SubEntryType) {
            EntityType parentType = (EntityType)entityType.getParent();
            errorMsg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7b2c\u201c%2$s\u201d\u884c, \u201c%3$s\u201d\u7b2c\u201c%4$s\u201d\u884c, %5$s", (String)"ConditionValidator_4", (String)"bos-mservice-operation", (Object[])new Object[0]), parentType.getDisplayName().toString(), dataEntity.getRowIndex() + 1, entityType.getDisplayName().toString(), dataEntity.getSubRowIndex() + 1, this.message.toString());
            if (tipsVars.size() == 1) {
                String var = (String)tipsVars.get(0);
                String entryKey = this.getEntryKeyByFieldKey(entityType, var);
                if (StringUtils.isBlank((CharSequence)entryKey)) {
                    this.addPromptInfo(new FieldPos(var, this.message.toString(), ValidPromtType.CONDITION.getType(), this.getValidatorId()));
                } else if (entityType.getName().equalsIgnoreCase(entryKey)) {
                    FieldPos fieldPos = new FieldPos(entryKey, dataEntity.getSubRowIndex(), var, this.message.toString(), ValidPromtType.CONDITION.getType(), this.getValidatorId());
                    fieldPos.setFullMsg(errorMsg);
                    this.addPromptInfo(fieldPos);
                } else {
                    FieldPos fieldPos = new FieldPos(entryKey, dataEntity.getRowIndex(), var, this.message.toString(), ValidPromtType.CONDITION.getType(), this.getValidatorId());
                    fieldPos.setFullMsg(errorMsg);
                    this.addPromptInfo(fieldPos);
                }
            }
        } else if (entityType instanceof EntryType) {
            errorMsg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7b2c\u201c%2$s\u201d\u884c\uff0c%3$s", (String)"ConditionValidator_5", (String)"bos-mservice-operation", (Object[])new Object[0]), entityType.getDisplayName(), dataEntity.getRowIndex() + 1, this.message.toString());
            if (tipsVars.size() == 1) {
                String var = (String)tipsVars.get(0);
                String[] path = this.getFieldPath(entityType, var);
                if (StringUtils.isBlank((CharSequence)path[0])) {
                    this.addPromptInfo(new FieldPos(path[1], this.message.toString(), ValidPromtType.CONDITION.getType(), this.getValidatorId()));
                } else {
                    FieldPos fieldPos = new FieldPos(path[0], dataEntity.getRowIndex(), path[1], this.message.toString(), ValidPromtType.CONDITION.getType(), this.getValidatorId());
                    fieldPos.setFullMsg(errorMsg);
                    this.addPromptInfo(fieldPos);
                }
            }
        } else {
            errorMsg = String.format("%s", this.message.toString());
            if (tipsVars.size() == 1) {
                this.addPromptInfo(new FieldPos((String)tipsVars.get(0), errorMsg, ValidPromtType.CONDITION.getType(), this.getValidatorId()));
            }
        }
        return errorMsg;
    }

    private String[] getFieldPath(EntityType entityType, String var) {
        String[] result = new String[]{null, var};
        if (StringUtils.isBlank((CharSequence)var)) {
            return result;
        }
        String[] path = var.split("\\.");
        EntityType mainType = entityType;
        while (mainType.getParent() != null) {
            mainType = (EntityType)mainType.getParent();
        }
        IDataEntityProperty property = null;
        for (int i = 0; i < path.length && property == null; ++i) {
            IDataEntityProperty entityItem = mainType.findProperty(path[i]);
            if (!(entityItem instanceof IFieldHandle)) continue;
            property = entityItem;
        }
        if (property == null) {
            return result;
        }
        result[1] = property.getName();
        if (property.getParent() instanceof MainEntityType) {
            return result;
        }
        result[0] = property.getParent().getName();
        return result;
    }

    private String buildSyntaxErrMessage(String errContext) {
        return String.format(ResManager.loadKDString((String)"%1$s-%2$s\uff0c%3$s\u7684\u8868\u8fbe\u5f0f(%4$s)\uff1a%5$s", (String)"ConditionValidator_3", (String)"bos-mservice-operation", (Object[])new Object[0]), this.getValidateContext().getBillEntityType().getDisplayName().toString(), this.getOperationName(), this.desc.toString(), this.express, errContext);
    }

    private void collectErrNode(ExprTreeWapper cur, boolean matchValue, List<Expr> errNodes) {
        if (!cur.isBooleanNode || cur.getResult() != matchValue) {
            return;
        }
        if (!(cur.getExpr() instanceof BinaryExpr)) {
            if (cur.getResult() == matchValue) {
                errNodes.add(cur.getExpr());
            }
            return;
        }
        BinaryExpr binaryExpr = (BinaryExpr)cur.getExpr();
        boolean isLeaf = cur.getChilds().isEmpty();
        for (ExprTreeWapper it : cur.getChilds()) {
            if (it.isBooleanNode) continue;
            isLeaf = true;
            break;
        }
        if (isLeaf) {
            if (cur.getResult() == matchValue) {
                errNodes.add(cur.getExpr());
            }
            return;
        }
        Operator operator = binaryExpr.getOperator();
        if (operator == Operator.AND || operator == Operator.OR) {
            for (ExprTreeWapper it : cur.getChilds()) {
                this.collectErrNode(it, matchValue, errNodes);
            }
        } else if (cur.getResult() == matchValue) {
            errNodes.add(cur.getExpr());
        }
    }

    private List<String> getErrVars(List<Expr> errNodes) {
        ArrayList<String> vars = new ArrayList<String>(10);
        if (errNodes.isEmpty()) {
            return vars;
        }
        for (Expr it : errNodes) {
            VerifyVisitor varVisitor = new VerifyVisitor((ExecuteContext)new MapExecuteContext());
            it.accept((Visitor)varVisitor);
            vars.addAll(varVisitor.getInvalidSymboList());
        }
        return vars;
    }

    static class ExprTreeWapper {
        private Expr expr;
        private Object v;
        private ExprTreeWapper parent;
        private boolean isBooleanNode = false;
        private List<ExprTreeWapper> childs = new ArrayList<ExprTreeWapper>(10);

        public ExprTreeWapper(Expr expr) {
            this.expr = expr;
        }

        public void addChild(ExprTreeWapper expr) {
            this.childs.add(expr);
            expr.parent = this;
        }

        public ExprTreeWapper getParent() {
            return this.parent;
        }

        public List<ExprTreeWapper> getChilds() {
            return this.childs;
        }

        public Expr getExpr() {
            return this.expr;
        }

        public void setResult(Object v) {
            this.v = v;
            this.isBooleanNode = v instanceof Boolean;
        }

        public Boolean getResult() {
            return (Boolean)this.v;
        }

        public void run(Map<String, Object> varCtx, BOSUDFunction[] functions) {
            Object result = FormulaEngine.execExcelFormula((Expr)this.expr, varCtx, (UDFunction[])functions);
            this.setResult(result);
            if (this.isBooleanNode) {
                for (ExprTreeWapper child : this.childs) {
                    child.run(varCtx, functions);
                }
            }
        }
    }

    static class ExprTreeBuilder {
        private List<Expr> gSequence = new ArrayList<Expr>(10);
        private Map<Expr, Integer> gLevel = new HashMap<Expr, Integer>(10);
        private Map<Expr, ExprTreeWapper> flatWapper = new HashMap<Expr, ExprTreeWapper>(10);
        private Expr rootExpr;
        ExprTreeWapper rootTree;
        boolean parserSuccess = true;

        public ExprTreeBuilder(Expr expr) {
            this.rootExpr = expr;
            this.rootTree = new ExprTreeWapper(this.rootExpr);
            this.flatWapper.putIfAbsent(expr, this.rootTree);
        }

        public void build() {
            ExprVisitor visitor = new ExprVisitor();
            this.rootExpr.accept((Visitor)visitor);
            for (Expr it : visitor.sequence) {
                this.gSequence.add(it);
                this.gLevel.put(it, 1);
                this.flatWapper.putIfAbsent(it, new ExprTreeWapper(it));
            }
            if (this.gSequence.size() <= 1) {
                return;
            }
            for (int i = 1; i < this.gSequence.size(); ++i) {
                int lIndex;
                Expr next = this.gSequence.get(i);
                ExprTreeWapper nextWarpper = this.flatWapper.get(next);
                int lastLevel = this.gLevel.get(next);
                ExprVisitor subVisitor = new ExprVisitor();
                next.accept((Visitor)subVisitor);
                List subSequence = subVisitor.sequence;
                for (lIndex = i - 1; lIndex >= 0; --lIndex) {
                    if (lastLevel == this.gLevel.get(this.gSequence.get(lIndex))) {
                        this.parserSuccess = true;
                        break;
                    }
                    this.parserSuccess = false;
                }
                if (!this.parserSuccess) {
                    return;
                }
                this.flatWapper.get(this.gSequence.get(lIndex)).addChild(nextWarpper);
                for (Expr sub : subSequence) {
                    this.gLevel.put(sub, this.gLevel.get(sub) + 1);
                }
            }
        }

        public ExprTreeWapper getRootTree() {
            if (this.parserSuccess) {
                return this.rootTree;
            }
            return null;
        }
    }

    static class ExprVisitor
    implements Visitor {
        private List<Expr> sequence = new ArrayList<Expr>(10);
        private Expr start;

        ExprVisitor() {
        }

        public void visit(Expr expr) {
            if (this.start == null) {
                this.start = expr;
            }
            if (!this.sequence.contains(expr)) {
                this.sequence.add(expr);
            }
        }
    }
}

