/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation.validate;

import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.IValueComparator;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;

public class DeleteEmptyIdValidator
extends AbstractValidator {
    private int idCount = 0;

    public int getIdCount() {
        return this.idCount;
    }

    public void setIdCount(int idCount) {
        this.idCount = idCount;
    }

    public void validate() {
        if (this.getIdCount() <= 0) {
            return;
        }
        if (this.getIdCount() >= this.dataEntities.length) {
            return;
        }
        int emptyPKCount = 0;
        ISimpleProperty prop = this.validateContext.getBillEntityType().getPrimaryKey();
        if (prop instanceof PKFieldProp) {
            PKFieldProp pkFieldProp = (PKFieldProp)prop;
            IValueComparator valueComparator = pkFieldProp.getValueComparator();
            for (ExtendedDataEntity dataObj : this.dataEntities) {
                if (!valueComparator.compareValue(dataObj.getDataEntity().getPkValue())) continue;
                ++emptyPKCount;
            }
        }
        if (emptyPKCount > 0) {
            String errMsg = ResManager.loadKDString((String)"\u5355\u636e\u7684\u4e3b\u952e\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u6267\u884c\u5220\u9664\u64cd\u4f5c\uff0c\u9700\u8054\u7cfb\u7ba1\u7406\u5458\u4fee\u590d\u4e3b\u952e\u503c\u4e4b\u540e\u518d\u5220\u9664\u3002", (String)"DeleteEmptyIdValidator_0", (String)"bos-mservice-operation", (Object[])new Object[0]);
            throw new KDBizException(BosErrorCode.operationFailed, new Object[]{errMsg});
        }
    }
}

