/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation.validate;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.exception.ORMDesignException;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.FieldPos;
import kd.bos.entity.validate.GroupFieldsUniqueValidateResult;
import kd.bos.entity.validate.ValidPromtType;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.inte.api.EnabledLang;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.operation.validate.GroupKey;
import kd.bos.service.operation.validate.GroupKeyBuilder;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;

public class GrpFieldsUniqueValidator
extends AbstractValidator {
    private static final Log LOG = LogFactory.getLog(GrpFieldsUniqueValidator.class);
    private static final String BOS_MSERVICE_OPERATION = "bos-mservice-operation";
    private List<String> ENABLE_LANG_NUMBER = new ArrayList<String>(5);
    private Map<String, String> ENABLE_LANG_NUMBE2_NAME = new HashMap<String, String>(5);
    private List<String> fieldKeys = null;
    private GroupKeyBuilder groupKeyBuilder = null;
    private Set<GroupKey> tempGroupKeys = null;
    private Set<Object> pkIdsInMemory = null;
    private final Set<Object> pkIdsGrpValidError = new HashSet<Object>(10);
    private final Set<String> multilangFieldSet = new HashSet<String>();
    private Map<Object, DynamicObject> multilangDynamicObjectMap = new HashMap<Object, DynamicObject>();

    protected void initValidateResult() {
        this.validateResult = new GroupFieldsUniqueValidateResult();
    }

    protected List<String> getFields() {
        if (this.fieldKeys == null) {
            this.fieldKeys = new ArrayList<String>();
            List fieldsMap = (List)this.getValidation().get("fields");
            if (fieldsMap != null && !fieldsMap.isEmpty()) {
                for (Map fMap : fieldsMap) {
                    this.fieldKeys.add((String)fMap.get("id"));
                }
            }
        }
        return this.fieldKeys;
    }

    protected boolean isIgnoreDB() {
        return (Boolean)this.getValidation().get("isCheckAllEntity");
    }

    protected String getCustomProp() {
        if (this.getValidation() != null) {
            Object customProp = this.getValidation().get("customPromp");
            if (ObjectUtils.isEmpty(customProp)) {
                return "";
            }
            String customPropStr = "{}";
            if (customProp instanceof Map) {
                customPropStr = (String)((Map)customProp).get(Lang.get().name());
            } else if (customProp instanceof String) {
                customPropStr = (String)customProp;
            }
            if ("{}".equals(customPropStr)) {
                return "";
            }
            return customPropStr;
        }
        return "";
    }

    protected boolean isCheckMultilang() {
        if (this.getValidation() != null) {
            Object isCheckMultilang = this.getValidation().get("isCheckMultilang");
            if (ObjectUtils.isEmpty(isCheckMultilang)) {
                return false;
            }
            return (Boolean)isCheckMultilang;
        }
        return false;
    }

    protected boolean isIgnoreBlank() {
        ICodeRuleService codeRuleService;
        List rules;
        String billNo;
        if (this.getValidateContext() != null && this.getValidateContext().getBillEntityType() instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)(billNo = ((BillEntityType)this.getValidateContext().getBillEntityType()).getBillNo())) && this.getFields().contains(billNo) && this.isSkipBillNoValidator() && !(rules = (codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class)).getAllCodeRuleByEntity(this.getValidateContext().getBillEntityType().getName())).isEmpty()) {
            return true;
        }
        return (Boolean)this.getValidation().get("isCheckEmptyValue");
    }

    private boolean isSkipBillNoValidator() {
        return this.getOption() != null && Boolean.parseBoolean(this.getOption().getVariableValue("skipbillnovalidator", String.valueOf(false)));
    }

    protected boolean checkAData() {
        if (this.getValidation() != null) {
            Object checkAData = this.getValidation().get("checkadata");
            if (ObjectUtils.isEmpty(checkAData)) {
                return false;
            }
            return (Boolean)checkAData;
        }
        return false;
    }

    protected LocaleString getValidateDesc() {
        return LocaleString.fromMap((Map)((Map)this.getValidationValueByKey("description")));
    }

    public Set<String> preparePropertys() {
        Set set = super.preparePropertys();
        List<String> fields = this.getFields();
        set.addAll(fields);
        return set;
    }

    public void initializeConfiguration() {
        super.initializeConfiguration();
        this.getEnableLangs();
        List<String> fields = this.getFields();
        boolean ignoreDB = this.isIgnoreDB();
        boolean ignoreBlank = this.isIgnoreBlank();
        boolean checkMultilang = this.isCheckMultilang();
        LocaleString validateDesc = this.getValidateDesc();
        this.groupKeyBuilder = new GroupKeyBuilder(this.getValidateContext().getSubEntityType(), this.getValidateContext().getOperateMetaMap(), fields, ignoreDB, ignoreBlank, checkMultilang);
        if (this.groupKeyBuilder.error) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s-%2$s\uff0c%3$s\uff1a\u914d\u7f6e\u9519\u8bef\uff0c%4$s", (String)"GrpFieldsUniqueValidator_0", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), this.getValidateContext().getBillEntityType().getDisplayName().toString(), this.getOperationName(), validateDesc.toString(), this.groupKeyBuilder.errMsg));
        }
        this.setEntityKey(this.groupKeyBuilder.entityKey);
        ((GroupFieldsUniqueValidateResult)this.getValidateResult()).setFieldKeys(this.groupKeyBuilder.propNames);
        ((GroupFieldsUniqueValidateResult)this.getValidateResult()).setFieldCaptions(this.groupKeyBuilder.fldCaptions);
        for (String prop : this.groupKeyBuilder.propNames) {
            DynamicProperty property = this.validateContext.getBillEntityType().getProperty(prop);
            if (!(property instanceof MuliLangTextProp)) continue;
            this.multilangFieldSet.add(prop);
        }
    }

    public void validate() {
        this.pkIdsInMemory = new HashSet<Object>(this.dataEntities.length);
        Map<GroupKey, List<ExtendedDataEntity>> noRepeatedGroups = this.checkRepeatedInMemory();
        if (!this.groupKeyBuilder.ignoreDB) {
            this.checkRepeatedInDb(noRepeatedGroups);
        }
    }

    private Map<GroupKey, List<ExtendedDataEntity>> checkRepeatedInMemory() {
        GroupKey groupKey;
        HashMap<GroupKey, ArrayList<ExtendedDataEntity>> groups = new HashMap<GroupKey, ArrayList<ExtendedDataEntity>>();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            groupKey = this.groupKeyBuilder.build(dataEntity);
            if (groupKey == null) continue;
            this.pkIdsInMemory.add(groupKey.getPkValue());
            ArrayList<ExtendedDataEntity> list = (ArrayList<ExtendedDataEntity>)groups.get(groupKey);
            if (list == null) {
                list = new ArrayList<ExtendedDataEntity>();
                groups.put(groupKey, list);
            }
            list.add(dataEntity);
        }
        HashMap<GroupKey, List<ExtendedDataEntity>> noRepeatedGroups = new HashMap<GroupKey, List<ExtendedDataEntity>>(groups.size());
        for (Map.Entry group : groups.entrySet()) {
            noRepeatedGroups.put((GroupKey)group.getKey(), (List<ExtendedDataEntity>)group.getValue());
            int repeatedRowCount = ((List)group.getValue()).size();
            if (repeatedRowCount <= 1) continue;
            groupKey = (GroupKey)group.getKey();
            List extendedDataEntities = (List)group.getValue();
            groupKey.addRepeatedRowIndex(extendedDataEntities.stream().map(obj -> obj.getRowIndex() + 1).collect(Collectors.toList()));
            boolean hasAdd = false;
            for (int i = 0; i < repeatedRowCount; ++i) {
                ExtendedDataEntity repeatedDataEntity = (ExtendedDataEntity)((List)group.getValue()).get(i);
                groupKey.setRowIndex(repeatedDataEntity.getRowIndex());
                String errMsg = this.buildErrMsg(groupKey, repeatedDataEntity);
                Object status = null;
                try {
                    this.groupKeyBuilder.rowModel.setRowContext(repeatedDataEntity.getDataEntity());
                    status = this.groupKeyBuilder.rowModel.getValue(this.groupKeyBuilder.statusProp.getName());
                }
                catch (Exception e) {
                    status = null;
                }
                if (!ObjectUtils.isEmpty(status) && status instanceof String) {
                    String statusStr = (String)status;
                    if (!hasAdd && StringUtils.equalsIgnoreCase((CharSequence)statusStr, (CharSequence)"A")) {
                        hasAdd = true;
                        continue;
                    }
                } else if (!hasAdd) {
                    hasAdd = true;
                    continue;
                }
                this.addErrorMsg(errMsg, repeatedDataEntity);
                this.pkIdsGrpValidError.add(repeatedDataEntity.getDataEntity().getPkValue());
            }
        }
        return noRepeatedGroups;
    }

    private void addErrorMsg(String errMsg, ExtendedDataEntity repeatedDataEntity) {
        if (errMsg.contains("@@")) {
            String[] split = errMsg.split("@@");
            errMsg = split[0];
            String pattern = split[1];
            this.addMessage(repeatedDataEntity, errMsg, this.getErrorLevl(), pattern);
        } else {
            this.addMessage(repeatedDataEntity, errMsg, this.getErrorLevl());
        }
    }

    private void checkRepeatedInDb(Map<GroupKey, List<ExtendedDataEntity>> groups) {
        if (groups.isEmpty()) {
            return;
        }
        if (this.groupKeyBuilder.fullPropNames.size() == 1) {
            this.checkRepeatedInDB1(groups);
        } else {
            this.checkRepeatedInDbMore(groups);
        }
    }

    private void checkRepeatedInDB1(Map<GroupKey, List<ExtendedDataEntity>> groups) {
        DynamicObjectCollection repObjs;
        HashMap<GroupKey, GroupKey> groupKeys = new HashMap<GroupKey, GroupKey>(groups.size());
        for (Map.Entry<GroupKey, List<ExtendedDataEntity>> group : groups.entrySet()) {
            GroupKey groupKey = group.getKey();
            Object fldValue = groupKey.getFldValues()[0];
            if (StringUtils.isBlank((Object)fldValue)) {
                fldValue = null;
            }
            GroupKey key = new GroupKey(0, null, new Object[]{fldValue}, new Object[]{fldValue});
            key.setCheckMultilang(this.isCheckMultilang());
            groupKeys.put(key, groupKey);
        }
        QFilter[] fs = this.buildFilters(groups);
        String selectFields = this.buildSelectFields();
        try {
            repObjs = QueryServiceHelper.query((String)this.validateContext.getEntityNumber(), (String)selectFields, (QFilter[])fs);
        }
        catch (KDException e) {
            if (e.getErrorCode() == BosErrorCode.tableNotDefined) {
                Object description = this.getValidation().get("description");
                String validatorName = description instanceof Map ? LocaleString.fromMap((Map)((Map)description)).toString() : ResManager.loadKDString((String)"\u7ec4\u5408\u5b57\u6bb5\u552f\u4e00\u6027\u6821\u9a8c\u5668", (String)"GrpFieldsUniqueValidator_21", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]);
                throw new KDBizException(ResManager.loadKDString((String)"\"%s\" \u6821\u9a8c\u5668\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u7ef4\u62a4\u5b57\u6bb5\u6240\u5c5e\u5b9e\u4f53\u7684\u8868\u540d\u4fe1\u606f\u3002", (String)"GrpFieldsUniqueValidator_20", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[]{validatorName}));
            }
            throw e;
        }
        if (this.isCheckMultilang() && this.checkHasMultilang()) {
            ArrayList<Object> pkList = new ArrayList<Object>();
            for (DynamicObject dynamicObject : repObjs) {
                pkList.add(dynamicObject.get("id"));
            }
            this.multilangDynamicObjectMap = this.loadMultilangField(this.validateContext.getEntityNumber(), pkList);
        }
        if (repObjs != null && !repObjs.isEmpty()) {
            for (DynamicObject repObj : repObjs) {
                DynamicObject dynamicObject;
                Object pkId = repObj.get("id");
                String propFieldName = this.groupKeyBuilder.propNames.get(0);
                Object fldValue = repObj.get(propFieldName);
                if (StringUtils.isBlank((Object)fldValue)) {
                    fldValue = null;
                }
                if (fldValue instanceof Timestamp) {
                    fldValue = new Date(((Timestamp)fldValue).getTime());
                }
                if (this.multilangFieldSet.contains(propFieldName) && (dynamicObject = this.multilangDynamicObjectMap.get(pkId)) != null && ((OrmLocaleValue)dynamicObject.get(propFieldName)).size() != 0) {
                    fldValue = dynamicObject.get(propFieldName);
                }
                GroupKey key = new GroupKey(0, null, new Object[]{fldValue}, new Object[]{fldValue});
                key.setCheckMultilang(this.isCheckMultilang());
                GroupKey groupKey = this.getGroupKey(groupKeys, key);
                if (groupKey != null) {
                    List<ExtendedDataEntity> list = groups.get(groupKey);
                    if (list == null || list.isEmpty()) continue;
                    for (int i = 0; i < list.size(); ++i) {
                        String errMsg;
                        Object billPkId;
                        ExtendedDataEntity dataEntity = list.get(i);
                        Object pkVal = dataEntity.getDataEntity().getPkValue();
                        if (this.pkIdsGrpValidError.contains(pkVal) || pkVal.equals(pkId) || (billPkId = dataEntity.getBillPkId()) != null && billPkId.equals(pkId)) continue;
                        if (this.multilangDynamicObjectMap.size() != 0 && fldValue instanceof OrmLocaleValue && ((OrmLocaleValue)fldValue).size() != 0) {
                            errMsg = this.buildErrMsg(groupKey, (OrmLocaleValue)fldValue, dataEntity);
                        } else {
                            groupKey.setRowIndex(dataEntity.getRowIndex());
                            errMsg = this.buildErrMsg(groupKey, dataEntity);
                        }
                        this.addErrorMsg(errMsg, dataEntity);
                        groupKeys.remove(key);
                    }
                }
                if (!groupKeys.isEmpty()) continue;
                break;
            }
        }
    }

    private GroupKey getKeyIgnoreCase(Map<GroupKey, GroupKey> groupKeys, GroupKey key) {
        for (GroupKey gk : groupKeys.values()) {
            if (!gk.equalsIgnoreCase(key)) continue;
            return gk;
        }
        return null;
    }

    private GroupKey getGroupKey(Map<GroupKey, GroupKey> groupKeys, GroupKey key) {
        if (groupKeys == null || groupKeys.size() == 0) {
            return null;
        }
        for (Map.Entry<GroupKey, GroupKey> gkEntry : groupKeys.entrySet()) {
            GroupKey gk = gkEntry.getKey();
            if (!gk.equalsIgnoreCase(key)) continue;
            return gkEntry.getValue();
        }
        return null;
    }

    private void checkRepeatedInDbMore(Map<GroupKey, List<ExtendedDataEntity>> groups) {
        QFilter[] fs = this.buildFilters(groups);
        String selectedFields = this.buildSelectFields();
        ORM orm = ORM.create();
        try (DataSet allData = orm.queryDataSet("kd.bos.service.operation.validate", this.validateContext.getEntityNumber(), selectedFields, fs);
             DataSet allDataCopy = allData.copy();){
            if (!allDataCopy.hasNext()) {
                return;
            }
            if (this.isCheckMultilang() && this.checkHasMultilang()) {
                try (DataSet idCopySet = allDataCopy.copy();){
                    ArrayList<Object> pkList = new ArrayList<Object>(10);
                    while (idCopySet.hasNext()) {
                        Row next = idCopySet.next();
                        Object pkId = next.get("id");
                        pkList.add(pkId);
                    }
                    this.multilangDynamicObjectMap = this.loadMultilangField(this.validateContext.getEntityNumber(), pkList);
                }
            }
            this.tempGroupKeys = new HashSet<GroupKey>(16);
            while (allDataCopy.hasNext()) {
                Row row = allDataCopy.next();
                Object pkId = row.get("id");
                boolean isMatch = this.matchRepeateRow(groups, row, false);
                if (isMatch) continue;
                isMatch = this.matchRepeateRow(groups, row, true);
            }
            this.tempGroupKeys = null;
        }
    }

    private boolean matchRepeateRow(Map<GroupKey, List<ExtendedDataEntity>> groups, Row row, boolean ignoreCase) {
        boolean isMatch = false;
        for (Map.Entry<GroupKey, List<ExtendedDataEntity>> group : groups.entrySet()) {
            GroupKey groupKey = group.getKey();
            List<ExtendedDataEntity> list = group.getValue();
            if (list.isEmpty()) continue;
            boolean hasMatchData = true;
            for (int i = 0; i < this.groupKeyBuilder.fullPropNames.size(); ++i) {
                String propName = this.groupKeyBuilder.props.get(i).getName();
                Object fldValue = groupKey.getFldValues()[i];
                if (this.isCheckMultilang() && this.multilangFieldSet.contains(propName)) {
                    OrmLocaleValue fldOrmLocalvalue = (OrmLocaleValue)fldValue;
                    Object pkid = row.get("id");
                    DynamicObject multilangObject = this.multilangDynamicObjectMap.get(pkid);
                    OrmLocaleValue multilangPropValue = (OrmLocaleValue)multilangObject.get(propName);
                    if (GrpFieldsUniqueValidator.checkMultilangHasEqualItem(fldOrmLocalvalue, multilangPropValue, this.isCheckMultilang(), ignoreCase)) continue;
                    hasMatchData = false;
                    break;
                }
                if (this.equalsValue(fldValue, row.get(propName), ignoreCase)) continue;
                hasMatchData = false;
                break;
            }
            if (!hasMatchData) continue;
            isMatch = true;
            for (int j = 0; j < list.size(); ++j) {
                ExtendedDataEntity dataEntity = list.get(j);
                if (dataEntity.getBillPkId().equals(row.get("id")) || !this.tempGroupKeys.add(groupKey)) continue;
                groupKey.setRowIndex(dataEntity.getRowIndex());
                String errMsg = this.buildErrMsg(groupKey, dataEntity);
                this.addErrorMsg(errMsg, dataEntity);
            }
        }
        return isMatch;
    }

    private void matchRepeateRow_old(Map<GroupKey, List<ExtendedDataEntity>> groups, DataSet allData) {
        for (Map.Entry<GroupKey, List<ExtendedDataEntity>> group : groups.entrySet()) {
            GroupKey groupKey = group.getKey();
            List<ExtendedDataEntity> list = group.getValue();
            if (list.isEmpty()) continue;
            ExtendedDataEntity dataEntity = list.get(0);
            StringBuilder exprBuilder = new StringBuilder();
            HashMap<String, Object> varValues = new HashMap<String, Object>();
            exprBuilder.append("id != id_value");
            varValues.put("id_value", groupKey.getPkValue());
            for (int i = 0; i < this.groupKeyBuilder.fullPropNames.size(); ++i) {
                String propName = this.groupKeyBuilder.props.get(i).getName();
                Object fldValue = groupKey.getFldValues()[i];
                if (StringUtils.isBlank((Object)fldValue)) {
                    exprBuilder.append(" and ").append(String.format("(%s = null or %s = '' or %s = ' ')", propName, propName, propName));
                    continue;
                }
                exprBuilder.append(" and ").append(String.format("%s = %s_value ", propName, propName));
                varValues.put(propName + "_value", fldValue);
            }
            boolean isMatch = true;
            try (DataSet allDataCopy = allData.copy();
                 DataSet currSet = allDataCopy.filter(exprBuilder.toString(), varValues);){
                if (currSet.hasNext()) {
                    String errMsg = this.buildErrMsg(groupKey, dataEntity);
                    this.addErrorMsg(errMsg, dataEntity);
                } else {
                    isMatch = false;
                }
            }
            if (!isMatch) {
                allDataCopy = allData.copy();
                var12_12 = null;
                try {
                    while (allDataCopy.hasNext()) {
                        Row row = allDataCopy.next();
                        boolean hasMatchData = true;
                        for (int i = 0; i < this.groupKeyBuilder.fullPropNames.size(); ++i) {
                            String propName = this.groupKeyBuilder.props.get(i).getName();
                            Object fldValue = groupKey.getFldValues()[i];
                            if (this.equalsValue(fldValue, row.get(propName), true)) continue;
                            hasMatchData = false;
                            break;
                        }
                        if (!hasMatchData) continue;
                        isMatch = true;
                        String errMsg = this.buildErrMsg(groupKey, dataEntity);
                        this.addErrorMsg(errMsg, dataEntity);
                    }
                }
                catch (Throwable throwable) {
                    var12_12 = throwable;
                    throw throwable;
                }
                finally {
                    if (allDataCopy != null) {
                        if (var12_12 != null) {
                            try {
                                allDataCopy.close();
                            }
                            catch (Throwable throwable) {
                                var12_12.addSuppressed(throwable);
                            }
                        } else {
                            allDataCopy.close();
                        }
                    }
                }
            }
            if (isMatch) continue;
            String errMsg = String.format(ResManager.loadKDString((String)"\u552f\u4e00\u6027\u6821\u9a8c\u53d1\u73b0\u6709\u91cd\u590d\u6570\u636e\uff0c\u53ef\u80fd\u7531\u4e8e\u5b57\u7b26\u96c6\u7b49\u539f\u56e0\u4e0d\u80fd\u5b9a\u4f4d\u5177\u4f53\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u5546\u68c0\u67e5\u3002", (String)"GrpFieldsUniqueValidator_2", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), new Object[0]);
            throw new KDBizException(BosErrorCode.nullError, new Object[]{errMsg});
        }
    }

    private boolean equalsValue(Object v1, Object v2, boolean stringIgnoreCase) {
        if (v1 == null) {
            return v2 == null;
        }
        if (v1 instanceof Integer && v2 instanceof Long) {
            return ((Integer)v1).longValue() == ((Long)v2).longValue();
        }
        if (v1 instanceof Long && v2 instanceof Integer) {
            return ((Long)v1).longValue() == ((Integer)v2).longValue();
        }
        if (v1 instanceof BigDecimal && v2 instanceof BigDecimal) {
            return ((BigDecimal)v1).compareTo((BigDecimal)v2) == 0;
        }
        if (v1 instanceof String && v2 instanceof String && stringIgnoreCase) {
            return ((String)v1).trim().equalsIgnoreCase(((String)v2).trim());
        }
        if (v1 instanceof String && v2 instanceof String) {
            return ((String)v1).trim().equals(((String)v2).trim());
        }
        return v1.equals(v2);
    }

    private QFilter[] buildFilters(Map<GroupKey, List<ExtendedDataEntity>> groups) {
        int size = this.groupKeyBuilder.fullPropNames.size();
        ArrayList fldValues = new ArrayList(size);
        Boolean[] fldIsNulls = new Boolean[size];
        Boolean[] fldIsBlanks = new Boolean[size];
        for (int i = 0; i < size; ++i) {
            fldValues.add(new HashSet());
            fldIsNulls[i] = Boolean.FALSE;
            fldIsBlanks[i] = Boolean.FALSE;
        }
        for (Map.Entry<GroupKey, List<ExtendedDataEntity>> group : groups.entrySet()) {
            for (int i = 0; i < size; ++i) {
                Object fldValue = group.getKey().getFldValues()[i];
                if (fldValue == null) {
                    fldIsNulls[i] = Boolean.TRUE;
                    continue;
                }
                if (StringUtils.isBlank((Object)fldValue)) {
                    fldIsBlanks[i] = Boolean.TRUE;
                    continue;
                }
                if (fldValue instanceof OrmLocaleValue) continue;
                ((Set)fldValues.get(i)).add(fldValue);
            }
        }
        QFilter[] fs = new QFilter[size + 1];
        for (int i = 0; i < size; ++i) {
            String currFullPropName = this.groupKeyBuilder.fullPropNames.get(i);
            Set currFldVals = (Set)fldValues.get(i);
            Boolean hasNullValue = fldIsNulls[i];
            Boolean hasBlandValue = fldIsBlanks[i];
            QFilter nullFilter = null;
            if (hasNullValue.booleanValue()) {
                nullFilter = this.multilangFieldSet.contains(currFullPropName) ? new QFilter(currFullPropName, "is null", null).or(currFullPropName, "=", (Object)"").or(currFullPropName, "=", (Object)" ") : new QFilter(currFullPropName, "is null", null);
            } else if (hasBlandValue.booleanValue()) {
                nullFilter = new QFilter(currFullPropName, "=", (Object)" ").or(currFullPropName, "=", (Object)"");
            }
            QFilter fldFilter = null;
            if (currFldVals.isEmpty()) {
                fldFilter = nullFilter;
            } else {
                fldFilter = currFldVals.size() > 1 ? new QFilter(currFullPropName, "in", (Object)currFldVals.toArray()) : new QFilter(currFullPropName, "=", currFldVals.iterator().next());
                if (fldFilter != null && nullFilter != null) {
                    fldFilter.or(nullFilter);
                }
            }
            fs[i] = fldFilter;
        }
        if (!this.checkAData() && this.groupKeyBuilder.statusProp != null && StringUtils.isNotBlank((CharSequence)this.groupKeyBuilder.statusDefValue)) {
            fs[size] = new QFilter(this.groupKeyBuilder.statusProp.getName(), "!=", (Object)this.groupKeyBuilder.statusDefValue);
        }
        return fs;
    }

    private String buildSelectFields() {
        String billNo;
        StringBuilder selectFldBuilder = new StringBuilder();
        selectFldBuilder.append("id");
        if (this.validateContext.getBillEntityType() instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)(billNo = ((BillEntityType)this.validateContext.getBillEntityType()).getBillNo())) && !this.getFields().contains(billNo)) {
            selectFldBuilder.append(',').append(billNo);
        }
        for (int i = 0; i < this.groupKeyBuilder.fullPropNames.size(); ++i) {
            selectFldBuilder.append(',').append(this.groupKeyBuilder.fullPropNames.get(i)).append(' ').append(this.groupKeyBuilder.propNames.get(i));
        }
        return selectFldBuilder.toString();
    }

    protected String buildErrMsg(GroupKey groupKey, ExtendedDataEntity dataEntity) {
        String errMsg = "";
        String pattern = "";
        String customProp = this.getCustomProp();
        if (StringUtils.isEmpty((CharSequence)customProp)) {
            String fldNames;
            String joincharacter = ResManager.loadKDString((String)"\u3001", (String)"GrpFieldsUniqueValidator_19", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]);
            String fieldTips = "";
            if (this.groupKeyBuilder.fullPropNames.size() == 1) {
                Object fldValue = groupKey.getFldValues()[0];
                Object fldValueDes = groupKey.getFldValuesDesc()[0];
                if (fldValue == null || (fldValue.equals(-1) || fldValue.equals("")) && !fldValue.equals(fldValueDes) || fldValue.equals("") && fldValue.equals(fldValueDes)) {
                    errMsg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d \u7a7a\u503c\u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"GrpFieldsUniqueValidator_14", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), this.groupKeyBuilder.fldNames);
                    fieldTips = String.format(ResManager.loadKDString((String)"\u7a7a\u503c\u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"GrpFieldsUniqueValidator_22", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), new Object[0]);
                } else if (fldValue instanceof OrmLocaleValue && ((OrmLocaleValue)fldValue).size() == 0) {
                    errMsg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d \u7a7a\u503c\u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"GrpFieldsUniqueValidator_14", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), this.groupKeyBuilder.fldNames);
                    fieldTips = String.format(ResManager.loadKDString((String)"\u7a7a\u503c\u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"GrpFieldsUniqueValidator_22", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), new Object[0]);
                } else {
                    errMsg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d \u503c \u201c%2$s\u201d \u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"GrpFieldsUniqueValidator_13", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), this.groupKeyBuilder.fldNames, groupKey.getFldValuesDesc()[0].toString());
                    fieldTips = String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u503c\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"GrpFieldsUniqueValidator_23", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), new Object[0]);
                }
            } else if (this.isIgnoreDB() || groupKey.getPkValue().equals(0L)) {
                fldNames = Arrays.asList(this.groupKeyBuilder.fldNames.split("\\+")).stream().map(name -> String.format(ResManager.loadKDString((String)"\u201c%s\u201d", (String)"GrpFieldsUniqueValidator_17", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), name)).collect(Collectors.joining(joincharacter));
                fieldTips = errMsg = String.format(ResManager.loadKDString((String)"%s \u7684\u7ec4\u5408\u503c\u91cd\u590d\uff0c\u8bf7\u81f3\u5c11\u4fee\u6539\u4e00\u9879\u3002", (String)"GrpFieldsUniqueValidator_12", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), fldNames);
                pattern = ResManager.loadKDString((String)"%s \u7684\u7ec4\u5408\u503c\u91cd\u590d\uff0c\u8bf7\u81f3\u5c11\u4fee\u6539\u4e00\u9879\u3002", (String)"GrpFieldsUniqueValidator_12", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]);
            } else {
                fldNames = Arrays.asList(this.groupKeyBuilder.fldNames.split("\\+")).stream().map(name -> String.format(ResManager.loadKDString((String)"\u201c%s\u201d", (String)"GrpFieldsUniqueValidator_17", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), name)).collect(Collectors.joining(joincharacter));
                fieldTips = errMsg = String.format(ResManager.loadKDString((String)"%s \u7684\u7ec4\u5408\u503c\u4e0e\u5176\u4ed6\u8868\u5355\u91cd\u590d\uff0c\u8bf7\u81f3\u5c11\u4fee\u6539\u4e00\u9879\u3002", (String)"GrpFieldsUniqueValidator_11", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), fldNames);
                pattern = ResManager.loadKDString((String)"%s \u7684\u7ec4\u5408\u503c\u4e0e\u5176\u4ed6\u8868\u5355\u91cd\u590d\uff0c\u8bf7\u81f3\u5c11\u4fee\u6539\u4e00\u9879\u3002", (String)"GrpFieldsUniqueValidator_11", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]);
            }
            if (this.getFields().size() >= 1) {
                for (String fieldKey : this.getFields()) {
                    this.addPromptInfo(dataEntity, errMsg, fieldTips, fieldKey);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)pattern)) {
                errMsg = String.format("%1$s@@%2$s", errMsg, pattern);
            }
        } else {
            errMsg = this.handleCustomPromp(customProp, groupKey);
        }
        return errMsg;
    }

    private String getEntryKey(String fieldKey) {
        MainEntityType mainEntityType = this.getValidateContext().getSubEntityType();
        IDataEntityProperty prop = (IDataEntityProperty)mainEntityType.getAllFields().get(fieldKey);
        if (prop == null) {
            return "";
        }
        IDataEntityType parent = prop.getParent();
        if (parent == null || mainEntityType == parent) {
            return "";
        }
        return parent.getName();
    }

    private String handleCustomPromp(String customProp, GroupKey groupKey) {
        List<Object> flds = Arrays.asList(groupKey.getFldValues());
        List<String> propNames = this.groupKeyBuilder.propNames;
        int len = propNames.size();
        ExtendedDataEntity dataEntity = null;
        block8: for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject dynamicObject = entity.getDataEntity();
            boolean equal = true;
            for (int i = 0; i < len; ++i) {
                Object prop;
                try {
                    prop = dynamicObject.get(propNames.get(i));
                }
                catch (ORMDesignException ormDesignException) {
                    continue;
                }
                if (prop == null || !flds.contains(prop)) {
                    equal = false;
                }
                if (!equal && dataEntity != null) continue;
                dataEntity = entity;
                continue block8;
            }
        }
        if (dataEntity == null) {
            return "";
        }
        String billNo = dataEntity.getBillNo();
        int rowIndex = groupKey.getRowIndex();
        if (customProp.contains("{Lnum}")) {
            customProp = customProp.replace("{Lnum}", String.valueOf(rowIndex + 1));
        }
        if (this.isIgnoreDB() && customProp.contains("{Lnums}")) {
            String repeatedRowStr = groupKey.getRepeatedRowIndex().toString();
            customProp = customProp.replace("{Lnums}", repeatedRowStr.substring(1, repeatedRowStr.length() - 1));
        }
        if (customProp.contains("{Billno}")) {
            customProp = customProp.replace("{Billno}", billNo);
        }
        String[] fields = this.groupKeyBuilder.fldNames.split("\\+");
        try {
            int loopCount = 0;
            while (customProp.contains("{Fields")) {
                if (loopCount > 15) {
                    customProp = ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u914d\u7f6e\u7684\u7ec4\u5408\u552f\u4e00\u6821\u9a8c\u7684\u63d0\u793a\u8bed\u7684Field\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u8bf7\u53c2\u8003tips\uff0c\u5e76\u8bbe\u7f6e\u6b63\u786e\u7684\u53c2\u6570\u3002", (String)"GrpFieldsUniqueValidator_16", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]);
                    break;
                }
                int index = customProp.indexOf("{Fields");
                int num = Integer.parseInt(String.valueOf(customProp.charAt(index + 8)));
                customProp = customProp.replaceFirst("\\{Fields\\[" + num + "\\]\\}", fields[num]);
                ++loopCount;
            }
        }
        catch (Exception e) {
            LOG.error(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u914d\u7f6e\u7684\u7ec4\u5408\u552f\u4e00\u6821\u9a8c\u7684\u63d0\u793a\u8bed\u7684Field\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u8bf7\u53c2\u8003tips\uff0c\u5e76\u8bbe\u7f6e\u6b63\u786e\u7684\u53c2\u6570\u3002", (String)"GrpFieldsUniqueValidator_16", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
        }
        try {
            ExtendedDataEntity currEntity;
            IDataEntityProperty property;
            String valueStr;
            Object fieldValue;
            String regex;
            ExtendedDataEntity headEntity = null;
            try {
                String entityNumber = this.validateContext.getEntityNumber();
                Map extDataEntityMap = this.validateContext.getExtendedDataEntitySet().getExtDataEntityMap();
                headEntity = (ExtendedDataEntity)((List)extDataEntityMap.get(entityNumber)).get(0);
            }
            catch (Exception e) {
                LOG.error("get headEntity with error:", (Throwable)e);
            }
            Pattern secBDPattern = Pattern.compile("\\{(\\w+\\.\\w+\\.\\w+)\\}");
            Matcher secBDMatcher = secBDPattern.matcher(customProp);
            int loopCount = 0;
            while (secBDMatcher.find()) {
                DynamicObject bdObj;
                if (loopCount > 15) {
                    customProp = this.fieldNumErrorMsg();
                    break;
                }
                String[] strs = secBDMatcher.group().replaceAll("\\{", "").replaceAll("\\}", "").split("\\.");
                String bdField = strs[0];
                String secBDField = strs[1];
                String prop = strs[2];
                ExtendedDataEntity currEntity2 = dataEntity;
                if (headEntity != null && headEntity.getValue(bdField) != null) {
                    currEntity2 = headEntity;
                }
                if (currEntity2.getValue(bdField) != null && (bdObj = (DynamicObject)currEntity2.getValue(bdField)).get(secBDField) != null) {
                    DynamicObject secBD = bdObj.getDynamicObject(secBDField);
                    regex = String.format("\\{%1$s\\.%2$s\\.%3$s\\}", bdField, secBDField, prop);
                    fieldValue = secBD.get(prop);
                    valueStr = fieldValue.toString();
                    property = (IDataEntityProperty)secBD.getDataEntityType().getProperties().get((Object)prop);
                    valueStr = this.dateFieldFormat(property, fieldValue, valueStr);
                    customProp = customProp.replaceFirst(regex, valueStr);
                }
                ++loopCount;
            }
            Pattern bdPattern = Pattern.compile("\\{(\\w+\\.\\w+)\\}");
            Matcher bdMatcher = bdPattern.matcher(customProp);
            loopCount = 0;
            while (bdMatcher.find()) {
                if (loopCount > 15) {
                    customProp = this.fieldNumErrorMsg();
                    break;
                }
                String[] prop = bdMatcher.group().replaceAll("\\{", "").replaceAll("\\}", "").split("\\.");
                String bdField = prop[0];
                String bdProp = prop[1];
                currEntity = dataEntity;
                if (headEntity != null && headEntity.getValue(bdField) != null) {
                    currEntity = headEntity;
                }
                if (currEntity.getValue(bdField) != null) {
                    DynamicObject obj = (DynamicObject)currEntity.getValue(bdField);
                    regex = String.format("\\{%1$s\\.%2$s\\}", bdField, bdProp);
                    fieldValue = obj.get(bdProp);
                    valueStr = fieldValue.toString();
                    property = (IDataEntityProperty)obj.getDataEntityType().getProperties().get((Object)bdProp);
                    valueStr = this.dateFieldFormat(property, fieldValue, valueStr);
                    customProp = customProp.replaceFirst(regex, valueStr);
                }
                ++loopCount;
            }
            Pattern pattern1 = Pattern.compile("\\{(\\w+)\\}");
            Matcher matcher1 = pattern1.matcher(customProp);
            loopCount = 0;
            while (matcher1.find()) {
                if (loopCount > 15) {
                    customProp = this.fieldNumErrorMsg();
                    break;
                }
                String field = matcher1.group().replaceAll("\\{", "").replaceAll("\\}", "");
                currEntity = dataEntity;
                if (headEntity != null && headEntity.getValue(field) != null) {
                    currEntity = headEntity;
                }
                if (currEntity.getValue(field) != null) {
                    String regex2 = String.format("\\{%s\\}", field);
                    Object fieldValue2 = currEntity.getValue(field);
                    String valueStr2 = fieldValue2.toString();
                    IDataEntityProperty property2 = (IDataEntityProperty)currEntity.getDataEntity().getDataEntityType().getProperties().get((Object)field);
                    valueStr2 = this.dateFieldFormat(property2, fieldValue2, valueStr2);
                    customProp = customProp.replaceFirst(regex2, valueStr2);
                }
                ++loopCount;
            }
        }
        catch (Exception e) {
            LOG.error(this.fieldNumErrorMsg(), (Throwable)e);
        }
        for (String fieldKey : this.getFields()) {
            this.addPromptInfo(dataEntity, customProp, customProp, fieldKey);
        }
        return customProp;
    }

    private void addPromptInfo(ExtendedDataEntity dataEntity, String fullErrMsg, String simpleTips, String fieldKey) {
        fieldKey = fieldKey.split("\\.")[0];
        String entryKey = this.getEntryKey(fieldKey);
        FieldPos fieldPos = null;
        if (StringUtils.isBlank((CharSequence)entryKey)) {
            fieldPos = new FieldPos(fieldKey, simpleTips, ValidPromtType.GRP_UNIQUE.getType(), this.getValidatorId());
            this.addPromptInfo(fieldPos);
        } else if (!this.isSubEntity(entryKey)) {
            fieldPos = new FieldPos(entryKey, dataEntity.getRowIndex(), fieldKey, simpleTips, ValidPromtType.GRP_UNIQUE.getType(), this.getValidatorId());
            this.addPromptInfo(fieldPos);
        } else {
            String subEntryKey = entryKey;
            EntityType subEntry = (EntityType)this.getValidateContext().getSubEntityType().getAllEntities().get(entryKey);
            entryKey = subEntry.getParent() == null ? "" : subEntry.getParent().getName();
            fieldPos = new FieldPos(entryKey, subEntryKey, dataEntity.getRowIndex(), dataEntity.getSubRowIndex(), fieldKey, simpleTips, ValidPromtType.GRP_UNIQUE.getType(), this.getValidatorId());
            this.addPromptInfo(fieldPos);
        }
        if (!StringUtils.equals((CharSequence)fullErrMsg, (CharSequence)simpleTips)) {
            fieldPos.setFullMsg(fullErrMsg);
        }
    }

    private boolean isSubEntity(String entryKey) {
        EntityType entityType = (EntityType)this.getValidateContext().getSubEntityType().getAllEntities().get(entryKey);
        return entityType instanceof SubEntryType;
    }

    private String fieldNumErrorMsg() {
        return ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u914d\u7f6e\u7684\u7ec4\u5408\u552f\u4e00\u6821\u9a8c\u7684\u63d0\u793a\u8bed\u7684{\u5b57\u6bb5\u6807\u8bc6}\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u8bf7\u53c2\u8003tips\uff0c\u5e76\u8bbe\u7f6e\u6b63\u786e\u7684\u53c2\u6570\u3002", (String)"GrpFieldsUniqueValidator_18", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]);
    }

    private String dateFieldFormat(IDataEntityProperty property, Object fieldValue, String valueStr) {
        String result = valueStr;
        if (property instanceof DateProp) {
            DateFormat dateFormat = ((DateProp)property).getDateFormat();
            result = dateFormat.format(fieldValue);
        } else if (property instanceof DateTimeProp) {
            DateFormat dateFormat = ((DateTimeProp)property).getDateFormat();
            result = dateFormat.format(fieldValue);
        } else if (property instanceof TimeProp && fieldValue instanceof Integer) {
            int totalSeconds = (Integer)fieldValue;
            int hours = totalSeconds / 3600;
            int minutes = totalSeconds % 3600 / 60;
            int actualSeconds = totalSeconds % 60;
            result = String.format("%02d:%02d:%02d", hours, minutes, actualSeconds);
        }
        return result;
    }

    private String buildErrMsg(GroupKey groupKey, OrmLocaleValue fldVaule, ExtendedDataEntity dataEntity) {
        Object[] fieldVules = groupKey.getFldValues();
        StringBuilder fields = new StringBuilder();
        for (Object fldVal : fieldVules) {
            if (!(fldVal instanceof OrmLocaleValue)) continue;
            Set filedEntrySet = ((OrmLocaleValue)fldVal).entrySet();
            for (Map.Entry fieldEntry : filedEntrySet) {
                String fieldKey = (String)fieldEntry.getKey();
                String fieldValue = (String)fieldEntry.getValue();
                if (!fieldValue.equalsIgnoreCase(fldVaule.get((Object)fieldKey)) || fieldKey.equalsIgnoreCase("GLang") || !this.getEnableLangs().contains(fieldKey)) continue;
                fields.append(this.ENABLE_LANG_NUMBE2_NAME.get(fieldKey)).append(" ").append(fieldValue).append("\uff0c");
            }
        }
        String fieldinfo = "";
        if (StringUtils.isNotEmpty((CharSequence)fields)) {
            fieldinfo = fields.substring(0, fields.length() - 1);
        }
        String errMsg = "";
        String pattern = "";
        String customProp = this.getCustomProp();
        if (StringUtils.isEmpty((CharSequence)customProp)) {
            String fldNames;
            String joincharacter = ResManager.loadKDString((String)"\u3001", (String)"GrpFieldsUniqueValidator_19", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]);
            String simpleTips = null;
            if (this.getFields().size() == 1) {
                if (groupKey.getFldValues()[0] != null) {
                    errMsg = StringUtils.isNotEmpty((CharSequence)fieldinfo) ? String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d \u503c \u201c%2$s\u201d \u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"GrpFieldsUniqueValidator_13", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), this.groupKeyBuilder.fldNames, fieldinfo) : String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d %2$s \u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"GrpFieldsUniqueValidator_15", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), this.groupKeyBuilder.fldNames, groupKey.getFldValuesDesc()[0].toString());
                    simpleTips = String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u503c\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"GrpFieldsUniqueValidator_23", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), new Object[0]);
                } else {
                    errMsg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d \u7a7a\u503c\u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"GrpFieldsUniqueValidator_14", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), this.groupKeyBuilder.fldNames);
                    simpleTips = String.format(ResManager.loadKDString((String)"\u7a7a\u503c\u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"GrpFieldsUniqueValidator_22", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), new Object[0]);
                }
            } else if (this.isIgnoreDB() || groupKey.getPkValue().equals(0L)) {
                fldNames = Arrays.asList(this.groupKeyBuilder.fldNames.split("\\+")).stream().map(name -> String.format(ResManager.loadKDString((String)"\u201c%s\u201d", (String)"GrpFieldsUniqueValidator_17", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), name)).collect(Collectors.joining(joincharacter));
                errMsg = String.format(ResManager.loadKDString((String)"%s \u7684\u7ec4\u5408\u503c\u91cd\u590d\uff0c\u8bf7\u81f3\u5c11\u4fee\u6539\u4e00\u9879\u3002", (String)"GrpFieldsUniqueValidator_12", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), fldNames);
                pattern = ResManager.loadKDString((String)"%s \u7684\u7ec4\u5408\u503c\u91cd\u590d\uff0c\u8bf7\u81f3\u5c11\u4fee\u6539\u4e00\u9879\u3002", (String)"GrpFieldsUniqueValidator_12", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]);
            } else {
                fldNames = Arrays.asList(this.groupKeyBuilder.fldNames.split("\\+")).stream().map(name -> String.format(ResManager.loadKDString((String)"\u201c%s\u201d", (String)"GrpFieldsUniqueValidator_17", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), name)).collect(Collectors.joining(joincharacter));
                errMsg = String.format(ResManager.loadKDString((String)"%s \u7684\u7ec4\u5408\u503c\u4e0e\u5176\u4ed6\u8868\u5355\u91cd\u590d\uff0c\u8bf7\u81f3\u5c11\u4fee\u6539\u4e00\u9879\u3002", (String)"GrpFieldsUniqueValidator_11", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), fldNames);
                pattern = ResManager.loadKDString((String)"%s \u7684\u7ec4\u5408\u503c\u4e0e\u5176\u4ed6\u8868\u5355\u91cd\u590d\uff0c\u8bf7\u81f3\u5c11\u4fee\u6539\u4e00\u9879\u3002", (String)"GrpFieldsUniqueValidator_11", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]);
            }
            if (this.getFields().size() >= 1) {
                for (String fieldKey : this.getFields()) {
                    this.addPromptInfo(dataEntity, errMsg, simpleTips != null ? simpleTips : errMsg, fieldKey);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)pattern)) {
                errMsg = String.format("%1$s@@%2$s", errMsg, pattern);
            }
        } else {
            errMsg = this.handleCustomPromp(customProp, groupKey);
        }
        return errMsg;
    }

    public List<String> getEnableLangs() {
        if (this.ENABLE_LANG_NUMBER.isEmpty()) {
            List enabledLangs = InteServiceHelper.getEnabledLang();
            for (EnabledLang enabledLang : enabledLangs) {
                String enableNumber = enabledLang.getNumber();
                this.ENABLE_LANG_NUMBER.add(enableNumber);
                this.ENABLE_LANG_NUMBE2_NAME.put(enableNumber, enabledLang.getName());
            }
        }
        return this.ENABLE_LANG_NUMBER;
    }

    public Map<Object, DynamicObject> loadMultilangField(String entityNumber, List<Object> ids) {
        DynamicObject[] dynamicObjects;
        HashMap<Object, DynamicObject> result = new HashMap<Object, DynamicObject>(16);
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
        StringBuilder fieldBuild = new StringBuilder("id");
        for (String mfield : this.multilangFieldSet) {
            fieldBuild.append(",").append(mfield);
        }
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)entityNumber, (String)fieldBuild.toString(), (QFilter[])filters)) {
            result.put(dynamicObject.get("id"), dynamicObject);
        }
        return result;
    }

    private boolean checkHasMultilang() {
        boolean hasMultilang = false;
        for (String prop : this.groupKeyBuilder.propNames) {
            DynamicProperty property = (DynamicProperty)this.validateContext.getBillEntityType().getAllFields().get(prop);
            if (!(property instanceof MuliLangTextProp)) continue;
            hasMultilang = true;
            break;
        }
        return hasMultilang;
    }

    static boolean checkMultilangHasEqualItem(OrmLocaleValue currentValue, OrmLocaleValue dbValue, boolean checkMultilang, boolean ignoreCase) {
        boolean equal = false;
        if (currentValue == null && dbValue == null) {
            equal = false;
        } else if (currentValue == null || dbValue == null) {
            equal = true;
        } else {
            if (currentValue.size() == 0 && dbValue.size() == 0) {
                equal = true;
                return equal;
            }
            for (String currentKey : currentValue.keySet()) {
                if (!checkMultilang && !currentKey.equals(Lang.get().name()) || !(equal = ignoreCase ? StringUtils.equalsIgnoreCase((CharSequence)currentValue.get((Object)currentKey), (CharSequence)dbValue.get((Object)currentKey)) : StringUtils.equals((CharSequence)currentValue.get((Object)currentKey), (CharSequence)dbValue.get((Object)currentKey)))) continue;
                break;
            }
        }
        return equal;
    }
}

