/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation.validate;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.OperationContext;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.validate.DataMutexResult;
import kd.bos.service.operation.validate.MutexThreadRecorder;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.utils.DbTypeConverter;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class MutexValidator
extends AbstractValidator {
    private static final String BOS_MSERVICE_OPERATION = "bos-mservice-operation";
    private static Log log = LogFactory.getLog(MutexValidator.class);
    OperationContext operationCtx = null;
    static final String TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    SimpleDateFormat timesdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    static final String MUTEX_DATAOBJID = "dataObjId";
    static final String MUTEX_DATA_OBJ_NUMBER = "dataObjNumber";
    static final String MUTEX_GROUPID = "groupId";
    static final String MUTEX_ENTITYKEY = "entityKey";
    static final String MUTEX_OPERATIONKEY = "operationKey";
    static final String MUTEX_ISSTRICT = "isStrict";
    static final String MUTEX_CALL_SOURCE = "callSource";
    private static final String MUTEX_AUTOCLEARLOSTLOCK = "autoclearlostlock";
    private static final String MUTEX_MAXLOCKTIME = "maxlocktime_s";

    public void setOperationCtx(OperationContext operationCtx) {
        this.operationCtx = operationCtx;
    }

    public void validate() {
        if (this.validateContext.getOption() != null && this.validateContext.getOption().containsVariable("ignoreValidation") && "true".equalsIgnoreCase(this.validateContext.getOption().getVariableValue("ignoreValidation"))) {
            return;
        }
        HashMap<String, ExtendedDataEntity> dataMap = new HashMap<String, ExtendedDataEntity>();
        HashMap<Object, String> idMaps = new HashMap<Object, String>(this.dataEntities.length);
        for (ExtendedDataEntity dataObj : this.dataEntities) {
            String idStr;
            Long idLong;
            Object idValue = dataObj.getBillPkId();
            if (idValue == null || (idValue instanceof Long ? (idLong = (Long)idValue) == 0L : (idStr = String.valueOf(idValue)).trim().length() == 0)) continue;
            String objId = String.valueOf(idValue);
            idMaps.put(objId, dataObj.getBillNo());
            dataMap.put(objId, dataObj);
        }
        Map<String, DataMutexResult> dataMutexResults = MutexValidator.batchRequire(this.entityKey, this.getOperateKey(), idMaps, this.operationCtx, this.validateContext.getOption());
        if (dataMutexResults != null) {
            for (DataMutexResult dataMutexResult : dataMutexResults.values()) {
                if (dataMutexResult.isSuccess()) continue;
                this.addFatalErrorMessage((ExtendedDataEntity)dataMap.get(dataMutexResult.getId()), dataMutexResult.getMessage());
            }
        }
    }

    public static Map<String, DataMutexResult> batchRequire(String entityNumber, String opKey, Object[] ids, OperationContext operationCtx, OperateOption option) {
        HashMap<Object, String> data;
        block5: {
            block4: {
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                if (!(entityType instanceof BillEntityType) || !StringUtils.isNotBlank((CharSequence)((BillEntityType)entityType).getBillNo())) break block4;
                BillEntityType billEntityType = (BillEntityType)entityType;
                Object[] selectIds = new Object[ids.length];
                for (int i = 0; i < ids.length; ++i) {
                    selectIds[i] = DbTypeConverter.safeConvert((int)billEntityType.getPrimaryKey().getDbType(), (Object)ids[i]);
                }
                DynamicObject[] objs = BusinessDataServiceHelper.load((String)entityNumber, (String)("id," + billEntityType.getBillNo()), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)selectIds)});
                data = new HashMap(objs.length);
                for (DynamicObject dynamicObject : objs) {
                    data.put(dynamicObject.getPkValue(), dynamicObject.getString(billEntityType.getBillNo()));
                }
                if (data.size() >= selectIds.length) break block5;
                for (Object object : selectIds) {
                    if (data.containsKey(object)) continue;
                    data.put(object, String.valueOf(object));
                }
                break block5;
            }
            data = new HashMap<Object, String>(ids.length);
            for (Object object : ids) {
                data.put(object, String.valueOf(object));
            }
        }
        return MutexValidator.batchRequire(entityNumber, opKey, data, operationCtx, option);
    }

    private static Map<String, DataMutexResult> batchRequire(String entityNumber, String opKey, Map<Object, String> idMap, OperationContext operationCtx, OperateOption option) {
        String netGroupId = MutexValidator.getGroupIdByEntityNumber(entityNumber, opKey);
        if (netGroupId == null) {
            return new HashMap<String, DataMutexResult>(0);
        }
        operationCtx.getParameter().put(MUTEX_GROUPID, netGroupId);
        boolean isStrict = true;
        boolean isIgnoreModify = false;
        boolean isOpenIntentLocks = false;
        boolean ignore = false;
        boolean autoClearDirtyLock = false;
        long maxlocktime = -1L;
        if (option != null) {
            if (option.containsVariable(MUTEX_ISSTRICT)) {
                isStrict = Boolean.parseBoolean(option.getVariableValue(MUTEX_ISSTRICT));
            }
            if (option.containsVariable("mutex_ignoremodify")) {
                isIgnoreModify = Boolean.parseBoolean(option.getVariableValue("mutex_ignoremodify"));
            }
            if (option.containsVariable("isOpenIntentLocks")) {
                isOpenIntentLocks = Boolean.parseBoolean(option.getVariableValue("isOpenIntentLocks"));
            }
            if (option.containsVariable("ignoreValidation")) {
                ignore = Boolean.parseBoolean(option.getVariableValue("ignoreValidation"));
            }
            if (option.containsVariable(MUTEX_AUTOCLEARLOSTLOCK)) {
                autoClearDirtyLock = Boolean.parseBoolean(option.getVariableValue(MUTEX_AUTOCLEARLOSTLOCK));
            }
            if (option.containsVariable(MUTEX_MAXLOCKTIME)) {
                maxlocktime = Long.parseLong(option.getVariableValue(MUTEX_MAXLOCKTIME));
            }
        }
        HashSet mutexLocks = new HashSet(operationCtx.getMutexLocks());
        ArrayList<Map<String, Object>> mutexRequireList = new ArrayList<Map<String, Object>>(idMap.size());
        HashMap<String, DataMutexResult> dataMutexResults = new HashMap<String, DataMutexResult>(mutexRequireList.size());
        if (ignore) {
            for (Object id : idMap.keySet()) {
                DataMutexResult dataMutexResult = new DataMutexResult(String.valueOf(id), true);
                dataMutexResults.put(String.valueOf(id), dataMutexResult);
            }
            return dataMutexResults;
        }
        for (Map.Entry<Object, String> entry : idMap.entrySet()) {
            String objId;
            Long idLong;
            String idStr;
            String billNo;
            Object idValue = entry.getKey();
            String string = billNo = StringUtils.isNotBlank((CharSequence)entry.getValue()) ? entry.getValue() : String.valueOf(idValue);
            if (idValue == null || (!(idValue instanceof Long) ? (idStr = String.valueOf(idValue)).trim().length() == 0 : (idLong = (Long)idValue) == 0L) || mutexLocks.contains(objId = String.valueOf(idValue))) continue;
            HashMap<String, Object> requireParam = new HashMap<String, Object>();
            requireParam.put(MUTEX_DATAOBJID, objId);
            requireParam.put(MUTEX_DATA_OBJ_NUMBER, billNo);
            requireParam.put(MUTEX_GROUPID, netGroupId);
            requireParam.put(MUTEX_ENTITYKEY, entityNumber);
            requireParam.put(MUTEX_OPERATIONKEY, opKey);
            requireParam.put(MUTEX_ISSTRICT, isStrict);
            if (isIgnoreModify) {
                requireParam.put("ignoreModify", isIgnoreModify);
            }
            requireParam.put(MUTEX_CALL_SOURCE, "default");
            if (autoClearDirtyLock && maxlocktime > 0L) {
                requireParam.put(MUTEX_AUTOCLEARLOSTLOCK, autoClearDirtyLock);
                requireParam.put(MUTEX_MAXLOCKTIME, maxlocktime);
            }
            requireParam.put("isOpenIntentLocks", isOpenIntentLocks);
            mutexRequireList.add(requireParam);
        }
        return MutexValidator.batchRequireMutex(netGroupId, entityNumber, mutexRequireList, idMap.keySet().toArray(), operationCtx);
    }

    private static String getGroupIdByEntityNumber(String entityNumber, String opKey) {
        Map netCtrlConf = EntityMetadataCache.getDataEntityNetCtrlOperate((String)entityNumber);
        if (netCtrlConf == null) {
            return null;
        }
        String netGroupId = null;
        block0: for (Map.Entry entry : netCtrlConf.entrySet()) {
            String groupId = (String)entry.getKey();
            List operList = (List)entry.getValue();
            for (Map oper : operList) {
                String operKey = (String)oper.get(MUTEX_OPERATIONKEY);
                if (!operKey.equals(opKey)) continue;
                netGroupId = groupId;
                continue block0;
            }
        }
        return netGroupId;
    }

    private static Map<String, DataMutexResult> batchRequireMutex(String groupId, String entityNumber, List<Map<String, Object>> mutexRequireList, Object[] ids, OperationContext operationCtx) {
        if (mutexRequireList.isEmpty()) {
            return new HashMap<String, DataMutexResult>(0);
        }
        String opKey = (String)mutexRequireList.get(0).get(MUTEX_OPERATIONKEY);
        HashMap<String, DataMutexResult> dataMutexResults = new HashMap<String, DataMutexResult>(mutexRequireList.size());
        try (DataMutex dataMutex = DataMutex.create();
             EntityTraceSpan span = EntityTracer.create((String)"MutexValidator", (String)"batchRequireMutex");){
            try {
                Map<String, Boolean> mutexResult = MutexValidator.doRequireMutex(dataMutex, mutexRequireList);
                if (span.isRealtime()) {
                    span.addLocaleTag("mutexRequireList", mutexRequireList);
                    span.addLocaleTag("mutexResult", mutexResult);
                }
                for (Map.Entry<String, Boolean> mutexItem : mutexResult.entrySet()) {
                    String objId = mutexItem.getKey();
                    Boolean ret = mutexItem.getValue();
                    DataMutexResult dataMutexResult = new DataMutexResult(objId, ret);
                    dataMutexResults.put(objId, dataMutexResult);
                    if (ret.booleanValue()) {
                        operationCtx.getMutexLocks().add(objId);
                        MutexThreadRecorder.record(entityNumber, objId, opKey);
                        continue;
                    }
                    if (MutexThreadRecorder.isExist(entityNumber, objId)) {
                        dataMutexResult = new DataMutexResult(objId, true);
                        dataMutexResults.put(objId, dataMutexResult);
                        continue;
                    }
                    Map lockInfo = dataMutex.getLockInfo(objId, groupId, entityNumber);
                    StringBuilder sb = new StringBuilder();
                    if (lockInfo != null) {
                        Long userid = Long.valueOf((String)lockInfo.get("userid"));
                        String client = (String)lockInfo.get("client");
                        String sessionId = (String)lockInfo.get("GLOBALSESSION");
                        if (userid == -1L) {
                            sb.append("guest");
                        } else {
                            DynamicObject userObj = BusinessDataServiceHelper.loadSingleFromCache((Object)userid, (String)"bos_user");
                            if (userObj != null) {
                                sb.append(userObj.getString("name"));
                            }
                        }
                        if (StringUtils.isNotBlank((CharSequence)client)) {
                            sb.append(MutexValidator.getClientDescription(client));
                        } else {
                            sb.append(ResManager.loadKDString((String)"\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55", (String)"MutexValidator_0", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
                        }
                        if (StringUtils.equals((CharSequence)((CharSequence)lockInfo.get("userid")), (CharSequence)RequestContext.get().getUserId()) && StringUtils.equals((CharSequence)sessionId, (CharSequence)RequestContext.get().getGlobalSessionId())) {
                            sb.delete(0, sb.length());
                            sb.append(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5df2\u5728\u5176\u4ed6\u9875\u7b7e\u4e2d\u6253\u5f00\uff0c\u5982\u9700\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5173\u95ed\u5355\u636e\u540e\u91cd\u8bd5\uff0c\u6216\u91cd\u65b0\u767b\u5f55\u540e\uff0c\u518d\u6b21\u5c1d\u8bd5\u3002", (String)"MutexValidator_8", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
                        } else {
                            sb.append("\uff0c");
                            sb.append(ResManager.loadKDString((String)"\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"MutexValidator_1", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
                        }
                    } else {
                        sb.append(ResManager.loadKDString((String)"\u8be5\u5bf9\u8c61\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"MutexValidator_2", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
                    }
                    dataMutexResult.setMessage(sb.toString());
                }
            }
            catch (KDException e) {
                for (Object idValue : ids) {
                    if (dataMutexResults.containsKey(String.valueOf(idValue))) continue;
                    DataMutexResult dataMutexResult = new DataMutexResult(String.valueOf(idValue), false);
                    dataMutexResults.put(String.valueOf(idValue), dataMutexResult);
                    StringBuilder sb = new StringBuilder();
                    sb.append(e.getMessage());
                    sb.append("\uff0c");
                    sb.append(ResManager.loadKDString((String)"\u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"MutexValidator_9", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
                    dataMutexResult.setMessage(sb.toString());
                }
            }
        }
        catch (IOException e) {
            ErrorCode ec = new ErrorCode("MUTEX_REQUIRE_ERROR", String.format(ResManager.loadKDString((String)"%s\u7533\u8bf7\u4e92\u65a5\u9501\u51fa\u9519;err:", (String)"MutexValidator_3", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), e.getMessage()));
            throw new KDException((Throwable)e, ec, new Object[0]);
        }
        return dataMutexResults;
    }

    private static Map<String, Boolean> doRequireMutex(DataMutex dataMutex, List<Map<String, Object>> mutexRequireList) {
        HashMap<String, Boolean> mutexResult = null;
        int maxRequireCount = 5;
        Boolean isIgnoreModify = (Boolean)mutexRequireList.get(0).get("ignoreModify");
        for (int requireCount = 0; requireCount < maxRequireCount; ++requireCount) {
            mutexResult = dataMutex.batchrequire(mutexRequireList);
            if (isIgnoreModify == null || !isIgnoreModify.booleanValue() || mutexRequireList.size() > 1 || mutexResult == null || mutexResult.size() != 1 || ((Boolean)mutexResult.entrySet().iterator().next().getValue()).booleanValue() || MutexThreadRecorder.isExist((String)mutexRequireList.get(0).get(MUTEX_ENTITYKEY), (String)mutexRequireList.get(0).get(MUTEX_DATAOBJID))) break;
            MutexValidator.sleep(200L);
        }
        if (mutexResult == null) {
            mutexResult = new HashMap<String, Boolean>(mutexRequireList.size());
            for (Map<String, Object> item : mutexRequireList) {
                String objId = (String)item.get(MUTEX_DATAOBJID);
                if (objId == null) continue;
                mutexResult.put(objId, false);
            }
        }
        return mutexResult;
    }

    private static void sleep(long sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void batchRelease(String entityNumber, String opKey, OperationContext operationCtx) {
        if (operationCtx == null) {
            return;
        }
        List mutexLocks = operationCtx.getMutexLocks();
        String netGroupId = (String)operationCtx.getParameter().get(MUTEX_GROUPID);
        if (!mutexLocks.isEmpty()) {
            ArrayList mutexRequireList = new ArrayList(mutexLocks.size());
            for (String mutexLock : mutexLocks) {
                HashMap<String, String> requireParam = new HashMap<String, String>();
                requireParam.put(MUTEX_DATAOBJID, mutexLock);
                requireParam.put(MUTEX_GROUPID, netGroupId);
                requireParam.put(MUTEX_ENTITYKEY, entityNumber);
                requireParam.put(MUTEX_OPERATIONKEY, opKey);
                mutexRequireList.add(requireParam);
            }
            try (DataMutex dataMutex = DataMutex.create();){
                Map releaseResult = dataMutex.batchRelease(mutexRequireList);
                ArrayList<String> failIds = new ArrayList<String>();
                for (Map.Entry releaseItem : releaseResult.entrySet()) {
                    boolean releaseRet = (Boolean)releaseItem.getValue();
                    String objId = (String)releaseItem.getKey();
                    if (!releaseRet) {
                        failIds.add(objId);
                        continue;
                    }
                    MutexThreadRecorder.release(entityNumber, objId, opKey);
                }
                if (!failIds.isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Failure to release the data object mutex, a total of ").append(failIds.size()).append(" failures: ");
                    sb.append((String)failIds.get(0));
                    for (int i = 1; i < failIds.size() && i < 100; ++i) {
                        sb.append(",").append((String)failIds.get(i));
                    }
                    log.info(sb.toString());
                }
            }
            catch (IOException e) {
                throw new KDException((Throwable)e, new ErrorCode("MUTEX_REQUIRE_ERROR", String.format(ResManager.loadKDString((String)"\u91ca\u653e\u6570\u636e\u5bf9\u8c61\u4e92\u65a5\u9501\u51fa\u9519.", (String)"MutexValidator_4", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), e.getMessage())), new Object[0]);
            }
            mutexLocks.clear();
        }
    }

    private static String getClientDescription(String clientType) {
        if ("web".equals(clientType)) {
            return ResManager.loadKDString((String)"\u6b63\u5728PC\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55", (String)"MutexValidator_5", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]);
        }
        if ("mobile".equals(clientType)) {
            return ResManager.loadKDString((String)"\u6b63\u5728\u79fb\u52a8\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55", (String)"MutexValidator_6", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]);
        }
        if ("batch".equals(clientType) || "MQ".equals(clientType)) {
            return ResManager.loadKDString((String)"\u6b63\u5728\u540e\u53f0\u4efb\u52a1\u7f16\u8f91\u8be5\u8bb0\u5f55", (String)"MutexValidator_7", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u6b63\u5728PC\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55", (String)"MutexValidator_5", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]);
    }
}

