/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation.validate;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class OperateDataPermValidator
extends AbstractValidator {
    public void validate() {
        boolean isHasRight = Boolean.parseBoolean(this.getOption().getVariableValue("ishasright", String.valueOf(false)));
        if (isHasRight) {
            return;
        }
        String permissionItemId = this.getPermssionItemId();
        if (permissionItemId == null) {
            return;
        }
        MainEntityType mainType = this.validateContext.getSubEntityType();
        if (!mainType.getPermissionControlType().isControlFunction()) {
            return;
        }
        if (mainType.getPermissionControlType().isAnonymousUserControl() && RequestContext.get().getUserId().equalsIgnoreCase("-1")) {
            return;
        }
        boolean skipCheckDataPerm = false;
        if (this.getOption().containsVariable("skipCheckDataPermission")) {
            skipCheckDataPerm = Boolean.parseBoolean(this.getOption().getVariableValue("skipCheckDataPermission"));
        }
        if (!skipCheckDataPerm && !OperateDataPermValidator.hasEnableOldDataRule()) {
            long userId = Long.parseLong(RequestContext.get().getUserId());
            String bizAppId = this.getOption().getVariableValue("currbizappid", null);
            String displayName = mainType.getDisplayName().getLocaleValue();
            displayName = StringUtils.isBlank((CharSequence)displayName) ? mainType.getName() : displayName;
            HashMap<Object, ExtendedDataEntity> allDatas = new HashMap<Object, ExtendedDataEntity>(16);
            for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
                allDatas.put(dataEntity.getBillPkId(), dataEntity);
            }
            PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
            Map resultMap = permissionService.matchDataRule(userId, bizAppId, mainType.getName(), permissionItemId, allDatas.keySet().toArray(), new HashMap());
            if (resultMap != null) {
                for (Map.Entry entry : resultMap.entrySet()) {
                    if (((Boolean)entry.getValue()).booleanValue()) continue;
                    this.addFatalErrorMessage((ExtendedDataEntity)allDatas.get(entry.getKey()), String.format(ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff0c\u60a8\u6ca1\u6709[%1$s][%2$s]\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OperateDataPermValidator_0", (String)"bos-mservice-operation", (Object[])new Object[0]), this.getOperationName(), displayName));
                }
            }
        }
    }

    private static boolean hasEnableOldDataRule() {
        DynamicObject dObj = BusinessDataServiceHelper.loadSingleFromCache((Object)1L, (String)"perm_olddataruleenable");
        if (dObj == null) {
            return true;
        }
        return dObj.getBoolean("enable_olddatarule");
    }

    private String getPermssionItemId() {
        String permissionEntityId = this.getOption().getVariableValue("permissionentityid", "");
        Map operateMetaMap = EntityMetadataCache.getDataEntityOperate((String)(StringUtils.isNotBlank((CharSequence)permissionEntityId) ? permissionEntityId : this.getEntityKey()), (String)this.getOperateKey());
        if (operateMetaMap == null) {
            return null;
        }
        return (String)operateMetaMap.get("permission");
    }
}

