/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.formplugin;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.service.cache.LicenseCache;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class AppWhiteListPluginListPlugin
extends AbstractListPlugin {
    private static final String BARITEM_ADD = "btn_add";
    public static final String APPWHITELIST = "lic_appwhitelist";
    public static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";

    public void itemClick(ItemClickEvent evt) {
        String itemkey = evt.getItemKey();
        switch (itemkey.toLowerCase(Locale.ENGLISH)) {
            case "btn_add": {
                this.showAppF7TreeList();
                break;
            }
        }
    }

    private void showAppF7TreeList() {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"bos_devportal_app_layout", (boolean)false);
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u901a\u7528\u5e94\u7528\u9009\u62e9", (String)"AppWhiteListPluginListPlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        listShowParameter.setFormId("bos_devp_apptreelistf7");
        listShowParameter.setCustomParam("onlyvisible", (Object)true);
        List<String> selectAppIds = this.getSelectAppIds();
        listShowParameter.setSelectedRows(selectAppIds.toArray());
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addappcallback"));
        listShowParameter.setMultiSelect(true);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private List<String> getSelectAppIds() {
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)APPWHITELIST, (String)"bizapp.id", null);
        LinkedList<String> selectAppIds = new LinkedList<String>();
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                selectAppIds.add(dynamicObject.getString("bizapp.id"));
            }
        }
        return selectAppIds;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String key = evt.getActionId();
        if ("addappcallback".equals(key) && evt.getReturnData() != null) {
            ListSelectedRowCollection rt = (ListSelectedRowCollection)evt.getReturnData();
            Object[] primaryKeyValues = rt.getPrimaryKeyValues();
            List<String> bizAppIds = Arrays.stream(primaryKeyValues).map(Object::toString).collect(Collectors.toList());
            this.addAppCloseCallBack(bizAppIds);
        }
    }

    private void addAppCloseCallBack(List<String> appIds) {
        try (TXHandle h = TX.required();){
            DynamicObjectCollection insertDoc = new DynamicObjectCollection();
            try {
                DeleteServiceHelper.delete((String)APPWHITELIST, null);
                for (String appid : appIds) {
                    DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)APPWHITELIST);
                    object.set("bizapp", (Object)appid);
                    insertDoc.add((Object)object);
                }
                SaveServiceHelper.save((DynamicObject[])((DynamicObject[])insertDoc.toArray((Object[])new DynamicObject[0])));
                LicenseCache.clearCache4AvailableApp();
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"AppWhiteListPluginListPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(2000));
        ((IListView)this.getView()).refresh();
    }
}

