/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class LegalPersonAssignLicPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(LegalPersonAssignLicPlugin.class);
    private static final String ENTITY_NAME = "lic_legalpersonassign";
    private static final String LEGAL_PERSON = "legalperson";
    private static final String ASSIGNED_NUM = "assignedlicnums";
    private static final String USED_NUM = "usedlicnums";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String TOOL_BAR = "toolbarap";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Long id = Long.valueOf(fsp.getCustomParam("licgroupid").toString());
        if (id != null) {
            DB.query((DBRoute)DBRoute.basedata, (String)("select forgid,fassignednum,fusednum from t_lic_legalassign where fgroupid = " + id), k -> {
                while (k.next()) {
                    int row = this.getModel().createNewEntryRow(ENTRY_ENTITY);
                    this.getModel().setValue(LEGAL_PERSON, (Object)k.getLong("forgid"), row);
                    this.getModel().setValue(ASSIGNED_NUM, (Object)k.getLong("fassignednum"), row);
                    this.getModel().setValue(USED_NUM, (Object)k.getLong("fusednum"), row);
                }
                this.getView().updateView(ENTRY_ENTITY);
                return true;
            });
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOL_BAR});
        EntryGrid grid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        BasedataEdit bde = (BasedataEdit)this.getControl(LEGAL_PERSON);
        bde.addBeforeF7SelectListener(k -> {
            List corporateOrg = OrgUnitServiceHelper.getCorporateOrg((boolean)false);
            ArrayList<Long> ids = new ArrayList<Long>(corporateOrg.size());
            for (Map map : corporateOrg) {
                Long id = (Long)map.get("id");
                ids.add(id);
            }
            EntryData entryData = grid.getEntryData();
            if (entryData != null) {
                DynamicObject[] dynamicObjects;
                for (DynamicObject dynamicObject : dynamicObjects = entryData.getDataEntitys()) {
                    DynamicObject object = dynamicObject.getDynamicObject(LEGAL_PERSON);
                    if (object == null) continue;
                    Long pkValue = (Long)object.getPkValue();
                    ids.remove(pkValue);
                }
            }
            k.getCustomQFilters().add(new QFilter("id", "in", ids));
        });
        Control legalpersonCtl = this.getView().getControl(LEGAL_PERSON);
        if (null != legalpersonCtl) {
            OrgEdit legalperson = (OrgEdit)legalpersonCtl;
            legalperson.addBeforeF7SelectListener(new BeforeF7SelectListener(){

                public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                    FormShowParameter formShowParameter = beforeF7SelectEvent.getFormShowParameter();
                    formShowParameter.setCaption(ResManager.loadKDString((String)"\u6cd5\u4eba\u516c\u53f8", (String)"LegalPersonAssignLicPlugin_5", (String)"bos-license-formplugin", (Object[])new Object[0]));
                    formShowParameter.addCustPlugin("kd.bos.license.formplugin.LicenseLegalPersonF7Plugin");
                }
            });
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("save".equals(itemKey)) {
            this.save();
        }
    }

    private void save() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Long licGroupId = Long.valueOf(fsp.getCustomParam("licgroupid").toString());
        int endIndex = ((EntryGrid)this.getControl(ENTRY_ENTITY)).getEntryData().getEndIndex();
        if (endIndex == 0) {
            try {
                DB.execute((DBRoute)DBRoute.basedata, (String)("delete from t_lic_legalassign where fgroupid = " + licGroupId));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"LegalPersonAssignLicPlugin_0", (String)"bos-license-formplugin", (Object[])new Object[0]));
                return;
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"LegalPersonAssignLicPlugin_2", (String)"bos-license-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(endIndex);
        ORM orm = ORM.create();
        long[] ids = orm.genLongIds("lic_legalassign", endIndex);
        LinkedList<Integer> emptyOrgList = new LinkedList<Integer>();
        int totalCount = 0;
        for (int i = 0; i < endIndex; ++i) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(LEGAL_PERSON, i);
            if (org == null) {
                emptyOrgList.add(i);
                continue;
            }
            int assignedNum = (Integer)this.getModel().getValue(ASSIGNED_NUM, i);
            int usedNum = (Integer)this.getModel().getValue(USED_NUM, i);
            if (usedNum > assignedNum) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684\u201c\u5df2\u4f7f\u7528\u8bb8\u53ef\u6570\u201d\u5927\u4e8e\u201c\u5206\u914d\u8bb8\u53ef\u6570\u201d,\u4fdd\u5b58\u5931\u8d25\u3002", (String)"LegalPersonAssignLicPlugin_1", (String)"bos-license-formplugin", (Object[])new Object[]{i + 1}));
                return;
            }
            if (assignedNum == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684\u201c\u5206\u914d\u8bb8\u53ef\u6570\u201d\u4e3a0,\u4fdd\u5b58\u5931\u8d25\u3002", (String)"LegalPersonAssignLicPlugin_4", (String)"bos-license-formplugin", (Object[])new Object[]{i + 1}));
                return;
            }
            paramList.add(new Object[]{org.getPkValue(), assignedNum, usedNum, ids[i]});
            totalCount += assignedNum;
        }
        this.getModel().deleteEntryRows(ENTRY_ENTITY, emptyOrgList.stream().mapToInt(Integer::valueOf).toArray());
        if (paramList.isEmpty()) {
            try {
                DB.execute((DBRoute)DBRoute.basedata, (String)("delete from t_lic_legalassign where fgroupid = " + licGroupId));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"LegalPersonAssignLicPlugin_0", (String)"bos-license-formplugin", (Object[])new Object[0]));
                return;
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                return;
            }
        }
        int count = (Integer)DB.query((DBRoute)DBRoute.basedata, (String)("select ftotalcount from t_lic_licensedetail where fgroupid = " + licGroupId), k -> {
            int result = 0;
            while (k.next()) {
                result = k.getInt("ftotalcount");
            }
            return result;
        });
        if (totalCount > count) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u7684\u201c\u5206\u914d\u8bb8\u53ef\u6570\u201d\u603b\u548c\u5927\u4e8e\u5f53\u524d\u5206\u7ec4\u7684\u8bb8\u53ef\u6570\u91cf\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"LegalPersonAssignLicPlugin_3", (String)"bos-license-formplugin", (Object[])new Object[0]));
            return;
        }
        String sql = "insert into t_lic_legalassign (fgroupid, forgid, fassignednum, fusednum, fid) values (" + licGroupId + ",?,?,?,?)";
        try (TXHandle tx = TX.required();){
            try {
                DB.execute((DBRoute)DBRoute.basedata, (String)("delete from t_lic_legalassign where fgroupid = " + licGroupId));
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql, paramList);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"LegalPersonAssignLicPlugin_0", (String)"bos-license-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"LegalPersonAssignLicPlugin_2", (String)"bos-license-formplugin", (Object[])new Object[0]));
                tx.markRollback();
            }
        }
    }
}

