/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.formplugin;

import com.alibaba.fastjson.JSON;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.attachment.DisposableUrlParam;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.filter.SortType;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.engine.LicenseUserRelEngine;
import kd.bos.license.service.cache.LicenseCache;
import kd.bos.license.util.LicenseGroupUtil;
import kd.bos.license.util.LicenseModuleUtil;
import kd.bos.license.util.LicenseUtil;
import kd.bos.license.util.UserLicenseGroupUtil;
import kd.bos.list.BillList;
import kd.bos.list.ListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.DevVerifyServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.util.FileNameUtils;
import kd.bos.workflow.message.api.SmsUsingQuantities;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class LicenseDetailListPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(LicenseDetailListPlugin.class);
    public static final String PRODNAME = "prodname";
    public static final String GROUPNUMBER = "groupnumber";
    public static final String GROUPNAME = "groupname";
    public static final String GROUPDES = "groupdes";
    public static final String TOTALCOUNT = "totalcountlist";
    public static final String ASSIGNEDCOUNT = "assignedcountlist";
    public static final String REMAINCOUNT = "remaincountlist";
    public static final String LICENSETYPE = "licensetype";
    public static final String LEGALASSIGNEDCOUNT = "legalassignedcount";
    public static final String LEGALREMAINCOUNT = "legalremaincount";
    public static final String LEGALPERSONASSIGN = "legalpersonassign";
    public static final String TABPAGE_ASSIGN = "tabpage_assign";
    public static final String LEGALPERSONENTRY = "legalpersonentry";
    public static final String BEGINDATE = "begindate_visible";
    public static final String ENDDATE = "enddate_visible";
    public static final String DETAILID = "detailid";
    private Map<String, String> legalIllegalData = new HashMap<String, String>(16);
    private static final String LIC_MODULE = "lic_module";
    private static final String UDD_GROUP_TOTAL_COUNT = "999999";
    private int index = 0;
    private String[][] arrays = new String[][]{{ResManager.loadKDString((String)"\u5206\u7ec4\u7b80\u7801", (String)"LicenseDetailListPlugin_0", (String)"bos-license-formplugin", (Object[])new Object[0]), "groupnumber"}, {ResManager.loadKDString((String)"\u5206\u7ec4\u540d\u79f0", (String)"LicenseDetailListPlugin_1", (String)"bos-license-formplugin", (Object[])new Object[0]), "groupname"}, {ResManager.loadKDString((String)"\u4ea7\u54c1\u540d\u79f0", (String)"LicenseDetailListPlugin_12", (String)"bos-license-formplugin", (Object[])new Object[0]), "prodname"}, {ResManager.loadKDString((String)"\u5206\u7ec4\u63cf\u8ff0", (String)"LicenseDetailListPlugin_23", (String)"bos-license-formplugin", (Object[])new Object[0]), "groupdes"}, {ResManager.loadKDString((String)"\u8bb8\u53ef\u6570\u91cf", (String)"LicenseDetailListPlugin_3", (String)"bos-license-formplugin", (Object[])new Object[0]), "totalcountlist"}, {ResManager.loadKDString((String)"\u5df2\u5360\u8bb8\u53ef\u91cf", (String)"LicenseDetailListPlugin_4", (String)"bos-license-formplugin", (Object[])new Object[0]), "assignedcountlist"}, {ResManager.loadKDString((String)"\u5269\u4f59\u8bb8\u53ef\u91cf", (String)"LicenseDetailListPlugin_5", (String)"bos-license-formplugin", (Object[])new Object[0]), "remaincountlist"}, {ResManager.loadKDString((String)"\u8bb8\u53ef\u6587\u4ef6\u7c7b\u578b", (String)"LicenseDetailListPlugin_6", (String)"bos-license-formplugin", (Object[])new Object[0]), "licensetype"}, {ResManager.loadKDString((String)"\u8bb8\u53ef\u5df2\u5206\u914d\u6570\u91cf", (String)"LicenseDetailListPlugin_13", (String)"bos-license-formplugin", (Object[])new Object[0]), "legalassignedcount"}, {ResManager.loadKDString((String)"\u8bb8\u53ef\u5269\u4f59\u53ef\u5206\u914d\u6570\u91cf", (String)"LicenseDetailListPlugin_14", (String)"bos-license-formplugin", (Object[])new Object[0]), "legalremaincount"}, {ResManager.loadKDString((String)"\u79df\u8d41\u8d77\u59cb\u65f6\u95f4", (String)"LicenseDetailListPlugin_18", (String)"bos-license-formplugin", (Object[])new Object[0]), "begindate_visible"}, {ResManager.loadKDString((String)"\u79df\u8d41\u7ed3\u675f\u65f6\u95f4", (String)"LicenseDetailListPlugin_19", (String)"bos-license-formplugin", (Object[])new Object[0]), "enddate_visible"}};

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        CardEntry license = (CardEntry)this.getControl("license");
        final Map allLicenseModuleName = LicenseModuleUtil.getAllLicenseModuleName();
        license.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                LicenseDetailListPlugin.this.CardRowClickAddFilter(evt);
            }

            public void entryRowDoubleClick(RowClickEvent evt) {
                LicenseDetailListPlugin.this.CardRowClickAddFilter(evt);
            }
        });
        EntryGrid modulesentry = (EntryGrid)this.getControl("modulesentry");
        modulesentry.addPackageDataListener((Consumer)new Consumer<PackageDataEvent>(){

            @Override
            public void accept(PackageDataEvent packageDataEvent) {
                DynamicObject rowData = packageDataEvent.getRowData();
                if (null == rowData || null == rowData.getString("module")) {
                    return;
                }
                String number = rowData.getString("module.number");
                String nameVersion = (String)allLicenseModuleName.get(number);
                if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)nameVersion)) {
                    return;
                }
                rowData.set("module_name", (Object)nameVersion);
            }
        });
    }

    private void CardRowClickAddFilter(RowClickEvent evt) {
        int row = evt.getRow();
        EntryData entryData = ((CardEntry)evt.getSource()).getEntryData();
        String detailId = (String)entryData.getDataEntitys()[row].get("license_detail");
        String filters = this.getView().getPageCache().get("filters");
        Map filterMap = null;
        filterMap = kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)filters) ? new HashMap(10) : (Map)JSON.parseObject((String)filters, Map.class);
        filterMap.put(DETAILID, "detailid=" + detailId);
        this.getView().getPageCache().put("filters", JSON.toJSONString(filterMap));
        this.getView().getPageCache().put(DETAILID, detailId);
        BillList billlistap = (BillList)this.getControl("billlistap");
        billlistap.setClearSelection(true);
        billlistap.refresh();
        this.getModel().deleteEntryData("modulesentry");
        if (UserLicenseGroupUtil.isEnableLegalPersonAssign()) {
            this.getModel().deleteEntryData(LEGALPERSONENTRY);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("refresh".equals(actionId)) {
            BillList billlist = (BillList)this.getControl("billlistap");
            billlist.refresh();
        }
    }

    private void showConfigListForm() {
        ListShowParameter param = new ListShowParameter();
        param.setBillFormId("lic_stddevcfg");
        param.setFormId("lic_stddevcfglist");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setPageId(this.getView().getPageId() + "lic_stddevcfg");
        this.getView().showForm((FormShowParameter)param);
    }

    private void exportExcel() {
        SXSSFWorkbook wb = new SXSSFWorkbook();
        SXSSFSheet sheet = wb.createSheet("sheet1");
        CellStyle cellStyle = wb.createCellStyle();
        cellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        SXSSFRow row = sheet.createRow(this.addRowIndex());
        boolean enableLegalPersonAssign = UserLicenseGroupUtil.isEnableLegalPersonAssign();
        long userId = RequestContext.get().getCurrUserId();
        boolean isAdminUser = PermissionServiceHelper.isAdminUser((long)userId, (String)"10");
        int columnCount = 0;
        for (int i = 0; i < this.arrays.length; ++i) {
            if ((!enableLegalPersonAssign || !isAdminUser) && (i == 8 || i == 9) || i == 12) continue;
            Iterator cell = row.createCell(columnCount);
            cell.setCellStyle(cellStyle);
            cell.setCellValue(this.arrays[i][0]);
            sheet.setColumnWidth(columnCount++, this.arrays[i][0].getBytes().length * 2 * 160);
        }
        DynamicObjectCollection detailInfo = this.getLicDetailInfo();
        for (DynamicObject dynamicObject : detailInfo) {
            row = sheet.createRow(this.addRowIndex());
            columnCount = 0;
            for (int i = 0; i < this.arrays.length; ++i) {
                if ((!enableLegalPersonAssign || !isAdminUser) && (i == 8 || i == 9) || i == 12) continue;
                SXSSFCell cell = row.createCell(columnCount++);
                String value = i == 10 ? dynamicObject.getString(BEGINDATE) : (i == 11 ? dynamicObject.getString(ENDDATE) : dynamicObject.getString(this.arrays[i][1]));
                cell.setCellValue(value);
            }
        }
        try {
            String url = this.writeToFile((Workbook)wb);
            IClientViewProxy service = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            service.addAction("download", (Object)url);
        }
        catch (Exception e) {
            logger.error("LicenseDetailListPlugin.exportExcel : e = " + e);
        }
    }

    private int addRowIndex() {
        int index = this.getIndex();
        this.setIndex(index + 1);
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicObjectCollection getLicDetailInfo() {
        DynamicObjectCollection col = new DynamicObjectCollection((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"lic_license"), null);
        StringBuilder sql = new StringBuilder();
        String filterStr = this.getView().getPageCache().get("filters");
        boolean enableLegalPersonAssign = UserLicenseGroupUtil.isEnableLegalPersonAssign();
        if (enableLegalPersonAssign) {
            sql.append(" SELECT DISTINCT g.fname softwarename,a.fid detailid,f.fid id, a.fgroupid groupid, pl.fname prodname,g.fproductversion prodversion,a.fgroupid id,f.fnumber groupnumber,e.fname groupname,f.fgroupdes groupdes,f.ftype type,a.fbegindate begindate,a.fenddate enddate, ");
            sql.append(" a.ftotalcount totalcountlist,a.fassignedcount assignedcountlist,a.fremaincount remaincountlist,g.ftype licensetype,sum(d.fassignednum) legalassignedcount ");
            sql.append(" from t_lic_licensedetail a ");
            sql.append(" INNER JOIN t_lic_license g on g.fid = a.fid ");
            sql.append(" INNER JOIN t_lic_group f on f.fid = a.fgroupid ");
            sql.append(" LEFT JOIN t_lic_legalassign d on f.fid = d.fgroupid ");
            sql.append(" INNER JOIN t_lic_group_l e on e.fid = a.fgroupid and ");
            sql.append(String.format(" e.flocaleid = '%s' ", Locale.getDefault().toString()));
            sql.append(" left outer join t_lic_isvprod p on p.fid = g.fprodid ");
            sql.append(" left outer join t_lic_isvprod_l pl on pl.fid = p.fid and ");
            sql.append(String.format(" pl.flocaleid = '%s' ", Locale.getDefault().toString()));
            sql.append(" group by g.fname,a.fid,f.fid,a.fgroupid,pl.fname,g.fproductversion,a.fgroupid,f.fnumber,e.fname ,f.ftype,a.ftotalcount,a.fassignedcount,a.fremaincount,g.ftype,a.fbegindate,a.fenddate");
        } else {
            sql.append(" SELECT DISTINCT g.fname softwarename,a.fid detailid,f.fid id, a.fgroupid groupid, pl.fname prodname,g.fproductversion prodversion,a.fgroupid id,f.fnumber groupnumber,e.fname groupname,f.fgroupdes groupdes,f.ftype type,a.fbegindate begindate,a.fenddate enddate,");
            sql.append(" a.ftotalcount totalcountlist,a.fassignedcount assignedcountlist,a.fremaincount remaincountlist,g.ftype licensetype ");
            sql.append(" from t_lic_licensedetail a ");
            sql.append(" INNER JOIN t_lic_license g on g.fid = a.fid ");
            sql.append(" INNER JOIN t_lic_group f on f.fid = a.fgroupid ");
            sql.append(" INNER JOIN t_lic_group_l e on e.fid = a.fgroupid and ");
            sql.append(String.format(" e.flocaleid = '%s' ", Locale.getDefault().toString()));
            sql.append(" left outer join t_lic_isvprod p on p.fid = g.fprodid ");
            sql.append(" left outer join t_lic_isvprod_l pl on pl.fid = p.fid and ");
            sql.append(String.format(" pl.flocaleid = '%s' ", Locale.getDefault().toString()));
        }
        Map licenseGroup = LicenseGroupUtil.getLicenseGroup(null);
        ArrayList dataList = new ArrayList(10);
        DataSet exportDataSet = null;
        boolean isHighAvailabilityMode = LicenseUtil.isHighAvailabilityMode();
        Map licAllocateNumberByGroupIds = new HashMap(0);
        if (isHighAvailabilityMode && !LicenseCache.isCtrlAmountIgnoreTime() && !Boolean.parseBoolean(LicenseServiceHelper.getPubTenantType())) {
            Map hasBoughtRegLicGroup = LicenseGroupUtil.getHasBoughtRegLicGroup();
            Iterator groupIds = new ArrayList(32);
            if (!CollectionUtils.isEmpty((Map)hasBoughtRegLicGroup)) {
                for (String groupIdStr : hasBoughtRegLicGroup.keySet()) {
                    groupIds.add(Long.parseLong(groupIdStr));
                }
            }
            licAllocateNumberByGroupIds = LicenseUserRelEngine.getLicAllocateNumberByGroupIds(groupIds);
        }
        try {
            exportDataSet = DB.queryDataSet((String)"export_license_detail", (DBRoute)DBRoute.basedata, (String)sql.toString());
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)filterStr) && !"[]".equals(filterStr)) {
                Map filters = (Map)JSON.parseObject((String)filterStr, Map.class);
                for (String filter : filters.values()) {
                    exportDataSet = exportDataSet.filter(filter);
                }
            }
            Map licenseGroupDes = LicenseGroupUtil.getLicenseGroupDes((String)LicenseServiceHelper.getProductVersion());
            for (Row row : exportDataSet) {
                HashMap<String, Object> dataInfo = new HashMap<String, Object>(16);
                String groupId = row.getString("groupid");
                String softWareName = row.getString("softwarename");
                String name = row.getString(PRODNAME);
                if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)softWareName)) {
                    name = softWareName.contains("kingdee eas nextcloud") ? ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u00b7\u82cd\u7a79", (String)"LicenseDetailListPlugin_26", (String)"bos-license-formplugin", (Object[])new Object[0]) : softWareName;
                }
                dataInfo.put(PRODNAME, name);
                dataInfo.put(GROUPNUMBER, row.getString(GROUPNUMBER));
                if (licenseGroup.containsKey(groupId)) {
                    dataInfo.put(GROUPNAME, licenseGroup.get(groupId));
                } else {
                    dataInfo.put(GROUPNAME, row.getString(GROUPNAME));
                }
                String groupDes = row.getString(GROUPDES);
                String groupDesVersion = (String)licenseGroupDes.get(groupId);
                if (!kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)groupDesVersion)) {
                    groupDes = groupDesVersion;
                }
                dataInfo.put(GROUPDES, kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)groupDes) ? row.getString("type") : groupDes);
                Integer totalCount = row.getInteger(TOTALCOUNT);
                dataInfo.put(TOTALCOUNT, totalCount);
                Integer assCount = row.getInteger(ASSIGNEDCOUNT);
                long groupIdL = Long.parseLong(groupId);
                Integer regAssCount = (Integer)licAllocateNumberByGroupIds.get(groupIdL);
                Integer remainCount = row.getInteger(REMAINCOUNT);
                if (isHighAvailabilityMode && null != regAssCount) {
                    assCount = regAssCount;
                    remainCount = totalCount - regAssCount;
                }
                dataInfo.put(ASSIGNEDCOUNT, assCount);
                if (enableLegalPersonAssign) {
                    int legalCount = 0;
                    Integer count = row.getInteger(LEGALASSIGNEDCOUNT);
                    if (null != count) {
                        legalCount = count;
                    }
                    dataInfo.put(LEGALASSIGNEDCOUNT, legalCount);
                    int legalRemainCount = row.getInteger(TOTALCOUNT) - legalCount;
                    if (groupId.equals("16")) {
                        dataInfo.put(LEGALREMAINCOUNT, legalRemainCount * 10000);
                    } else {
                        dataInfo.put(LEGALREMAINCOUNT, legalRemainCount);
                    }
                }
                if (remainCount < 0) {
                    remainCount = 0;
                }
                dataInfo.put(REMAINCOUNT, remainCount);
                dataInfo.put(LICENSETYPE, row.getString(LICENSETYPE));
                dataInfo.put(BEGINDATE, row.getDate("begindate"));
                dataInfo.put(ENDDATE, row.getDate("enddate"));
                dataInfo.put("id", row.getString("id"));
                if (groupId.equals("16")) {
                    long total = Long.parseLong(String.valueOf(dataInfo.get(TOTALCOUNT)));
                    long actTotal = total * 10000L;
                    dataInfo.put(TOTALCOUNT, actTotal);
                    SmsUsingQuantities smsUsingQuantitySummary = MessageCenterServiceHelper.getSmsUsingQuantitySummary();
                    Long successSum = smsUsingQuantitySummary.getSuccessSum();
                    Long sum = 0L;
                    if (null != successSum) {
                        sum = successSum;
                    }
                    dataInfo.put(ASSIGNEDCOUNT, sum);
                    Long remain = actTotal - sum;
                    if (remain < 0L) {
                        remain = 0L;
                    }
                    dataInfo.put(REMAINCOUNT, remain);
                }
                if (groupId.equals("441")) {
                    try {
                        long total = Long.parseLong(String.valueOf(dataInfo.get(TOTALCOUNT)));
                        long enableSuccessCount = WorkflowServiceHelper.getEnableProcessCount();
                        dataInfo.put(ASSIGNEDCOUNT, enableSuccessCount);
                        long remain = total - enableSuccessCount;
                        if (remain < 0L) {
                            remain = 0L;
                        }
                        dataInfo.put(REMAINCOUNT, remain);
                    }
                    catch (Exception e) {
                        logger.error("\u83b7\u53d6\u6d41\u7a0b\u670d\u52a1\u4e91\u6d41\u91cf\u7248\u8ba1\u6570\u5f02\u5e38", (Throwable)e);
                    }
                }
                dataList.add(dataInfo);
            }
        }
        catch (Exception e) {
            logger.error("\u5f15\u51fa\u8bb8\u53ef\u8be6\u60c5\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
        }
        finally {
            if (null != exportDataSet) {
                exportDataSet.close();
            }
        }
        this.getPageCache().put("size", dataList.size() + "");
        for (int i = 0; i < dataList.size(); ++i) {
            Map map = (Map)dataList.get(i);
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"lic_license");
            dynamicObject.set(PRODNAME, map.get(PRODNAME));
            dynamicObject.set(GROUPNUMBER, map.get(GROUPNUMBER));
            dynamicObject.set(GROUPNAME, map.get(GROUPNAME));
            dynamicObject.set(GROUPDES, (Object)LicenseDetailListPlugin.getGroupDes(String.valueOf(map.get(GROUPDES))));
            dynamicObject.set(TOTALCOUNT, map.get(TOTALCOUNT));
            if (enableLegalPersonAssign) {
                dynamicObject.set(LEGALASSIGNEDCOUNT, map.get(LEGALASSIGNEDCOUNT));
                dynamicObject.set(LEGALREMAINCOUNT, map.get(LEGALREMAINCOUNT));
            }
            dynamicObject.set(ASSIGNEDCOUNT, map.get(ASSIGNEDCOUNT));
            dynamicObject.set(REMAINCOUNT, map.get(REMAINCOUNT));
            dynamicObject.set(LICENSETYPE, (Object)(map.get(LICENSETYPE).equals("1") ? ResManager.loadKDString((String)"\u6b63\u5f0f", (String)"LicenseDetailListPlugin_10", (String)"bos-license-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e34\u65f6", (String)"LicenseDetailListPlugin_11", (String)"bos-license-formplugin", (Object[])new Object[0])));
            dynamicObject.set(BEGINDATE, map.get(BEGINDATE));
            Date endDate = (Date)map.get(ENDDATE);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(endDate);
            if (calendar.get(1) < 2099) {
                dynamicObject.set(ENDDATE, (Object)endDate);
            } else {
                dynamicObject.set(ENDDATE, (Object)ResManager.loadKDString((String)"\u4e0d\u9650", (String)"LicenseDetailListPlugin_20", (String)"bos-license-formplugin", (Object[])new Object[0]));
            }
            dynamicObject.set("id", map.get("id"));
            col.add((Object)dynamicObject);
        }
        return col;
    }

    private static String getGroupDes(String type) {
        switch (type) {
            case "1": {
                return ResManager.loadKDString((String)"\u6ce8\u518c\u7528\u6237", (String)"LicenseDetailListPlugin_8", (String)"bos-license-formplugin", (Object[])new Object[0]);
            }
            case "2": {
                return ResManager.loadKDString((String)"\u7279\u6027", (String)"LicenseDetailListPlugin_9", (String)"bos-license-formplugin", (Object[])new Object[0]);
            }
            case "3": {
                return ResManager.loadKDString((String)"\u5458\u5de5\u6570\u91cf", (String)"LicenseDetailListPlugin_21", (String)"bos-license-formplugin", (Object[])new Object[0]);
            }
            case "4": {
                return ResManager.loadKDString((String)"\u7a0e\u53f7", (String)"LicenseDetailListPlugin_22", (String)"bos-license-formplugin", (Object[])new Object[0]);
            }
            case "5": {
                return ResManager.loadKDString((String)"\u7b7e\u7f72\u6b21\u6570", (String)"LicenseDetailListPlugin_27", (String)"bos-license-formplugin", (Object[])new Object[0]);
            }
            case "6": {
                return ResManager.loadKDString((String)"\u9879\u76ee\u6570\u91cf", (String)"LicenseDetailListPlugin_28", (String)"bos-license-formplugin", (Object[])new Object[0]);
            }
        }
        return type;
    }

    private String writeToFile(Workbook workbook) throws IOException {
        FileService service = FileServiceFactory.getAttachmentFileService();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        workbook.write((OutputStream)os);
        byte[] data = os.toByteArray();
        TempFileCache tempFile = CacheFactory.getCommonCacheFactory().getTempFileCache();
        LocalDate now = LocalDate.now();
        StringBuilder fileName = new StringBuilder();
        fileName.append(ResManager.loadKDString((String)"\u5bfc\u51fa\u5217\u8868_\u8bb8\u53ef\u5206\u7ec4_", (String)"LicenseDetailListPlugin_7", (String)"bos-license-formplugin", (Object[])new Object[0]));
        fileName.append(String.format("%02d%02d", now.getMonthValue(), now.getDayOfMonth()));
        fileName.append(".xlsx");
        String url = tempFile.saveAsUrl(fileName.toString(), data, data.length);
        RequestContext ctx = RequestContext.getOrCreate();
        String path = FileNameUtils.getExportFileName((String)ctx.getTenantId(), (String)ctx.getAccountId(), (String)"83bfebc8000037ac", (String)("18QCB4INQ9EO" + UUID.randomUUID().toString()), (String)fileName.toString());
        url = service.upload(new FileItem(fileName.toString(), path, tempFile.getInputStream(url)));
        DisposableUrlParam disposableUrlParam = new DisposableUrlParam();
        disposableUrlParam.setPath(url);
        disposableUrlParam.setEntityNum("lic_license");
        disposableUrlParam.setPkId((Object)"lic_license");
        disposableUrlParam.setPermItem("donothing");
        return AttachmentServiceHelper.genCustomAttachUrl((DisposableUrlParam)disposableUrlParam);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List listColumns = args.getListColumns();
        boolean enableLegalPersonAssign = UserLicenseGroupUtil.isEnableLegalPersonAssign();
        for (String[] arr : this.arrays) {
            if (arr[1].equals(LICENSETYPE) || !enableLegalPersonAssign && (arr[1].equals(LEGALASSIGNEDCOUNT) || arr[1].equals(LEGALREMAINCOUNT))) continue;
            ListColumn listColumn = this.createListColumn(arr);
            listColumns.add(listColumn);
        }
    }

    public ListColumn createListColumn(String[] arr) {
        ListColumn listColumn = new ListColumn();
        listColumn.setCaption(new LocaleString(arr[0]));
        listColumn.setClassName("className");
        listColumn.setFieldName(arr[1]);
        listColumn.setKey("key" + arr[1]);
        listColumn.setTextAlign("left");
        listColumn.setWidth(new LocaleString("12%"));
        listColumn.setParentViewKey("gridview");
        listColumn.setListFieldKey(arr[1]);
        listColumn.setSeq(2);
        listColumn.setVisible(11);
        if (arr[1].equals(GROUPNAME)) {
            listColumn.setOrder(SortType.ASC.toString());
        }
        return listColumn;
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        evt.setCancel(true);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new LicDetailListDataProviderImpl());
    }

    public void listRowClick(ListRowClickEvent evt) {
        TableValueSetter vs;
        super.listRowClick(evt);
        this.getModel().deleteEntryData("modulesentry");
        ListSelectedRow listSelectedRow = evt.getCurrentListSelectedRow();
        if (listSelectedRow == null) {
            return;
        }
        Long licenseDetailId = (Long)listSelectedRow.getPrimaryKeyValue();
        String sql = "select ld.fbegindate,ld.fenddate,lga.fbizappid fbizappid, lga.fmoduleid fmoduleid,lga.fmodulebegindate,lga.fmoduleenddate  from t_lic_licensegroupapps lga INNER JOIN t_lic_licensedetail ld ON lga.fentryid = ld.fentryid WHERE ld.fgroupid = " + licenseDetailId;
        List modules = (List)DB.query((DBRoute)DBRoute.base, (String)sql, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                ArrayList<Map<String, Object>> modules = new ArrayList<Map<String, Object>>(16);
                while (rs.next()) {
                    Timestamp endDate;
                    if (!kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)rs.getString("fmoduleid"))) continue;
                    HashMap<String, Object> map = new HashMap<String, Object>(4);
                    Timestamp beginDate = rs.getTimestamp("fmodulebegindate");
                    if (ObjectUtils.isEmpty((Object)beginDate)) {
                        beginDate = rs.getTimestamp("fbegindate");
                    }
                    if (ObjectUtils.isEmpty((Object)(endDate = rs.getTimestamp("fmoduleenddate")))) {
                        endDate = rs.getTimestamp("fenddate");
                    }
                    if (ObjectUtils.isEmpty((Object)beginDate) || ObjectUtils.isEmpty((Object)endDate)) continue;
                    map.put("moduleid", rs.getString("fmoduleid"));
                    map.put("begindate", beginDate);
                    map.put("enddate", endDate);
                    modules.add(map);
                }
                return modules;
            }
        });
        Date now = new Date();
        modules.sort((o1, o2) -> {
            try {
                boolean isValid2;
                Date beginDate1 = (Date)o1.get("begindate");
                Date endDate1 = (Date)o1.get("enddate");
                boolean isValid1 = beginDate1.before(now) && endDate1.after(now);
                Date beginDate2 = (Date)o2.get("begindate");
                Date endDate2 = (Date)o2.get("enddate");
                boolean bl = isValid2 = beginDate2.before(now) && endDate2.after(now);
                if (isValid1 && isValid2) {
                    return beginDate1.compareTo(beginDate2);
                }
                if (isValid1 && !isValid2) {
                    return -1;
                }
                if (!isValid1 && isValid2) {
                    return 1;
                }
                return beginDate2.compareTo(beginDate1);
            }
            catch (Exception e) {
                return 1;
            }
        });
        if (modules != null && !modules.isEmpty()) {
            this.getModel().beginInit();
            vs = new TableValueSetter(new String[]{"module", "modulebegindate", "moduleenddate"});
            for (Map moduleMap : modules) {
                vs.addRow(new Object[]{Long.valueOf((String)moduleMap.get("moduleid")), moduleMap.get("begindate"), moduleMap.get("enddate")});
            }
            ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("modulesentry", vs);
            this.getModel().endInit();
            this.getView().updateView("modulesentry");
        }
        if (UserLicenseGroupUtil.isEnableLegalPersonAssign()) {
            this.getModel().deleteEntryData(LEGALPERSONENTRY);
            this.getModel().beginInit();
            vs = new TableValueSetter(new String[]{"legalperson", "assignedcount", "usedcount"});
            DB.query((DBRoute)DBRoute.basedata, (String)("select forgid,fassignednum,fusednum from t_lic_legalassign where fgroupid = " + licenseDetailId), k -> {
                while (k.next()) {
                    vs.addRow(new Object[]{k.getLong("forgid"), k.getLong("fassignednum"), k.getLong("fusednum")});
                }
                ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(LEGALPERSONENTRY, vs);
                this.getModel().endInit();
                this.getView().updateView(LEGALPERSONENTRY);
                return true;
            });
        }
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        if (CollectionUtils.isEmpty((Collection)qFilters)) {
            String filters = this.getView().getPageCache().get("filters");
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)filters)) {
                Map filterMap = (Map)JSON.parseObject((String)filters, Map.class);
                filterMap.remove("searchFilters");
                this.getView().getPageCache().put("filters", JSON.toJSONString((Object)filterMap));
            }
            return;
        }
        StringBuilder sqlFilter = new StringBuilder();
        Map licenseGroup = LicenseGroupUtil.getLicenseGroup(null);
        boolean isEmptyed = true;
        boolean isFirst = true;
        for (QFilter qFilter : qFilters) {
            String sql;
            if (isFirst) {
                isFirst = false;
            } else {
                sqlFilter.append(" and ");
            }
            if (!kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)(sql = this.parseSearchQFilter(qFilter, licenseGroup)))) continue;
            isEmptyed = false;
            sqlFilter.append(sql);
        }
        if (!isEmptyed) {
            String filters = this.getView().getPageCache().get("filters");
            Map filterMap = null;
            filterMap = kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)filters) ? new HashMap(10) : (Map)JSON.parseObject((String)filters, Map.class);
            filterMap.put("searchFilters", sqlFilter.toString());
            this.getView().getPageCache().put("filters", JSON.toJSONString(filterMap));
        }
    }

    private String parseSearchQFilter(QFilter filter, Map<String, String> licenseGroup) {
        if (null == filter) {
            return "";
        }
        StringBuilder filterSql = new StringBuilder();
        String value = String.valueOf(filter.getValue());
        int splitLocation = value.indexOf(35);
        if (splitLocation == -1) {
            return "";
        }
        String propertyStr = value.substring(0, value.indexOf(35));
        String[] properties = propertyStr.split(",");
        String searchContentStr = value.substring(splitLocation + 1);
        String[] searchContent = searchContentStr.split("\b");
        boolean isSearchGroupName = false;
        for (String searchStr : searchContent) {
            if ('%' == searchStr.charAt(0)) {
                searchStr = searchStr.substring(1, searchStr.length() - 1);
            }
            for (String property : properties) {
                filterSql.append(" or ");
                if ("lic_licensedetail.group.name".equals(property)) {
                    isSearchGroupName = true;
                    filterSql.append("upper(").append(GROUPNAME).append(')').append(" like '%").append(searchStr.toUpperCase()).append("%' ");
                    continue;
                }
                if (!"lic_licensedetail.group.number".equals(property)) continue;
                filterSql.append("upper(").append(GROUPNUMBER).append(')').append(" like '%").append(searchStr.toUpperCase()).append("%' ");
            }
        }
        if (isSearchGroupName && !CollectionUtils.isEmpty(licenseGroup)) {
            HashSet<Long> groupIds = new HashSet<Long>(6);
            for (Map.Entry<String, String> group : licenseGroup.entrySet()) {
                String groupId = group.getKey();
                String groupName = group.getValue();
                for (String searchStr : searchContent) {
                    if ('%' == searchStr.charAt(0)) {
                        searchStr = searchStr.substring(1, searchStr.length() - 1);
                    }
                    if (!StringUtils.containsIgnoreCase((CharSequence)groupName, (CharSequence)searchStr)) continue;
                    groupIds.add(Long.parseLong(groupId));
                }
            }
            if (!groupIds.isEmpty()) {
                filterSql.append(" or ").append("groupid in (").append(this.getSqlListLong(groupIds)).append(')');
            }
        }
        filterSql.append(')');
        return '(' + filterSql.substring(4);
    }

    private String getSqlListLong(Set<Long> groupIds) {
        if (CollectionUtils.isEmpty(groupIds)) {
            return "";
        }
        boolean first = true;
        StringBuilder sqlList = new StringBuilder();
        for (Long one : groupIds) {
            if (first) {
                first = false;
                sqlList.append(one);
                continue;
            }
            sqlList.append(',').append(one);
        }
        return sqlList.toString();
    }

    public void afterCreateNewData(EventObject e) {
        this.loadLicenseCard();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        QFilter groupFilter = new QFilter("lic_licensedetail.group", "=", (Object)252L);
        QFilter totalFilter = new QFilter("lic_licensedetail.totalcount", ">", (Object)0);
        boolean exists = QueryServiceHelper.exists((String)"lic_license", (QFilter[])new QFilter[]{groupFilter, totalFilter});
        this.getView().setVisible(Boolean.valueOf(exists), new String[]{"btnconfig"});
        boolean enableLegalPersonAssign = UserLicenseGroupUtil.isEnableLegalPersonAssign();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{PRODNAME});
        long userId = RequestContext.get().getCurrUserId();
        if (!enableLegalPersonAssign || !PermissionServiceHelper.isAdminUser((long)userId, (String)"10")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{LEGALASSIGNEDCOUNT, LEGALREMAINCOUNT, LEGALPERSONASSIGN, TABPAGE_ASSIGN});
        }
        boolean isModuleVisible = true;
        int modeType = LicenseServiceHelper.getModeType();
        if (modeType != 2 && modeType != 4) {
            try {
                isModuleVisible = Float.parseFloat(LicenseServiceHelper.getProductVersion()) >= 4.0f;
            }
            catch (Exception exception) {
                logger.error("ProductVersion parse error.", (Throwable)exception);
            }
        }
        this.getView().setVisible(Boolean.valueOf(isModuleVisible), new String[]{"detail_panel", "division_panel"});
        if (!isModuleVisible) {
            SplitContainer splitcontainerap = (SplitContainer)this.getControl("splitcontainerap");
            splitcontainerap.changeFlexStatus(SplitDirection.right, true);
        }
        this.showMessage();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (null == operateKey || operationResult != null && !operationResult.isSuccess()) {
            return;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        boolean isAdminUser = PermissionServiceHelper.isAdminUser((long)currUserId);
        switch (operateKey) {
            case "formconfig": {
                if (!isAdminUser) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u975e\u7ba1\u7406\u5458\uff0c\u65e0\u5f00\u53d1\u670d\u52a1\u878d\u5408\u7248\u8868\u5355\u914d\u7f6e\u6743\u9650\u3002", (String)"LicenseDetailListPlugin_52", (String)"bos-license-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.showConfigListForm();
                break;
            }
            case "donothing": {
                if (!isAdminUser) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u975e\u7ba1\u7406\u5458\uff0c\u65e0\u5bfc\u51fa\u6743\u9650\u3002", (String)"LicenseDetailListPlugin_53", (String)"bos-license-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.exportExcel();
                break;
            }
            case "legalpersonassign": {
                if (!isAdminUser) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u975e\u7ba1\u7406\u5458\uff0c\u65e0\u6cd5\u4eba\u516c\u53f8\u914d\u7f6e\u6743\u9650\u3002", (String)"LicenseDetailListPlugin_54", (String)"bos-license-formplugin", (Object[])new Object[0]));
                    return;
                }
                ListSelectedRowCollection selectedRows = this.getSelectedRows();
                if (selectedRows == null || selectedRows.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u6761\u8bb8\u53ef\u5206\u7ec4\u6570\u636e\u3002", (String)"LicenseDetailListPlugin_15", (String)"bos-license-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (selectedRows.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u4e00\u6761\u8bb8\u53ef\u5206\u7ec4\u6570\u636e\u8fdb\u884c\u201c\u6cd5\u4eba\u516c\u53f8\u914d\u7f6e\u201d\u3002", (String)"LicenseDetailListPlugin_16", (String)"bos-license-formplugin", (Object[])new Object[0]));
                    break;
                }
                ListSelectedRow row = selectedRows.get(0);
                Long licGroupId = (Long)row.getPrimaryKeyValue();
                DynamicObject group = LicenseCache.getGroupByID((Long)licGroupId);
                String groupType = group.getString("type");
                if (!"1".equals(groupType)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7279\u6027\u8bb8\u53ef\u4e0d\u652f\u6301\u6cd5\u4eba\u516c\u53f8\u914d\u7f6e\u3002", (String)"LicenseDetailListPlugin_17", (String)"bos-license-formplugin", (Object[])new Object[0]));
                    break;
                }
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("lic_legalpersonassign");
                parameter.setStatus(OperationStatus.EDIT);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCustomParam("licgroupid", (Object)licGroupId);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refresh"));
                this.getView().showForm(parameter);
                break;
            }
            case "refresh": {
                this.loadLicenseCard();
                this.getModel().deleteEntryData("modulesentry");
                if (!UserLicenseGroupUtil.isEnableLegalPersonAssign()) break;
                this.getModel().deleteEntryData(LEGALPERSONENTRY);
            }
        }
    }

    private void loadLicenseCard() {
        HashMap<String, String> productIdToName = new HashMap<String, String>(16);
        Map licProd = BusinessDataServiceHelper.loadFromCache((String)"lic_prod", (String)"productid,name", null);
        if (!CollectionUtils.isEmpty((Map)licProd)) {
            for (Map.Entry licProdInfo : licProd.entrySet()) {
                ILocaleString name;
                DynamicObject licProdDyn = (DynamicObject)licProdInfo.getValue();
                if (null == licProd || null == (name = licProdDyn.getLocaleString("name"))) continue;
                String localeValue = name.getLocaleValue();
                if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)localeValue)) {
                    localeValue = name.getLocaleValue_en();
                }
                if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)localeValue)) continue;
                productIdToName.put(licProdDyn.getString("productid"), localeValue);
            }
        }
        this.getModel().deleteEntryData("license");
        String detailId = this.getPageCache().get(DETAILID);
        String langName = RequestContext.get().getLang().name();
        StringBuilder sql = new StringBuilder();
        sql.append("select g.fid, g.fproductno,g.fproductid ,pl.fname name ,pll.fname defname,g.factivedate,g.fexpdate,g.ftype,g.fname softwarename,g.fproductversion licenseversion");
        sql.append(" from t_lic_license g left outer join t_lic_isvprod p ");
        sql.append(" on p.fid = g.fprodid left outer join t_lic_isvprod_l pl on pl.fid = p.fid and ");
        sql.append(String.format(" pl.flocaleid  = '%s' ", langName));
        sql.append(" left outer join t_lic_isvprod_l pll on pll.fid = p.fid and ");
        sql.append(String.format(" pll.flocaleid  = '%s' ", Locale.getDefault().toString()));
        sql.append(" order by pl.fname,g.fproductno");
        Integer selectRow = (Integer)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), rs -> {
            Integer selectCardRow = -1;
            while (rs.next()) {
                int row = this.getModel().createNewEntryRow("license");
                String id = rs.getString("fid");
                String productId = rs.getString("fproductid");
                String softWareName = (String)productIdToName.get(productId);
                if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)softWareName)) {
                    softWareName = rs.getString("softwarename");
                }
                String name = rs.getString("name");
                String licVersion = rs.getString("licenseversion");
                if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)softWareName)) {
                    name = softWareName.contains("kingdee eas nextcloud") || softWareName.equals("kingdee cloud 5.0 for education") ? ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u00b7\u82cd\u7a79", (String)"LicenseDetailListPlugin_26", (String)"bos-license-formplugin", (Object[])new Object[0]) : softWareName;
                } else if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)name)) {
                    name = rs.getString("defname");
                }
                this.getModel().setValue("license_name", (Object)name, row);
                this.getModel().setValue("license_detail", (Object)id, row);
                if (null != id && id.equals(detailId)) {
                    selectCardRow = row;
                }
                this.getModel().setValue("licprodsn", (Object)rs.getString("fproductno"), row);
                java.sql.Date endDate = rs.getDate("fexpdate");
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(endDate);
                if (calendar.get(1) < 2099) {
                    this.getModel().setValue("licprodtime", (Object)(DateUtils.formatDate((Date)rs.getDate("factivedate"), (Object[])new Object[]{"yyyy-MM-dd"}) + " " + ResManager.loadKDString((String)"\u81f3", (String)"LicenseDetailListPlugin_51", (String)"bos-license-formplugin", (Object[])new Object[0]) + " " + DateUtils.formatDate((Date)endDate, (Object[])new Object[]{"yyyy-MM-dd"})), row);
                } else {
                    this.getModel().setValue("licprodtime", (Object)ResManager.loadKDString((String)"\u4e0d\u9650", (String)"LicenseDetailListPlugin_20", (String)"bos-license-formplugin", (Object[])new Object[0]), row);
                }
                this.getModel().setValue(LICENSETYPE, (Object)("1".equals(rs.getString("ftype")) ? ResManager.loadKDString((String)"\u6b63\u5f0f\u8bb8\u53ef", (String)"LicenseDetailListPlugin_49", (String)"bos-license-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e34\u65f6\u8bb8\u53ef", (String)"LicenseDetailListPlugin_50", (String)"bos-license-formplugin", (Object[])new Object[0])), row);
                this.getModel().setValue("licversion", (Object)("V" + licVersion), row);
            }
            return selectCardRow;
        });
        this.getView().updateView("license");
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)detailId)) {
            CardEntry licenseCard = (CardEntry)this.getControl("license");
            licenseCard.selectCard(selectRow);
            if (selectRow.equals(-1)) {
                this.getPageCache().remove(DETAILID);
                String filters = this.getView().getPageCache().get("filters");
                if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)filters)) {
                    Map filterMap = (Map)JSON.parseObject((String)filters, Map.class);
                    filterMap.remove(DETAILID);
                    this.getPageCache().put("filters", JSON.toJSONString((Object)filterMap));
                }
                BillList billlistap = (BillList)this.getControl("billlistap");
                billlistap.setClearSelection(true);
                billlistap.refresh();
            }
        }
    }

    private void showMessage() {
        if (CollectionUtils.isEmpty(this.legalIllegalData)) {
            return;
        }
        StringBuilder message = new StringBuilder();
        boolean isFirst = true;
        for (String groupName : this.legalIllegalData.keySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                message.append("\u3001");
            }
            message.append("\u3010").append(groupName).append("\u3011");
        }
        message.append(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u5206\u914d\u5404\u6cd5\u4eba\u516c\u53f8\u8bb8\u53ef\u6570\u91cf\uff0c\u4ee5\u786e\u4fdd\u5206\u914d\u7684\u603b\u6570\u4e0d\u8d85\u8fc7\u8d2d\u4e70\u7684\u8bb8\u53ef\u6570\u3002", (String)"LicenseDetailListPlugin_24", (String)"bos-license-formplugin", (Object[])new Object[0]));
        this.getView().showMessage(message.toString());
    }

    private Date parseObject2EndDate(Date date) {
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(date);
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
        }
        catch (Exception e) {
            logger.error("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
        }
        return cal.getTime();
    }

    class LicDetailListDataProviderImpl
    extends ListDataProvider {
        LicDetailListDataProviderImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DynamicObjectCollection getData(int start, int limit) {
            boolean isOEM = DevVerifyServiceHelper.isOEMEnv();
            List<Long> allShowGroupId = new ArrayList(16);
            if (isOEM) {
                allShowGroupId = LicenseGroupUtil.getAllIsvGroupId();
                Set groupIds = LicenseGroupUtil.getLicenseGroup((String)"1").keySet();
                if (!CollectionUtils.isEmpty(groupIds)) {
                    for (String groupId : groupIds) {
                        try {
                            allShowGroupId.add(Long.parseLong(groupId));
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            DynamicObjectCollection col = new DynamicObjectCollection((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"lic_license"), null);
            String langName = Locale.getDefault().toString();
            SqlBuilder sql = new SqlBuilder();
            String filterStr = LicenseDetailListPlugin.this.getView().getPageCache().get("filters");
            boolean enableLegalPersonAssign = UserLicenseGroupUtil.isEnableLegalPersonAssign();
            if (enableLegalPersonAssign) {
                sql.append(" SELECT DISTINCT a.fid detailid,f.fid id, a.fgroupid groupid, a.fgroupid id,f.fnumber groupnumber,e.fname groupname,f.fgroupdes groupdes,f.ftype type,a.fbegindate begindate,a.fenddate enddate,", new Object[0]);
                sql.append(" a.ftotalcount totalcountlist,a.fassignedcount assignedcountlist,a.fremaincount remaincountlist,sum(d.fassignednum) legalassignedcount ", new Object[0]);
                sql.append(" from t_lic_licensedetail a ", new Object[0]);
                sql.append(" left join t_lic_license g on g.fid = a.fid ", new Object[0]);
                sql.append(" LEFT JOIN t_lic_group f on f.fid = a.fgroupid ", new Object[0]);
                sql.append(" LEFT JOIN t_lic_legalassign d on f.fid = d.fgroupid ", new Object[0]);
                sql.append(" LEFT JOIN t_lic_group_l e on e.fid = a.fgroupid and ", new Object[0]);
                sql.append(String.format(" e.flocaleid = '%s' ", langName), new Object[0]);
                if (isOEM && !CollectionUtils.isEmpty(allShowGroupId)) {
                    sql.append(" WHERE ", new Object[0]);
                    sql.appendIn(" a.fgroupid ", allShowGroupId.toArray());
                }
                sql.append(" group by a.fid,f.fid,a.fgroupid,g.fproductversion,a.fgroupid,f.fnumber,e.fname ,f.ftype,a.ftotalcount,a.fassignedcount,a.fremaincount,g.ftype,a.fbegindate,a.fenddate ", new Object[0]);
            } else {
                sql.append(" SELECT DISTINCT a.fid detailid,f.fid id, a.fgroupid groupid , a.fgroupid id,f.fnumber groupnumber,e.fname groupname,f.fgroupdes groupdes,f.ftype type,a.fbegindate begindate,a.fenddate enddate,", new Object[0]);
                sql.append(" a.ftotalcount totalcountlist,a.fassignedcount assignedcountlist,a.fremaincount remaincountlist ", new Object[0]);
                sql.append(" from t_lic_licensedetail a ", new Object[0]);
                sql.append(" left join t_lic_license g on g.fid = a.fid ", new Object[0]);
                sql.append(" LEFT JOIN t_lic_group f on f.fid = a.fgroupid ", new Object[0]);
                sql.append(" LEFT JOIN t_lic_group_l e on e.fid = a.fgroupid and ", new Object[0]);
                sql.append(String.format(" e.flocaleid = '%s' ", langName), new Object[0]);
                if (isOEM && !CollectionUtils.isEmpty(allShowGroupId)) {
                    sql.append(" WHERE ", new Object[0]);
                    sql.appendIn("a.fgroupid", allShowGroupId.toArray());
                }
            }
            Map groupId2GroupName = LicenseGroupUtil.getLicenseGroup(null);
            ArrayList<Map> dataList = new ArrayList<Map>(10);
            DataSet dataDataSet = null;
            boolean isHighAvailabilityMode = LicenseUtil.isHighAvailabilityMode();
            Map licAllocateNumberByGroupIds = new HashMap(0);
            Map hasBoughtRegLicGroup = LicenseGroupUtil.getHasBoughtRegLicGroup();
            ArrayList<Long> groupIds = new ArrayList<Long>(32);
            if (!CollectionUtils.isEmpty((Map)hasBoughtRegLicGroup)) {
                for (String groupIdStr : hasBoughtRegLicGroup.keySet()) {
                    groupIds.add(Long.parseLong(groupIdStr));
                }
            }
            licAllocateNumberByGroupIds = LicenseUserRelEngine.getLicAllocateNumberByGroupIds(groupIds);
            Map groupId2GroupDes = LicenseGroupUtil.getLicenseGroupDes((String)LicenseServiceHelper.getProductVersion());
            try {
                dataDataSet = DB.queryDataSet((String)"select_license_detial", (DBRoute)DBRoute.basedata, (SqlBuilder)sql);
                if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)filterStr) && !"[]".equals(filterStr)) {
                    Map filters = (Map)JSON.parseObject((String)filterStr, Map.class);
                    for (String filter : filters.values()) {
                        dataDataSet = dataDataSet.filter(filter);
                    }
                }
                for (Row row : dataDataSet) {
                    HashMap<String, Object> dataInfo = new HashMap<String, Object>(8);
                    String groupId = row.getString("groupid");
                    dataInfo.put(LicenseDetailListPlugin.GROUPNUMBER, row.getString(LicenseDetailListPlugin.GROUPNUMBER));
                    if (groupId2GroupName.containsKey(groupId)) {
                        dataInfo.put(LicenseDetailListPlugin.GROUPNAME, groupId2GroupName.get(groupId));
                    } else {
                        dataInfo.put(LicenseDetailListPlugin.GROUPNAME, row.getString(LicenseDetailListPlugin.GROUPNAME));
                    }
                    String groupDes = row.getString(LicenseDetailListPlugin.GROUPDES);
                    String groupDesVersion = (String)groupId2GroupDes.get(groupId);
                    if (!kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)groupDesVersion)) {
                        groupDes = groupDesVersion;
                    }
                    dataInfo.put(LicenseDetailListPlugin.GROUPDES, kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)groupDes) ? row.getString("type") : groupDes);
                    Integer totalCount = row.getInteger(LicenseDetailListPlugin.TOTALCOUNT);
                    dataInfo.put(LicenseDetailListPlugin.TOTALCOUNT, totalCount);
                    Integer assCount = row.getInteger(LicenseDetailListPlugin.ASSIGNEDCOUNT);
                    long groupIdL = Long.parseLong(groupId);
                    Integer regAssCount = (Integer)licAllocateNumberByGroupIds.get(groupIdL);
                    Integer remainCount = row.getInteger(LicenseDetailListPlugin.REMAINCOUNT);
                    if (isHighAvailabilityMode && null != regAssCount) {
                        assCount = regAssCount;
                        remainCount = totalCount - regAssCount;
                    }
                    dataInfo.put(LicenseDetailListPlugin.ASSIGNEDCOUNT, assCount);
                    if (enableLegalPersonAssign) {
                        int legalCount = 0;
                        Integer count = row.getInteger(LicenseDetailListPlugin.LEGALASSIGNEDCOUNT);
                        if (null != count) {
                            legalCount = count;
                        }
                        dataInfo.put(LicenseDetailListPlugin.LEGALASSIGNEDCOUNT, legalCount);
                        int legalRemainCount = row.getInteger(LicenseDetailListPlugin.TOTALCOUNT) - legalCount;
                        if (legalRemainCount < 0) {
                            LicenseDetailListPlugin.this.legalIllegalData.put(String.valueOf(dataInfo.get(LicenseDetailListPlugin.GROUPNAME)), legalRemainCount + "");
                        }
                        if (groupId.equals("16")) {
                            dataInfo.put(LicenseDetailListPlugin.LEGALREMAINCOUNT, legalRemainCount * 10000);
                        } else {
                            dataInfo.put(LicenseDetailListPlugin.LEGALREMAINCOUNT, legalRemainCount);
                        }
                    }
                    if (remainCount < 0) {
                        remainCount = 0;
                    }
                    dataInfo.put(LicenseDetailListPlugin.REMAINCOUNT, remainCount);
                    dataInfo.put(LicenseDetailListPlugin.BEGINDATE, row.getDate("begindate"));
                    dataInfo.put(LicenseDetailListPlugin.ENDDATE, LicenseDetailListPlugin.this.parseObject2EndDate(row.getDate("enddate")));
                    dataInfo.put("id", row.getString("id"));
                    if (groupId.equals("16")) {
                        Long total = Long.valueOf(String.valueOf(dataInfo.get(LicenseDetailListPlugin.TOTALCOUNT)));
                        Long actTotal = total * 10000L;
                        dataInfo.put(LicenseDetailListPlugin.TOTALCOUNT, actTotal);
                        SmsUsingQuantities smsUsingQuantitySummary = MessageCenterServiceHelper.getSmsUsingQuantitySummary();
                        Long successSum = smsUsingQuantitySummary.getSuccessSum();
                        Long sum = 0L;
                        if (null != successSum) {
                            sum = successSum;
                        }
                        dataInfo.put(LicenseDetailListPlugin.ASSIGNEDCOUNT, sum);
                        Long remain = actTotal - sum;
                        if (remain < 0L) {
                            remain = 0L;
                        }
                        dataInfo.put(LicenseDetailListPlugin.REMAINCOUNT, remain);
                    }
                    if (groupId.equals("441")) {
                        try {
                            Long total = Long.valueOf(String.valueOf(dataInfo.get(LicenseDetailListPlugin.TOTALCOUNT)));
                            long enableSuccessCount = WorkflowServiceHelper.getEnableProcessCount();
                            dataInfo.put(LicenseDetailListPlugin.ASSIGNEDCOUNT, enableSuccessCount);
                            Long remain = total - enableSuccessCount;
                            if (remain < 0L) {
                                remain = 0L;
                            }
                            dataInfo.put(LicenseDetailListPlugin.REMAINCOUNT, remain);
                        }
                        catch (Exception e) {
                            logger.error("\u83b7\u53d6\u6d41\u7a0b\u670d\u52a1\u4e91\u6d41\u91cf\u7248\u8ba1\u6570\u5f02\u5e38", (Throwable)e);
                        }
                    }
                    dataList.add(dataInfo);
                }
            }
            catch (Exception e) {
                logger.error("\u52a0\u8f7d\u8bb8\u53ef\u8be6\u60c5\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage(), (Throwable)e);
            }
            finally {
                if (null != dataDataSet) {
                    dataDataSet.close();
                }
            }
            LicenseDetailListPlugin.this.getPageCache().put("size", dataList.size() + "");
            Collator chineseComparator = Collator.getInstance(Locale.CHINESE);
            dataList.sort(Comparator.comparing(map -> (String)map.get(LicenseDetailListPlugin.GROUPNAME), Comparator.nullsFirst(chineseComparator)));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String groupDesUDD = "UDD";
            String totalCountUDD = ResManager.loadKDString((String)"\u4e0d\u9650", (String)"LicenseDetailListPlugin_20", (String)"bos-license-formplugin", (Object[])new Object[0]);
            String assignedCountUDD = "-";
            String remainCountUDD = totalCountUDD;
            for (int i = start; i < start + limit && i < dataList.size(); ++i) {
                Map map2 = (Map)dataList.get(i);
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"lic_license");
                dynamicObject.set(LicenseDetailListPlugin.GROUPNUMBER, map2.get(LicenseDetailListPlugin.GROUPNUMBER));
                dynamicObject.set(LicenseDetailListPlugin.GROUPNAME, map2.get(LicenseDetailListPlugin.GROUPNAME));
                boolean isUDD = LicenseDetailListPlugin.UDD_GROUP_TOTAL_COUNT.equals(map2.get(LicenseDetailListPlugin.TOTALCOUNT).toString());
                dynamicObject.set(LicenseDetailListPlugin.GROUPDES, (Object)(isUDD ? groupDesUDD : map2.get(LicenseDetailListPlugin.GROUPDES)));
                dynamicObject.set(LicenseDetailListPlugin.TOTALCOUNT, (Object)(isUDD ? totalCountUDD : map2.get(LicenseDetailListPlugin.TOTALCOUNT)));
                if (enableLegalPersonAssign) {
                    dynamicObject.set(LicenseDetailListPlugin.LEGALASSIGNEDCOUNT, map2.get(LicenseDetailListPlugin.LEGALASSIGNEDCOUNT));
                    dynamicObject.set(LicenseDetailListPlugin.LEGALREMAINCOUNT, map2.get(LicenseDetailListPlugin.LEGALREMAINCOUNT));
                }
                dynamicObject.set(LicenseDetailListPlugin.ASSIGNEDCOUNT, (Object)(isUDD ? assignedCountUDD : map2.get(LicenseDetailListPlugin.ASSIGNEDCOUNT)));
                dynamicObject.set(LicenseDetailListPlugin.REMAINCOUNT, (Object)(isUDD ? remainCountUDD : map2.get(LicenseDetailListPlugin.REMAINCOUNT)));
                dynamicObject.set(LicenseDetailListPlugin.BEGINDATE, map2.get(LicenseDetailListPlugin.BEGINDATE));
                Date endDate = (Date)map2.get(LicenseDetailListPlugin.ENDDATE);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(endDate);
                if (calendar.get(1) < 2099) {
                    dynamicObject.set(LicenseDetailListPlugin.ENDDATE, (Object)sdf.format(endDate));
                } else {
                    dynamicObject.set(LicenseDetailListPlugin.ENDDATE, (Object)ResManager.loadKDString((String)"\u4e0d\u9650", (String)"LicenseDetailListPlugin_20", (String)"bos-license-formplugin", (Object[])new Object[0]));
                }
                dynamicObject.set("id", map2.get("id"));
                col.add((Object)dynamicObject);
            }
            int dataCount = this.getDataCount();
            this.getQueryResult().setDataCount(dataCount);
            this.getQueryResult().setCollection(col);
            return col;
        }

        public int getDataCount() {
            return Integer.parseInt(LicenseDetailListPlugin.this.getPageCache().get("size"));
        }

        public int getRealCount() {
            return Integer.parseInt(LicenseDetailListPlugin.this.getPageCache().get("size"));
        }
    }
}

