/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.formplugin;

import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.license.LicenseServiceUtil;
import kd.bos.license.util.LicenseExpireUtil;
import kd.bos.license.util.LicenseUpdateUtil;
import kd.bos.permission.model.AdminInfo;
import kd.bos.servicehelper.license.LicenseServiceHelper;

public class LicenseExpireNoticePlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        String pubTenantType;
        boolean isAdmin = this.isAdministrator();
        if (isAdmin && LicenseExpireUtil.getExpireNoticeStatus()) {
            this.showExpireNotice();
        }
        if (isAdmin && this.verificationShowUpdateNotice() && LicenseUpdateUtil.isNeedShowUpdateWindows() && (StringUtils.isBlank((CharSequence)(pubTenantType = LicenseServiceHelper.getPubTenantType())) || !Boolean.parseBoolean(pubTenantType))) {
            this.showUpdateLicenseNotice();
        }
        if (this.isAdministrator() && this.verificationShowGrayFeatureNotice() && LicenseServiceUtil.isEnableGrayLicense()) {
            this.showGrayFeatureNotice();
        }
    }

    private boolean isAdministrator() {
        Long currUserId = RequestContext.get().getCurrUserId();
        AdminInfo administratorInfo = LicenseExpireUtil.getAdministratorInfo();
        return null != administratorInfo && administratorInfo.getUserid().equals(currUserId);
    }

    private boolean verificationShowUpdateNotice() {
        return (Boolean)DB.query((DBRoute)DBRoute.base, (String)"select fid from t_lic_license_trial ", rs -> rs.next());
    }

    private boolean verificationShowGrayFeatureNotice() {
        return (Boolean)DB.query((DBRoute)DBRoute.base, (String)"select fid from t_lic_grayfeature where fremindersign = '1' and fstatus <> '10' and fstatus <> '11' ", rs -> rs.next());
    }

    private void showExpireNotice() {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("license_expire_notice");
        param.setShowTitle(false);
        param.setShowClose(false);
        this.getView().showForm(param);
    }

    private void showUpdateLicenseNotice() {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("lic_license_upnotice");
        param.setShowTitle(false);
        param.setShowClose(false);
        this.getView().showForm(param);
    }

    private void showGrayFeatureNotice() {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("lic_grayfeaturenotice");
        param.setCaption(ResManager.loadKDString((String)"\u7070\u5ea6\u7279\u6027", (String)"LicenseExpireNoticePlugin_0", (String)"bos-license-formplugin", (Object[])new Object[0]));
        param.setShowTitle(true);
        param.setShowClose(true);
        this.getView().showForm(param);
    }
}

