/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.formplugin;

import com.bes.mq.util.CollectionUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.license.gray.UpdateGrayBlackList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.sqlscript.PreInsDataScriptBuilder;

public class LicenseGrayFeatureExportPlugin
extends AbstractListPlugin {
    private static String GRAYFEATURE_TABLE = "t_lic_grayfeaturescheme";
    private static String GRAYFEATURE_CLOUD_TABLE = "t_lic_grayfeatschecld";
    private static String GRAYFEATURE_APP_TABLE = "t_lic_grayfeatscheapp";
    private static String GRAYFEATURE_OBJ_TABLE = "t_lic_grayfeatscheobj";
    private static String GRAYFEATURE = "grayFeature";
    private static String STR_FIELDS_GRAY = "fid,fnumber,fminversion,fname,fintroduction,fdetailurl";
    private static String STR_FIELDS_GRAY_CLOUD = "fid,fentryid,fseq,fcloudid,fproduct,fcloudnum,fisblack";
    private static String STR_FIELDS_GRAY_APP = "fid,fentryid,fseq,fappid,fproduct,fappnum,fisblack";
    private static String STR_FIELDS_GRAY_OBJ = "fid,fentryid,fseq,fentityid,fproduct,fappid,fentitynum,fappnum,fisblack";
    private static String WHEREFILTER = "fid in (";
    private static String EXPORT_SQL = "export_sql";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (EXPORT_SQL.equals(operateKey)) {
            ListSelectedRowCollection listSelectedData = args.getListSelectedData();
            if (CollectionUtils.isEmpty((Collection)listSelectedData)) {
                args.setCancel(true);
                args.setCancelMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u9700\u8981\u5bfc\u51fa\u7684\u7279\u6027\u3002", (String)"LicenseGrayFeatureExportPlugin_0", (String)"bos-license-formplugin", (Object[])new Object[0]));
                return;
            }
            StringBuilder sql = new StringBuilder();
            Object[] primaryKeyValues = listSelectedData.getPrimaryKeyValues();
            PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
            String splitSql = Arrays.stream(primaryKeyValues).map(Object::toString).collect(Collectors.joining(","));
            Map result = builder.genInsertSQLScript(DBRoute.base, GRAYFEATURE_TABLE, STR_FIELDS_GRAY, WHEREFILTER + splitSql + ")", "", "");
            sql.append(result.get("sql"));
            result = builder.genInsertSQLScript(DBRoute.base, GRAYFEATURE_CLOUD_TABLE, STR_FIELDS_GRAY_CLOUD, WHEREFILTER + splitSql + ")", "", "");
            sql.append(result.get("sql"));
            result = builder.genInsertSQLScript(DBRoute.base, GRAYFEATURE_APP_TABLE, STR_FIELDS_GRAY_APP, WHEREFILTER + splitSql + ")", "", "");
            sql.append(result.get("sql"));
            result = builder.genInsertSQLScript(DBRoute.base, GRAYFEATURE_OBJ_TABLE, STR_FIELDS_GRAY_OBJ, WHEREFILTER + splitSql + ")", "", "");
            sql.append(result.get("sql"));
            this.getView().openUrl(LicenseGrayFeatureExportPlugin.downloadFile(sql.toString()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String downloadFile(String sql) {
        String sqlFileName = String.format("%s_%s.sql", GRAYFEATURE, new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        try (ByteArrayInputStream ins = new ByteArrayInputStream(sql.getBytes(StandardCharsets.UTF_8));){
            String string = LicenseGrayFeatureExportPlugin.exportFile(ins, sqlFileName);
            return string;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{String.format("KSQLExpPlugin error:%s.", e.getMessage())});
        }
    }

    private static String exportFile(InputStream ins, String sqlFileName) {
        return CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(sqlFileName, ins, 5000);
    }

    public void addItemClickListeners(String ... keys) {
        super.addItemClickListeners(keys);
        this.addClickListeners(new String[]{"createblacklist"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        ListSelectedRowCollection selectedRows;
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if ("createblacklist".equals(itemKey) && (selectedRows = this.getSelectedRows()).size() <= 0) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7070\u5ea6\u7279\u6027\u3002", (String)"LicenseGrayFeatureExportPlugin_1", (String)"bos-license-formplugin", (Object[])new Object[0]));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("createblacklist".equals(itemKey)) {
            this.createBlackList();
        }
    }

    private void createBlackList() {
        ArrayList<String> features = new ArrayList<String>();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        for (ListSelectedRow selectedRow : selectedRows) {
            features.add(selectedRow.getNumber());
        }
        if (features.size() > 0) {
            try {
                UpdateGrayBlackList updateGrayBlackList = new UpdateGrayBlackList();
                updateGrayBlackList.saveBlackListByFeatures(features);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u52a0\u5165\u9ed1\u540d\u5355\u6210\u529f\u3002", (String)"LicenseGrayFeatureExportPlugin_2", (String)"bos-license-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                this.getView().showTipNotification(e.getMessage());
            }
        }
    }
}

