/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.util.StringUtils;

public class LicenseGrayFeatureNoticePlugin
extends AbstractListPlugin {
    private static final String FEATURE_CARD = "grayfeature";
    private static final String FEATURE_NAME = "feature_name";
    private static final String FEATURE_INTRODUCE = "feature_introduce";
    private static final String COLOR_MARK = "color_mark";
    private static final String INTRODUCE = "introduce";
    private static final String SHOW_DETAIL = "showdetail";
    private static final String NO_SHOW = "no_show";
    private static final String SHOW_DETAIL_ENTITY = "lic_grayfeature";
    private static final String TABAP = "tabap";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loadLicenseCard();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{SHOW_DETAIL, NO_SHOW});
    }

    private void loadLicenseCard() {
        this.getModel().deleteEntryData(FEATURE_CARD);
        ArrayList featureIds = new ArrayList(16);
        String selectGraySchemeId = "select fid featureId,fschemeid from t_lic_grayfeature where fremindersign = '1' and fstatus <> '10' and fstatus <> '11' ";
        List fschemeIds = (List)DB.query((DBRoute)DBRoute.base, (String)selectGraySchemeId, rs -> {
            HashSet<Object> ids = new HashSet<Object>(16);
            ArrayList<Object> idLs = new ArrayList<Object>(16);
            while (rs.next()) {
                Object fschemeId = rs.getObject("fschemeid");
                featureIds.add(rs.getObject("featureId"));
                if (!ids.add(fschemeId)) continue;
                idLs.add(fschemeId);
            }
            return idLs;
        });
        if (null == fschemeIds || fschemeIds.isEmpty()) {
            return;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fname featureName ,fintroduction featureIntroduction from t_lic_grayfeaturescheme where ", new Object[0]);
        sqlBuilder.appendIn("fid", fschemeIds);
        int feaCount = (Integer)DB.query((DBRoute)DBRoute.base, (SqlBuilder)sqlBuilder, rs -> {
            int featureCount = 0;
            while (rs.next()) {
                int row = this.getModel().createNewEntryRow(FEATURE_CARD);
                String featureName = rs.getString("featureName");
                String featureIntroduction = rs.getString("featureIntroduction");
                this.getModel().setValue(FEATURE_NAME, (Object)featureName, row);
                this.getModel().setValue(FEATURE_INTRODUCE, (Object)featureIntroduction, row);
                this.getModel().setValue(COLOR_MARK, (Object)(row % 5), row);
                featureCount = row + 1;
            }
            return featureCount;
        });
        this.getView().getPageCache().put("featureIds", SerializationUtils.toJsonString(featureIds));
        this.getModel().setValue(INTRODUCE, (Object)String.format(ResManager.loadKDString((String)"\u73b0\u6709%1$s\u4e2a\u65b0\u589e\u7684\u7070\u5ea6\u7279\u6027\uff0c\u4f60\u53ef\u4ee5\u67e5\u770b\u8be6\u60c5\u5e76\u7533\u8bf7\u7070\u5ea6\u8bb8\u53ef\u8fdb\u884c\u8bd5\u7528\u3002", (String)"LicenseGrayFeatureNoticePlugin_0", (String)"bos-license-formplugin", (Object[])new Object[0]), feaCount));
        this.getView().updateView(FEATURE_CARD);
        this.getView().updateView(INTRODUCE);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button source = (Button)evt.getSource();
        String key = source.getKey();
        if (SHOW_DETAIL.equals(key)) {
            this.showDetail();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String featureIdJson;
        super.beforeClosed(e);
        if (Boolean.parseBoolean(String.valueOf(this.getModel().getValue(NO_SHOW))) && !StringUtils.isEmpty((String)(featureIdJson = this.getView().getPageCache().get("featureIds")))) {
            List featureIds = (List)SerializationUtils.fromJsonString((String)featureIdJson, List.class);
            SqlBuilder sql = new SqlBuilder();
            sql.append("update t_lic_grayfeature set fremindersign = '2' where ", new Object[0]).appendIn("fid", featureIds);
            DB.execute((DBRoute)DBRoute.base, (SqlBuilder)sql);
        }
    }

    private void showDetail() {
        IFormView view = this.getView();
        IFormView mainView = view.getMainView();
        if (null == mainView || null == mainView.getControl(TABAP)) {
            view.close();
            return;
        }
        String menuId = (String)DB.query((DBRoute)DBRoute.meta, (String)"select fid menuId from t_meta_menuruntime where fformid = 'lic_grayfeature' and fappid = 'secm'", rs -> {
            if (rs.next()) {
                return rs.getString("menuId");
            }
            return null;
        });
        if (StringUtils.isNotEmpty((String)menuId)) {
            AppInfo app = AppMetadataCache.getAppInfo((String)"secm");
            AppMenuInfo menu = AppMetadataCache.getAppMenuInfo((String)"secm", (String)menuId);
            if (null == app || null == menu) {
                this.getView().close();
                return;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("view", this.getView());
            map.put("appname", app.getName());
            map.put("appmainnumber", app.getHomeNum());
            map.put("formnumber", SHOW_DETAIL_ENTITY);
            map.put("parametertype", menu.getParamType());
            map.put("parameter", menu.getParams());
            map.put("menuname", menu.getName().getLocaleValue());
            OpenPageUtils.openApp((String)"secm", (String)menuId, map, (IFormView)this.getView());
        }
        this.getView().close();
    }
}

