/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.license.LicenseServiceUtil;
import kd.bos.license.constant.GrayLicApplyStatusEnum;
import kd.bos.license.gray.UpdateGrayLicense;
import kd.bos.license.util.LicenseGrayUpdateStatusUtil;
import kd.bos.license.util.LicensePoApiUtil;
import kd.bos.license.util.LicenseUtil;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class LicenseGrayShowDetailListPlugin
extends AbstractListPlugin {
    private static final String OPERATE_SHOW_DETAIL = "showdetail";
    private static final String OPERATE_UPDATE_LICENSE = "updatelicense";
    private static final String OPERATE_APPLY_GRAY_LIC = "appgraylic";
    private static final String REFRESH = "refresh";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!LicenseServiceUtil.isEnableGrayLicense()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{OPERATE_UPDATE_LICENSE, OPERATE_APPLY_GRAY_LIC, REFRESH});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        switch (operateKey.toLowerCase(Locale.ENGLISH)) {
            case "updatelicense": {
                this.beforeUpdateLicense(args);
                break;
            }
            case "appgraylic": {
                this.beforeApplyGrayLic(args);
                break;
            }
            case "refresh": {
                this.refreshStatus();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        switch (operateKey.toLowerCase(Locale.ENGLISH)) {
            case "showdetail": {
                this.openUrl(afterDoOperationEventArgs);
                break;
            }
            case "updatelicense": {
                this.updateLicense(afterDoOperationEventArgs);
                break;
            }
            case "appgraylic": {
                this.applyGrayLic(afterDoOperationEventArgs);
            }
        }
    }

    private void beforeUpdateLicense(BeforeDoOperationEventArgs args) {
        long currUserId = RequestContext.get().getCurrUserId();
        if (!PermissionServiceHelper.isAdminUser((long)currUserId)) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u975e\u7ba1\u7406\u5458\uff0c\u65e0\u66f4\u65b0\u7070\u5ea6\u8bb8\u53ef\u6743\u9650\u3002", (String)"LicenseGrayShowDetailListPlugin_0", (String)"bos-license-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!QueryServiceHelper.exists((String)"lic_grayfeaturescheme", null)) {
            args.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u7070\u5ea6\u8bb8\u53ef\u7684\u9884\u7f6e\u4fe1\u606f\u5b58\u5728\u7f3a\u5931\u6216\u4e0d\u5b8c\u6574\u7684\u60c5\u51b5\uff0c\u56e0\u6b64\u65e0\u6cd5\u66f4\u65b0\u6210\u529f\u3002\u5982\u9700\u89e3\u51b3\u6b64\u95ee\u9898\uff0c\u5efa\u8bae\u60a8\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u9884\u7f6e\u4fe1\u606f\u7684\u8865\u5145\u548c\u5b8c\u5584\u3002", (String)"LicenseGrayShowDetailListPlugin_5", (String)"bos-license-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            return;
        }
    }

    private void beforeApplyGrayLic(BeforeDoOperationEventArgs args) {
        long currUserId = RequestContext.get().getCurrUserId();
        if (!PermissionServiceHelper.isAdminUser((long)currUserId)) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u975e\u7ba1\u7406\u5458\uff0c\u65e0\u7533\u8bf7\u7070\u5ea6\u8bb8\u53ef\u6743\u9650\u3002", (String)"LicenseGrayShowDetailListPlugin_1", (String)"bos-license-formplugin", (Object[])new Object[0]));
        }
    }

    private void updateLicense(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        UpdateGrayLicense updateGrayLicense = new UpdateGrayLicense();
        Map updateResult = updateGrayLicense.downloadAndUpdateGrayLicense("manual", true);
        if (Boolean.parseBoolean((String)updateResult.get("success"))) {
            this.getView().showSuccessNotification((String)updateResult.get("msg"));
        } else if (Boolean.parseBoolean((String)updateResult.get("showconfirm"))) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u7070\u5ea6\u8bb8\u53ef\u7684\u9884\u7f6e\u4fe1\u606f\u5b58\u5728\u7f3a\u5931\u6216\u4e0d\u5b8c\u6574\u7684\u60c5\u51b5\uff0c\u56e0\u6b64\u65e0\u6cd5\u66f4\u65b0\u6210\u529f\u3002\u5982\u9700\u89e3\u51b3\u6b64\u95ee\u9898\uff0c\u5efa\u8bae\u60a8\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u9884\u7f6e\u4fe1\u606f\u7684\u8865\u5145\u548c\u5b8c\u5584\u3002", (String)"LicenseGrayShowDetailListPlugin_5", (String)"bos-license-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
        } else {
            this.getView().showErrorNotification((String)updateResult.get("msg"));
        }
        ((ListView)this.getView()).refresh();
    }

    private void applyGrayLic(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        DynamicObjectCollection grayLicDoc = QueryServiceHelper.query((String)"lic_grayfeature", (String)"grayfeature.number,grayfeature.name,grayfeature.minversion", null);
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        String currCosmicVersion = this.removeLastVersion(LicenseUtil.getCosmicVersion());
        for (DynamicObject grayLicObj : grayLicDoc) {
            String minVersion = grayLicObj.getString("grayfeature.minversion");
            if (!LicenseUtil.compareVersion((String)minVersion, (String)currCosmicVersion)) continue;
            list.add(grayLicObj);
        }
        if (list.size() > 0) {
            this.showConfirmForm(list, currCosmicVersion);
            return;
        }
        String url = LicensePoApiUtil.getApplyGrayLicUrl();
        this.getView().openUrl(url);
    }

    private String removeLastVersion(String version) {
        String[] split;
        if (StringUtils.isNotEmpty((CharSequence)version) && (split = version.split("\\.")).length == 4) {
            version = String.join((CharSequence)".", Arrays.copyOf(split, split.length - 1));
        }
        return version;
    }

    private void showConfirmForm(List<DynamicObject> list, String currCosmicVersion) {
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("lic_grayapplyconfirm");
        parameters.setShowTitle(true);
        parameters.setCustomParam("operateName", (Object)ResManager.loadKDString((String)"\u7533\u8bf7\u7070\u5ea6\u8bb8\u53ef", (String)"LicenseGrayShowDetailListPlugin_4", (String)"bos-license-formplugin", (Object[])new Object[0]));
        ArrayList<String> errors = new ArrayList<String>(list.size());
        parameters.setCustomParam("hasMore", (Object)false);
        for (DynamicObject grayLicObj : list) {
            errors.add(String.format(ResManager.loadKDString((String)"%1$s\u3001%2$s\uff0c\u4f9d\u8d56\u7248\u672c%3$s\uff1b", (String)"LicenseGrayShowDetailListPlugin_3", (String)"bos-license-formplugin", (Object[])new Object[0]), grayLicObj.getString("grayfeature.number"), grayLicObj.getString("grayfeature.name"), grayLicObj.getString("grayfeature.minversion")));
        }
        parameters.setCustomParam("errorMsg", errors);
        String title = String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u7684\u82cd\u7a79\u7cfb\u7edf\u7248\u672c\u662f%1$s\uff0c\u5b58\u5728\u7070\u5ea6\u5e94\u7528\u4f9d\u8d56\u7684\u73af\u5883\u9ad8\u4e8e%2$s\uff0c\u8bf7\u7533\u8bf7\u7070\u5ea6\u8bb8\u53ef\u540c\u65f6\u66f4\u65b0\u82cd\u7a79\u548c\u7ba1\u7406\u4e2d\u5fc3\u7248\u672c\u3002", (String)"LicenseGrayShowDetailListPlugin_2", (String)"bos-license-formplugin", (Object[])new Object[0]), currCosmicVersion, currCosmicVersion);
        parameters.setCustomParam("title", (Object)title);
        this.getView().showForm(parameters);
    }

    private void openUrl(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        BillList billlistap = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billlistap.getSelectedRows();
        if (null == selectedRows || selectedRows.isEmpty()) {
            return;
        }
        Object id = selectedRows.getPrimaryKeyValues()[0];
        String url = this.getUrl(id);
        if (StringUtils.isBlank((CharSequence)url)) {
            return;
        }
        this.getView().openUrl(url);
    }

    private String getUrl(Object id) {
        return (String)DB.query((DBRoute)DBRoute.base, (String)("select lgs.fdetailurl url from t_lic_grayfeaturescheme lgs join t_lic_grayfeature lg on lgs.fid = lg.fschemeid where lg.fid = " + id), rs -> {
            if (rs.next()) {
                return rs.getString("url");
            }
            return "";
        });
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        PermCommonUtil.showMesIfUserIsNotAdmin((PreOpenFormEventArgs)e);
        if (e.isCancel()) {
            return;
        }
        Boolean isNeedRequest = (Boolean)DB.query((DBRoute)DBRoute.base, (String)"select fstatus from t_lic_grayfeature;", rs -> {
            boolean result = false;
            while (rs.next()) {
                if (!result) {
                    result = true;
                }
                if (!GrayLicApplyStatusEnum.Success.toString().equals(rs.getString("fstatus"))) continue;
                return false;
            }
            return result;
        });
        if (isNeedRequest.booleanValue()) {
            this.refreshStatus();
        }
    }

    private void refreshStatus() {
        LicenseGrayUpdateStatusUtil.updateGrayLicenseStatus();
    }
}

