/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.formplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.license.engine.LicenseUserRelEngine;
import kd.bos.license.service.cache.LicenseCacheMrg;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class LicenseGroupBitMaintainPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(LicenseGroupBitMaintainPlugin.class);
    private static final String CON_LIC_GROUP = "lic_group";
    private static final String CON_LIC_SIGN = "sign";
    private static final String CON_ACCOUNT = "account";
    private static final String BTN_CLEAR_BIT = "btn_clear_bit_cache";
    private static final String ENTRY_USER = "userbilllist";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_CLEAR_BIT});
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        if (!PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId())) {
            e.setCancelMessage("permission denied.");
            e.setCancel(true);
        }
    }

    public void afterCreateNewData(EventObject e) {
        RequestContext context = RequestContext.get();
        List accounts = AccountUtils.getAllAccounts((String)context.getTenantId());
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(accounts.size());
        for (Account account : accounts) {
            LocaleString name = new LocaleString(account.getAccountName());
            items.add(new ComboItem(name, account.getAccountId()));
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl(CON_ACCOUNT);
        comboEdit.setComboItems(items);
        BillList userBillList = (BillList)this.getControl(ENTRY_USER);
        List filters = userBillList.getFilterParameter().getQFilters();
        filters.add(new QFilter("bitmapindex", "in", Collections.emptyList()));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        if (!CON_ACCOUNT.equals(name) && !CON_LIC_GROUP.equals(name)) {
            return;
        }
        String accountId = Objects.toString(this.getModel().getValue(CON_ACCOUNT), null);
        Object value = this.getModel().getValue(CON_LIC_GROUP);
        BillList userBillList = (BillList)this.getControl(ENTRY_USER);
        List filters = userBillList.getFilterParameter().getQFilters();
        filters.clear();
        Label sign = (Label)this.getControl(CON_LIC_SIGN);
        if (StringUtils.isBlank((CharSequence)accountId) || Objects.isNull(value)) {
            filters.add(new QFilter("bitmapindex", "in", Collections.emptyList()));
            sign.setText("");
            userBillList.refresh();
            return;
        }
        Map<String, List<Integer>> licGroupUsers = this.getLicGroupUsers(accountId, (DynamicObject)value);
        if (licGroupUsers.isEmpty()) {
            filters.add(new QFilter("bitmapindex", "in", Collections.emptyList()));
            sign.setText("");
        } else {
            for (Map.Entry<String, List<Integer>> entry : licGroupUsers.entrySet()) {
                sign.setText(entry.getKey());
                List<Integer> indexes = entry.getValue();
                if (CollectionUtils.isEmpty(indexes)) {
                    filters.add(new QFilter("bitmapindex", "in", Collections.emptyList()));
                    continue;
                }
                filters.add(new QFilter("bitmapindex", "in", indexes));
            }
        }
        userBillList.refresh();
    }

    private Map<String, List<Integer>> getLicGroupUsers(String accountId, DynamicObject licenseGroup) {
        Account account = this.getAccountByAccountId(accountId);
        if (null == account) {
            return Collections.emptyMap();
        }
        try {
            Long groupId = (Long)licenseGroup.getPkValue();
            return LicenseUserRelEngine.getGroupIndexes((Long)groupId, (Account)account);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            this.getView().showErrorNotification("query license bit fail, see logs for details.");
            return Collections.emptyMap();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String accountId = Objects.toString(this.getModel().getValue(CON_ACCOUNT), null);
        if (StringUtils.isBlank((CharSequence)accountId)) {
            this.getView().showTipNotification("account is empty.");
            return;
        }
        Object value = this.getModel().getValue(CON_LIC_GROUP);
        if (Objects.isNull(value)) {
            this.getView().showTipNotification("license group is null.");
            return;
        }
        DynamicObject licenseGroup = (DynamicObject)value;
        Long groupId = (Long)licenseGroup.getPkValue();
        Control control = (Control)evt.getSource();
        String controlKey = control.getKey();
        if (BTN_CLEAR_BIT.equals(controlKey)) {
            this.clearAccountLicBitCache(accountId, groupId);
        }
    }

    private void clearAccountLicBitCache(String accountId, Long groupId) {
        try {
            String type = LicenseCacheMrg.getType4UserGroupBitMap((String)accountId);
            LicenseUserRelEngine.removeCache((String)groupId.toString(), (String)type);
            this.getView().showSuccessNotification(String.format("clear [%s] cache success.", groupId));
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    private Account getAccountByAccountId(String accountId) {
        List accounts = AccountUtils.getAllAccounts((String)RequestContext.get().getTenantId());
        for (Account account : accounts) {
            if (!accountId.equals(account.getAccountId())) continue;
            return account;
        }
        this.getView().showTipNotification("account is null.");
        return null;
    }
}

