/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.formplugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

public class LicenseListDataRpt
extends AbstractReportListDataPlugin {
    private static final String LEGALPERSON = "legalperson";
    private static final String LICENSEGROUP = "licensegroup";

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        List filters;
        String legalPersonFilter;
        FilterInfo filter = reportQueryParam.getFilter();
        DynamicObjectCollection legalPersons = filter.getDynamicObjectCollection(LEGALPERSON);
        DynamicObjectCollection licenseGroups = filter.getDynamicObjectCollection(LICENSEGROUP);
        if (legalPersons == null || legalPersons.isEmpty()) {
            String userId = RequestContext.get().getUserId();
            List adminChargeOrg = PermissionServiceHelper.getAdminChargeOrgs((Long)Long.valueOf(userId));
            List corporateOrg = OrgUnitServiceHelper.getCorporateOrg((boolean)false);
            ArrayList<Long> ids = new ArrayList<Long>(corporateOrg.size());
            for (Map map : corporateOrg) {
                Long id = (Long)map.get("id");
                if (!adminChargeOrg.contains(id)) continue;
                ids.add(id);
            }
            legalPersonFilter = this.shiftToStr(ids);
        } else {
            legalPersonFilter = this.shiftToStr(legalPersons);
        }
        String licenseGroupFilter = this.shiftToStr(licenseGroups);
        StringBuilder sql = new StringBuilder();
        sql.append("select o.fnumber legalpersonnum,ol.fname legalpersonname,gl.fname licgroup,la.fassignednum assignednum,(la.fassignednum-la.fusednum) remaindernum ").append("from t_lic_legalassign la ").append("inner join t_org_org o on o.fid=la.forgid ").append("inner join t_org_org_l ol on o.fid=ol.fid ").append("inner join t_lic_group_l gl on gl.fid=la.fgroupid ").append("inner join t_lic_licensedetail ld on ld.fgroupid=la.fgroupid ").append("where ol.flocaleid = ? and gl.flocaleid=? ").append(" and la.forgid in ").append(legalPersonFilter);
        if (!"()".equals(licenseGroupFilter)) {
            sql.append(" and la.fgroupid in ").append(licenseGroupFilter);
        }
        String lang = RequestContext.get().getLang().name();
        Object[] params = new Object[]{lang, lang};
        DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.base, (String)sql.toString(), (Object[])params);
        String sortInfo = reportQueryParam.getSortInfo();
        if (StringUtils.isNotEmpty((String)sortInfo)) {
            dataSet = dataSet.orderBy(new String[]{sortInfo});
        }
        if (!(filters = filter.getHeadFilters()).isEmpty()) {
            for (QFilter qFilter : filters) {
                dataSet = dataSet.filter(qFilter.toString());
            }
        }
        return dataSet;
    }

    private String shiftToStr(Object o) {
        StringBuilder result = new StringBuilder("(");
        if (o == null) {
            return "()";
        }
        if (o instanceof DynamicObjectCollection) {
            DynamicObjectCollection o1 = (DynamicObjectCollection)o;
            if (o1.isEmpty()) {
                return "()";
            }
            for (DynamicObject dynamicObject : o1) {
                long id = (Long)dynamicObject.getPkValue();
                result.append(id).append(",");
            }
        } else if (o instanceof ArrayList) {
            ArrayList o1 = (ArrayList)o;
            if (o1.isEmpty()) {
                return "()";
            }
            Iterator iterator = o1.iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                result.append(id).append(",");
            }
        }
        result.deleteCharAt(result.length() - 1).append(")");
        return result.toString();
    }
}

