/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.formplugin;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;

public class LicenseLogPlugin
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        List qfilters = e.getQFilters();
        if (!this.check(qfilters)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u65f6\u95f4\u67e5\u8be2\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc7%d\u4e2a\u6708\u3002", (String)"LogBillListPlugin_13", (String)"bos-form-business", (Object[])new Object[0]), 3));
        }
    }

    private boolean check(List<QFilter> qfilters) {
        int intervalMonth = 3;
        boolean checkResult = true;
        if (qfilters == null || qfilters.isEmpty()) {
            return true;
        }
        String operateTimeFieldName = "optime";
        for (QFilter filter : qfilters) {
            if (!operateTimeFieldName.equals(filter.getProperty())) continue;
            String filterStr = filter.toString();
            List qfilterNests = filter.getNests(true);
            if (qfilterNests == null || qfilterNests.isEmpty()) continue;
            String startTime = null;
            String endTime = null;
            filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
            startTime = filterStr.substring(0, filterStr.indexOf(39));
            filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
            filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
            endTime = filterStr.substring(0, filterStr.indexOf(39));
            try {
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                LocalDateTime start = LocalDateTime.parse(startTime, dateTimeFormatter);
                LocalDateTime end = LocalDateTime.parse(endTime, dateTimeFormatter);
                long duration = ChronoUnit.DAYS.between(start, end);
                if (duration > (long)(intervalMonth * 31)) {
                    checkResult = false;
                    continue;
                }
                checkResult = true;
            }
            catch (Exception px) {
                return checkResult;
            }
        }
        return checkResult;
    }
}

