/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.formplugin;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class LicenseParamFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static String AUTOASSIGNALLUSERLIC = "autoassignalluserlic";
    private static String ALLUSERLICEGROUP = "alluserlicegroup";
    private static String LEGAL_PERSON = "legal_person_assign";
    private static String ENABLE_GRAY_LICENSE = "enable_gray_license";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit licenseGroup = (MulBasedataEdit)this.getControl(ALLUSERLICEGROUP);
        licenseGroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        long currUserId = RequestContext.get().getCurrUserId();
        if (PermissionServiceHelper.isAdminUser((long)currUserId)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{AUTOASSIGNALLUSERLIC, ALLUSERLICEGROUP, ENABLE_GRAY_LICENSE});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{AUTOASSIGNALLUSERLIC, ALLUSERLICEGROUP, ENABLE_GRAY_LICENSE});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Boolean enable = (Boolean)this.getModel().getValue(AUTOASSIGNALLUSERLIC);
        this.updateAllUserLicGroupMustInput(enable);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (AUTOASSIGNALLUSERLIC.equals(propertyName)) {
            Boolean enable = (Boolean)e.getChangeSet()[0].getNewValue();
            this.updateAllUserLicGroupMustInput(enable);
        } else if (LEGAL_PERSON.equals(propertyName)) {
            boolean isUpdateLic = true;
            StringBuilder message = new StringBuilder();
            message.append(ResManager.loadKDString((String)"\u5207\u6362\u6cd5\u4eba\u516c\u53f8\u5206\u914d\u8bb8\u53ef\u540e\uff0c\u8bf7", (String)"LicenseParamFormPlugin_0", (String)"bos-license-formplugin", (Object[])new Object[0]));
            message.append(ResManager.loadKDString((String)"\u66f4\u65b0\u8bb8\u53ef", (String)"LicenseParamFormPlugin_1", (String)"bos-license-formplugin", (Object[])new Object[0]));
            message.append('\u3002');
            this.getView().showConfirm(message.toString(), MessageBoxOptions.OK);
        }
    }

    private void updateAllUserLicGroupMustInput(Boolean mustInput) {
        MulBasedataEdit allUserLicGroup = (MulBasedataEdit)this.getControl(ALLUSERLICEGROUP);
        allUserLicGroup.setMustInput(mustInput.booleanValue());
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String propName = e.getProperty().getName();
        if (ALLUSERLICEGROUP.equals(propName)) {
            QFilter filter = new QFilter("id", "in", this.gethasBoughtRegLicGroup()).and("id", "<>", (Object)412L);
            e.getCustomQFilters().add(filter);
            ListShowParameter parameter = (ListShowParameter)e.getFormShowParameter();
            parameter.setMustInput(true);
        }
    }

    private Set<Long> gethasBoughtRegLicGroup() {
        String sql = "SELECT FGROUPID FROM T_LIC_LICENSEDETAIL tlld INNER JOIN T_LIC_GROUP tlg on tlld.fgroupid = tlg.fid where tlg.ftype = '1'";
        return (Set)DB.query((DBRoute)DBRoute.base, (String)sql, k -> {
            HashSet<Long> groups = new HashSet<Long>(k.getRow());
            while (k.next()) {
                groups.add(k.getLong("FGROUPID"));
            }
            return groups;
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection collection;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (!operate.getOperateKey().equals("donothing")) {
            return;
        }
        Boolean enable = (Boolean)this.getModel().getValue(AUTOASSIGNALLUSERLIC);
        if (enable.booleanValue() && ((collection = (DynamicObjectCollection)this.getModel().getValue(ALLUSERLICEGROUP)) == null || collection.isEmpty())) {
            args.setCancel(true);
            args.setCancelMessage(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u8bb8\u53ef\u5206\u7ec4\u201d\u5b57\u6bb5\u3002", (String)"LicenseParamFormPlugin_3", (String)"bos-license-formplugin", (Object[])new Object[0]));
        }
    }
}

