/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.license.engine.LicenseSnapshotEngine;
import kd.bos.license.service.cache.LicenseCache;
import kd.bos.license.service.cache.LicenseCacheMrg;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class LicenseSnapshotListPlugin
extends AbstractListPlugin {
    private static final String ENTITY_LIC_SNAPSHOT = "lic_snapshot";
    private static final String CONFIRMCALLBACK_SNAPRESTORE = "ConfirmCallBack_SnapRestore";
    private static final String LOCALE_CACHE_PRODUCT = "ProductInfo";
    private static final Log logger = LogFactory.getLog(LicenseSnapshotListPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        boolean isAdminUser = PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId());
        if (!isAdminUser) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u975e\u7ba1\u7406\u5458\uff0c\u65e0\u5feb\u7167\u7ba1\u7406\u6743\u9650\u3002", (String)"LicenseSnapshotListPlugin_0", (String)"bos-license-formplugin", (Object[])new Object[0]));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (itemKey.equals("snaprestore") && this.checkPermission()) {
            BillList list = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            if (selectedRows == null || selectedRows.isEmpty() || selectedRows.size() >= 2) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u6570\u636e\u3002", (String)"LicenseSnapshotListPlugin_1", (String)"bos-license-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u6062\u590d\u4e3a\u9009\u4e2d\u65f6\u95f4\u70b9\u7684\u8bb8\u53ef\u5417\uff1f", (String)"LicenseSnapshotListPlugin_2", (String)"bos-license-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRMCALLBACK_SNAPRESTORE));
        }
    }

    private boolean checkPermission() {
        long userId = RequestContext.get().getCurrUserId();
        boolean isAdminUser = PermissionServiceHelper.isAdminUser((long)userId);
        if (!isAdminUser) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u975e\u7ba1\u7406\u5458\uff0c\u65e0\u5feb\u7167\u7ba1\u7406\u6743\u9650\u3002", (String)"LicenseSnapshotListPlugin_0", (String)"bos-license-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean hasPerm = PermissionServiceHelper.checkPermission((Long)userId, (String)this.getView().getFormShowParameter().getAppId(), (String)ENTITY_LIC_SNAPSHOT, (String)"47150e89000000ac");
        if (!hasPerm) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u5feb\u7167\u7ba1\u7406\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseSnapshotListPlugin_5", (String)"bos-license-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if (CONFIRMCALLBACK_SNAPRESTORE.equals(callBackId) && (evt.getResult().equals((Object)MessageBoxResult.Yes) || evt.getResult().equals((Object)MessageBoxResult.OK))) {
            BillList list = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            if (selectedRows == null || selectedRows.size() != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u6570\u636e\u3002", (String)"LicenseSnapshotListPlugin_1", (String)"bos-license-formplugin", (Object[])new Object[0]));
                return;
            }
            try (DLock dlock = DLock.createReentrant((String)"UserLicenseGroups");){
                dlock.tryLock();
                Long primaryKey = (Long)selectedRows.get(0).getPrimaryKeyValue();
                DynamicObject[] snapshot = BusinessDataServiceHelper.load((String)ENTITY_LIC_SNAPSHOT, (String)"data", (QFilter[])new QFilter("id", "=", (Object)primaryKey).toArray());
                if (snapshot == null || snapshot.length == 0) {
                    throw new KDBizException("License Snapshot Not Found");
                }
                boolean restoreResult = LicenseSnapshotEngine.restore();
                if (restoreResult) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6062\u590d\u6210\u529f\u3002", (String)"LicenseSnapshotListPlugin_3", (String)"bos-license-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6062\u590d\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u540c\u6b65\u8bb8\u53ef\u65e5\u5fd7\u3002", (String)"LicenseSnapshotListPlugin_4", (String)"bos-license-formplugin", (Object[])new Object[0]));
                }
            }
            catch (Exception e) {
                logger.error("\u8c03\u7528\u7ba1\u7406\u4e2d\u5fc3\u83b7\u53d6\u8bb8\u53ef\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6062\u590d\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u540c\u6b65\u8bb8\u53ef\u65e5\u5fd7\u3002", (String)"LicenseSnapshotListPlugin_4", (String)"bos-license-formplugin", (Object[])new Object[0]));
            }
            finally {
                LicenseCache.releaseWriteLock();
            }
        }
    }

    private void updateTenantType(List<?> dataList) {
        try {
            if (dataList == null || dataList.isEmpty()) {
                return;
            }
            Object dataMapJson = dataList.get(0);
            JSONObject jsonObject = JSON.parseObject((String)dataMapJson.toString());
            JSONObject content = jsonObject.getJSONObject("content");
            String tenantType = content.getString("tenantType");
            if (StringUtils.isBlank((CharSequence)tenantType)) {
                tenantType = "private";
            }
            String type = "tenant_type_" + RequestContext.get().getTenantId();
            if ("public".equals(tenantType)) {
                LicenseCacheMrg.putCache((String)type, (String)"tenant_type", (String)Boolean.TRUE.toString());
            } else if ("private".equals(tenantType)) {
                LicenseCacheMrg.putCache((String)type, (String)"tenant_type", (String)Boolean.FALSE.toString());
            }
            logger.info(String.format("\u8bb8\u53ef\u6587\u4ef6\u4e2d\u8fd4\u56de\u7684\u7cfb\u7edf\u90e8\u7f72\u65b9\u5f0f\u4e3a\uff1a%s", tenantType));
        }
        catch (Exception e) {
            logger.error(String.format("\u4ece\u8bb8\u53ef\u6587\u4ef6\u89e3\u6790\u90e8\u7f72\u65b9\u5f0f\u5931\u8d25\uff0c\u6570\u636e\u4e3a\uff1a%s", JSONObject.toJSONString(dataList)) + e.getMessage());
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(new QFilter("snapshottype", "=", (Object)"0"));
    }
}

