/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.formplugin;

import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class LicenseSyncDetailFormPlugin
extends AbstractFormPlugin {
    private static final String ENTITY_LICENSE_SYNC_DETAIL = "lic_licensesyncdetail";
    private static final String USER = "user";
    private static final String PHONE = "phone";
    private static final String EMAIL = "email";
    private static final String SUCCESS = "success";
    private static final String DESCRIPTION = "description";
    private static final String LOGTYPE = "logtype";
    private static final String TASKID = "taskid";
    private static final String SYNC = "sync";
    private static final String DOWNLOAD = "download";
    private static final String UPDATE = "update";
    private static final String OPERATOR = "operator";
    private static final String OPDATE = "opdate";
    private static final String REASON = "reason";
    private static final String TAB = "tabap";
    private static final String TABPAGE_DOWNLOAD = "tabpage_download";
    private static final String TABPAGE_UPDATE = "tabpage_update";
    private String OPERATOR_MSG = ResManager.loadKDString((String)"\u64cd\u4f5c\u4eba", (String)"LicenseSyncDetailFormPlugin_0", (String)"bos-license-formplugin", (Object[])new Object[0]);
    private String OPDATE_MSG = ResManager.loadKDString((String)"\u64cd\u4f5c\u65f6\u95f4", (String)"LicenseSyncDetailFormPlugin_1", (String)"bos-license-formplugin", (Object[])new Object[0]);
    private String SUCCESS_MSG = ResManager.loadKDString((String)"\u6210\u529f", (String)"LicenseSyncDetailFormPlugin_2", (String)"bos-license-formplugin", (Object[])new Object[0]);
    private String FAIL_MSG = ResManager.loadKDString((String)"\u5931\u8d25", (String)"LicenseSyncDetailFormPlugin_3", (String)"bos-license-formplugin", (Object[])new Object[0]);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long taskId = (Long)formShowParameter.getCustomParam(TASKID);
        String operator = (String)formShowParameter.getCustomParam(OPERATOR);
        String opdate = (String)formShowParameter.getCustomParam(OPDATE);
        String json = (String)formShowParameter.getCustomParam("singleUserDetailLogIds");
        List detailLogIds = new LinkedList();
        if (StringUtils.isNotEmpty((String)json)) {
            detailLogIds = SerializationUtils.fromJsonStringToList((String)json, Long.class);
        }
        Label label = (Label)this.getControl("operatorlabel");
        label.setText(this.OPERATOR_MSG + "\uff1a" + operator);
        Label label2 = (Label)this.getControl("opdatelabel");
        label2.setText(this.OPDATE_MSG + "\uff1a" + opdate);
        QFilter qFilter = new QFilter(LOGTYPE, "=", (Object)"1");
        if (detailLogIds.isEmpty()) {
            qFilter.and(new QFilter(TASKID, "in", (Object)taskId));
        } else {
            qFilter.and(new QFilter("id", "in", detailLogIds));
        }
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_LICENSE_SYNC_DETAIL, (String)String.join((CharSequence)",", USER, PHONE, EMAIL, SUCCESS, DESCRIPTION, REASON), (QFilter[])new QFilter[]{qFilter});
        if (dynamicObjects.length == 0) {
            return;
        }
        this.getModel().beginInit();
        TableValueSetter vs = new TableValueSetter(new String[]{"username", PHONE, EMAIL, "syncstatus", "syncdescription", "syncreason"});
        for (DynamicObject dynamicObject : dynamicObjects) {
            String user = dynamicObject.getString(USER);
            String phone = dynamicObject.getString(PHONE);
            String email = dynamicObject.getString(EMAIL);
            boolean success = dynamicObject.getBoolean(SUCCESS);
            String description = dynamicObject.getString(DESCRIPTION);
            String reason = dynamicObject.getString(REASON);
            vs.addRow(new Object[]{user, phone, email, success ? this.SUCCESS_MSG : this.FAIL_MSG, description, reason});
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(SYNC, vs);
        this.getModel().endInit();
        this.getView().updateView(SYNC);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl(TAB);
        tab.addTabSelectListener(k -> {
            String tabKey = k.getTabKey();
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Long taskId = (Long)formShowParameter.getCustomParam(TASKID);
            String json = (String)formShowParameter.getCustomParam("singleUserDetailLogIds");
            List detailLogIds = new LinkedList();
            if (StringUtils.isNotEmpty((String)json)) {
                detailLogIds = SerializationUtils.fromJsonStringToList((String)json, Long.class);
            }
            if (TABPAGE_DOWNLOAD.equals(tabKey)) {
                String loaded = this.getPageCache().get("tabpage_download_loaded");
                if (StringUtils.isNotEmpty((String)loaded)) {
                    return;
                }
                QFilter qFilter = new QFilter(LOGTYPE, "=", (Object)"2");
                if (detailLogIds.isEmpty()) {
                    qFilter.and(new QFilter(TASKID, "in", (Object)taskId));
                } else {
                    qFilter.and(new QFilter("id", "in", detailLogIds));
                }
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_LICENSE_SYNC_DETAIL, (String)String.join((CharSequence)",", SUCCESS, DESCRIPTION), (QFilter[])new QFilter[]{qFilter});
                if (dynamicObjects.length == 0) {
                    return;
                }
                this.getModel().beginInit();
                TableValueSetter vs = new TableValueSetter(new String[]{"opdescription", "downloadstatus"});
                for (DynamicObject dynamicObject : dynamicObjects) {
                    boolean success = dynamicObject.getBoolean(SUCCESS);
                    String description = dynamicObject.getString(DESCRIPTION);
                    vs.addRow(new Object[]{description, success ? this.SUCCESS_MSG : this.FAIL_MSG});
                }
                this.getPageCache().put("tabpage_download_loaded", "true");
                ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(DOWNLOAD, vs);
                this.getModel().endInit();
                this.getView().updateView(DOWNLOAD);
            } else if (TABPAGE_UPDATE.equals(tabKey)) {
                String loaded = this.getPageCache().get("tabpage_update_loaded");
                if (StringUtils.isNotEmpty((String)loaded)) {
                    return;
                }
                QFilter qFilter = new QFilter(LOGTYPE, "=", (Object)"3");
                if (detailLogIds.isEmpty()) {
                    qFilter.and(new QFilter(TASKID, "in", (Object)taskId));
                } else {
                    qFilter.and(new QFilter("id", "in", detailLogIds));
                }
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_LICENSE_SYNC_DETAIL, (String)String.join((CharSequence)",", USER, PHONE, EMAIL, SUCCESS, DESCRIPTION, REASON), (QFilter[])new QFilter[]{qFilter});
                if (dynamicObjects.length == 0) {
                    return;
                }
                this.getModel().beginInit();
                TableValueSetter vs = new TableValueSetter(new String[]{"username2", "phone2", "email2", "updatestatus", "updatedescription", "updatereason"});
                for (DynamicObject dynamicObject : dynamicObjects) {
                    String user = dynamicObject.getString(USER);
                    String phone = dynamicObject.getString(PHONE);
                    String email = dynamicObject.getString(EMAIL);
                    boolean success = dynamicObject.getBoolean(SUCCESS);
                    String description = dynamicObject.getString(DESCRIPTION);
                    String reason = dynamicObject.getString(REASON);
                    vs.addRow(new Object[]{user, phone, email, success ? this.SUCCESS_MSG : this.FAIL_MSG, description, reason});
                }
                this.getPageCache().put("tabpage_update_loaded", "true");
                ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(UPDATE, vs);
                this.getModel().endInit();
                this.getView().updateView(UPDATE);
            }
        });
    }
}

