/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.formplugin;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class LicenseSyncLogListPlugin
extends AbstractListPlugin {
    private static final String ENTITY_LICENSE_SYNC_DETAIL_LIST = "lic_licensesyncdetaillist";
    private static final String ENTITY_LICENSE_SYNC_LOG = "lic_licensesynclog";
    private static final String BTN_LOG_AUTO_CLEAN = "logautoclean";
    private static final String LIC_LICSYNCLOGCLEAN = "lic_licsynclogclean";
    private static final int USER_NO_CACHE = -10000;
    private String API = ResManager.loadKDString((String)"api\u63a5\u53e3\u89e6\u53d1", (String)"LicenseSyncLogListPlugin_0", (String)"bos-license-formplugin", (Object[])new Object[0]);
    private String EXPIRED_CACHE = ResManager.loadKDString((String)"\u91cd\u5efa\u7f13\u5b58\u89e6\u53d1", (String)"LicenseSyncLogListPlugin_2", (String)"bos-license-formplugin", (Object[])new Object[0]);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{BTN_LOG_AUTO_CLEAN});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (BTN_LOG_AUTO_CLEAN.equals(itemKey)) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId(LIC_LICSYNCLOGCLEAN);
            fsp.setCaption(ResManager.loadKDString((String)"\u65e5\u5fd7\u6e05\u7406\u914d\u7f6e", (String)"LicenseSyncLogListPlugin_3", (String)"bos-license-formplugin", (Object[])new Object[0]));
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(fsp);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillListHyperLinkClickEvent hyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        ListSelectedRow currentRow = hyperLinkClickEvent.getCurrentRow();
        if (currentRow == null) {
            return;
        }
        Long primaryKeyValue = (Long)currentRow.getPrimaryKeyValue();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)ENTITY_LICENSE_SYNC_LOG);
        DynamicObject user = dynamicObject.getDynamicObject("operator");
        String userName = "";
        if (user != null) {
            userName = user.getString("name");
        } else {
            String sql = "select fuserid from t_lic_licsynclog where fid = ?";
            Integer userId = (Integer)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{primaryKeyValue}, r -> {
                if (r.next()) {
                    return r.getInt("fuserid");
                }
                return null;
            });
            if (userId == -1 || userId == 0) {
                userName = this.API;
            } else if (userId == -10000) {
                userName = this.EXPIRED_CACHE;
            }
        }
        Date opdate = dynamicObject.getDate("operatedate");
        String pageId = this.getView().getPageId() + "_" + ENTITY_LICENSE_SYNC_DETAIL_LIST + "_" + primaryKeyValue;
        IFormView fv = this.getView().getView(pageId);
        if (fv != null) {
            fv.activate();
            this.getView().sendFormAction(fv);
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(ENTITY_LICENSE_SYNC_DETAIL_LIST);
        fsp.setPageId(pageId);
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        fsp.setCustomParam("taskid", (Object)primaryKeyValue);
        fsp.setCustomParam("operator", (Object)userName);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        fsp.setCustomParam("opdate", (Object)format.format(opdate));
        this.getView().showForm(fsp);
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        DynamicObject rowData = packageDataEvent.getRowData();
        DynamicObject operator = rowData.getDynamicObject("operator");
        if (operator != null) {
            return;
        }
        long operatorId = rowData.getLong("operator_id");
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_user"));
        if (operatorId == 0L || operatorId == -1L) {
            dynamicObject.set("name", (Object)this.API);
        } else if (operatorId == -10000L) {
            dynamicObject.set("name", (Object)this.EXPIRED_CACHE);
        }
        rowData.set("operator", (Object)dynamicObject);
    }

    public void setFilter(SetFilterEvent e) {
        if (null != e) {
            e.getQFilters().add(new QFilter("operation", "!=", (Object)"syncChange"));
        }
        super.setFilter(e);
    }
}

