/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.util.LicenseGroupUtil;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;

public class StandardDevGroupConfigPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static Map<String, String> offLicGroupAndAppId = Stream.of({"9", "2AN7+R08B0/5"}, {"411", "0DUMFA=HL9S1"}, {"410", "101/NKY=9OLA"}, {"412", "eae607fb000152ac"}, {"409", "SE7/UZFDVIE"}).collect(Collectors.toMap(data -> data[0], data -> data[1]));

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit bizObject = (BasedataEdit)this.getControl("bizobject");
        bizObject.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bizapp = (BasedataEdit)this.getControl("bizapp");
        bizapp.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    private ListShowParameter createAndSetListShowParameter(String billFormId, String fromId, String caption, boolean isMultiSelect) {
        ListShowParameter param = ShowFormHelper.createShowListForm((String)billFormId, (boolean)isMultiSelect);
        param.setCaption(caption);
        param.setFormId(fromId);
        return param;
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        if ("formCallBack".equalsIgnoreCase(actionId)) {
            ListSelectedRowCollection rt = (ListSelectedRowCollection)event.getReturnData();
            if (rt == null || rt.isEmpty()) {
                return;
            }
            this.getModel().setValue("bizobject", rt.get(0).getPrimaryKeyValue());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        List<String> list = Arrays.asList("kingdee", " ");
        if (key.equals("bizobject")) {
            evt.setCancel(true);
            ListShowParameter listShowParameter = this.createAndSetListShowParameter("bos_formmeta", "bos_devp_formtreelistf7", ResManager.loadKDString((String)"\u901a\u7528\u8868\u5355\u9009\u62e9", (String)"StandardDevGroupConfigPlugin_0", (String)"bos-license-formplugin", (Object[])new Object[0]), false);
            ListFilterParameter listFilterParameter = listShowParameter.getListFilterParameter();
            QFilter filter = new QFilter("modeltype", "<>", (Object)"BaseFormModel").and("type", "=", (Object)"0").and("isv", "not in", list);
            listFilterParameter.setFilter(filter);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "formCallBack"));
            this.getView().showForm((FormShowParameter)listShowParameter);
        } else if (key.equals("bizapp")) {
            FormShowParameter showParameter;
            ArrayList<String> offLineAppIds = new ArrayList<String>(5);
            int modeType = LicenseServiceHelper.getModeType();
            if (2 != modeType && 4 != modeType) {
                DynamicObject[] load;
                Map hasBoughtRegLicGroup = LicenseGroupUtil.getHasBoughtRegLicGroup();
                for (Map.Entry<String, String> entry : offLicGroupAndAppId.entrySet()) {
                    if (hasBoughtRegLicGroup.containsKey(entry.getKey())) continue;
                    offLineAppIds.add(entry.getValue());
                }
                if (!CollectionUtils.isEmpty(offLineAppIds) && (load = BusinessDataServiceHelper.load((String)"lic_stddevcfg", (String)"bizapp", (QFilter[])new QFilter[]{new QFilter("bizapp", "in", offLineAppIds)})) != null) {
                    for (DynamicObject obj : load) {
                        offLineAppIds.remove(obj.getString("bizapp_id"));
                    }
                }
            }
            if ((showParameter = evt.getFormShowParameter()) instanceof ListShowParameter) {
                ListShowParameter listShowParameter = (ListShowParameter)showParameter;
                ListFilterParameter listFilterParameter = listShowParameter.getListFilterParameter();
                QFilter filter = new QFilter("isv", "in", list).and("deploystatus", "=", (Object)"2");
                if (!CollectionUtils.isEmpty(offLineAppIds)) {
                    filter.and(new QFilter("id", "not in", offLineAppIds));
                }
                listFilterParameter.setFilter(filter);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        DynamicObject bizObj = (DynamicObject)this.getModel().getValue("bizobject");
        String formId = "";
        if (bizObj != null) {
            formId = bizObj.getString("id");
        }
        if ("save".equals(operateKey) && this.isOverLimit() && !this.getForms().contains(formId)) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u8fbe\u5230\u6700\u5927\u53ef\u914d\u7f6e\u6570\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"StandardDevGroupConfigPlugin_1", (String)"bos-license-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean isOverLimit() {
        int sum = LicenseServiceHelper.getTotalNumber((Object)252L);
        int entityCount = this.getFormCount();
        return entityCount >= sum;
    }

    private int getFormCount() {
        String sql = "SELECT COUNT(DISTINCT FENTITYTYPEID) ENTITYCOUNT FROM T_LIC_STANDDEVCONFIG";
        return (Integer)DB.query((DBRoute)DBRoute.base, (String)sql, k -> {
            int count = 0;
            while (k.next()) {
                count = k.getInt("ENTITYCOUNT");
            }
            return count;
        });
    }

    private Set<String> getForms() {
        String sql = "SELECT FENTITYTYPEID FROM T_LIC_STANDDEVCONFIG";
        return (Set)DB.query((DBRoute)DBRoute.base, (String)sql, k -> {
            HashSet<String> forms = new HashSet<String>(16);
            while (k.next()) {
                forms.add(k.getString("FENTITYTYPEID"));
            }
            return forms;
        });
    }
}

