/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.formplugin;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.formplugin.dataprovider.StandardDevGroupListDataProvider;
import kd.bos.license.service.cache.LicenseCache;
import kd.bos.license.util.LicenseGroupUtil;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class StandardDevGroupListPlugin
extends AbstractListPlugin {
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new StandardDevGroupListDataProvider());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        Set<String> enableDataKeys = this.getALlEnableIds();
        switch (operateKey) {
            case "enable": {
                Object[] primaryKeyValues = operate.getListSelectedData().getPrimaryKeyValues();
                enableDataKeys.addAll(Arrays.stream(primaryKeyValues).map(Object::toString).collect(Collectors.toSet()));
                int sum = LicenseServiceHelper.getTotalNumber((Object)252L);
                if (enableDataKeys.size() <= sum) break;
                String errorMessage = ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\uff0c\u5df2\u7ecf\u8d85\u8fc7%s\u7684\u6700\u5927\u8bb8\u53ef\u6570\u91cf\u3002", (String)"StandardDevGroupListPlugin_3", (String)"bos-license-formplugin", (Object[])new Object[]{LicenseGroupUtil.getLicenseGroup((String)"2").get("252")});
                args.setCancelMessage(errorMessage);
                args.setCancel(true);
                this.getView().showTipNotification(errorMessage);
                break;
            }
            case "new_donothing": {
                if (enableDataKeys.size() < LicenseServiceHelper.getTotalNumber((Object)252L)) break;
                String errorMessage = ResManager.loadKDString((String)"\u65b0\u589e\u5931\u8d25\uff0c\u5df2\u7ecf\u8d85\u8fc7%s\u7684\u6700\u5927\u8bb8\u53ef\u6570\u91cf\u3002", (String)"StandardDevGroupListPlugin_4", (String)"bos-license-formplugin", (Object[])new Object[]{LicenseGroupUtil.getLicenseGroup((String)"2").get("252")});
                this.getView().showTipNotification(errorMessage);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "enable": {
                DB.execute((DBRoute)DBRoute.base, (String)"update t_lic_standdevconfig set fcomment = '' where fstatus = 'true'");
                break;
            }
            case "new_donothing": {
                this.showFormF7();
                break;
            }
            case "showapps": {
                this.showAppF7();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        if ("formCallBack".equalsIgnoreCase(actionId)) {
            ListSelectedRowCollection rts = (ListSelectedRowCollection)event.getReturnData();
            if (null == rts || rts.isEmpty()) {
                return;
            }
            Set<String> enableDataKeys = this.getALlEnableIds();
            if (enableDataKeys.size() + rts.size() > LicenseServiceHelper.getTotalNumber((Object)252L)) {
                String errorMessage = ResManager.loadKDString((String)"\u65b0\u589e\u5931\u8d25\uff0c\u5df2\u7ecf\u8d85\u8fc7%s\u7684\u6700\u5927\u8bb8\u53ef\u6570\u91cf\u3002", (String)"StandardDevGroupListPlugin_4", (String)"bos-license-formplugin", (Object[])new Object[]{LicenseGroupUtil.getLicenseGroup((String)"2").get("252")});
                this.getView().showTipNotification(errorMessage);
                return;
            }
            DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
            for (ListSelectedRow rt : rts) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"lic_stddevcfg");
                dynamicObject.set("bizobject", rt.getPrimaryKeyValue());
                dynamicObject.set("status", (Object)"true");
                dynamicObject.set("creater", (Object)RequestContext.get().getUserId());
                dynamicObjects.add((Object)dynamicObject);
            }
            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])dynamicObjects.toArray((Object[])new DynamicObject[0])));
            this.getView().updateView();
        }
    }

    private Set<String> getALlEnableIds() {
        return (Set)DB.query((DBRoute)DBRoute.base, (String)"select fid,fstatus from t_lic_standdevconfig", rs -> {
            HashSet<String> enableData = new HashSet<String>(16);
            while (rs.next()) {
                if (!"true".equals(rs.getString("fstatus"))) continue;
                enableData.add(rs.getString("fid"));
            }
            return enableData;
        });
    }

    private Set<Object> getALlEntities() {
        return (Set)DB.query((DBRoute)DBRoute.base, (String)"select fentitytypeid from t_lic_standdevconfig", rs -> {
            HashSet<Object> result = new HashSet<Object>(16);
            while (rs.next()) {
                result.add(rs.getObject("fentitytypeid"));
            }
            return result;
        });
    }

    private void showAppF7() {
        ListShowParameter listShowParameter = this.createAndSetListShowParameter("bos_devportal_bizapp", "lic_showappsf7llist", ResManager.loadKDString((String)"\u53ef\u878d\u5408\u5e94\u7528", (String)"StandardDevGroupListPlugin_2", (String)"bos-license-formplugin", (Object[])new Object[0]), false);
        Set allControlApps = LicenseCache.getAllControlApps();
        ListFilterParameter listFilterParameter = listShowParameter.getListFilterParameter();
        QFilter filter = new QFilter("isv", "in", Arrays.asList("kingdee", " ")).and("deploystatus", "=", (Object)"2").and("id", "in", (Object)allControlApps);
        listFilterParameter.setFilter(filter);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void showFormF7() {
        ListShowParameter listShowParameter = this.createAndSetListShowParameter("bos_formmeta", "bos_devp_formtreelistf7", ResManager.loadKDString((String)"\u901a\u7528\u8868\u5355\u9009\u62e9", (String)"StandardDevGroupListPlugin_1", (String)"bos-license-formplugin", (Object[])new Object[0]), true);
        List<String> list = Arrays.asList("kingdee", " ");
        ListFilterParameter listFilterParameter = listShowParameter.getListFilterParameter();
        QFilter filter = new QFilter("modeltype", "<>", (Object)"BaseFormModel").and("type", "=", (Object)"0").and("isv", "not in", list).and("id", "not in", this.getALlEntities());
        listFilterParameter.setFilter(filter);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "formCallBack"));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private ListShowParameter createAndSetListShowParameter(String billFormId, String fromId, String caption, boolean isMultiSelect) {
        ListShowParameter param = ShowFormHelper.createShowListForm((String)billFormId, (boolean)isMultiSelect);
        param.setCaption(caption);
        param.setFormId(fromId);
        return param;
    }

    private int getFormCount() {
        return this.getALlEnableIds().size();
    }

    public void afterBindData(EventObject e) {
        Label label_last;
        Label label_used;
        super.afterBindData(e);
        int sum = LicenseServiceHelper.getTotalNumber((Object)252L);
        int used = this.getFormCount();
        int last = sum - used;
        Label label_sum = (Label)this.getControl("label_sum");
        if (label_sum != null) {
            label_sum.setText(String.valueOf(sum));
        }
        if ((label_used = (Label)this.getControl("label_used")) != null) {
            label_used.setText(String.valueOf(used));
        }
        if ((label_last = (Label)this.getControl("label_last")) != null) {
            label_last.setText(String.valueOf(last));
        }
    }
}

