/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.license.LicenseServiceUtil;
import kd.bos.license.api.bean.SyncLicenseProgressInfo;
import kd.bos.license.service.cache.LicenseCache;
import kd.bos.license.util.UserLicenseGroupUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPools;

public class SyncProgressPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(SyncProgressPlugin.class);
    private String errorMessage = ResManager.loadKDString((String)"\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"SyncProgressPlugin_6", (String)"bos-license-formplugin", (Object[])new Object[0]);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"uploadsuccess"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"uploadfail"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"downloadsuccess"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"downloadfail"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"updatesuccess"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"updatefail"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"error1"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"error2"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"error3"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnretry"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"message"});
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        progressBar.start();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnretry"});
        this.addClickListeners(new String[]{"btnclose"});
        final ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        progressBar.addProgressListener(new ProgresssListener(){

            public void onProgress(ProgressEvent progress) {
                String regUserProgress;
                String taskId = SyncProgressPlugin.this.getTaskId();
                if (StringUtils.isNotBlank((CharSequence)taskId)) {
                    TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
                    taskInfo.getProgress();
                }
                if ((regUserProgress = LicenseCache.getUploadRegUserProgress()) == null) {
                    return;
                }
                SyncLicenseProgressInfo licenseProgress = (SyncLicenseProgressInfo)SerializationUtils.fromJsonString((String)regUserProgress, SyncLicenseProgressInfo.class);
                HashMap<String, LocaleString> map = new HashMap<String, LocaleString>();
                if (!licenseProgress.isInSync()) {
                    map.put("text", new LocaleString(ResManager.loadKDString((String)"\u5173\u95ed", (String)"SyncProgressPlugin_0", (String)"bos-license-formplugin", (Object[])new Object[0])));
                    SyncProgressPlugin.this.getView().updateControlMetadata("btnclose", map);
                }
                int hasSyncNum = licenseProgress.getHasSyncNum();
                int syncTotal = licenseProgress.getSyncTotal();
                boolean showErrorField1 = false;
                if (syncTotal == -1) {
                    hasSyncNum = 0;
                    syncTotal = 0;
                    showErrorField1 = true;
                    SyncProgressPlugin.this.getModel().setValue("error1", (Object)SyncProgressPlugin.this.errorMessage);
                }
                int percentage = 0;
                if (syncTotal != 0 && hasSyncNum != 0) {
                    percentage = hasSyncNum * 100 / syncTotal;
                }
                SyncProgressPlugin.this.getModel().setValue("percent", (Object)(percentage + "%"));
                int per = 0;
                if (syncTotal != 0) {
                    per = 80 * hasSyncNum / syncTotal;
                }
                if (licenseProgress.isInSync()) {
                    SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{"uploadsuccess"});
                    SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{"uploadfail"});
                    SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{"downloadsuccess"});
                    SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{"downloadfail"});
                    SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{"updatesuccess"});
                    SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{"updatefail"});
                    SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(showErrorField1), new String[]{"error1"});
                    SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{"error2"});
                    SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{"error3"});
                    SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnretry"});
                } else if (licenseProgress.isInDownload()) {
                    SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(!showErrorField1), new String[]{"uploadsuccess"});
                    SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(showErrorField1), new String[]{"uploadfail"});
                    SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{"downloadsuccess"});
                    SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{"downloadfail"});
                    SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{"updatesuccess"});
                    SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{"updatefail"});
                    SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(showErrorField1), new String[]{"error1"});
                    SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{"error2"});
                    SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{"error3"});
                    SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnretry"});
                    per = 80;
                } else if (licenseProgress.isInUpdate()) {
                    SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(!showErrorField1), new String[]{"uploadsuccess"});
                    SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(showErrorField1), new String[]{"uploadfail"});
                    if (licenseProgress.isDownloadSuccess()) {
                        SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(true), new String[]{"downloadsuccess"});
                        SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{"downloadfail"});
                        SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{"error2"});
                    } else {
                        SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{"downloadsuccess"});
                        SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(true), new String[]{"downloadfail"});
                        SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(true), new String[]{"error2"});
                        String downloadMsg = licenseProgress.getDownloadMsg();
                        if (StringUtils.isNotBlank((CharSequence)downloadMsg)) {
                            SyncProgressPlugin.this.getModel().setValue("error2", (Object)downloadMsg);
                        } else {
                            SyncProgressPlugin.this.getModel().setValue("error2", (Object)SyncProgressPlugin.this.errorMessage);
                        }
                    }
                    SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{"updatesuccess"});
                    SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{"updatefail"});
                    SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(showErrorField1), new String[]{"error1"});
                    SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{"error3"});
                    SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnretry"});
                    per = 90;
                } else {
                    SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(!showErrorField1), new String[]{"uploadsuccess"});
                    SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(showErrorField1), new String[]{"uploadfail"});
                    if (licenseProgress.isDownloadSuccess()) {
                        SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(true), new String[]{"downloadsuccess"});
                        SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{"downloadfail"});
                        SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{"error2"});
                    } else {
                        SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{"downloadsuccess"});
                        SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(true), new String[]{"downloadfail"});
                        SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(true), new String[]{"error2"});
                        String downloadMsg = licenseProgress.getDownloadMsg();
                        if (StringUtils.isNotBlank((CharSequence)downloadMsg)) {
                            SyncProgressPlugin.this.getModel().setValue("error2", (Object)downloadMsg);
                        } else {
                            SyncProgressPlugin.this.getModel().setValue("error2", (Object)SyncProgressPlugin.this.errorMessage);
                        }
                    }
                    if (licenseProgress.isUpdateSuccess()) {
                        SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(true), new String[]{"updatesuccess"});
                        SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{"updatefail"});
                        SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{"error3"});
                        if (UserLicenseGroupUtil.isEnableLegalPersonAssign() && !UserLicenseGroupUtil.checkLegalPersonAssignData()) {
                            SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(true), new String[]{"message"});
                        }
                    } else {
                        SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{"updatesuccess"});
                        SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(true), new String[]{"updatefail"});
                        SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(true), new String[]{"error3"});
                        String updateMsg = licenseProgress.getUpdateMsg();
                        if (StringUtils.isNotBlank((CharSequence)updateMsg)) {
                            SyncProgressPlugin.this.getModel().setValue("error3", (Object)updateMsg);
                        } else {
                            SyncProgressPlugin.this.getModel().setValue("error3", (Object)SyncProgressPlugin.this.errorMessage);
                        }
                    }
                    SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(showErrorField1), new String[]{"error1"});
                    SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnretry"});
                    per = 100;
                    progressBar.stop();
                    if (StringUtils.isNotBlank((CharSequence)taskId)) {
                        SyncProgressPlugin.this.returnResult(ScheduleServiceHelper.queryTask((String)taskId));
                    }
                    LicenseServiceUtil.setUploadRegUserMsg((String)"", (String)"");
                }
                this.updatePercentTotal(per);
                this.setProgress(progress, per);
            }

            private void updatePercentTotal(int per) {
                String[] str;
                int i = 0;
                String key = "percentTotal";
                String percentTotal = SyncProgressPlugin.this.getPageCache().get(key);
                if (StringUtils.isNotBlank((CharSequence)percentTotal) && (str = percentTotal.split("_per_")) != null && str.length > 0 && str[0] != null && str[0].equals(per + "")) {
                    i = Integer.parseInt(str[1]);
                }
                if (++i > 40) {
                    SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(true), new String[]{"btnretry"});
                    return;
                }
                SyncProgressPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnretry"});
                SyncProgressPlugin.this.getPageCache().put(key, per + "_per_" + i);
            }

            private void setProgress(ProgressEvent progress, int per) {
                progress.setProgress(per);
                SyncProgressPlugin.this.getModel().setValue("syncpercent", (Object)(per + "%"));
            }
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Button) {
            String key = ((Button)source).getKey();
            if ("btnretry".equals(key)) {
                ThreadPools.executeOnceIncludeRequestContext((String)"synUserGroup", (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LicenseServiceHelper.syncUserGroup();
                    }
                });
            } else if ("btnclose".equals(key)) {
                ProgressBar progressbarap = (ProgressBar)this.getControl("progressbarap");
                if (null != progressbarap && progressbarap.getPercent() < 100) {
                    this.doTranBackground();
                } else {
                    IFormView parentView = this.getView().getParentView();
                    if (null != parentView) {
                        parentView.updateView();
                        this.getView().sendFormAction(parentView);
                    }
                }
            }
        }
    }

    private void returnResult(TaskInfo taskInfo) {
        Map<String, String> result = SyncProgressPlugin.packageReturnResult(taskInfo);
        if (result != null) {
            this.getView().returnDataToParent(result);
        }
    }

    public static Map<String, String> packageReturnResult(TaskInfo taskInfo) {
        if (taskInfo == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (taskInfo != null) {
            String taskInfoStr = SerializationUtils.toJsonString((Object)taskInfo);
            result.put("taskinfo", taskInfoStr);
            result.put("taskend", String.valueOf(taskInfo.isTaskEnd()));
        }
        return result;
    }

    private String getTaskId() {
        JobFormInfo jobFormInfo;
        String taskId;
        String string = taskId = this.getView().getFormShowParameter().getCustomParams().containsKey("taskid") ? (String)this.getView().getFormShowParameter().getCustomParam("taskid") : this.getPageCache().get("taskid");
        if (StringUtils.isBlank((CharSequence)taskId) && null != (jobFormInfo = this.getJobFormInfo())) {
            taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
            this.getView().getFormShowParameter().getCustomParams().put("taskid", taskId);
            this.getPageCache().put("taskid", taskId);
        }
        return taskId;
    }

    private JobFormInfo getJobFormInfo() {
        String str = (String)this.getView().getFormShowParameter().getCustomParam("sch_clientjobinfo");
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return (JobFormInfo)SerializationUtils.fromJsonString((String)str, JobFormInfo.class);
    }

    private void doTranBackground() {
        TaskClientProxy.setProgressPageId((String)this.getTaskId(), (String)"");
        this.getView().close();
        String taskId = this.getTaskId();
        if (!StringUtils.isBlank((CharSequence)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            if (!TaskClientProxy.isExistTask((String)taskId)) {
                TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)this.getJobFormInfo(), (TaskInfo)taskInfo);
                BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), this.getJobFormInfo(), taskId);
                ThreadPools.executeOnce((String)"BOSSchedule-task-background-monitor", (Runnable)subscriber);
            }
        }
    }
}

