/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.drew.lang.StringUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.SortType;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.report.CellStyle;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.SearchClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.engine.LicenseSnapshotEngine;
import kd.bos.license.engine.LicenseUserRelEngine;
import kd.bos.license.service.cache.LicenseCache;
import kd.bos.license.service.cache.LicenseCacheMrg;
import kd.bos.license.util.LicenseExpireUtil;
import kd.bos.license.util.LicenseGroupUtil;
import kd.bos.license.util.LicenseUpdateUtil;
import kd.bos.license.util.LicenseUtil;
import kd.bos.list.BillList;
import kd.bos.list.ListColumn;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.DevVerifyServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.message.api.SmsUsingQuantities;

public class UpdateLicenseFormPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(UpdateLicenseFormPlugin.class);
    public static final String GROUP_NAME = "group_name";
    public static final String LICENSEASSIGN_NOW = "licenseassign_now";
    public static final String LICENSEASSIGN_NEW = "licenseassign_new";
    public static final String LICENSEASSIGN_REMARK = "licenseassign_remark";
    public static final String SEQ = "serial_number";
    public static final String USER_NAME = "user_name";
    public static final String USER_PHONE = "user_phone";
    public static final String USER_EMAIL = "user_email";
    public static final String GROUP_NEMA_NOW = "group_name_now";
    public static final String GROUP_NEMA_NEW = "group_name_new";
    public static final String USERSYNSTATUS_NOW = "user_synstatus_now";
    public static final String USERSYNSTATUS_NEW = "user_synstatus_new";
    public static final String NEXT_PAGE = "btnok";
    public static final String CLOSE_BUTTON = "close_button";
    public static final String LAST_PAGE = "lastpage";
    public static final String CONFIRM_UPDATE = "confirm_update";
    public static final String BTN_CANCEL = "btncancel";
    public static final String SHOWASSIGN_DIF = "showassigndif";
    public static final String SHOWSTATUS_DIF = "showstatusdif";
    public static final String TAB = "tabap";
    public static final String FILTER_CONTAINER = "filtercontainerap";
    public static final String ENTITY = "lic_licensenewandnow";
    public static final String UPDTEA_MESSAGE = "updatesuccess";
    public static final String SUCCESS_ICON = "vectorap";
    public static final String ERROR_ICON = "vectoraperror";
    public static final String LICENSE_UP = "license_up";
    private static final List<String> tabList = Arrays.asList("lic_groupdif", "lic_assigndif", "lic_userstatusdif", "lic_updateresult");
    private static final List<String> langNamelist = Arrays.asList("zh_CN", "zh_TW");

    public void beforeClosed(BeforeClosedEvent e) {
        IFormView parentView = this.getView().getParentView();
        if (null != parentView && parentView.toString().contains("lic_license_upnotice")) {
            parentView.close();
            this.getView().sendFormAction(parentView);
        }
        LicenseCache.releaseReadLock((String)this.getView().getPageId());
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{NEXT_PAGE, LAST_PAGE, CONFIRM_UPDATE});
        this.addSelectTabListener();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (SHOWASSIGN_DIF.equals(propertyName)) {
            BillList billlist = (BillList)this.getControl("billlistap_assign");
            billlist.setPageIndex(1);
            billlist.refresh();
            this.setColor(billlist);
        } else if (SHOWSTATUS_DIF.equals(propertyName)) {
            BillList billlist = (BillList)this.getControl("billlistap_userstatus");
            billlist.setPageIndex(1);
            billlist.refresh();
        }
    }

    private boolean isBlankLicense() {
        return (Boolean)DB.query((DBRoute)DBRoute.base, (String)"select fid from t_lic_license ", rs -> rs.next()) == false;
    }

    private boolean isBlackSnapshot() {
        return (Boolean)DB.query((DBRoute)DBRoute.base, (String)"select FDATA from T_LIC_Snapshot where fsnapshottype = '0' ", rs -> rs.next()) == false;
    }

    public void click(EventObject evt) {
        Button source = (Button)evt.getSource();
        String clickKey = source.getKey();
        if (CONFIRM_UPDATE.equals(clickKey)) {
            this.showLicenseUpdateConfirm();
        }
        if (NEXT_PAGE.equals(clickKey)) {
            String pageCount = this.getPageCache().get("pageCount");
            if (StringUtils.isEmpty((CharSequence)pageCount)) {
                pageCount = "0";
            }
            int currTab = Integer.parseInt(pageCount) + 1;
            this.activeTab(currTab);
        } else if (LAST_PAGE.equals(clickKey)) {
            String pageCount = this.getPageCache().get("pageCount");
            if (StringUtils.isEmpty((CharSequence)pageCount)) {
                pageCount = "0";
            }
            int currTab = Integer.parseInt(pageCount) - 1;
            this.activeTab(currTab);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        if (!LicenseCache.requireReadLock((String)e.getFormShowParameter().getPageId())) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u65b0\u8bb8\u53ef\u6b63\u5728\u8bd5\u7b97\uff0c\u8bf7\u7a0d\u540e\u518d\u5c1d\u8bd5\u3002", (String)"UpdateLicenseFormPlugin_29", (String)"bos-license-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void initialize() {
        this.buildLicenseAssignList();
        this.buildLicenseUserStatusList();
        this.addSearchFilterContainerListener();
        this.getLangName();
    }

    private void showLicenseUpdateConfirm() {
        if (this.isBlankLicense() || this.isBlackSnapshot()) {
            this.updateLicense(false);
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("lic_license_backup");
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u786e\u8ba4\u66f4\u65b0", (String)"UpdateLicenseFormPlugin_27", (String)"bos-license-formplugin", (Object[])new Object[0]));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "updateConfirm"));
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent c) {
        super.closedCallBack(c);
        String actionId = c.getActionId();
        if ("updateConfirm".equals(actionId)) {
            Object returnData = c.getReturnData();
            if ("dierctUpdate".equals(returnData)) {
                this.updateLicense(false);
            } else if ("backUpAndUpdate".equals(returnData)) {
                this.updateLicense(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLicense(boolean isCoverSnapShot) {
        try (TXHandle h = TX.requiresNew((String)"updateLicense");){
            LicenseCache.releaseReadLock((String)this.getView().getPageId());
            this.coverSnapShot(isCoverSnapShot);
            if (!LicenseSnapshotEngine.restoreTrial()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{SUCCESS_ICON});
                this.getModel().setValue(UPDTEA_MESSAGE, (Object)ResManager.loadKDString((String)"\u66f4\u65b0\u8bb8\u53ef\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"UpdateLicenseFormPlugin_0", (String)"bos-license-formplugin", (Object[])new Object[0]));
            } else {
                LicenseUpdateUtil.clearTrialTable();
                LicenseExpireUtil.updateExpireNoticeStatus();
                LicenseCacheMrg.clearCache((String)LicenseCacheMrg.getTypeLicenseTrialRedisMap());
                this.getView().setVisible(Boolean.FALSE, new String[]{ERROR_ICON});
            }
        }
        this.activeTab(3);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{CLOSE_BUTTON, CONFIRM_UPDATE, LAST_PAGE, SHOWASSIGN_DIF, SHOWSTATUS_DIF});
        this.insertLicenseGroupTotalInfo();
        this.getView().updateView("lic_groupdif");
        this.getModel().setValue(UPDTEA_MESSAGE, (Object)ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f", (String)"UpdateLicenseFormPlugin_17", (String)"bos-license-formplugin", (Object[])new Object[0]));
        this.getView().updateView(UPDTEA_MESSAGE);
    }

    private void insertLicenseGroupTotalInfo() {
        this.insertFlexControl("update_beforediv", this.loadLicenseInfo("now"));
        this.insertFlexControl("update_afterdiv", this.loadLicenseInfo("new"));
    }

    private void insertFlexControl(String flexKey, Collection<LicenseGroupDif> license) {
        int key = 0;
        Container flexBefore = (Container)this.getControl(flexKey);
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>(36);
        for (LicenseGroupDif licenseInfo : license) {
            items.add(this.createLicenseName(LICENSE_UP + ++key, licenseInfo.getLicenseName()));
            items.add(this.createLicenseInfo(LICENSE_UP + ++key, licenseInfo.getLeaseDate()));
            Map<String, String> groupInfos = licenseInfo.getGroupInfo();
            for (Map.Entry<String, String> groupInfo : groupInfos.entrySet()) {
                items.add(this.createLicenseGroup(LICENSE_UP + ++key, groupInfo.getKey()));
                items.add(this.createLicenseGroupDate(LICENSE_UP + ++key, groupInfo.getValue()));
            }
            items.add(this.createFlex(LICENSE_UP + ++key));
        }
        flexBefore.addControls(items);
    }

    private Map<String, Object> createTabControl(String key, String text, String width, String height, String weight, String color, int fontSize) {
        LabelAp labelAp = new LabelAp();
        if (StringUtils.isBlank((CharSequence)key)) {
            return Collections.EMPTY_MAP;
        }
        labelAp.setKey(key);
        labelAp.setName(new LocaleString(text));
        labelAp.setFontWeight(weight);
        if (!StringUtils.isBlank((CharSequence)width)) {
            labelAp.setWidth(new LocaleString(width));
        }
        if (!StringUtils.isBlank((CharSequence)height)) {
            labelAp.setHeight(new LocaleString(height));
        }
        labelAp.setForeColor(color);
        labelAp.setFontSize(fontSize);
        return labelAp.createControl();
    }

    private Map<String, Object> createLicenseName(String key, String name) {
        return this.createTabControl(key, name, "416px", "37px", "600", "#212121", 14);
    }

    private Map<String, Object> createFlex(String key) {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(key + "_flex");
        flexPanelAp.setHeight(new LocaleString("30px"));
        flexPanelAp.setWidth(new LocaleString("416px"));
        return flexPanelAp.createControl();
    }

    private Map<String, Object> createLicenseGroup(String key, String name) {
        return this.createTabControl(key, name, "220px", "36px", "400", "#666666", 12);
    }

    private Map<String, Object> createLicenseGroupDate(String key, String name) {
        return this.createTabControl(key, name, "142px", "36px", "400", "#212121", 12);
    }

    private Map<String, Object> createLicenseInfo(String tabKey, String date) {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(tabKey + "_flex");
        flexPanelAp.setDirection("row");
        flexPanelAp.setJustifyContent("space-between");
        flexPanelAp.setWrap(true);
        Style style = new Style();
        Border border = new Border();
        border.setBottom("1px solid #E5E5E5");
        style.setBorder(border);
        Margin margin = new Margin();
        margin.setBottom("10px");
        style.setMargin(margin);
        flexPanelAp.setStyle(style);
        LabelAp tipAp = new LabelAp();
        tipAp.setKey(tabKey);
        tipAp.setName(new LocaleString(ResManager.loadKDString((String)"\u79df\u8d41\u65e5\u671f", (String)"UpdateLicenseFormPlugin_26", (String)"bos-license-formplugin", (Object[])new Object[0])));
        tipAp.setFontWeight("400");
        tipAp.setFontSize(12);
        tipAp.setForeColor("#666666");
        tipAp.setWidth(new LocaleString("220px"));
        tipAp.setHeight(new LocaleString("26px"));
        LabelAp dateAp = new LabelAp();
        dateAp.setKey(tabKey + "_date");
        dateAp.setName(new LocaleString(date));
        tipAp.setFontWeight("400");
        tipAp.setFontSize(12);
        dateAp.setForeColor("#212121");
        dateAp.setWidth(new LocaleString("142px"));
        dateAp.setHeight(new LocaleString("26px"));
        flexPanelAp.getItems().add(tipAp);
        flexPanelAp.getItems().add(dateAp);
        return flexPanelAp.createControl();
    }

    private String getLangName() {
        try {
            String localName = RequestContext.get().getLang().name();
            if (langNamelist.contains(localName)) {
                return localName;
            }
            String langName = this.getView().getPageCache().get("langName");
            if (!StringUtils.isEmpty((CharSequence)langName)) {
                return langName;
            }
            Boolean isExist = (Boolean)DB.query((DBRoute)DBRoute.base, (String)String.format("select top 1 fid from t_lic_group_l where flocaleid = '%s'", localName), rs -> rs.next());
            if (isExist.booleanValue()) {
                this.getView().getPageCache().put("langName", localName);
                return localName;
            }
            this.getView().getPageCache().put("langName", "zh_CN");
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6langName\u51fa\u9519\uff0c\u9ed8\u8ba4\u4e2d\u6587\u663e\u793a\u3002", (Throwable)e);
        }
        return "zh_CN";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection<LicenseGroupDif> loadLicenseInfo(String type) {
        String licenseDetailTable;
        String licenseTable;
        boolean isOEM = DevVerifyServiceHelper.isOEMEnv();
        List<Long> allShowGroupId = new ArrayList(16);
        if (isOEM) {
            allShowGroupId = LicenseGroupUtil.getAllIsvGroupId();
            Set groupIds = LicenseGroupUtil.getLicenseGroup((String)"1").keySet();
            if (!CollectionUtils.isEmpty(groupIds)) {
                for (String groupId : groupIds) {
                    try {
                        allShowGroupId.add(Long.parseLong(groupId));
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if ("new".equalsIgnoreCase(type)) {
            licenseTable = "t_lic_license_trial";
            licenseDetailTable = "t_lic_licDetail_trial";
        } else {
            licenseTable = "t_lic_license";
            licenseDetailTable = "t_lic_licensedetail";
        }
        HashMap<String, String> productIdToName = new HashMap<String, String>(16);
        Map licProd = BusinessDataServiceHelper.loadFromCache((String)"lic_prod", (String)"productid,name", null);
        if (!CollectionUtils.isEmpty((Map)licProd)) {
            for (Map.Entry licProdInfo : licProd.entrySet()) {
                ILocaleString name;
                DynamicObject licProdDyn = (DynamicObject)licProdInfo.getValue();
                if (null == licProd || null == (name = licProdDyn.getLocaleString("name"))) continue;
                String localeValue = name.getLocaleValue();
                if (StringUtils.isBlank((CharSequence)localeValue)) {
                    localeValue = name.getLocaleValue_en();
                }
                if (StringUtils.isBlank((CharSequence)localeValue)) continue;
                productIdToName.put(licProdDyn.getString("productid"), localeValue);
            }
        }
        String langName = this.getLangName();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        LinkedHashMap<String, LicenseGroupDif> result = new LinkedHashMap<String, LicenseGroupDif>(2);
        StringBuilder licenseSql = new StringBuilder();
        licenseSql.append("select g.fid licenseid,g.fproductid productId,pl.fname licensename,g.fname softwarename ,g.fproductversion productversion ,g.factivedate licenseactivedate,g.fexpdate licenseexpdate from ");
        licenseSql.append(licenseTable);
        licenseSql.append(" g left outer join t_lic_isvprod p ");
        licenseSql.append(" on p.fid = g.fprodid left outer join t_lic_isvprod_l pl on pl.fid = p.fid and ");
        licenseSql.append(String.format(" pl.flocaleid  = '%s' ", langName));
        licenseSql.append(" order by pl.fname,g.fproductno");
        SqlBuilder groupSql = new SqlBuilder();
        groupSql.append("select a.fid licenseid,a.fgroupid groupid ,a.ftotalcount totalcount,b.ftype grouptype,c.fname groupname,a.fbegindate groupbegindate,a.fenddate groupenddate  from ", new Object[0]);
        groupSql.append(licenseDetailTable, new Object[0]);
        groupSql.append(" a inner join t_lic_group  b on a.fgroupid = b.fid join t_lic_group_l c on b.fid = c.fid and ", new Object[0]);
        groupSql.append(String.format(" c.flocaleid  = '%s' ", langName), new Object[0]);
        if (isOEM && !CollectionUtils.isEmpty(allShowGroupId)) {
            groupSql.append(" WHERE ", new Object[0]);
            groupSql.appendIn(" a.fgroupid ", allShowGroupId.toArray());
        }
        groupSql.append("order by grouptype,groupid", new Object[0]);
        try (DataSet selectLicenseInfo = DB.queryDataSet((String)"select_lic_license", (DBRoute)DBRoute.base, (String)licenseSql.toString());
             DataSet selectLicenseGroupInfo = DB.queryDataSet((String)"selectLicenseGroupInfo", (DBRoute)DBRoute.base, (SqlBuilder)groupSql);
             DataSet licenseInfoDS = selectLicenseInfo.leftJoin(selectLicenseGroupInfo).on("licenseid", "licenseid").select(new String[]{"productId", "licenseid", "softwarename", "licensename", "groupid", "totalcount", "grouptype", "groupname", "productversion", "licenseactivedate", "licenseexpdate", "groupbegindate", "groupenddate"}).finish();){
            if (null == licenseInfoDS || licenseInfoDS.isEmpty()) {
                List<LicenseGroupDif> list = Collections.emptyList();
                return list;
            }
            HashMap<String, Map> licenseVersionGroupNamesMap = new HashMap<String, Map>(2);
            for (Row row : licenseInfoDS) {
                String productId = row.getString("productId");
                String softwareName = (String)productIdToName.get(productId);
                String productversion = row.getString("productversion");
                String groupid = row.getString("groupid");
                Map groupIdAndname = LicenseGroupUtil.getLicenseGroup((String)productversion, null);
                if (StringUtils.isBlank((CharSequence)softwareName)) {
                    softwareName = row.getString("softwarename");
                }
                String licenseName = row.getString("licensename");
                String leaseDate = sdf.format(row.getDate("licenseactivedate")) + " " + ResManager.loadKDString((String)"\u81f3", (String)"LicenseDetailListPlugin_51", (String)"bos-license-formplugin", (Object[])new Object[0]) + " " + this.getStringDate(row.getDate("licenseexpdate"));
                String groupName = (String)groupIdAndname.get(row.getString("groupid"));
                StringBuilder groupDate = new StringBuilder();
                if (StringUtils.isEmpty((CharSequence)groupName)) {
                    groupName = row.getString("groupname");
                }
                licenseVersionGroupNamesMap.computeIfAbsent(type, k -> new HashMap()).put(groupid, groupName);
                String groupTotalCount = row.getString("totalcount");
                String groupType = row.getString("grouptype");
                if (StringUtils.isNotEmpty((CharSequence)softwareName)) {
                    licenseName = softwareName.contains("kingdee eas nextcloud") ? ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u00b7\u82cd\u7a79", (String)"LicenseDetailListPlugin_26", (String)"bos-license-formplugin", (Object[])new Object[0]) : softwareName;
                }
                LicenseGroupDif licenseGroupDif = result.computeIfAbsent(licenseName, k -> new LicenseGroupDif());
                licenseGroupDif.setLicenseName(licenseName + " V" + productversion);
                licenseGroupDif.setLeaseDate(leaseDate);
                Map<String, String> groupInfo = licenseGroupDif.getGroupInfo();
                groupName = "2".equals(groupType) ? groupName + "\r\n" : groupName + "(" + groupTotalCount + ")\r\n";
                groupDate.append(sdf.format(row.getDate("groupbegindate")));
                groupDate.append(" ");
                groupDate.append(ResManager.loadKDString((String)"\u81f3", (String)"LicenseDetailListPlugin_51", (String)"bos-license-formplugin", (Object[])new Object[0]));
                groupDate.append(" ");
                groupDate.append(this.getStringDate(row.getDate("groupenddate"))).append("\r\n");
                groupInfo.put(groupName, groupDate.toString());
            }
            String licenseGroups = this.getPageCache().get("licenseGroups");
            if (!StringUtils.isEmpty((CharSequence)licenseGroups)) {
                Map licenseGroupNames = (Map)SerializationUtils.fromJsonString((String)licenseGroups, Map.class);
                licenseVersionGroupNamesMap.putAll(licenseGroupNames);
            }
            this.getPageCache().put("licenseGroups", SerializationUtils.toJsonString(licenseVersionGroupNamesMap));
            return result.values();
        }
        catch (Exception e) {
            logger.error("\u52a0\u8f7d\u5f53\u524d\u8bb8\u53ef\u5206\u7ec4\u51fa\u9519", (Throwable)e);
        }
        return result.values();
    }

    private String getStringDate(Date date) {
        if (null == date) {
            return " ";
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (calendar.get(1) >= 2099) {
            return ResManager.loadKDString((String)"\u4e0d\u9650", (String)"LicenseDetailListPlugin_20", (String)"bos-license-formplugin", (Object[])new Object[0]);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setColor((BillList)this.getView().getControl("billlistap_assign"));
    }

    private void setColor(BillList billList) {
        if (null == billList) {
            return;
        }
        String redColumnJson = this.getPageCache().get("redColumn");
        if (StringUtils.isEmpty((CharSequence)redColumnJson)) {
            return;
        }
        List redColumn = (List)SerializationUtils.fromJsonString((String)redColumnJson, List.class);
        if (!CollectionUtils.isEmpty((Collection)redColumn)) {
            ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(redColumn.size());
            Iterator iterator = redColumn.iterator();
            while (iterator.hasNext()) {
                int count = (Integer)iterator.next();
                CellStyle item = new CellStyle();
                item.setFieldKey(LICENSEASSIGN_REMARK);
                item.setForeColor("red");
                item.setRow(count);
                cellStyles.add(item);
            }
            billList.setCellStyle(cellStyles);
        }
    }

    private static Map<String, String> getAllAccountTrialGroupUsers() {
        String type = LicenseCacheMrg.getTypeLicenseTrialRedisMap();
        Map allAccountGroupUsers = LicenseCacheMrg.getCache((String)type);
        List centerList = AccountUtils.getAllAccounts((String)RequestContext.get().getTenantId());
        HashMap<Long, Set> allAccountUserBitMapIndex = new HashMap<Long, Set>(32);
        for (Account account : centerList) {
            String json;
            if (null == account || StringUtils.isEmpty((CharSequence)(json = (String)allAccountGroupUsers.get(account.getAccountId())))) continue;
            Map userBitMapIndex = (Map)JSON.parseObject((String)json, (TypeReference)new TypeReference<Map<Long, Set<Integer>>>(){}, (Feature[])new Feature[0]);
            for (Map.Entry groupAndIndexs : userBitMapIndex.entrySet()) {
                Long groupId = (Long)groupAndIndexs.getKey();
                Set indexSet = (Set)groupAndIndexs.getValue();
                if (CollectionUtils.isEmpty((Collection)indexSet)) continue;
                allAccountUserBitMapIndex.computeIfAbsent(groupId, k -> new HashSet()).addAll(indexSet);
            }
        }
        HashMap<String, String> result = new HashMap<String, String>(32);
        for (Map.Entry allAccountUserBitMapIndexEntry : allAccountUserBitMapIndex.entrySet()) {
            result.put(((Long)allAccountUserBitMapIndexEntry.getKey()).toString(), String.valueOf(((Set)allAccountUserBitMapIndexEntry.getValue()).size()));
        }
        return result;
    }

    private boolean isCtrlAmountLicense() {
        return (Boolean)DB.query((DBRoute)DBRoute.base, (String)"select fid from t_lic_licdetail_trial where fgroupid in (186,187)", k -> k.next());
    }

    private void addSelectTabListener() {
        Tab tabap = (Tab)this.getControl(TAB);
        tabap.addTabSelectListener(new TabSelectListener(){

            public void tabSelected(TabSelectEvent tabSelectEvent) {
                String tabKey;
                switch (tabKey = tabSelectEvent.getTabKey()) {
                    case "lic_groupdif": {
                        UpdateLicenseFormPlugin.this.getView().setVisible(Boolean.valueOf(true), new String[]{UpdateLicenseFormPlugin.NEXT_PAGE, UpdateLicenseFormPlugin.BTN_CANCEL});
                        UpdateLicenseFormPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{UpdateLicenseFormPlugin.CLOSE_BUTTON, UpdateLicenseFormPlugin.CONFIRM_UPDATE, UpdateLicenseFormPlugin.LAST_PAGE, UpdateLicenseFormPlugin.SHOWASSIGN_DIF, UpdateLicenseFormPlugin.SHOWSTATUS_DIF});
                        UpdateLicenseFormPlugin.this.getPageCache().put("pageCount", "0");
                        break;
                    }
                    case "lic_assigndif": {
                        UpdateLicenseFormPlugin.this.getView().setVisible(Boolean.valueOf(true), new String[]{UpdateLicenseFormPlugin.NEXT_PAGE, UpdateLicenseFormPlugin.BTN_CANCEL, UpdateLicenseFormPlugin.LAST_PAGE, UpdateLicenseFormPlugin.SHOWASSIGN_DIF});
                        UpdateLicenseFormPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{UpdateLicenseFormPlugin.CLOSE_BUTTON, UpdateLicenseFormPlugin.CONFIRM_UPDATE, UpdateLicenseFormPlugin.SHOWSTATUS_DIF});
                        UpdateLicenseFormPlugin.this.getPageCache().put("pageCount", "1");
                        break;
                    }
                    case "lic_userstatusdif": {
                        UpdateLicenseFormPlugin.this.getView().setVisible(Boolean.valueOf(true), new String[]{UpdateLicenseFormPlugin.BTN_CANCEL, UpdateLicenseFormPlugin.LAST_PAGE, UpdateLicenseFormPlugin.CONFIRM_UPDATE, UpdateLicenseFormPlugin.SHOWSTATUS_DIF});
                        UpdateLicenseFormPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{UpdateLicenseFormPlugin.NEXT_PAGE, UpdateLicenseFormPlugin.CLOSE_BUTTON, UpdateLicenseFormPlugin.SHOWASSIGN_DIF});
                        UpdateLicenseFormPlugin.this.getPageCache().put("pageCount", "2");
                        break;
                    }
                    case "lic_updateresult": {
                        UpdateLicenseFormPlugin.this.getView().setVisible(Boolean.valueOf(true), new String[]{UpdateLicenseFormPlugin.CLOSE_BUTTON});
                        UpdateLicenseFormPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{UpdateLicenseFormPlugin.NEXT_PAGE, UpdateLicenseFormPlugin.CONFIRM_UPDATE, UpdateLicenseFormPlugin.BTN_CANCEL, UpdateLicenseFormPlugin.LAST_PAGE, UpdateLicenseFormPlugin.SHOWASSIGN_DIF, UpdateLicenseFormPlugin.SHOWSTATUS_DIF});
                        UpdateLicenseFormPlugin.this.getPageCache().put("pageCount", "3");
                    }
                }
            }
        });
    }

    private void addSearchFilterContainerListener() {
        FilterContainer filterContainer = (FilterContainer)this.getControl(FILTER_CONTAINER);
        filterContainer.setBillFormId(ENTITY);
        filterContainer.setEntityId(ENTITY);
        filterContainer.setSearchFields(Arrays.asList(USER_NAME, USER_PHONE, GROUP_NAME));
        filterContainer.addSearchClickListener(new SearchClickListener(){

            public void click(SearchClickEvent searchClickEvent) {
                List fastfilter = (List)searchClickEvent.getFilterValues().get("fastfilter");
                UpdateLicenseFormPlugin.this.getPageCache().put("searchFilter", UpdateLicenseFormPlugin.this.parseSearchQFilter(fastfilter));
                BillList userStatusDifList = (BillList)UpdateLicenseFormPlugin.this.getControl("billlistap_userstatus");
                userStatusDifList.setPageIndex(1);
                userStatusDifList.refresh();
            }
        });
    }

    private void buildLicenseAssignList() {
        final String[][] LicenseAssignDifArrays = new String[][]{{ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"UpdateLicenseFormPlugin_1", (String)"bos-license-formplugin", (Object[])new Object[0]), SEQ}, {ResManager.loadKDString((String)"\u8bb8\u53ef\u5206\u7ec4", (String)"UpdateLicenseFormPlugin_2", (String)"bos-license-formplugin", (Object[])new Object[0]), GROUP_NAME}, {ResManager.loadKDString((String)"\u66f4\u65b0\u524d\u5360\u7528\u60c5\u51b5", (String)"UpdateLicenseFormPlugin_3", (String)"bos-license-formplugin", (Object[])new Object[0]), LICENSEASSIGN_NOW}, {ResManager.loadKDString((String)"\u66f4\u65b0\u540e\u5360\u7528\u60c5\u51b5", (String)"UpdateLicenseFormPlugin_4", (String)"bos-license-formplugin", (Object[])new Object[0]), LICENSEASSIGN_NEW}, {ResManager.loadKDString((String)"\u5907\u6ce8", (String)"UpdateLicenseFormPlugin_21", (String)"bos-license-formplugin", (Object[])new Object[0]), LICENSEASSIGN_REMARK}};
        BillList billlist = (BillList)this.getControl("billlistap_assign");
        billlist.addCreateListColumnsListener(new CreateListColumnsListener(){

            public void createListColumns(BeforeCreateListColumnsArgs args) {
                List listColumns = args.getListColumns();
                for (String[] arr : LicenseAssignDifArrays) {
                    ListColumn listColumn = UpdateLicenseFormPlugin.this.createListColumn(arr);
                    listColumns.add(listColumn);
                }
            }
        });
        billlist.addCreateListDataProviderListener(new CreateListDataProviderListener(){

            public void createListDataProvider(BeforeCreateListDataProviderArgs beforeCreateListDataProviderArgs) {
                beforeCreateListDataProviderArgs.setListDataProvider((IListDataProvider)new LicenseAssignDifListDataProvider());
            }
        });
    }

    private void buildLicenseUserStatusList() {
        final String[][] LicenseUserStatusDifArrays = new String[][]{{ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"UpdateLicenseFormPlugin_1", (String)"bos-license-formplugin", (Object[])new Object[0]), SEQ}, {ResManager.loadKDString((String)"\u59d3\u540d", (String)"UpdateLicenseFormPlugin_6", (String)"bos-license-formplugin", (Object[])new Object[0]), USER_NAME}, {ResManager.loadKDString((String)"\u624b\u673a", (String)"UpdateLicenseFormPlugin_7", (String)"bos-license-formplugin", (Object[])new Object[0]), USER_PHONE}, {ResManager.loadKDString((String)"\u90ae\u7bb1", (String)"UpdateLicenseFormPlugin_8", (String)"bos-license-formplugin", (Object[])new Object[0]), USER_EMAIL}, {ResManager.loadKDString((String)"\u66f4\u65b0\u524d\u8bb8\u53ef\u5206\u7ec4", (String)"UpdateLicenseFormPlugin_9", (String)"bos-license-formplugin", (Object[])new Object[0]), GROUP_NEMA_NOW}, {ResManager.loadKDString((String)"\u66f4\u65b0\u540e\u8bb8\u53ef\u5206\u7ec4", (String)"UpdateLicenseFormPlugin_10", (String)"bos-license-formplugin", (Object[])new Object[0]), GROUP_NEMA_NEW}, {ResManager.loadKDString((String)"\u66f4\u65b0\u524d\u4f7f\u7528\u72b6\u6001", (String)"UpdateLicenseFormPlugin_11", (String)"bos-license-formplugin", (Object[])new Object[0]), USERSYNSTATUS_NOW}, {ResManager.loadKDString((String)"\u66f4\u65b0\u540e\u4f7f\u7528\u72b6\u6001", (String)"UpdateLicenseFormPlugin_12", (String)"bos-license-formplugin", (Object[])new Object[0]), USERSYNSTATUS_NEW}};
        BillList userStatusDifList = (BillList)this.getControl("billlistap_userstatus");
        userStatusDifList.addCreateListColumnsListener(new CreateListColumnsListener(){

            public void createListColumns(BeforeCreateListColumnsArgs args) {
                List listColumns = args.getListColumns();
                for (String[] arr : LicenseUserStatusDifArrays) {
                    ListColumn listColumn = UpdateLicenseFormPlugin.this.createListColumn(arr);
                    listColumns.add(listColumn);
                }
            }
        });
        userStatusDifList.addCreateListDataProviderListener(new CreateListDataProviderListener(){

            public void createListDataProvider(BeforeCreateListDataProviderArgs beforeCreateListDataProviderArgs) {
                beforeCreateListDataProviderArgs.setListDataProvider((IListDataProvider)new UserStatusDifListDataProvider());
            }
        });
    }

    private String parseSearchQFilter(List<Map<String, List<Object>>> fastfilter) {
        if (CollectionUtils.isEmpty(fastfilter)) {
            return "";
        }
        StringBuilder filterSql = new StringBuilder();
        for (Map<String, List<Object>> searchFilters : fastfilter) {
            List<String> realFieldName = this.parseSearchFieldName(searchFilters.get("FieldName"));
            List<Object> searchValues = searchFilters.get("Value");
            filterSql.append("(");
            for (String field : realFieldName) {
                for (Object search : searchValues) {
                    String searchStr = String.valueOf(search);
                    filterSql.append(field).append(" like ").append("'%").append(searchStr).append("%'").append(" or ");
                }
            }
            int length = filterSql.length();
            filterSql.delete(length - 3, length);
            filterSql.append(") and ");
        }
        int count = filterSql.length();
        filterSql.delete(count - 4, count);
        return filterSql.toString();
    }

    private List<String> parseSearchFieldName(List<Object> fieldNames) {
        if (CollectionUtils.isEmpty(fieldNames)) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> fieldNameList = new ArrayList<String>(fieldNames.size() * 2);
        for (Object fieldName : fieldNames) {
            fieldNameList.addAll(this.getRealFieldName(String.valueOf(fieldName)));
        }
        return fieldNameList;
    }

    private List<String> getRealFieldName(String fieldStr) {
        ArrayList<String> array = new ArrayList<String>(2);
        switch (fieldStr) {
            case "user_name": {
                array.add(USER_NAME);
                break;
            }
            case "user_phone": {
                array.add(USER_PHONE);
                break;
            }
            case "group_name": {
                array.add(GROUP_NEMA_NOW);
                array.add(GROUP_NEMA_NEW);
            }
        }
        return array;
    }

    private ListColumn createListColumn(String[] arr) {
        ListColumn listColumn = new ListColumn();
        listColumn.setCaption(new LocaleString(arr[0]));
        listColumn.setClassName("className");
        listColumn.setFieldName(arr[1]);
        listColumn.setKey("key" + arr[1]);
        if (SEQ.equals(arr[1])) {
            listColumn.setTextAlign("center");
        } else {
            listColumn.setTextAlign("left");
        }
        listColumn.setWidth(new LocaleString("12%"));
        listColumn.setParentViewKey("gridview");
        listColumn.setListFieldKey(arr[1]);
        listColumn.setSeq(2);
        listColumn.setVisible(11);
        if (arr[1].equals(GROUP_NAME)) {
            listColumn.setOrder(SortType.ASC.toString());
        }
        return listColumn;
    }

    private void coverSnapShot(boolean isCoverSnapShot) {
        boolean isNeedForcedBackUp;
        boolean bl = isNeedForcedBackUp = !this.isBlankLicense() && this.isBlackSnapshot();
        if (isNeedForcedBackUp || isCoverSnapShot) {
            LicenseSnapshotEngine.backUp();
        }
    }

    private void activeTab(int selectTab) {
        if (selectTab >= tabList.size() || selectTab < 0) {
            return;
        }
        Tab tabap = (Tab)this.getControl(TAB);
        tabap.activeTab(tabList.get(selectTab));
        this.getPageCache().put("pageCount", selectTab + "");
    }

    static class LicenseGroupDif {
        private String licenseName;
        private String leaseDate;
        private Map<String, String> groupInfo = new LinkedHashMap<String, String>(16);

        LicenseGroupDif() {
        }

        public String getLicenseName() {
            return this.licenseName;
        }

        public void setLicenseName(String licenseName) {
            this.licenseName = licenseName;
        }

        public String getLeaseDate() {
            return this.leaseDate;
        }

        public void setLeaseDate(String leaseDate) {
            this.leaseDate = leaseDate;
        }

        public Map<String, String> getGroupInfo() {
            return this.groupInfo;
        }

        public void setGroupInfo(Map<String, String> groupInfo) {
            this.groupInfo = groupInfo;
        }
    }

    class LicenseAssignDifListDataProvider
    extends ListDataProvider {
        public static final String LICENSEDETAIL_NOW = "t_lic_licensedetail";
        public static final String LICENSEDETAIL_NEW = "t_lic_licdetail_trial";

        LicenseAssignDifListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            boolean showdif = (Boolean)UpdateLicenseFormPlugin.this.getModel().getValue(UpdateLicenseFormPlugin.SHOWASSIGN_DIF);
            int count = 0;
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)UpdateLicenseFormPlugin.ENTITY);
            DynamicObjectCollection curPageData = new DynamicObjectCollection((DynamicObjectType)dataEntityType, null);
            HashMap<String, Map<String, Map<String, String>>> licenseGroupInfoMap = new HashMap<String, Map<String, Map<String, String>>>(10);
            this.queryLicenseGroupInfo(LICENSEDETAIL_NOW, licenseGroupInfoMap);
            this.queryLicenseGroupInfo(LICENSEDETAIL_NEW, licenseGroupInfoMap);
            HashSet<Integer> redColumn = new HashSet<Integer>(16);
            for (Map.Entry info : licenseGroupInfoMap.entrySet()) {
                Map licenseGroupInfoNew;
                String groupNameNow = null;
                String groupNameNew = null;
                String licenseAssignNow = null;
                String licenseAssignNew = null;
                long totalCountNow = 0L;
                long totalCountNew = 0L;
                DynamicObject row = new DynamicObject((DynamicObjectType)dataEntityType);
                String groupId = (String)info.getKey();
                Map LicenseGroupInfos = (Map)info.getValue();
                Map licenseGroupInfoNow = (Map)LicenseGroupInfos.get(LICENSEDETAIL_NOW);
                if (null != licenseGroupInfoNow) {
                    groupNameNow = (String)licenseGroupInfoNow.get("groupName");
                    if ("16".equals(groupId)) {
                        String totalCount;
                        SmsUsingQuantities smsUsingQuantitySummary = MessageCenterServiceHelper.getSmsUsingQuantitySummary();
                        Long successSum = smsUsingQuantitySummary.getSuccessSum();
                        Long sum = 0L;
                        if (null != successSum) {
                            sum = successSum;
                        }
                        if (!StringUtils.isBlank((CharSequence)(totalCount = (String)licenseGroupInfoNow.get("totalCount")))) {
                            totalCountNow = Long.parseLong(totalCount) * 10000L;
                        }
                        licenseAssignNow = sum + "/" + totalCountNow;
                    } else {
                        String totalCount = (String)licenseGroupInfoNow.get("totalCount");
                        if (!StringUtils.isBlank((CharSequence)totalCount)) {
                            totalCountNow = Long.parseLong(totalCount);
                        }
                        licenseAssignNow = (String)licenseGroupInfoNow.get("assignCount") + "/" + totalCountNow;
                    }
                }
                if (null != (licenseGroupInfoNew = (Map)LicenseGroupInfos.get(LICENSEDETAIL_NEW))) {
                    groupNameNew = (String)licenseGroupInfoNew.get("groupName");
                    if ("16".equals(groupId)) {
                        String totalCount;
                        SmsUsingQuantities smsUsingQuantitySummary = MessageCenterServiceHelper.getSmsUsingQuantitySummary();
                        Long successSum = smsUsingQuantitySummary.getSuccessSum();
                        Long sum = 0L;
                        if (null != successSum) {
                            sum = successSum;
                        }
                        if (!StringUtils.isBlank((CharSequence)(totalCount = (String)licenseGroupInfoNew.get("totalCount")))) {
                            totalCountNew = Long.parseLong(totalCount) * 10000L;
                        }
                        licenseAssignNew = sum + "/" + totalCountNew;
                    } else {
                        String totalCount = (String)licenseGroupInfoNew.get("totalCount");
                        if (!StringUtils.isBlank((CharSequence)totalCount)) {
                            totalCountNew = Long.parseLong(totalCount);
                        }
                        licenseAssignNew = (String)licenseGroupInfoNew.get("assignCount") + "/" + totalCountNew;
                    }
                }
                if (!showdif) {
                    ++count;
                } else {
                    if (StringUtil.compare(licenseAssignNow, licenseAssignNew) == 0) continue;
                    ++count;
                }
                if (count <= start || count > start + limit) continue;
                row.set(UpdateLicenseFormPlugin.SEQ, (Object)count);
                row.set(UpdateLicenseFormPlugin.LICENSEASSIGN_NOW, StringUtils.isEmpty(licenseAssignNow) ? Integer.valueOf(0) : licenseAssignNow);
                row.set(UpdateLicenseFormPlugin.LICENSEASSIGN_NEW, StringUtils.isEmpty(licenseAssignNew) ? Integer.valueOf(0) : licenseAssignNew);
                row.set(UpdateLicenseFormPlugin.GROUP_NAME, (Object)(StringUtils.isEmpty((CharSequence)groupNameNow) ? groupNameNew : groupNameNow));
                row.set(UpdateLicenseFormPlugin.LICENSEASSIGN_REMARK, (Object)this.getRemark(totalCountNow, totalCountNew, count - 1, redColumn));
                curPageData.add((Object)row);
            }
            UpdateLicenseFormPlugin.this.getPageCache().put("size", count + "");
            if (!CollectionUtils.isEmpty(redColumn)) {
                UpdateLicenseFormPlugin.this.getPageCache().put("redColumn", SerializationUtils.toJsonString(redColumn));
            }
            return curPageData;
        }

        private String getRemark(long nowTotal, long newTotal, int count, Set<Integer> redColumn) {
            int compare = Long.compare(nowTotal, newTotal);
            if (0 == compare) {
                return "";
            }
            if (compare > 0 && 0L == newTotal) {
                redColumn.add(count);
                return ResManager.loadKDString((String)"\u51cf\u6a21", (String)"UpdateLicenseFormPlugin_24", (String)"bos-license-formplugin", (Object[])new Object[0]);
            }
            if (compare > 0) {
                redColumn.add(count);
                return ResManager.loadKDString((String)"\u51cf\u7ad9", (String)"UpdateLicenseFormPlugin_25", (String)"bos-license-formplugin", (Object[])new Object[0]);
            }
            if (compare < 0 && 0L == nowTotal) {
                return ResManager.loadKDString((String)"\u52a0\u6a21", (String)"UpdateLicenseFormPlugin_22", (String)"bos-license-formplugin", (Object[])new Object[0]);
            }
            if (compare < 0) {
                return ResManager.loadKDString((String)"\u52a0\u7ad9", (String)"UpdateLicenseFormPlugin_23", (String)"bos-license-formplugin", (Object[])new Object[0]);
            }
            return "";
        }

        public int getDataCount() {
            String size = UpdateLicenseFormPlugin.this.getPageCache().get("size");
            if (StringUtils.isEmpty((CharSequence)size)) {
                size = "0";
            }
            return Integer.parseInt(size);
        }

        public int getRealCount() {
            String size = UpdateLicenseFormPlugin.this.getPageCache().get("size");
            if (StringUtils.isEmpty((CharSequence)size)) {
                size = "0";
            }
            return Integer.parseInt(size);
        }

        private Map<String, Map<String, Map<String, String>>> queryLicenseGroupInfo(String tableName, Map<String, Map<String, Map<String, String>>> licenseGroupInfoMap) {
            String type;
            String string = type = tableName.contains("trial") ? "new" : "now";
            if (licenseGroupInfoMap == null) {
                return new HashMap<String, Map<String, Map<String, String>>>(0);
            }
            boolean isOEM = DevVerifyServiceHelper.isOEMEnv();
            List<Long> allShowGroupId = new ArrayList(16);
            if (isOEM) {
                allShowGroupId = LicenseGroupUtil.getAllIsvGroupId();
                Set groupIds = LicenseGroupUtil.getLicenseGroup((String)"1").keySet();
                if (!CollectionUtils.isEmpty(groupIds)) {
                    for (String groupId : groupIds) {
                        try {
                            allShowGroupId.add(Long.parseLong(groupId));
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            Map licAllocateNumberByGroupIds = new HashMap(0);
            Map allAccountTrialGroupUsers = new HashMap(0);
            String langName = UpdateLicenseFormPlugin.this.getLangName();
            if ("now".equals(type)) {
                if (LicenseUtil.isHighAvailabilityMode() && !LicenseCache.isCtrlAmountIgnoreTime()) {
                    Map hasBoughtRegLicGroup = LicenseGroupUtil.getHasBoughtRegLicGroup();
                    ArrayList<Long> groupIds = new ArrayList<Long>(32);
                    if (!CollectionUtils.isEmpty((Map)hasBoughtRegLicGroup)) {
                        for (String groupIdStr : hasBoughtRegLicGroup.keySet()) {
                            groupIds.add(Long.parseLong(groupIdStr));
                        }
                    }
                    licAllocateNumberByGroupIds = LicenseUserRelEngine.getLicAllocateNumberByGroupIds(groupIds);
                }
            } else if (!UpdateLicenseFormPlugin.this.isCtrlAmountLicense()) {
                allAccountTrialGroupUsers = UpdateLicenseFormPlugin.getAllAccountTrialGroupUsers();
            }
            Map licenseVersionGroupNamesMap = new HashMap(2);
            String licenseGroups = UpdateLicenseFormPlugin.this.getPageCache().get("licenseGroups");
            if (!StringUtils.isEmpty((CharSequence)licenseGroups)) {
                licenseVersionGroupNamesMap = (Map)SerializationUtils.fromJsonString((String)licenseGroups, Map.class);
            }
            SqlBuilder sql = new SqlBuilder();
            sql.append("select a.fgroupid groupid ,a.ftotalcount totalcount,a.fassignedcount assigncount,b.ftype grouptype,c.fname groupname,a.fid licenseid from ", new Object[0]);
            sql.append(tableName, new Object[0]);
            sql.append(" a inner join t_lic_group  b on a.fgroupid = b.fid join t_lic_group_l c on b.fid = c.fid and ", new Object[0]);
            sql.append(String.format(" c.flocaleid  = '%s' ", langName), new Object[0]);
            if (isOEM && !CollectionUtils.isEmpty(allShowGroupId)) {
                sql.append(" WHERE ", new Object[0]);
                sql.appendIn(" a.fgroupid ", allShowGroupId.toArray());
            }
            sql.append("order by grouptype,groupid", new Object[0]);
            try (DataSet selectLicenseInfo = DB.queryDataSet((String)("select_licenseInfo" + tableName), (DBRoute)DBRoute.base, (SqlBuilder)sql);){
                if (null != selectLicenseInfo && !selectLicenseInfo.isEmpty()) {
                    for (Row row : selectLicenseInfo) {
                        HashMap<String, String> licenseGroupInfo = new HashMap<String, String>(5);
                        String groupId = row.getString("groupid");
                        String totalCount = row.getString("totalcount");
                        String assignCount = "";
                        if ("now".equals(type)) {
                            Integer regAssCount = (Integer)licAllocateNumberByGroupIds.get(Long.parseLong(groupId));
                            assignCount = null == regAssCount ? row.getString("assigncount") : regAssCount + "";
                        } else {
                            String count = (String)allAccountTrialGroupUsers.get(groupId);
                            String string2 = assignCount = StringUtils.isEmpty((CharSequence)count) ? row.getString("assigncount") : count;
                            if (StringUtils.isNotEmpty((CharSequence)assignCount) && Integer.parseInt(assignCount) > Integer.parseInt(totalCount)) {
                                assignCount = totalCount;
                            }
                        }
                        String groupType = row.getString("grouptype");
                        String groupName = (String)((Map)licenseVersionGroupNamesMap.get(type)).get(groupId);
                        if (StringUtils.isEmpty((CharSequence)groupName)) {
                            groupName = row.getString("groupname");
                        }
                        licenseGroupInfo.put("groupId", groupId);
                        licenseGroupInfo.put("totalCount", totalCount);
                        licenseGroupInfo.put("assignCount", assignCount);
                        licenseGroupInfo.put("groupType", groupType);
                        licenseGroupInfo.put("groupName", groupName);
                        licenseGroupInfoMap.computeIfAbsent(groupId, k -> new HashMap(2)).put(tableName, licenseGroupInfo);
                    }
                }
            }
            catch (Exception e) {
                logger.error("\u67e5\u627e\u5206\u7ec4\u8be6\u60c5\u51fa\u9519", (Throwable)e);
            }
            return licenseGroupInfoMap;
        }
    }

    class UserStatusDifListDataProvider
    extends ListDataProvider {
        UserStatusDifListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            int count = 0;
            String searchFilter = UpdateLicenseFormPlugin.this.getPageCache().get("searchFilter");
            boolean isSearch = !StringUtils.isEmpty((CharSequence)searchFilter);
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)UpdateLicenseFormPlugin.ENTITY);
            DynamicObjectCollection curPageData = new DynamicObjectCollection((DynamicObjectType)dataEntityType, null);
            try (DataSet userLicenseGropDataSet = this.getUserLicenseGropDataSet();
                 DataSet userLicenseGropDataSetNew = isSearch ? userLicenseGropDataSet.filter(searchFilter) : userLicenseGropDataSet;){
                for (Row row : userLicenseGropDataSetNew) {
                    if (++count <= start || count > start + limit) continue;
                    DynamicObject listRow = new DynamicObject((DynamicObjectType)dataEntityType);
                    listRow.set(UpdateLicenseFormPlugin.SEQ, (Object)count);
                    listRow.set(UpdateLicenseFormPlugin.USER_NAME, (Object)row.getString(UpdateLicenseFormPlugin.USER_NAME));
                    listRow.set(UpdateLicenseFormPlugin.USER_PHONE, (Object)row.getString(UpdateLicenseFormPlugin.USER_PHONE));
                    listRow.set(UpdateLicenseFormPlugin.USER_EMAIL, (Object)row.getString(UpdateLicenseFormPlugin.USER_EMAIL));
                    listRow.set(UpdateLicenseFormPlugin.GROUP_NEMA_NOW, (Object)row.getString(UpdateLicenseFormPlugin.GROUP_NEMA_NOW));
                    listRow.set(UpdateLicenseFormPlugin.GROUP_NEMA_NEW, (Object)row.getString(UpdateLicenseFormPlugin.GROUP_NEMA_NEW));
                    listRow.set(UpdateLicenseFormPlugin.USERSYNSTATUS_NOW, (Object)row.getString(UpdateLicenseFormPlugin.USERSYNSTATUS_NOW));
                    listRow.set(UpdateLicenseFormPlugin.USERSYNSTATUS_NEW, (Object)row.getString(UpdateLicenseFormPlugin.USERSYNSTATUS_NEW));
                    curPageData.add((Object)listRow);
                }
                UpdateLicenseFormPlugin.this.getPageCache().put("userStatusSize", count + "");
            }
            catch (Exception e) {
                logger.error("getData \u51fa\u9519", (Throwable)e);
            }
            return curPageData;
        }

        private String getSyncStatus(String syncStatus) {
            if (StringUtils.isEmpty((CharSequence)syncStatus)) {
                return ResManager.loadKDString((String)"\u4e0d\u53ef\u7528", (String)"UpdateLicenseFormPlugin_18", (String)"bos-license-formplugin", (Object[])new Object[0]);
            }
            switch (syncStatus) {
                case "1": {
                    return ResManager.loadKDString((String)"\u53ef\u7528", (String)"UpdateLicenseFormPlugin_19", (String)"bos-license-formplugin", (Object[])new Object[0]);
                }
            }
            return ResManager.loadKDString((String)"\u4e0d\u53ef\u7528", (String)"UpdateLicenseFormPlugin_18", (String)"bos-license-formplugin", (Object[])new Object[0]);
        }

        private List<String[]> getUserLicenseGroupData(boolean showDif) {
            ArrayList<String[]> licenseGroupData = new ArrayList<String[]>(10);
            Map licenseVersionGroupNamesMap = new HashMap(2);
            String licenseGroups = UpdateLicenseFormPlugin.this.getPageCache().get("licenseGroups");
            if (!StringUtils.isEmpty((CharSequence)licenseGroups)) {
                licenseVersionGroupNamesMap = (Map)SerializationUtils.fromJsonString((String)licenseGroups, Map.class);
            }
            Map groupNameNowMap = (Map)licenseVersionGroupNamesMap.get("now");
            Map groupNameNewMap = (Map)licenseVersionGroupNamesMap.get("new");
            try (DataSet userLicenseGroupNow = QueryServiceHelper.queryDataSet((String)"query_userlicenseggroup_now", (String)"lic_userlicensegroup", (String)"user.id,user.name,user.phone,user.email,group.name,status,group.id", null, null);
                 DataSet userLicenseGroupNew = QueryServiceHelper.queryDataSet((String)"query_userlicenseggroup_new", (String)"lic_userlicgroup_trial", (String)"user.id,user.name,user.phone,user.email,group.id,group.name,status", null, null);){
                HashMap trialUserLicenseGroup = new HashMap(16);
                for (Row row : userLicenseGroupNew) {
                    HashMap<String, String> trialLicenseInfo = new HashMap<String, String>();
                    String userId = row.getString("user.id");
                    String groupId = row.getString("group.id");
                    String groupName = "";
                    if (!CollectionUtils.isEmpty((Map)groupNameNewMap)) {
                        groupName = (String)groupNameNewMap.get(groupId);
                    }
                    trialLicenseInfo.put("groupName", StringUtils.isEmpty((CharSequence)groupName) ? row.getString("group.name") : groupName);
                    trialLicenseInfo.put("syncStatus", row.getString("status"));
                    trialLicenseInfo.put("groupId", groupId);
                    trialUserLicenseGroup.put(userId + "_" + groupId, trialLicenseInfo);
                }
                for (Row row : userLicenseGroupNow) {
                    String[] licenseRow = new String[7];
                    String groupNameNew = "";
                    String syncStatusNew = "";
                    String groupIdNew = "";
                    String groupNameNow = "";
                    String userId = row.getString("user.id");
                    String groupId = row.getString("group.id");
                    String syncStatusNow = row.getString("status");
                    if (!CollectionUtils.isEmpty((Map)groupNameNowMap)) {
                        groupNameNow = (String)groupNameNowMap.get(groupId);
                    }
                    groupNameNow = StringUtils.isEmpty((CharSequence)groupNameNow) ? row.getString("group.name") : groupNameNow;
                    Map licenseInfoNew = (Map)trialUserLicenseGroup.get(userId + "_" + groupId);
                    if (CollectionUtils.isEmpty((Map)licenseInfoNew)) {
                        licenseInfoNew = (Map)trialUserLicenseGroup.get(userId + "_" + this.getLicenseGroupRelational().get(groupId));
                    }
                    if (!CollectionUtils.isEmpty((Map)licenseInfoNew)) {
                        groupNameNew = (String)licenseInfoNew.get("groupName");
                        syncStatusNew = (String)licenseInfoNew.get("syncStatus");
                        groupIdNew = (String)licenseInfoNew.get("groupId");
                    }
                    if (showDif && StringUtil.compare((String)syncStatusNew, (String)syncStatusNow) == 0 && StringUtil.compare((String)groupId, (String)groupIdNew) == 0) continue;
                    licenseRow[0] = row.getString("user.name");
                    licenseRow[1] = row.getString("user.phone");
                    licenseRow[2] = row.getString("user.email");
                    licenseRow[3] = groupNameNow;
                    licenseRow[4] = groupNameNew;
                    licenseRow[5] = this.getSyncStatus(syncStatusNow);
                    licenseRow[6] = this.getSyncStatus(syncStatusNew);
                    licenseGroupData.add(licenseRow);
                }
            }
            catch (Exception e) {
                logger.error("getUserLicenseGroupData :\u51fa\u9519", (Throwable)e);
            }
            return licenseGroupData;
        }

        private DataSet getUserLicenseGropDataSet() {
            Algo algo = Algo.create((String)(((Object)((Object)this)).getClass().getName() + ".query"));
            DataSetBuilder builder = algo.createDataSetBuilder(this.getRowMeta());
            List<String[]> userLicenseGroupData = this.getUserLicenseGroupData((Boolean)UpdateLicenseFormPlugin.this.getModel().getValue(UpdateLicenseFormPlugin.SHOWSTATUS_DIF));
            for (Object[] objectArray : userLicenseGroupData) {
                builder.append(objectArray);
            }
            return builder.build();
        }

        private RowMeta getRowMeta() {
            ArrayList<Field> fields = new ArrayList<Field>(18);
            fields.add(new Field(UpdateLicenseFormPlugin.USER_NAME, (DataType)DataType.StringType));
            fields.add(new Field(UpdateLicenseFormPlugin.USER_PHONE, (DataType)DataType.StringType));
            fields.add(new Field(UpdateLicenseFormPlugin.USER_EMAIL, (DataType)DataType.StringType));
            fields.add(new Field(UpdateLicenseFormPlugin.GROUP_NEMA_NOW, (DataType)DataType.StringType));
            fields.add(new Field(UpdateLicenseFormPlugin.GROUP_NEMA_NEW, (DataType)DataType.StringType));
            fields.add(new Field(UpdateLicenseFormPlugin.USERSYNSTATUS_NOW, (DataType)DataType.StringType));
            fields.add(new Field(UpdateLicenseFormPlugin.USERSYNSTATUS_NEW, (DataType)DataType.StringType));
            return new RowMeta(fields.toArray(new Field[0]));
        }

        private Map<String, String> getLicenseGroupRelational() {
            HashMap<String, String> relational = new HashMap<String, String>(12);
            relational.put("40", "13");
            relational.put("4", "401");
            relational.put("5", "401");
            relational.put("23", "401");
            relational.put("104", "401");
            relational.put("89", "401");
            relational.put("25", "401");
            relational.put("111", "401");
            relational.put("116", "401");
            relational.put("34 ", "406");
            relational.put("87", "406");
            relational.put("9", "412");
            return relational;
        }

        public int getDataCount() {
            String userStatusSize = UpdateLicenseFormPlugin.this.getPageCache().get("userStatusSize");
            if (StringUtils.isEmpty((CharSequence)userStatusSize)) {
                userStatusSize = "0";
            }
            return Integer.parseInt(userStatusSize);
        }

        public int getRealCount() {
            String userStatusSize = UpdateLicenseFormPlugin.this.getPageCache().get("userStatusSize");
            if (StringUtils.isEmpty((CharSequence)userStatusSize)) {
                userStatusSize = "0";
            }
            return Integer.parseInt(userStatusSize);
        }
    }
}

