/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.bean.SyncLicenseProgressInfo;
import kd.bos.license.service.cache.LicenseCache;
import kd.bos.license.service.cache.LicenseLocaleCache;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.message.api.ShortMessageInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.message.MessageServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPools;

public class UserLicRelListPlugin
extends AbstractListPlugin {
    private static final String USERIDADDSET = "userIdAddSet";
    private static final String USERLICGROUP = "lic_userlicensegroup";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"entrytoolbar"});
        super.registerListener(e);
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    public void setFilter(SetFilterEvent e) {
        Map map = BusinessDataServiceHelper.loadFromCache((String)USERLICGROUP, null);
        HashSet<Object> userIds = new HashSet<Object>();
        for (DynamicObject dynamicObject : map.values()) {
            DynamicObject user = dynamicObject.getDynamicObject("user");
            if (user == null) continue;
            userIds.add(user.getPkValue());
        }
        userIds.addAll(this.getUserAddIdCache());
        QFilter filter = new QFilter("id", "in", userIds);
        e.addCustomQFilter(filter);
        super.setFilter(e);
    }

    public void listRowClick(ListRowClickEvent evt) {
        ListSelectedRowCollection collection = evt.getListSelectedRowCollection();
        this.getModel().deleteEntryData("entryentity");
        if (collection == null || collection.size() == 0) {
            return;
        }
        for (ListSelectedRow row : collection) {
            Object userId = row.getPrimaryKeyValue();
            Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)USERLICGROUP, (QFilter[])new QFilter[]{new QFilter("user", "in", userId)});
            for (DynamicObject dynamicObject : loadFromCache.values()) {
                DynamicObject group = dynamicObject.getDynamicObject("group");
                if (group == null) continue;
                int entryRow = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("licgroup", (Object)group, entryRow);
                this.getModel().setValue("syncstatus", dynamicObject.get("syncstatus"), entryRow);
            }
        }
        super.listRowClick(evt);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "btn_new": {
                this.showUserF7TreeList();
                break;
            }
            case "btn_del": {
                BillList billList = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection collection = billList.getSelectedRows();
                if (collection == null || collection.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7528\u6237", (String)"UserLicRelListPlugin_0", (String)"bos-license-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u8be5\u7528\u6237\u6240\u6709\u8bb8\u53ef\u5206\u7ec4\uff1f", (String)"UserLicRelListPlugin_1", (String)"bos-license-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delUserLic"));
                break;
            }
            case "btn_sync": {
                if (!this.hasRight("/=HRYOD/F55R")) {
                    return;
                }
                LicenseServiceHelper.addLog((String)ResManager.loadKDString((String)"\u540c\u6b65\u6ce8\u518c\u7528\u6237", (String)"UserLicRelListPlugin_2", (String)"bos-license-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u5f00\u59cb\u540c\u6b65\u6ce8\u518c\u7528\u6237", (String)"UserLicRelListPlugin_3", (String)"bos-license-formplugin", (Object[])new Object[0]));
                String uploadRegUserProgress = LicenseCache.getUploadRegUserProgress();
                SyncLicenseProgressInfo syncProgress = new SyncLicenseProgressInfo();
                if (uploadRegUserProgress != null) {
                    syncProgress = (SyncLicenseProgressInfo)SerializationUtils.fromJsonString((String)uploadRegUserProgress, SyncLicenseProgressInfo.class);
                }
                this.showProgressForm();
                if (syncProgress.isInSync()) {
                    return;
                }
                this.syncUserLic();
                break;
            }
            case "btn_refresh": {
                this.refreshUserList();
                break;
            }
            case "addrow": {
                this.showLicGroupList();
                break;
            }
        }
    }

    private void showLicGroupList() {
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"lic_group", (boolean)true);
        ArrayList<QFilter> typeFilter = new ArrayList<QFilter>();
        typeFilter.add(new QFilter("type", "=", (Object)1));
        lsp.setListFilterParameter(new ListFilterParameter(typeFilter, null));
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "lic_grouplist"));
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void syncUserLic() {
        ThreadPools.executeOnceIncludeRequestContext((String)"synUserGroup", (Runnable)new Runnable(){

            @Override
            public void run() {
                Map result = LicenseServiceHelper.syncUserGroup();
                Object success = result.get("success");
                String userId = RequestContext.get().getUserId();
                if (success != null && Boolean.parseBoolean(success.toString())) {
                    UserLicRelListPlugin.this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f", (String)"UserLicRelListPlugin_4", (String)"bos-license-formplugin", (Object[])new Object[0]));
                    BillList billList = (BillList)UserLicRelListPlugin.this.getView().getControl("billlistap");
                    billList.refresh();
                    LicenseLocaleCache.remove((String)"ProductInfo");
                    success = true;
                } else {
                    success = false;
                }
                DynamicObject user = QueryServiceHelper.queryOne((String)"bos_user", (String)"phone", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)userId)});
                if (user == null) {
                    return;
                }
                String phone = user.getString("phone");
                if (StringUtils.isBlank((CharSequence)phone)) {
                    return;
                }
                ShortMessageInfo shortMessageInfo = new ShortMessageInfo();
                shortMessageInfo.setCountryCode("86");
                ArrayList<String> phones = new ArrayList<String>();
                phones.add(phone);
                shortMessageInfo.setPhone(phones);
                shortMessageInfo.setSignature(ResManager.loadKDString((String)"\u91d1\u8776\u4e91", (String)"UserLicRelListPlugin_5", (String)"bos-license-formplugin", (Object[])new Object[0]));
                String msg = ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25\uff0c\u8bf7\u67e5\u9605\u65e5\u5fd7\u3002", (String)"UserLicRelListPlugin_6", (String)"bos-license-formplugin", (Object[])new Object[0]);
                if (Boolean.parseBoolean(success.toString())) {
                    msg = ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f\uff0c\u8bf7\u524d\u5f80\u7528\u6237\u5206\u914d\u8bb8\u53ef\u4e2d\u67e5\u770b\u3002", (String)"UserLicRelListPlugin_7", (String)"bos-license-formplugin", (Object[])new Object[0]);
                }
                shortMessageInfo.setMessage(msg);
                MessageServiceHelper.sendShortMessage((ShortMessageInfo)shortMessageInfo);
            }
        });
    }

    private void showProgressForm() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("lic_syncprogress");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refreshCallBack"));
        this.getView().showForm(parameter);
    }

    private boolean hasRight(String permItem) {
        boolean hasRight = false;
        String userId = RequestContext.get().getUserId();
        if (userId != null) {
            boolean bl = hasRight = PermissionServiceHelper.checkPermission((long)Long.parseLong(userId), (String)"DIM_ORG", (long)0L, (String)this.getView().getFormShowParameter().getAppId(), (String)USERLICGROUP, (String)permItem) == 1;
            if (!hasRight) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u64cd\u4f5c\u6743\u9650", (String)"UserLicRelListPlugin_8", (String)"bos-license-formplugin", (Object[])new Object[0]));
            }
        }
        return hasRight;
    }

    private void showUserF7TreeList() {
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"bos_user", (boolean)true);
        long userId = Long.parseLong(RequestContext.get().getUserId());
        boolean isSuperAdmin = PermissionServiceHelper.isAdminUser((long)userId, (String)"10");
        ArrayList<QFilter> rangeFilterList = new ArrayList<QFilter>();
        QFilter enableFilter = new QFilter("enable", "=", (Object)true);
        if (!isSuperAdmin) {
            List userIds = PermissionServiceHelper.getAdminChargeUsers((Long)userId);
            rangeFilterList.add(enableFilter.and(new QFilter("id", "in", (Object)userIds)));
        } else {
            rangeFilterList.add(enableFilter);
        }
        lsp.setListFilterParameter(new ListFilterParameter(rangeFilterList, null));
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bos_userlistf7"));
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void importData() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_importdata");
        showParameter.setCustomParam("BillFormId", (Object)USERLICGROUP);
        showParameter.setCustomParam("ServiceAppId", (Object)this.getView().getFormShowParameter().getServiceAppId());
        showParameter.setCustomParam("ImportPlugin", (Object)"kd.bos.license.formplugin.UserLicenseGroupImportPlugin");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack(((Object)((Object)this)).getClass().getName(), "refresh");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if ("delUserLic".equals(callBackId)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection collection = billList.getSelectedRows();
            Object[] keyValues = collection.getPrimaryKeyValues();
            if (keyValues == null || keyValues.length == 0) {
                return;
            }
            HashSet<Long> userIdSet = new HashSet<Long>(keyValues.length);
            for (Object userId : keyValues) {
                userIdSet.add((Long)userId);
            }
            DeleteServiceHelper.delete((String)USERLICGROUP, (QFilter[])new QFilter[]{new QFilter("user", "in", userIdSet)});
            LicenseServiceHelper.deleteUserLic(userIdSet);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
        if (rows == null || rows.size() <= 0) {
            return;
        }
        switch (actionId) {
            case "bos_userlistf7": {
                this.addUser2Cache(rows.getPrimaryKeyValues());
                break;
            }
            case "lic_grouplist": {
                boolean success = true;
                BillList billList = (BillList)this.getView().getControl("billlistap");
                Object userIdStr = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
                if (StringUtils.isNotBlank((Object)userIdStr)) {
                    ArrayList<Long> userIds = new ArrayList<Long>();
                    userIds.add(Long.parseLong(userIdStr + ""));
                    for (ListSelectedRow row : rows) {
                        List result = LicenseServiceHelper.addUserListByGroupId((Object)row.getPrimaryKeyValue(), userIds);
                        if (result != null && result.size() != 0) continue;
                        success = false;
                    }
                }
                String msg = success ? ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"UserLicRelListPlugin_9", (String)"bos-license-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"UserLicRelListPlugin_10", (String)"bos-license-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msg, Integer.valueOf(2000));
                break;
            }
        }
    }

    private void addUser2Cache(Object[] userIdS) {
        Set<Object> userIdAddSet = this.getUserAddIdCache();
        userIdAddSet.addAll(Arrays.asList(userIdS));
        this.getPageCache().put(USERIDADDSET, SerializationUtils.toJsonString(userIdAddSet));
        this.refreshUserList();
    }

    private Set<Object> getUserAddIdCache() {
        String userIdCache = this.getPageCache().get(USERIDADDSET);
        Set<Object> userIdSet = new HashSet<Object>();
        if (userIdCache != null) {
            userIdSet = (Set)SerializationUtils.fromJsonString((String)userIdCache, Set.class);
        }
        return userIdSet;
    }

    private void refreshUserList() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.refresh();
    }
}

