/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.formplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.license.util.UserLicenseGroupUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class UserLicenseGroupImportPlugin
extends AbstractOperationServicePlugIn
implements IImportPlugin {
    private static Log logger = LogFactory.getLog(UserLicenseGroupImportPlugin.class);
    public static final String LIC_USERLICENSEGROUP = "lic_userlicensegroup";
    public static final String LIC_GROUP = "lic_group";
    public static final String NUMBER = "number";

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        String importType = (String)option.get("importtype");
        if (importType.equals("override")) {
            return super.beforeImportData(data, option, importlogs);
        }
        Map user = (Map)data.get("user");
        Map group = (Map)data.get("group");
        if (this.valuesNotNull(user) && this.valuesNotNull(group)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(NUMBER, group.get(NUMBER).toString());
            Object userNum = user.get(NUMBER);
            if (StringUtils.isNotBlank(userNum)) {
                DynamicObject[] users;
                List userIds = PermissionServiceHelper.getAdminChargeUsers((Long)Long.parseLong(RequestContext.get().getUserId()));
                for (DynamicObject dynamicObject : users = BusinessDataServiceHelper.load((String)"bos_user", (String)"enable,isforbidden", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", userNum)})) {
                    if (!userIds.contains(dynamicObject.getPkValue())) {
                        importlogs.add(new ImportLogger.ImportLog("", "\u65e0" + userNum + "\u7528\u6237\u7ba1\u7406\u6743\uff0c\u5bfc\u5165\u5931\u8d25"));
                        return false;
                    }
                    Object enable = dynamicObject.get("enable");
                    Object isForbidden = dynamicObject.get("isforbidden");
                    if (!"0".equals(enable) && !Boolean.TRUE.equals(isForbidden)) continue;
                    importlogs.add(new ImportLogger.ImportLog("", "\u7528\u6237" + userNum + "\u5df2\u7981\u7528\uff0c\u5bfc\u5165\u5931\u8d25"));
                    return false;
                }
            }
            if (!UserLicenseGroupUtil.checkLicenseNumber(map)) {
                importlogs.add(new ImportLogger.ImportLog("", group.get(NUMBER).toString() + "\u8bb8\u53ef\u5206\u7ec4\u4e2a\u6570\u4e0d\u8db3"));
                return false;
            }
        } else {
            importlogs.add(new ImportLogger.ImportLog("", "\u5206\u7ec4\u6216\u7528\u6237\u4e3a\u7a7a"));
            return false;
        }
        return super.beforeImportData(data, option, importlogs);
    }

    private boolean valuesNotNull(Map<String, Object> map) {
        return null != map && !map.isEmpty() && kd.bos.util.StringUtils.isNotEmpty((String)(map.get(NUMBER) + ""));
    }

    public List<Object> importData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        String importType = (String)option.get("importtype");
        Map user = (Map)data.get("user");
        Map group = (Map)data.get("group");
        Map org = (Map)data.get("org");
        if (this.valuesNotNull(user) && this.valuesNotNull(group)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(NUMBER, group.get(NUMBER).toString());
            if (!UserLicenseGroupUtil.checkLicenseNumber(map) && !importType.equals("override")) {
                ArrayList<Object> ids = new ArrayList<Object>();
                ids.add("-1");
                return ids;
            }
            if (UserLicenseGroupUtil.isEnableLegalPersonAssign() && !this.valuesNotNull(org)) {
                ArrayList<Object> ids = new ArrayList<Object>();
                ids.add("-1");
                return ids;
            }
            if (!importType.equals("override")) {
                DynamicObject[] userlicensegroup = BusinessDataServiceHelper.load((String)LIC_USERLICENSEGROUP, (String)"id", (QFilter[])new QFilter[]{new QFilter("user.number", "=", user.get(NUMBER)), new QFilter("group.number", "=", group.get(NUMBER))});
                if (userlicensegroup != null && userlicensegroup.length > 0) {
                    ArrayList<Object> ids = new ArrayList<Object>();
                    ids.add("-1");
                    return ids;
                }
            } else {
                DynamicObject[] users;
                Object userNum = user.get(NUMBER);
                for (DynamicObject dynamicObject : users = BusinessDataServiceHelper.load((String)"bos_user", (String)"enable,isforbidden", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", userNum)})) {
                    Object enable = dynamicObject.get("enable");
                    Object isForbidden = dynamicObject.get("isforbidden");
                    if (!"0".equals(enable) && !Boolean.TRUE.equals(isForbidden)) continue;
                    importlogs.add(new ImportLogger.ImportLog("", "\u7528\u6237" + userNum + "\u5df2\u7981\u7528\uff0c\u5bfc\u5165\u5931\u8d25"));
                    ArrayList<Object> ids = new ArrayList<Object>();
                    ids.add("-1");
                    return ids;
                }
            }
        }
        return super.importData(data, option, importlogs);
    }

    public void afterImportData(List<Object> pkIds, List<ImportLogger.ImportLog> importlogs) {
        DynamicObject[] userlicensegroup;
        if (null != pkIds && pkIds.size() > 0 && !"-1".equals(pkIds.get(0)) && (userlicensegroup = BusinessDataServiceHelper.load((String)LIC_USERLICENSEGROUP, (String)"id,group,user", (QFilter[])new QFilter[]{new QFilter("id", "=", pkIds.get(0))})) != null && userlicensegroup.length > 0) {
            DynamicObject user = userlicensegroup[0].getDynamicObject("user");
            try {
                LicenseServiceHelper.addUser2LicGroupDif((Long)Long.parseLong(user.getPkValue().toString()));
            }
            catch (NumberFormatException e) {
                logger.error("UserLicenseGroupImportPlugin.afterImportData : e = " + e);
            }
        }
    }
}

