/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.formplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.license.util.LicenseGroupUtil;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class UserLicenseGroupListDataProvider
extends ListDataProvider {
    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection curPageData = super.getData(start, limit);
        if (curPageData == null || curPageData.isEmpty()) {
            return curPageData;
        }
        HashMap<Long, List> userPKs = new HashMap<Long, List>(curPageData.size());
        Map licenseGroup = LicenseGroupUtil.getLicenseGroup(null);
        for (DynamicObject dynamicObject : curPageData) {
            if (null == dynamicObject) continue;
            userPKs.computeIfAbsent(dynamicObject.getLong("user_id"), k -> new ArrayList()).add(dynamicObject);
            String groupId = dynamicObject.getString("group.id");
            String versionName = (String)licenseGroup.get(groupId);
            if (StringUtils.isBlank((CharSequence)versionName)) continue;
            dynamicObject.set("group.name", (Object)versionName);
        }
        QFilter[] filters = new QFilter[]{new QFilter("ispartjob", "=", (Object)Boolean.FALSE), new QFilter("user", "in", userPKs.keySet())};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"select_user_position", (String)"bos_userposition", (String)"user,org.name,orgstructure.fullname", (QFilter[])filters, (String)"");){
            for (Row user : dataSet) {
                List dynamicObjectList = (List)userPKs.get(user.getLong("user"));
                if (dynamicObjectList == null || dynamicObjectList.isEmpty()) continue;
                for (DynamicObject dynamicObject : dynamicObjectList) {
                    String orgName;
                    String orgFullName = user.getString("orgstructure.fullname");
                    if (StringUtils.isNotEmpty((CharSequence)orgFullName) && dynamicObject.containsProperty("mainorgfullname")) {
                        dynamicObject.set("mainorgfullname", (Object)orgFullName);
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)(orgName = user.getString("org.name"))) || !dynamicObject.containsProperty("mainorg")) continue;
                    dynamicObject.set("mainorg", (Object)orgName);
                }
            }
        }
        return curPageData;
    }
}

