/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.formplugin;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.license.util.LicenseGroupUtil;
import kd.bos.license.util.UserLicenseGroupUtil;
import kd.bos.list.plugin.ListViewPluginProxy;
import kd.bos.mvc.cache.PageCache;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;

public class UserLiscenseListModel
extends TreeListModel {
    public static final String ROOTNODEID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private String pageId;
    private ListViewPluginProxy proxy;
    private TreeNode rootNode;
    private String rootNodeCacheKey;
    private IPageCache pageCache;
    private Object currentNodeId;

    public TreeNode getRoot() {
        if (this.rootNode != null) {
            return this.rootNode;
        }
        String rootNodeStr = this.pageCache.get(this.rootNodeCacheKey);
        if (StringUtils.isNotBlank((CharSequence)rootNodeStr)) {
            this.rootNode = (TreeNode)SerializationUtils.fromJsonString((String)rootNodeStr, TreeNode.class);
        }
        return this.rootNode;
    }

    public UserLiscenseListModel(String pageId, EntityType dataEntityType) {
        super(pageId, dataEntityType);
        this.pageId = pageId;
        this.rootNodeCacheKey = String.format("%s.root", pageId);
    }

    private TreeNode getTreeNode(Object nodeId) {
        if (this.getRoot() == null) {
            return this.createRootNode();
        }
        return this.getRoot().getTreeNode(nodeId.toString(), 10);
    }

    public TreeNode refreshNode(Object nodeId) {
        TreeNode node = this.getTreeNode(nodeId);
        if (node == null) {
            return node;
        }
        RefreshNodeEvent e = new RefreshNodeEvent((Object)this, nodeId);
        this.proxy.fireRefreshNode(e);
        List<TreeNode> list = e.getChildNodes();
        if (list == null) {
            list = this.getTreeNodeChildNodes(nodeId, node.getLongNumber());
        }
        if (list.size() > 0) {
            node.setChildren(list);
        } else {
            node.setChildren(null);
        }
        this.pageCache.put(this.rootNodeCacheKey, SerializationUtils.toJsonString((Object)this.rootNode));
        return node;
    }

    public List<QFilter> getTreeFilter() {
        List filter = super.getTreeFilter();
        filter.add(new QFilter("type", "!=", (Object)"2"));
        return filter;
    }

    public List<TreeNode> getTreeNodeChildNodes(Object parentId, String longNumber) {
        GroupProp group = this.getGroupProp();
        if (group == null || parentId == null) {
            return new ArrayList<TreeNode>();
        }
        if (this.isRootTreeNode(parentId)) {
            Map licenseGroup = LicenseGroupUtil.getHasBoughtRegLicGroup();
            List<TreeNode> nodes = new ArrayList<TreeNode>(licenseGroup.size());
            for (Map.Entry entry : licenseGroup.entrySet()) {
                TreeNode treeNode2 = new TreeNode(parentId.toString(), (String)entry.getKey(), (String)entry.getValue());
                nodes.add(treeNode2);
            }
            nodes = UserLicenseGroupUtil.getLicenseNum(nodes);
            Collator chineseComparator = Collator.getInstance(Locale.CHINESE);
            nodes.sort(Comparator.comparing(treeNode -> treeNode.getText(), Comparator.nullsFirst(chineseComparator)));
            return nodes;
        }
        boolean existParentFiled = false;
        for (IDataEntityProperty prop : group.getEntityType().getProperties()) {
            if (!(prop.getParent() instanceof MainEntityType) || !(prop instanceof ParentBasedataProp)) continue;
            existParentFiled = true;
            break;
        }
        if (!existParentFiled) {
            return new ArrayList<TreeNode>();
        }
        Map licenseGroup = LicenseGroupUtil.getLicenseGroup((String)"1");
        if (null == licenseGroup || licenseGroup.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        List<TreeNode> nodes = new ArrayList<TreeNode>(licenseGroup.size());
        for (Map.Entry entry : licenseGroup.entrySet()) {
            TreeNode treeNode3 = new TreeNode(parentId.toString(), (String)entry.getKey(), (String)entry.getValue());
            nodes.add(treeNode3);
        }
        nodes = UserLicenseGroupUtil.getLicenseNum(nodes);
        Collator chineseComparator = Collator.getInstance(Locale.CHINESE);
        nodes.sort(Comparator.comparing(treeNode -> treeNode.getText(), Comparator.nullsFirst(chineseComparator)));
        return nodes;
    }

    private boolean isRootTreeNode(Object nodeId) {
        if (this.getRoot() == null) {
            return false;
        }
        return this.getRoot().getId().compareTo(nodeId.toString()) == 0;
    }

    public void setCache(IPageCache pageCache) {
        this.pageCache = pageCache;
    }

    private IPageCache getPageCache() {
        if (this.pageCache == null) {
            this.pageCache = new PageCache(this.pageId);
        }
        return this.pageCache;
    }

    public void setPluginProxy(ListViewPluginProxy proxy) {
        this.proxy = proxy;
    }

    public Object getCurrentNodeId() {
        if (this.currentNodeId == null) {
            this.currentNodeId = this.pageCache.get(String.format("%s.currentnodeid", this.pageId));
        }
        return this.currentNodeId;
    }

    public void setCurrentNodeId(Object currentNodeId) {
        this.currentNodeId = currentNodeId;
        this.pageCache.put(String.format("%s.currentnodeid", this.pageId), currentNodeId.toString());
    }

    public void setRoot(TreeNode root) {
        this.rootNode = root;
        this.pageCache.put(this.rootNodeCacheKey, SerializationUtils.toJsonString((Object)root));
    }

    public QFilter getListFilter() {
        return super.getListFilter();
    }
}

