/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.config.client.util.StringUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.tree.TreeNode;
import kd.bos.license.engine.LicenseUserRelEngine;
import kd.bos.license.service.cache.LicenseCache;
import kd.bos.license.util.LicenseGroupUtil;
import kd.bos.license.util.LicenseUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.service.IParameterHelperService;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class UserLicenseGroupUtil {
    private static final String REMAINCOUNT = "remaincount";
    private static final String GROUP = "group";
    private static final String LIC_LICENSEDETAIL = "lic_licensedetail";
    private static final String LICENSEDETAIL_GROUP = "lic_licensedetail.group";
    private static final String LICENSESELECTSTR = "id,group,assignedCount,totalCount,remaincount,begindate,enddate";
    public static final String LIC_LICENSE = "lic_license";
    public static final String SPLIT = "_SPLIT_";
    private static Log logger = LogFactory.getLog(UserLicenseGroupUtil.class);

    public static void updateLicenseDetail(Long groupId, int num) {
        Object[] licensesNum = BusinessDataServiceHelper.load((String)LIC_LICENSE, (String)LICENSESELECTSTR, (QFilter[])new QFilter[]{new QFilter(LICENSEDETAIL_GROUP, "=", (Object)groupId)});
        if (licensesNum != null && licensesNum.length > 0) {
            DynamicObjectCollection licensedetails = (DynamicObjectCollection)licensesNum[0].get(LIC_LICENSEDETAIL);
            for (DynamicObject licensedetail : licensedetails) {
                if (!groupId.equals(((DynamicObject)licensedetail.get(GROUP)).getLong("id"))) continue;
                int assignedCount = (Integer)licensedetail.get("assignedcount") + num;
                int remaincount = UserLicenseGroupUtil.getTotalNumberNoUpdateCache(groupId) - assignedCount;
                if (assignedCount < 0 || remaincount > UserLicenseGroupUtil.getTotalNumberNoUpdateCache(groupId)) {
                    return;
                }
                licensedetail.set("assignedcount", (Object)assignedCount);
                licensedetail.set(REMAINCOUNT, (Object)remaincount);
                SaveServiceHelper.save((IDataEntityType)licensesNum[0].getDataEntityType(), (Object[])licensesNum);
            }
        }
    }

    public static boolean checkLicenseNumber(Map<String, String> map) {
        String number;
        DynamicObject[] userlicensegroup;
        if (CollectionUtils.isEmpty(map)) {
            return false;
        }
        String groupId = map.get("groupId");
        if (StringUtils.isEmpty((String)groupId) && (userlicensegroup = BusinessDataServiceHelper.load((String)"lic_group", (String)"id,group", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)(number = map.get("number"))), new QFilter("type", "=", (Object)"1")})) != null && userlicensegroup.length > 0) {
            groupId = userlicensegroup[0].getLong("id") + "";
        }
        if (StringUtils.isEmpty((String)groupId)) {
            return false;
        }
        DynamicObject[] licensesNum = BusinessDataServiceHelper.load((String)LIC_LICENSE, (String)LICENSESELECTSTR, (QFilter[])new QFilter[]{new QFilter(LICENSEDETAIL_GROUP, "=", (Object)Long.valueOf(groupId))});
        if (licensesNum != null && licensesNum.length > 0) {
            DynamicObjectCollection licensedetails = (DynamicObjectCollection)licensesNum[0].get(LIC_LICENSEDETAIL);
            for (DynamicObject licensedetail : licensedetails) {
                if (!groupId.equals(String.valueOf(((DynamicObject)licensedetail.get(GROUP)).getLong("id"))) || (Integer)licensedetail.get(REMAINCOUNT) <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public static TreeNode getLicenseNum(TreeNode treeNode) {
        return UserLicenseGroupUtil.getLicenseNum(Collections.singletonList(treeNode)).get(0);
    }

    public static List<TreeNode> getLicenseNum(List<TreeNode> treeNodes) {
        Date now = TimeServiceHelper.now();
        boolean highAvailabilityMode = LicenseUtil.isHighAvailabilityMode();
        boolean isCtrlAmountLic = LicenseCache.isCtrlAmountIgnoreTime();
        Boolean isPubTenantType = Boolean.valueOf(LicenseServiceHelper.getPubTenantType());
        logger.info("highAvailabilityMode:" + highAvailabilityMode + ",isCtrlAmountLic:" + isCtrlAmountLic + ",isPubTenantType:" + isPubTenantType);
        DynamicObject[] licensesNum = BusinessDataServiceHelper.load((String)LIC_LICENSE, (String)LICENSESELECTSTR, null);
        HashMap<String, Integer> licenseGroupAssigned = new HashMap<String, Integer>(16);
        HashMap<String, Boolean> licenseGroupEffective = new HashMap<String, Boolean>(16);
        HashSet<Long> registerGroupSet = new HashSet<Long>(16);
        if (licensesNum != null && licensesNum.length > 0) {
            for (DynamicObject dynamicObject : licensesNum) {
                DynamicObjectCollection licensedetails = dynamicObject.getDynamicObjectCollection(LIC_LICENSEDETAIL);
                for (DynamicObject licensedetail : licensedetails) {
                    DynamicObject groupObj = licensedetail.getDynamicObject(GROUP);
                    String groupId = groupObj.getPkValue().toString();
                    if (groupObj.getString("type").equals("1")) {
                        registerGroupSet.add(Long.valueOf(groupId));
                    }
                    int assignCount = licensedetail.getInt("assignedCount");
                    licenseGroupAssigned.put(groupId, assignCount);
                    Date beginDate = licensedetail.getDate("begindate");
                    Date endDate = licensedetail.getDate("enddate");
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(endDate);
                    calendar.set(10, 23);
                    calendar.set(12, 59);
                    calendar.set(13, 59);
                    endDate = calendar.getTime();
                    if (now.before(beginDate) || now.after(endDate)) {
                        licenseGroupEffective.put(groupId, Boolean.FALSE);
                        continue;
                    }
                    licenseGroupEffective.put(groupId, Boolean.TRUE);
                }
            }
        }
        Map groupTotal = LicenseCache.getGroupTotal();
        if (highAvailabilityMode) {
            Map licAllocateNumberByGroupIds = !isCtrlAmountLic ? LicenseUserRelEngine.getLicAllocateNumberByGroupIds(new ArrayList(registerGroupSet)) : LicenseGroupUtil.getCurAccountAssignByGroupIds(new ArrayList(licenseGroupAssigned.keySet()));
            for (Map.Entry entry : licAllocateNumberByGroupIds.entrySet()) {
                Long groupId = (Long)entry.getKey();
                Integer assigned = (Integer)entry.getValue();
                licenseGroupAssigned.put(groupId.toString(), assigned);
            }
        }
        for (TreeNode treeNode : treeNodes) {
            String groupId = treeNode.getId();
            String text = treeNode.getText();
            int assignCount = (Integer)licenseGroupAssigned.get(groupId);
            int total = (Integer)groupTotal.get(Long.valueOf(groupId));
            int textflag = text.indexOf("(");
            if (textflag >= 0) {
                treeNode.setText(text.substring(0, textflag) + "(" + assignCount + "/" + total + ")");
            } else {
                treeNode.setText(treeNode.getText() + "(" + assignCount + "/" + total + ")");
            }
            if (((Boolean)licenseGroupEffective.get(groupId)).booleanValue()) continue;
            treeNode.setColor("#cccccc");
        }
        return treeNodes;
    }

    public static int getTotalNumberNoUpdateCache(Object groupId) {
        return LicenseServiceHelper.getTotalNumberNoUpdateCache((Object)groupId);
    }

    public static int getRemainNumber(Object groupId) {
        return LicenseServiceHelper.getRemainNumber((Object)groupId);
    }

    private static boolean isEnableSysParam(String sysParamKey) {
        Object isEnable = UserLicenseGroupUtil.getParameterFromCache(sysParamKey);
        return isEnable != null && Boolean.parseBoolean(isEnable.toString());
    }

    private static Object getParameterFromCache(String key) {
        AppParam appParam = new AppParam();
        appParam.setAppId("83bfebc8000037ac");
        appParam.setViewType("15");
        appParam.setOrgId(Long.valueOf(((IParameterHelperService)ServiceSvcFactory.getService(IParameterHelperService.class)).getParamRootOrgId()));
        appParam.setActBookId(Long.valueOf(0L));
        Map paramMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        return paramMap == null ? null : paramMap.get(key);
    }

    public static boolean isEnableLegalPersonAssign() {
        return UserLicenseGroupUtil.isEnableSysParam("legal_person_assign");
    }

    public static boolean checkLegalPersonAssignData() {
        HashMap groupAll = new HashMap(16);
        String sql = "select fgroupid,ftotalcount from t_lic_licensedetail ";
        DB.query((DBRoute)DBRoute.base, (String)sql, k -> {
            while (k.next()) {
                Long groupId = k.getLong("fgroupid");
                Long count = k.getLong("ftotalcount");
                groupAll.put(groupId, count);
            }
            return true;
        });
        sql = "select fgroupid, sum(fassignednum) sumcount from t_lic_legalassign group by fgroupid";
        return (Boolean)DB.query((DBRoute)DBRoute.base, (String)sql, k -> {
            while (k.next()) {
                Long groupId = k.getLong("fgroupid");
                Long count = k.getLong("sumcount");
                Long groupSum = (Long)groupAll.get(groupId);
                if (groupSum == null || count <= groupSum) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        });
    }
}

