/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.license.api.LicenseAssignLog;
import kd.bos.license.bean.LicenseCheckLog;
import kd.bos.license.bean.LicenseCheckLogDetail;
import kd.bos.license.bean.LicenseSyncDetailLog;
import kd.bos.license.bean.LicenseSyncLog;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;

public class LicConsumer
implements MessageConsumer {
    private static final Log logger = LogFactory.getLog(LicConsumer.class);
    private static final String ENTITY_LICENSESYNCLOG = "lic_licensesynclog";
    private static final String ENTITY_LICENSESYNCDETAIL = "lic_licensesyncdetail";
    private static final String ID = "id";
    private static final String PROPERTY_OP = "operation";
    private static final String PROPERTY_DESCRIPTION = "description";
    private static final String PROPERTY_OPERATE_DATE = "operatedate";
    private static final String PROPERTY_OPERATOR = "operator";
    private static final String PROPERTY_ISSUCCESS = "success";
    private static final String PROPERTY_COMPARE = "compare";
    private static final String PROPERTY_PHONE = "phone";
    private static final String PROPERTY_EMAIL = "email";
    private static final String PROPERTY_SUCCESS = "success";
    private static final String PROPERTY_REASON = "reason";
    private static final String PROPERTY_LOGTYPE = "logtype";
    private static final String PROPERTY_TASKID = "taskid";
    private static final String PROPERTY_USER = "user";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onMessage(Object body, String messageId, boolean resend, MessageAcker acker) {
        if (body instanceof LicenseSyncLog) {
            LicenseSyncLog log = (LicenseSyncLog)body;
            DynamicObject appLogObj = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_LICENSESYNCLOG);
            String operation = log.getOperation();
            String description = log.getDescription();
            Date operationDate = log.getOperationDate();
            Long operator = log.getOperator();
            boolean success = log.isSuccess();
            String compare = log.getCompare();
            Long pkId = log.getPkId();
            logger.info("operation:" + operation + "," + PROPERTY_DESCRIPTION + ":" + description + "," + PROPERTY_OPERATE_DATE + ":" + operationDate + "," + PROPERTY_OPERATOR + ":" + operator + "success" + ":" + success + PROPERTY_COMPARE + ":" + compare + ID + ":" + pkId);
            if (null != pkId) {
                appLogObj.set(ID, (Object)pkId);
            }
            appLogObj.set(PROPERTY_OP, (Object)operation);
            appLogObj.set(PROPERTY_DESCRIPTION, (Object)description);
            appLogObj.set(PROPERTY_OPERATE_DATE, (Object)operationDate);
            appLogObj.set(PROPERTY_OPERATOR, (Object)operator);
            appLogObj.set("success", (Object)(success ? "1" : "0"));
            appLogObj.set(PROPERTY_COMPARE, (Object)compare);
            HashMap param = new HashMap(2);
            EventServiceHelper.triggerEventSubscribe((String)"lic_sync_license", (String)SerializationUtils.toJsonString(param));
            DynamicObject[] dataEntities = new DynamicObject[]{appLogObj};
            try (TXHandle h = TX.required();){
                try {
                    SaveServiceHelper.save((DynamicObject[])dataEntities);
                    List detailLogs = log.getLogs();
                    if (detailLogs == null || detailLogs.isEmpty()) return;
                    DynamicObject[] dynamicObjects = new DynamicObject[detailLogs.size()];
                    int index = 0;
                    for (LicenseSyncDetailLog detailLog : detailLogs) {
                        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_LICENSESYNCDETAIL);
                        dynamicObject.set(PROPERTY_USER, (Object)detailLog.getUser());
                        dynamicObject.set(PROPERTY_PHONE, (Object)detailLog.getPhone());
                        dynamicObject.set(PROPERTY_EMAIL, (Object)detailLog.getEmail());
                        dynamicObject.set("success", (Object)(detailLog.isSuccess() ? "1" : "0"));
                        dynamicObject.set(PROPERTY_REASON, (Object)detailLog.getReason());
                        dynamicObject.set(PROPERTY_OP, (Object)detailLog.getOperation());
                        dynamicObject.set(PROPERTY_DESCRIPTION, (Object)detailLog.getDescription());
                        dynamicObject.set(PROPERTY_LOGTYPE, (Object)detailLog.getLogType());
                        dynamicObject.set(PROPERTY_TASKID, appLogObj.getPkValue());
                        dynamicObjects[index++] = dynamicObject;
                    }
                    SaveServiceHelper.save((DynamicObject[])dynamicObjects);
                    logger.info("LicConsumer.onMessage, save LicenseSyncLog success");
                    acker.ack(messageId);
                    return;
                }
                catch (Exception e) {
                    h.markRollback();
                    logger.info("LicConsumer.onMessage, \u4fdd\u5b58\u8bb8\u53ef\u65e5\u5fd7\u51fa\u9519: " + e.getMessage());
                    acker.discard(messageId);
                }
                return;
            }
        } else if (body instanceof List) {
            List LicenseAssignLogs = (List)body;
            ArrayList<DynamicObject> licenseAssignLogObjs = new ArrayList<DynamicObject>(LicenseAssignLogs.size());
            for (LicenseAssignLog licenseAssignLog : LicenseAssignLogs) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"lic_assignlog");
                Long userID = licenseAssignLog.getAssignUserID();
                Long groupID = licenseAssignLog.getGroupID();
                boolean status = licenseAssignLog.isStatus();
                if (status) {
                    HashMap<String, Long> param = new HashMap<String, Long>(2);
                    param.put("userId", userID);
                    param.put("groupId", groupID);
                    EventServiceHelper.triggerEventSubscribe((String)"lic_userlicensegroup_add", (String)SerializationUtils.toJsonString(param));
                }
                dynamicObject.set("opuser", (Object)licenseAssignLog.getUserID());
                dynamicObject.set("optime", (Object)licenseAssignLog.getOpTime());
                dynamicObject.set("assignuser", (Object)userID);
                dynamicObject.set("group", (Object)groupID);
                dynamicObject.set("status", (Object)status);
                dynamicObject.set(PROPERTY_DESCRIPTION, (Object)licenseAssignLog.getOpDescription());
                dynamicObject.set("operate", (Object)licenseAssignLog.getOperate());
                dynamicObject.set("operatetype", (Object)licenseAssignLog.getOperateType());
                licenseAssignLogObjs.add(dynamicObject);
            }
            SaveServiceHelper.save((DynamicObject[])licenseAssignLogObjs.toArray(new DynamicObject[0]));
            logger.info("LicConsumer.onMessage, save LicenseAssignLog success");
            return;
        } else if (body instanceof LicenseCheckLog) {
            LicenseCheckLog licenseCheckLog = (LicenseCheckLog)body;
            DynamicObject licenseCheckLogObj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"lic_licchecklog"));
            licenseCheckLogObj.set(ID, (Object)licenseCheckLog.getId());
            licenseCheckLogObj.set("traceid", (Object)licenseCheckLog.getTraceID());
            licenseCheckLogObj.set("checktime", (Object)licenseCheckLog.getCheckTime());
            licenseCheckLogObj.set(PROPERTY_USER, (Object)licenseCheckLog.getCheckUserID());
            licenseCheckLogObj.set("bizapp", (Object)licenseCheckLog.getBizAppId());
            licenseCheckLogObj.set("bizobject", (Object)licenseCheckLog.getBizObjId());
            licenseCheckLogObj.set("cancelmessage", (Object)licenseCheckLog.getCancelMessage());
            DynamicObjectCollection doc = licenseCheckLogObj.getDynamicObjectCollection("entryentity");
            DynamicObjectType docType = doc.getDynamicObjectType();
            Set logs = licenseCheckLog.getLogs();
            for (LicenseCheckLogDetail log : logs) {
                DynamicObject logObj = new DynamicObject(docType);
                logObj.set("message", (Object)log.getMessage());
                logObj.set("level", (Object)log.getLevel());
                doc.add((Object)logObj);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{licenseCheckLogObj});
            return;
        } else {
            logger.info("LicConsumer.onMessage, \u4f20\u5165\u53c2\u6570\u7c7b\u578b\u4e0d\u662f\u65e5\u5fd7\u4fe1\u606f\u3002");
            acker.discard(messageId);
        }
    }
}

